#!/bin/sh

count=5
interval=1

show_help ()
{
    cat <<-EOF
    Usage: $(basename $0) -h|--host[=]<host or IP> -n|--name[=]<name> -c|--count[=]<count> -i|--interval[=]<interval>(secs)
EOF
}

die() {
    printf '%s\n' "$1" >&2
    exit 1
}

while :; do
    case $1 in
        -\?|--help)
            show_help    # Display a usage synopsis.
            exit
            ;;
        -h|--host)       # Takes an option argument; ensure it has been specified.
            if [ "$2" ]; then
                host=$2
                shift
            else
                die 'ERROR: "--host" requires a non-empty option argument.'
            fi
            ;;
        -h=?*|--host=?*)
            host=${1#*=} # Delete everything up to "=" and assign the remainder.
            ;;
        -h=|--host=)         # Handle the case of an empty --host=
            die 'ERROR: "--host" requires a non-empty option argument.'
            ;;
        -n|--name)       # Takes an option argument; ensure it has been specified.
            if [ "$2" ]; then
                name=$2
                shift
            else
                die 'ERROR: "--name" requires a non-empty option argument.'
            fi
            ;;
        --name=?*)
            name=${1#*=} # Delete everything up to "=" and assign the remainder.
            ;;
        --name=)         # Handle the case of an empty --name=
            die 'ERROR: "--name" requires a non-empty option argument.'
            ;;
        -c|--count)       # Takes an option argument; ensure it has been specified.
            if [ "$2" ]; then
                count=$2
                shift
            else
                die 'ERROR: "--count" requires a non-empty option argument.'
            fi
            ;;
        --count=?*)
            count=${1#*=} # Delete everything up to "=" and assign the remainder.
            ;;
        --count=)         # Handle the case of an empty --count=
            die 'ERROR: "--count" requires a non-empty option argument.'
            ;;
        -i|--interval)       # Takes an option argument; ensure it has been specified.
            if [ "$2" ]; then
                interval=$2
                shift
            else
                die 'ERROR: "--interval" requires a non-empty option argument.'
            fi
            ;;
        --interval=?*)
            interval=${1#*=} # Delete everything up to "=" and assign the remainder.
            ;;
        --interval=)         # Handle the case of an empty --interval=
            die 'ERROR: "--interval" requires a non-empty option argument.'
            ;;
        --)              # End of all options.
            shift
            break
            ;;
        -?*)
            printf 'WARN: Unknown option (ignored): %s\n' "$1" >&2
            ;;
        *)               # Default case: No more options, so break out of the loop.
            break
    esac

    shift
done

[ -z "$host" ] && die 'ERROR: missing host parameter'
[ -z "$name" ] && name=$host

ping -c $count -i $interval -q $host | awk '/packet loss/ {split($6,loss,"%"); print "ping,host='$host',name='$name' loss="loss[1]}; /^rtt min/ {split($4,rtt,"/");print "ping,host='$host',name='$name' min="rtt[1];print "ping,host='$host',name='$name' avg="rtt[2];print "ping,host='$host',name='$name' max="rtt[3]}'
