#! /bin/bash

##############################################################################
# he-update 0.1
##############################################################################

# /home/pi/he-update
# -     dz 2022
#
# Zweck:
# Aenderungen der WAN-IPv4-Adresse verfolgen
# und IPv6-Tunnel von Tunnelbroker aktualisieren
##
# Funktion:
# - wird von einem Cronjob zyklisch gestartet
# - liest IPv4-Adresse ueber einen Dienstleister aus
#
# Fehlermeldungen sind zu finden in /var/log/messages
#
# bei Bedarf Debugging einschalten
#set -x

VERSION="he-update 0.1"

# TunnelUpdate-Funktion
# example update URL https://USERNAME:UPDATEKEY@ipv4.tunnelbroker.net/nic/update?hostname=TUNNELID
# This is an example of the URL to use for updating your tunnel's endpoint via a script
# on the device anchoring the tunnel. Additional parameters might be useful for your specific case.

# USERNAME : The UserID shown on the main page of tunnelbroker.net when you log in.
# UPDATEKEY : This update key is used with the Client IP update scripts.
# When set, tunnel endpoint updates use this value as the password, instead of your account password. 
# TUNNELID: The ID of the tunnel you're updating the endpoint on. This can
# be found on the tunnel information page.

#hier eigene Tunnel-Variablen eintragen
TUSER="Username" # Name des Tunnel-Users
TKEY="aBCdEfGhi-Jk-lMN" # Updatekey des Tunnel-Users
TUNNELID="123456" # die Tunnel-ID

#AB HIER KEINE AENDERUNGEN ERFORDERLICH

PATH=/bin:/usr/bin:/sbin:/usr/sbin

ADRESSMERKER="/home/pi/he-update/"

#lokale Variablen
CACHEWAN=""
AKTUELLEWAN=`curl -s "http://www.networksecuritytoolkit.org/nst/tools/ip.shtml"` # ohne UPnP, aber auf externen Dienst angewiesen

#falls die obige Abfrage der WAN-IP-Adresse ueber networksecuritytoolkit.org nicht funktioniert 
#gibt es diverse weitere Abfragemoeglichkeiten...
#AKTUELLEWAN=`curl -s "http://v4.ipv6-test.com/api/myip.php"` # ohne UPnP, aber auf externen Dienst angewiesen
#AKTUELLEWAN=`upnpc -s | grep -i ExternalIP | awk '{ print $3}'` # ohne externen Dienst, aber auf installiertes miniupnpc und aktives UPnP im Router angewiesen
#AKTUELLEWAN=$(/opt/local/bin/wget "http://freedns.afraid.org/dynamic/check.php" -o /dev/null -O /dev/stdout | grep Detected | cut -d : -f 2 | cut -d '<' -f 1 | tr -d " ")
#AKTUELLEWAN=`curl -s "http://www.networksecuritytoolkit.org/nst/cgi-bin/ip.cgi"`
#AKTUELLEWAN=`curl -s "http://checkip.dyndns.org"` #-qO - | cut -d : -f 2 | cut -d '<' -f 1
#AKTUELLEWAN=`curl -s "http://www.whatismyipaddress.com/" und so weiter...`

WANIP="$ADRESSMERKER/wanIP.txt"

 TunnelUpdate ()
{   echo "aktualisiere Tunnelbroker IPv6-Tunnel fuer $TUSER"
    curl -4 -s "https://"$TUSER":"$TKEY"@ipv4.tunnelbroker.net/ipv4_end.php?tid="$TUNNELID""
	echo "" 
	}

########################Ordner anlegen
echo `date`, "$VERSION", "$TUSER"
echo ""

if ! [ -d "$ADRESSMERKER" ];
    then
    echo "Ordner $ADRESSMERKER fehlt, lege ihn an..."
    /bin/mkdir "$ADRESSMERKER" 
fi

#letzte WAN-IP einlesen
if test -f "$WANIP"
then
CACHEWAN=$(cat "$WANIP")
fi

# fuer Debugging-Zwecke Kommentarzeichen entfernen:
#echo "Inhalt der Variablen CACHEWAN:" "$CACHEWAN"
#echo "Inhalt der Variablen AKTUELLEWAN:" "$AKTUELLEWAN"
#if [ "$AKTUELLEWAN" = "$CACHEWAN" ] && [ "$AKTUELLELAN" = "$CACHELAN" ]
if [ "$AKTUELLEWAN" = "$CACHEWAN" ]
 then
   echo "WAN-IP-Adresse unveraendert, kein Update erforderlich..."
   echo ""
else
   echo "WAN-IP-Adresse hat sich geaendert, Aktualisierung erforderlich mit:" 
   echo "aktuelle WAN-IP: "$AKTUELLEWAN""
   echo ""
    TunnelUpdate
    echo ""
fi

echo "$AKTUELLEWAN" > "$WANIP"
