#!/bin/bash

# Alle IPv4- und IPv6-Regeln zuruecksetzen

iptables -P INPUT ACCEPT
iptables -P FORWARD ACCEPT
iptables -P OUTPUT ACCEPT
iptables -t nat -F
iptables -t mangle -F
iptables -F
iptables -X

ip6tables -P INPUT ACCEPT
ip6tables -P FORWARD ACCEPT
ip6tables -P OUTPUT ACCEPT
ip6tables -t mangle -F
ip6tables -t mangle -X
ip6tables -F
ip6tables -X

#IPv4: Protokoll 41 vom Tunnel-Server durchlassen
#ggf. die IP-Adresse je nach Tunnelbroker-Konfiguration anpassen
iptables -A INPUT -p 41 -s 216.66.80.30 -j ACCEPT

#IPv6-Grundeinstellungen
ip6tables -A INPUT -m rt --rt-type 0 -j DROP
ip6tables -A FORWARD -m rt --rt-type 0 -j DROP

ip6tables -A INPUT -i lo -j ACCEPT

# gegebenenfalls eth0 mit tatsaechlicher Schnittstellenbezeichnung ersetzen
# check mit ip a
ip6tables -A INPUT -i eth0 -j ACCEPT
# gegebenenfalls eth0 mit tatsaechlicher Schnittstellenbezeichnung ersetzen
ip6tables -A FORWARD -i eth0 -o eth0 -j ACCEPT

ip6tables -A INPUT -s fe80::/10 -j ACCEPT

ip6tables -I INPUT -p icmpv6 -j ACCEPT
ip6tables -I FORWARD -p icmpv6 -j ACCEPT

# gegebenenfalls eth0 mit tatsaechlicher Schnittstellenbezeichnung ersetzen
ip6tables -A FORWARD -m state --state NEW -i eth0 -o he-ipv6 -j ACCEPT
ip6tables -A FORWARD -m state --state ESTABLISHED,RELATED -j ACCEPT
ip6tables -A INPUT -i he-ipv6 -m state --state ESTABLISHED,RELATED -j ACCEPT
ip6tables -A FORWARD -m state --state INVALID -j DROP

ip6tables -A FORWARD -p ipv6-nonxt -m length --length 40 -j ACCEPT

ip6tables -P INPUT DROP
ip6tables -P FORWARD DROP
ip6tables -P OUTPUT ACCEPT
