@echo off
set workdir=%~d0%~p0
%windir%\System32\more +9 "%~f0" > "%workdir%%~n0-temp.ps1"
cd /d %workdir%
powershell -NoProfile -ExecutionPolicy Bypass -File "%workdir%%~n0-temp.ps1" %*
del %workdir%%~n0-temp.ps1
exit /b

*** Ab hier PowerShell ***
param(
  [switch] $Uninstall
)

$ToDo = @(
# @("Name für Verknüpfung", "Datei (im aktuellen Ordner)", "Argumente", "Ordner für Verknüpfung"),
  @("Restric'tor-Ausnahme", "restrictor.exe", "/NewHash", "%SendTo%"),
  @("Restric'tor", "restrictor.exe", "", "%Programs%\c't")
)

function SpecialFolder($str) {
  # Liste der unterstützten Namen siehe https://learn.microsoft.com/de-de/dotnet/api/system.environment.specialfolder?view=net-7.0
  $result = $str
  if($str.StartsWith('%')) {
    $varEnd = $str.IndexOf('%', 1)
    if($varEnd -ne -1) {
      $special = $str.Substring(1, $varEnd - 1)
      if($special -in [Environment+SpecialFolder].GetEnumNames()) {
        $onDisk = [Environment]::GetFolderPath($special)
        $result = Join-Path $onDisk $str.Substring($varEnd + 1)
      }
    }
  }
  return $result
}

if($Uninstall) {
  foreach($item in $ToDo) {
    $linkFolder = SpecialFolder $item[3]
    $linkName = Join-Path $linkFolder ($item[0] + '.lnk')
    Write-Host ('Lösche "{0}" ...' -f $linkName)
    Remove-Item $linkName -Force -ErrorAction SilentlyContinue
  }
} else {
  $WshShell = New-Object -ComObject WScript.Shell
  foreach($item in $ToDo) {
    if(-not (Test-Path (Join-Path $PSScriptRoot $item[1]))) {
      Write-Host ("Fehler: {0} existiert nicht. Bitte lesen Sie den zu diesem Skript gehörigen c't-Artikel!" -f (Join-Path $PSScriptRoot $item[1])) -ForegroundColor Red
      return
    }
    $linkFolder = SpecialFolder $item[3]
    if(-not (Test-Path $linkFolder)) {
      New-Item $linkFolder -ItemType Directory | Out-Null
    }
    $linkName = Join-Path $linkFolder ($item[0] + '.lnk')
    Write-Host ('Erstelle Verknüpfung "{0}" für {1} ...' -f $linkName, $item[1])
    $Shortcut = $WshShell.CreateShortcut($linkName)
    $Shortcut.TargetPath = '"{0}"' -f (Join-Path $PSScriptRoot $item[1])
    if($item[2]) {
      $Shortcut.Arguments = $item[2]
    }
    $Shortcut.Save()
  }
}