#!/usr/bin/env python3

import networkx as nx

maze = [z.strip() for z in open('ct_maze.txt')]

accessible = set()
holes = set()
start_end = dict()
for y, row in enumerate(maze):
  for x, char in enumerate(row):
    if char not in ['#', 'O']:
      accessible.add((x, y))
    elif char == 'O':
      holes.add((x,y))
    if char in ['S', 'Z']:
      start_end[char] = (x, y)

G = nx.DiGraph()
not_visited = [start_end['S']]
LEFT, RIGHT, DOWN, UP = \
  (-1, 0), (1, 0), (0, 1), (0, -1)
DIRECTIONS = LEFT, RIGHT, DOWN, UP
while len(not_visited):
  x, y = not_visited.pop(0)
  pos1 = x, y
  for dx, dy in DIRECTIONS:
    for distance in range(1, 20):
      x2, y2 = x + dx * distance, y + dy * distance
      pos2 = x2, y2
      if pos2 in accessible:
        continue
      if pos2 in holes:
        pos2 = [p for p in holes if p != pos2][0]
      else:  
        x2, y2 = x2 - dx, y2 - dy
        pos2 = x2, y2
        distance -= 1
      if (pos1, pos2) in G.edges:
        break
      G.add_edge(pos1, pos2, weight=distance)
      not_visited.append(pos2)
      break
    
paths = list(nx.all_shortest_paths(G,
  start_end['S'], start_end['Z']))


moves, distance, path = min(
  (len(p) - 1, nx.path_weight(
                   G, p, 'weight'), p)
   for p in paths)
print(f"*** Pfad mit den wenigsten Zügen:\n{path}")
print(f"Anzahl Züge: {moves}")
print(f"Entfernung: {distance}")

print()

path = nx.dijkstra_path(G, start_end['S'], start_end['Z'])
print(f"*** Pfad mit der kürztesten Entfernung:\n{path}")
print(f"Anzahl Züge: {len(path) - 1}")
print(f"Entfernung: {nx.path_weight(G, path, 'weight')}")
