#!/usr/bin/env python3

import networkx as nx

maze = open('simple_maze.txt').readlines()

accessible = set()
start_end = {}
for y, row in enumerate(maze):
  for x, char in enumerate(row):
    if char != '#' :
      accessible.add((x, y))
    if char in ['S', 'Z']:
      start_end[char] = (x, y)

LEFT, RIGHT, DOWN, UP = \
  (-1, 0), (1, 0), (0, 1), (0, -1)
DIRECTIONS = LEFT, RIGHT, DOWN, UP
G = nx.Graph()
for (x, y) in accessible:
  for dx, dy in DIRECTIONS:
    possible_pos = (x + dx, y + dy)
    if possible_pos in accessible:
      G.add_edge((x, y), possible_pos)

path = nx.shortest_path(
  G, start_end['S'], start_end['Z'])

print(path)
