#!/usr/bin/python3

import argparse
from pythonosc import udp_client
from pythonosc import osc_bundle_builder
from pythonosc import osc_message_builder

parser = argparse.ArgumentParser()
parser.add_argument('-H', '--host', dest='host', default='127.0.0.1', 
    help='Hostname or IP address of the Companion (default: 127.0.0.1)')
parser.add_argument('-P', '--port', dest='port', default=12321, type=int, 
    help='Port of the Companion OSC server (default: 12321)')
parser.add_argument('-B', '--button', dest='b', type=int, nargs=2, 
    help='Specify button number [1-32] on page [1-99]',
    metavar=('page', 'number'))
parser.add_argument('-T', '--text', dest='text',  
    help='Text to be displayed on specified button')
parser.add_argument('-c', '--color', dest='fgcolor', type=int, nargs=3, 
    help='Text color (r g b) [0-255] for specified button',
    metavar=('red', 'green', 'blue'))
parser.add_argument('-b', '--bgcolor', dest='bgcolor', type=int, nargs=3, 
    help='Background color (r g b) [0-255] for specified button',
    metavar=('red', 'green', 'blue'))
parser.add_argument('-p', '--press', dest='bpress',  action='store_true', 
    help='Press (and release) specified button')
parser.add_argument('-l', '--hold', dest='bhold',  action='store_true', 
    help='Press (and hold) specified button')
parser.add_argument('-r', '--release', dest='brelease',  action='store_true', 
    help='Release (a previously held) specified button')
parser.add_argument('-V', '--var', dest='var',  nargs=2,
    help='Set custom variable name to value',
    metavar=('name', 'value'))
args = parser.parse_args()

bundle = osc_bundle_builder.OscBundleBuilder(osc_bundle_builder.IMMEDIATELY)
msg=None
if (args.b and args.text):
    msg = osc_message_builder.OscMessageBuilder(
        address="/style/text/{0}/{1}".format(args.b[0], args.b[1]))
    msg.add_arg(args.text)
    bundle.add_content(msg.build())
if (args.b and args.fgcolor):
    msg = osc_message_builder.OscMessageBuilder(
        address="/style/color/{0}/{1}".format(args.b[0], args.b[1]))
    for c in args.fgcolor:
        msg.add_arg(c)
    bundle.add_content(msg.build())
if (args.b and args.bgcolor):
    msg = osc_message_builder.OscMessageBuilder(
        address="/style/bgcolor/{0}/{1}".format(args.b[0], args.b[1]))
    for c in args.bgcolor:
        msg.add_arg(c)
    bundle.add_content(msg.build())
if (args.b and args.bpress):
    msg = osc_message_builder.OscMessageBuilder(
        address="/press/bank/{0}/{1}".format(args.b[0], args.b[1]))
    bundle.add_content(msg.build())
if (args.b and args.bhold):
    msg = osc_message_builder.OscMessageBuilder(
        address="/press/bank/{0}/{1}".format(args.b[0], args.b[1]))
    msg.add_arg(1)
    bundle.add_content(msg.build())
if (args.b and args.brelease):
    msg = osc_message_builder.OscMessageBuilder(
        address="/press/bank/{0}/{1}".format(args.b[0], args.b[1]))
    msg.add_arg(0)
    bundle.add_content(msg.build())
if (args.var):
    msg = osc_message_builder.OscMessageBuilder(
        address="/custom-variable/{0}/value".format(args.var[0]))
    msg.add_arg(args.var[1])
    bundle.add_content(msg.build())

if (msg):
    client = udp_client.SimpleUDPClient(args.host, args.port)
    if (client):
        client.send(bundle.build())
