﻿namespace OnAir
{
    public partial class SettingsForm : Form
    {
        private bool _extendedUrls = false;
        private string _onSuffix = "/on";
        private string _offSuffix = "/off";

        public string LampStateUrl
        {
            get { return tbLampState.Text; }
            set { tbLampState.Text = value; }
        }
        public string LampOnUrl
        {
            get { return tbLampOn.Text; }
            set { tbLampOn.Text = value; }
        }
        public string LampOffUrl
        {
            get { return tbLampOff.Text; }
            set { tbLampOff.Text = value; }
        }
        public bool AlwaysOnTop
        {
            get { return cbAlwysOnTop.Checked; }
            set { cbAlwysOnTop.Checked = value; }
        }
        public bool MinimizeToTray
        {
            get { return cbMinimizeToTray.Checked; }
            set { cbMinimizeToTray.Checked = value; }
        }

        public SettingsForm()
        {
            InitializeComponent();
        }

        private void SettingsForm_Load(object sender, EventArgs e)
        {
            bool ext = false;
            if (LampOnUrl.StartsWith(LampStateUrl))
            {
                _onSuffix = LampOnUrl.Substring(LampStateUrl.Length);
            }
            else
            {
                ext = true;
            }
            if (LampOffUrl.StartsWith(LampStateUrl))
            {
                _offSuffix = LampOffUrl.Substring(LampStateUrl.Length);
            }
            else
            {
                ext = true;
            }
            if (ext)
            {
                turnOnExtendedUrls();
            }
        }

        private void tbLampState_TextChanged(object sender, EventArgs e)
        {
            if (!_extendedUrls)
            {
                LampOnUrl = LampStateUrl + _onSuffix;
                LampOffUrl = LampStateUrl + _offSuffix;
            }
        }

        private void btnEditUrls_Click(object sender, EventArgs e)
        {
            turnOnExtendedUrls();
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.OK;
        }

        private void turnOnExtendedUrls()
        {
            btnEditUrls.Visible = false;
            tbLampOn.Width = tbLampState.Width;
            tbLampOff.Width = tbLampState.Width;
            tbLampOn.ReadOnly = false;
            tbLampOff.ReadOnly = false;
            _extendedUrls = true;
        }
    }
}
