import sys
import base64
from io import BytesIO
from PIL import Image, ImageOps
from langchain_ollama import OllamaLLM

def convert2Base64(image):
    buffered = BytesIO()
    rgb_im = image.convert('RGB')
    rgb_im.save(buffered, format="JPEG") 
    img_str = base64.b64encode(buffered.getvalue()).decode("utf-8")
    return img_str


llm_inst = OllamaLLM(model='llava:v1.6', base_url=sys.argv[1], temperature=0)
prompt = "Create headline for image."

image = Image.open(sys.argv[2])
ImageOps.exif_transpose(image, in_place=True)
image.thumbnail((672, 672))
image_b64 = convert2Base64(image)

llm_context = llm_inst.bind(images=[image_b64])
print (llm_context.invoke(prompt))


