import sys
import signal
import base64
from io import BytesIO
from PIL import Image, ImageOps
from langchain_ollama import OllamaLLM
from threading import Thread
from time import time, sleep

def convert2Base64(image):
    buffered = BytesIO()
    rgb_im = image.convert('RGB')
    rgb_im.save(buffered, format="JPEG") 
    img_str = base64.b64encode(buffered.getvalue()).decode("utf-8")
    return img_str

def llmInvoke(ctx, prompt):
    global llm_result
    llm_result = None
    llm_result = ctx.invoke(prompt)

llm_timeout = 10.0
llm_thread = None
llm_result = None
llm_inst = OllamaLLM(model='llava:v1.6', base_url=sys.argv[1], temperature=0)
prompt = "list keywords describing the image, separated by comma."

image = Image.open(sys.argv[2])
ImageOps.exif_transpose(image, in_place=True)
image.thumbnail((672, 672))
image_b64 = convert2Base64(image)

llm_context = llm_inst.bind(images=[image_b64])
llm_thread = Thread(target=llmInvoke, args=[llm_context, prompt])
llm_start  = time()
llm_thread.start()
while llm_thread.is_alive():
    sleep(1)
    if time() - llm_start > llm_timeout:
        signal.pthread_kill(llm_thread.ident, signal.SIGKILL)
print(llm_result)

