#!/bin/bash

# 2 Parameter übergeben?
# überwachtes Verzeichnis
[ -z "${1}" ] && exit 1
# Eingabedatei
[ -z "${2}" ] && exit 1

# existiert das zu überwachende Verzeichnis?
dir_input="${1}"
[ -d "${dir_input}" ] || exit 1

# Ausgabeverzeichnis ocr neben dem überwachten Verzeichnis anlegen
dir_output="$(dirname "${dir_input}")/ocr"
[ -d "${dir_output}" ] || mkdir "${dir_output}"

# Ein- und Ausgabedateien definieren
file="${2}"
file_out="${file}"
# exisitiert die Eingabedatei?
[ -e "${dir_input}/${file}" ] || exit 1

# wenn die Ausgabedatei bereits existiert, ihren Namen um ein
# zufälliges Element ergänzen
if [ -e "${dir_output}/${file}" ]; then
	file_out_name="${file_out%.*}"
	file_out_ext="${file_out##*.}"
	file_out="${file_out_name}-$$.${file_out_ext}"
fi

# Format der Eingabedatei erkennen, wenn pdf dann OCR, wenn kein pdf,
# dann Datei nur vom Eingabe- ins Ausgabeverzeichnis verschieben
if ( file -bi "${dir_input}/${file}" | grep 'application/pdf' >/dev/null 2>&1 ) then
	/home/scanner/ocrmypdf/bin/python /home/scanner/ocrmypdf/bin/ocrmypdf -l deu \
		"${dir_input}/${file}" \
		"${dir_output}/${file_out}" >/dev/null 2>&1
	# wenn OCR-Wandlung ohne Fehler, dann Eingabedatei löschen
	[ $? -eq 0 ] && rm "${dir_input}/${file}" >/dev/null 2>&1
else
	# kein pdf
	# Eingabedatei verschieben ins Ausgabeverzeichnis
	mv "${dir_input}/${file}" "${dir_output}/${file_out}" >/dev/null 2>&1
fi
