#Requires -RunAsAdministrator

<#
.SYNOPSIS
  USB-SpeeedCheck
.DESCRIPTION
  Lesen Sie unbedingt die Anleitungen zum Skript in c't 12/2025
.NOTES
  Version:        1.00
  Author:         Axel Vahldiek <axv@ct.de>
  Creation Date:  2025-04-23
#>



cls 
$USBLW = Get-Disk | Where-Object {$_.BusType -eq 'USB'}
If ($USBLW) {
	$USBLW | ForEach-Object {
		Write-Host "`n" $_.FriendlyName $([math]::round($_.Size / 1GB, 1))"GB`n"
		Winsat Disk -Drive (Get-Partition -DiskNumber $_.Number |  Where-Object {$_.DriveLetter} | Select-Object -First 1 -ExpandProperty DriveLetter) | Where-Object {
			$_ -match "sequent"
		}
	}
} Else {
	Write-Host "`nKein USB-Laufwerk gefunden."
}

Write-Host "`nEnter zum Beenden"
Read-Host