Attribute VB_Name = "modMessage"
Option Explicit
'**************************************************
' Eine Sammlung angemeldeter Objekte
'**************************************************
Dim m_colMsgObjects As Collection

'**************************************************
' RaiseEvents reicht die Parameter an alle an-
' gemeldeten Objekte weiter
'**************************************************
Public Sub RaiseEvents(ByVal MessageID As Long, ByVal MessageTag As Long)
  On Error GoTo RaiseEventsErr

  Dim objEvents As clsEvents
  
  '**************************************************
  ' eine Methode der angemeldeten Objekte aufrufen,
  ' die ihrerseits wieder ein Ereignis auslsen
  '**************************************************
  For Each objEvents In m_colMsgObjects
    objEvents.RaiseAppMessage MessageID, MessageTag
  Next
  

RaiseEventsExit:
  On Error Resume Next
  Exit Sub
RaiseEventsErr:
  'put your debug stuff here
  #If ver_debug Then
    Debug.Print "Error@modMessage.RaiseEvents.Line:"; Erl; Err.Number; Err.Description
  #End If
  Resume RaiseEventsExit
End Sub

'**************************************************
' Fgt ein Objekt der Sammlung aller angemeldeten
' Objekte hinzu
'**************************************************
Public Sub AddMessageObject(This As clsEvents)
  On Error GoTo AddMessageObjectErr
  
  If m_colMsgObjects Is Nothing Then Set m_colMsgObjects = New Collection
  
  m_colMsgObjects.Add This
  

AddMessageObjectExit:
  On Error Resume Next
  Exit Sub
AddMessageObjectErr:
  'put your debug stuff here
  #If ver_debug Then
    Debug.Print "Error@modMessage.AddMessageObject.Line:"; Erl; Err.Number; Err.Description
  #End If
  Resume AddMessageObjectExit
End Sub

'**************************************************
' Entfernt ein Objekt wieder
'**************************************************
Public Sub RemoveMessageObject(This As clsEvents)

  Dim vObjects As clsEvents
  
  '**************************************************
  ' Sammlung durchlaufen und bei gleicher
  ' Identitt wieder entfernen
  '**************************************************
  For Each vObjects In m_colMsgObjects
    If vObjects Is This Then
      m_colMsgObjects.Remove vObjects
      Debug.Print "Object removed"
      Exit For
    End If
  Next
  
End Sub
