/**********************************/
/* ct-Logo-Bildschirmschoner     */
/* Kai-Uwe Mrkor                  */
/* 1998                           */
/**********************************/
#include <windows.h>
#include <scrnsave.h>
#include <mmsystem.h>
#include <stdio.h>
#include "RES\resource.h"
#define ANZAHLBILDER	 18
#define TIMER_ID		207

HBITMAP hbmLogo[ANZAHLBILDER];	/* Handles auf die Teilbilder */
int		aktBild=0;				/* Index auf das aktuelle Bild*/
RECT	bildschirm;				/* Desktop-Dimensionen */
int		posx=0,					/* aktuelle X-Position des Logos */
		posy=0;					/* aktuelle Y-Position des Logos */
int		XRichtung=1,			/* X-Bewegungsrichtung des Logos */
		YRichtung=1;			/* Y-Bewegungsrichtung des Logos */
int		intervall;				/* Aufrufintervall */
BOOL	bKrach=FALSE;			/* Merkbit Bandengerusch EIN/AUS*/
BOOL	bande=FALSE;			/* Merkbit fr Bande berhrt */
HANDLE	hresWave;				/* Handle auf die Wave-Resource */
LPSTR	lpWave;					/* Zeiger auf die Wave-Resource */

void LeseRegistrierung(void);

/****************************************/
/* Konfiguration des Bildschirmschoners */
/****************************************/
BOOL WINAPI ScreenSaverConfigureDialog(HWND hDlg, UINT message,
									   WPARAM wParam, LPARAM lParam)
{
	static HWND	hTest;
	HANDLE hResInfo;

	char  dummy[5];
	HKEY  hKey; 
	DWORD  dwDisposition; 

	switch(message) 
	{
		case WM_INITDIALOG:	 /* Dialogbox initialisieren */
			LeseRegistrierung();

			SetDlgItemInt(hDlg, IDC_INTERVALL, intervall, FALSE);
			SendDlgItemMessage(hDlg, IDC_KRACH, BM_SETCHECK, (WPARAM)bKrach, (LPARAM)0);		 

			hTest=GetDlgItem(hDlg, IDC_TEST);
			EnableWindow(hTest, bKrach);

			return TRUE;

		case WM_COMMAND:		/* Dialogereignisse auswerten */
			switch (LOWORD(wParam))
			{
				case IDOK:			/* nderungen bernehmen */	
					intervall=GetDlgItemInt(hDlg, IDC_INTERVALL, NULL, FALSE);

					RegCreateKeyEx(HKEY_CURRENT_USER,
								"SOFTWARE\\Kai-Uwe Mrkor\\c`t-Logo",
								0, 
								NULL, 
								REG_OPTION_NON_VOLATILE, 
								KEY_WRITE, 
								NULL, 
								&hKey, 
								&dwDisposition); 

					wsprintf(dummy, "%u", intervall);
					RegSetValueEx(hKey, "Intervall", 0, REG_SZ, dummy, sizeof(dummy));

					if(bKrach) 
						wsprintf(dummy,"1");
					else
						wsprintf(dummy,"0");

					RegSetValueEx(hKey, "Sound", 0, REG_SZ, dummy, sizeof(dummy));

				case IDCANCEL:		/* nderungen verwerfen */
					EndDialog(hDlg, TRUE);
					return TRUE;

				case IDC_KRACH:	/* Bandengerusch EIN-/AUS-schalten*/
					bKrach ^= 1;
					CheckDlgButton(hDlg, wParam, bKrach);
					EnableWindow(hTest, bKrach);
					break;

				case IDC_TEST:		/* Bandengerusch testen */
					if( hResInfo = FindResource(hMainInstance, "BANDE", "WAVE") )
					{
						if( hresWave = LoadResource(hMainInstance, hResInfo) )
						{
							if( lpWave = LockResource(hresWave) )
							{
								sndPlaySound(lpWave, SND_SYNC | SND_MEMORY | SND_NODEFAULT);
								UnlockResource(hresWave);
							}
							FreeResource(hresWave);
						}
					}
					break;
			}
	}
	return FALSE;
}

/************************************/
/* Die eigentliche BSS-Routine      */
/************************************/
LONG WINAPI ScreenSaverProc(HWND hWnd, UINT message,
							WPARAM wParam, LPARAM lParam)
{
	BITMAP	bm;

	HDC		hDC, hMemDC;
	HBITMAP	hbmOld;

	HANDLE	hResInfo;

	int		i;
	char	dummy[8];

	switch(message)
	{
		case WM_CREATE:		/* Erzeugen des BSS */
			for(i=1; i<=ANZAHLBILDER; i++)
			{
				wsprintf(dummy,"LOGO_%0.2d",i);
				hbmLogo[i-1] = LoadBitmap(hMainInstance, dummy);
			}

			if( hResInfo = FindResource(hMainInstance, "BANDE", "WAVE") )
				if( hresWave = LoadResource(hMainInstance, hResInfo) )
					lpWave = LockResource(hresWave);

			LeseRegistrierung();
			SetTimer(hWnd, TIMER_ID, intervall, NULL);
			GetClientRect(hWnd, &bildschirm);
			break;	

		case WM_ERASEBKGND:
			break;

		case WM_TIMER:		/* Timerintervall */
			aktBild++;
			if(aktBild == ANZAHLBILDER)
				aktBild = 0;

			GetObject(hbmLogo[aktBild], sizeof(bm), &bm);	

			hDC    = GetDC(hWnd);									
			hMemDC = CreateCompatibleDC(hDC);						
			hbmOld = SelectObject(hMemDC, hbmLogo[aktBild]);		

			if(bildschirm.right < 200)	/* Ausgabe im Vorschaufenster */
			{
				BitBlt( hDC,0,0,
						bm.bmWidth,bm.bmHeight,
						hMemDC,0,0,SRCCOPY);
			}
			else						/* Desktop-Ausgabe */
			{
				BitBlt(	hDC,posx,posy,
						bm.bmWidth,bm.bmHeight,
						hMemDC,0,0,SRCCOPY);

				posx += (XRichtung*2);		/* neue X-Position festlegen */
				posy += (YRichtung*2);		/* neue Y-Position festlegen */

				/* ist das Logo unten angestoen ? */
				if(posy+bm.bmHeight > bildschirm.bottom)
				{
					bande=TRUE;
					YRichtung=-1;
				}

				/* ist das Logo oben angestoen ? */
				if(posy < bildschirm.top)
				{
					bande=TRUE;
					YRichtung=1;
				}

				/* ist das Logo links angestoen ? */
				if(posx < bildschirm.left)
				{
					bande=TRUE;
					XRichtung=+1;
				}

				/* ist das Logo rechts angestoen ? */
				if(posx+bm.bmWidth > bildschirm.right)
				{
					bande=TRUE;
					XRichtung=-1;
				}

				/* Bandengerusch ausgeben ? */
				if(bande==TRUE && bKrach==TRUE)
				{
					bande=FALSE;
					sndPlaySound(lpWave, SND_ASYNC | SND_MEMORY | SND_NODEFAULT);
				}

			} // else

			SelectObject(hMemDC, hbmOld);
			DeleteDC(hMemDC);
			ReleaseDC(hWnd, hDC);

			break;	

		case WM_DESTROY:	/* Beenden des BSS */
			if(lpWave)
				UnlockResource(hresWave);
			if(hresWave)
				FreeResource(hresWave);

			KillTimer(hWnd,TIMER_ID);

			for(i=0; i<ANZAHLBILDER; i++)
				DeleteObject(hbmLogo[i]);

			break;	
	}

	/* Nachricht an DefScreenSaverProc() weiterleiten */
	return DefScreenSaverProc(hWnd,message,wParam,lParam);
}

/***********************************/
/* Registrierung der Fensterklasse */
/***********************************/
BOOL WINAPI RegisterDialogClasses(HANDLE hInst)
{
	return TRUE;
}

/***********************************/
/* Registrierung auslesen          */
/***********************************/
void LeseRegistrierung( void)
{
	HKEY hKey;
	DWORD groesse;
	DWORD art;
	char puffer[40];
	int dummy;

	if(RegOpenKeyEx(HKEY_CURRENT_USER,
					"SOFTWARE\\Kai-Uwe Mrkor\\c`t-Logo",
					0, 
					KEY_READ, 
					&hKey ) == ERROR_SUCCESS) 
	{
		groesse = sizeof(puffer);
		art = REG_SZ;
		RegQueryValueEx(hKey, "Intervall", 0, &art, puffer, &groesse);
		sscanf(puffer,"%u",&intervall);

		RegQueryValueEx(hKey, "Sound", 0, &art, puffer, &groesse);
		sscanf(puffer,"%u",&dummy);
		if(dummy)
			bKrach = TRUE;
	}
	else	/* noch kein Eintrag in der Registrierung */
	{
		intervall = 100;
		bKrach = TRUE;
	}
}
