#!/usr/bin/perl

# copyright ct/ju

use IO::Socket;

sub get_host {
# Arg 1: IP-Adresse als String
# Return: Host-Name als String
  my $iaddr, $host;
  # String in numerisches Formmat wandeln
  $iaddr = inet_aton($_[0]);
  $host = gethostbyaddr ( $iaddr , AF_INET ) || return "";
  return $host;
}

sub get_user {
# Arg 1: IP-Adresse als String
# Arg 2: Port des Browsers
# Arg 3: Port des Servers
# Return: String mit User-Name bzw. Full-Name
  my ($iname, $port, $sport, $iaddr, $paddr, $proto, $question, $answer, $id);

  $iname = $_[0];
  $port = $_[1];
  $sport = $_[2];
  #-- test identd --
  $iaddr = inet_aton ( $iname );
  # Port 113: identd
  $paddr = sockaddr_in ( 113 , $iaddr );
  $proto= getprotobyname( "tcp" );
  # Format der Anfrage: "<<lokaler Port>>, <<enfernter Port>>"
  $question = "$port, $sport\n";

  socket( SOCK, PF_INET, SOCK_STREAM, $proto) || return "";
  connect( SOCK, $paddr ) || return "";
  send( SOCK, $question, 0) || return "";
  recv( SOCK, $answer, 1024, 0) || return "";
  close( SOCK ); 
  # Format der Antwort: 
  # "<<lok.Port>> , <<entf. Port>> : USERID : UNIX :ju"
  (undef, undef, undef, $id ) = split (":", $answer);

  if ( $id ) {
    #-- now try finger --
    $remote = IO::Socket::INET->new(
       Proto => "tcp",
       PeerAddr => $iname,
       PeerPort => "finger(79)"
    ) or return $id;
    $remote->autoflush(1);
    print $remote "$id\n";
    while (<$remote>) {
      # Suchen nach "Name: Hugo Meier"
      if (/Name: ([a-z, ]+)/i) {
	$id = $1;
      }
    }
    close $remote; 
  }
  return $id;
}



############
# Main
###########

#-- Get Infos --
$sport    = "$ENV{SERVER_PORT}";
$addr     = "$ENV{REMOTE_ADDR}";
$port     = "$ENV{REMOTE_PORT}";
$browser  = "$ENV{HTTP_USER_AGENT}";
$url      = "$ENV{REQUEST_URI}";
$host     =  get_host ($addr);       
$user     =  get_user( $addr, $port, $sport);
$now      =  localtime;


#-- HTML-Seite erzeugen --
# HTML-Kopf
print( "Content-type: text/html\r\n\r\n",
       "<html><head>",
       "<title>BigBrother (Perl)</title>\n",
       "</head><body>");

# HTML-Text
print( "<H2>We are watching... </H2>\n",
       "<p><H3> Hello $user, nice to see you.\n</H3><p>",
       "You connected at $now from $host ($addr), Port $port.\n<p>",
       "You are using $browser\n<P>");

# HTML-Ausgabe beenden
print ("</body></html>\n");
