#!/usr/bin/perl

# CGI-Skript, das diverse Informationen ueber
# den Aufrufer abspeichert
#
# copyright 1999 ct/ju

use IO::Socket;

# Konstanten fuer flock()
$LOCK_SH = 1;
$LOCK_EX = 2;
$LOCK_NB = 4;
$LOCK_UN = 8;

sub get_host {
# Arg 1: IP-Adresse als String
# Return: Host-Name als String
  my $iaddr, $host;
  # String in numerisches Formmat wandeln
  $iaddr = inet_aton($_[0]);
  $host = gethostbyaddr ( $iaddr , AF_INET ) or return "";
  return $host;
}

sub get_user {
# Arg 1: IP-Adresse als String
# Arg 2: Port des Browsers
# Arg 3: Port des Servers
# Return: String mit User-Name bzw. Full-Name
  my ($iname, $port, $sport, $iaddr, $paddr, $proto, $question, $answer, $id);

  $iname = $_[0];
  $port = $_[1];
  $sport = $_[2];
  #-- test identd --
  $iaddr = inet_aton ( $iname );
  # Port 113: identd
  $paddr = sockaddr_in ( 113 , $iaddr );
  $proto= getprotobyname( "tcp" );
  # Format der Anfrage: "<<lokaler Port>>, <<enfernter Port>>"
  $question = "$port, $sport\n";

  socket( SOCK, PF_INET, SOCK_STREAM, $proto) or return "";
  connect( SOCK, $paddr ) or return "";
  send( SOCK, $question, 0) or return "";
  recv( SOCK, $answer, 1024, 0) or return "";
  close( SOCK ); 
  # Format der Antwort: 
  # "<<lok.Port>> , <<entf. Port>> : USERID : UNIX :ju"
  (undef, undef, undef, $id ) = split (":", $answer);

  if ( $id ) {
    #-- now try finger --
    $remote = IO::Socket::INET->new(
       Proto => "tcp",
       PeerAddr => $iname,
       PeerPort => "finger(79)"
    ) or return $id;
    # Systempuffer abschalten
    $remote->autoflush(1);
    # nach Benutzer fragen
    print $remote "$id\n";
    # Ausgabe auswerten
    while (<$remote>) {
      # Suchen nach "Name: Hugo Meier"
      if (/Name: ([a-z, ]+)/i) {
	$id = $1;
      }
    }
    close $remote; 
  }
  return $id;
}

############
# Main
###########

#-- Get Infos --
$sport    = "$ENV{SERVER_PORT}";
$addr     = "$ENV{REMOTE_ADDR}";
$port     = "$ENV{REMOTE_PORT}";
$browser  = "$ENV{HTTP_USER_AGENT}";
$url      = "$ENV{REQUEST_URI}";
$host     =  get_host ($addr);       
$user     =  get_user( $addr, $port, $sport);
$now      =  localtime;


#-- Log infos --
open (LOG, ">>logs/stats.log") or die ("$!: cant open stats.log\n");
flock (LOG, $LOCK_EX) or die ("$!: cant get lock\n");
print (LOG "$now, URL=$url, ADDR=$addr, HOST=$host, ",
           "PORT=$port, BROWSER=$browser, USER=$user\n");
flock (LOG, $LOCK_UN);
close (LOG);

# return Image-Location to keep Browser happy
print "location: //icons/null.gif\n\n";

