/**************************************************************************/
/**************************************************************************/
/**                                                                      **/
/**               TU Muenchen - Institut fuer Informatik                 **/
/**                                                                      **/
/** Program for the game of Solitair  V1.1                               **/
/**                                                                      **/
/**            Joern Eichler                                             **/
/**            Jochen Jaeger                                             **/
/**            Thomas Ludwig                                             **/
/**                                                                      **/
/** File:      gen_array.c                                               **/
/**                                                                      **/
/**************************************************************************/
/**************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <limits.h>

#ifndef STYPE
#define STYPE unsigned long long
#endif

#define ULONG unsigned long

FILE *disktable;

struct HashEntry {
    STYPE hashindex;		/* The board */
    STYPE solutions;		/* Number of solutions from this pos. */
};

#ifndef BIG_ENDIAN
#define BIG_ENDIAN 4321
#endif
#ifndef LITTLE_ENDIAN
#define LITTLE_ENDIAN 1234
#endif

unsigned short byte_order = BIG_ENDIAN;		/* hope for the best... */

union {
    ULONG ll;
    unsigned char bytes[4];
} endian;

void check_byte_order(void)
{
    endian.ll = 0x01020304;
    if (endian.bytes[0] == 1)
	/* Big Endian 
	 * so nothing to change... */
	;
    else
	/* Hmm... Little Endian
	 * we have to change all values... */
	byte_order = LITTLE_ENDIAN;
}

STYPE little_to_big(STYPE x)
{
    STYPE y;

    ((char *) &y)[0] = ((char *) &x)[7];
    ((char *) &y)[1] = ((char *) &x)[6];
    ((char *) &y)[2] = ((char *) &x)[5];
    ((char *) &y)[3] = ((char *) &x)[4];
    ((char *) &y)[4] = ((char *) &x)[3];
    ((char *) &y)[5] = ((char *) &x)[2];
    ((char *) &y)[6] = ((char *) &x)[1];
    ((char *) &y)[7] = ((char *) &x)[0];

    return y;
}

int reads = 0;

STYPE read_key(int index)
{
    struct HashEntry h;
    reads++;
    fseek(disktable, index * sizeof(struct HashEntry), SEEK_SET);
    fread((void *) &h, sizeof(struct HashEntry), 1, disktable);
    return h.hashindex;
}

int main()
{
    int i = 0;
    FILE *wp;
    STYPE key;

    check_byte_order();
    disktable = fopen("disktable", "rb");
    if (!disktable) {
	printf("Disktable file not found!\n");
	exit(0);
    }

// write out index table, therefore get key for every 2048th entry
    wp=fopen("disktable.index","wb");
    fprintf(wp,"STYPE index[] = {");
    for(i=0;;i+=2048) {
	key=read_key(i);
	if(byte_order==LITTLE_ENDIAN) key=little_to_big(key);
        if (feof(disktable)) break;
	if (i!=0) fprintf(wp,",");
	fprintf(wp,"%lldULL", key);
    }
    fprintf(wp,"};");
    fclose(wp);
    fclose(disktable);
    return 1;
}
