//
// Simple3D.java, Frank Bu 03/1999
//
// So einfach ist das Java 3D API.
//

// imports fr GraphicsConfiguration, Frame und BorderLayout
import java.awt.*;

// imports fr WindowAdapter und WindowEvent fr windowClosing
import java.awt.event.*;

// imports fr Canvas3D, BranchGroup, Transform3D und TransformGroup
import javax.media.j3d.*;

// Utility Klassen machen einem das Leben leichter
import com.sun.j3d.utils.geometry.ColorCube;
import com.sun.j3d.utils.universe.SimpleUniverse;

// Definition der eigentlichen Klasse
public class Simple3D
{
    // Programmstart
    public static void main(String[] args) {

        //
        // 3D Szene aufbauen
        //

        // 3D Transformationsmatrix erzeugen und um 210 Grad drehen
        Transform3D trans = new Transform3D();
        trans.rotY(Math.PI / 180 * 210);

        // Knoten mit der Rotationsmatrix erzeugen und Wrfel einhngen
        TransformGroup group = new TransformGroup(trans);
        group.addChild(new ColorCube(0.5));

        // Wurzelknoten erzeugen und die Gruppe mit dem Wrfel einhngen
        BranchGroup root = new BranchGroup();
        root.addChild(group);

        //
        // Szene anzeigen
        //

        // ein 3D-Canvas mit Default-Konfiguration erzeugen
        GraphicsConfiguration c = SimpleUniverse.getPreferredConfiguration();
        Canvas3D canvas = new Canvas3D(c);

        // Universum erzeugen und Szene einhngen
        SimpleUniverse universe = new SimpleUniverse(canvas);
        universe.addBranchGraph(root);

        // etwas zurcktreten, damit alles sichtbar wird
        universe.getViewingPlatform().setNominalViewingTransform();

        // Hauptfenster der Gre 400 x 400 mit Schliemglichkeit erzeugen
        Frame frame = new Frame("Simple Java 3D Demo");
        frame.setSize(400, 400);
        frame.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) { System.exit(0); }
        });

        // 3D-Canvas dem Fenster hinzufgen und Fenster anzeigen
        frame.add(BorderLayout.CENTER, canvas);
        frame.show();
    }
}
