//
// ct.java, Frank Bu 03/1999
//
// Ein beleuchteter, dreidimensionaler Schriftzug mit
// der Maus in alle Richtungen drehbar.
//

// imports fr GraphicsConfiguration, Frame und BorderLayout
import java.awt.*;

// imports fr WindowAdapter und WindowEvent fr windowClosing
import java.awt.event.*;

// imports fr verschiendene Knoten-Klassen
import javax.media.j3d.*;

// imports fr Point3f, Point3d, Color3f und Vector3f
import javax.vecmath.*;

// Utility Klassen machen einem das Leben leichter
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.behaviors.mouse.MouseRotate;

// Definition der eigentlichen Klasse
public class ct
{
    // Programmstart
    public static void main(String[] args) {

        //
        // 3D Szene aufbauen
        //

        // 3D Transformationsmatrix erzeugen und um 210 Grad drehen
        Transform3D trans = new Transform3D();
        trans.rotY(Math.PI / 180 * 30);

        // Knoten mit der Rotationsmatrix erzeugen und Wrfel einhngen
        TransformGroup group = new TransformGroup(trans);

        // neues Font3D Objekt erzeugen
        Font3D f3d = new Font3D(
            new Font("SansSerif", Font.BOLD, 1),
            new FontExtrusion());

        // Textgeometrie fr den Schriftzug c't erzeugen
        Text3D text = new Text3D(f3d, "c't", new Point3f( -.8f, -.5f, 0f));

        // neues Shape3D Objekt mit dem Schriftzug erzeugen
        Shape3D textShape = new Shape3D(text);

        // Farben fr das Material
        Color3f objColor = new Color3f(1f, 1f, 1f);
        Color3f black = new Color3f(0, 0, 0);

        // ein neues Material-Objekt damit initialisieren
        Material mat = new Material(objColor, black, objColor, black, 20f);

        // und ein Apperance-Objekt damit initialisieren
        Appearance app = new Appearance();
        app.setMaterial(mat);

        // im Logo das neue Material setzen
        textShape.setAppearance(app);

        // und der Gruppe hinzufgen
        group.addChild(textShape);

        // grere Bounding Box fr Mouse- und Licht-Bounds anlegen
        Bounds bounds = new BoundingBox(
            new Point3d(-10, -10, -10),
            new Point3d(10, 10, 10));

        // Mglichkeit zur Maus-Interaktion erzeugen
        group.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
        group.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
        MouseRotate behavior = new MouseRotate(group);
        behavior.setSchedulingBounds(bounds);
        group.addChild(behavior);

        // Wurzelknoten erzeugen und die Gruppe mit dem Logo einhngen
        BranchGroup root = new BranchGroup();
        root.addChild(group);

        // weie Farbe und Richtung fr das Licht erzeugen
        Color3f lightColor = new Color3f(1f, 1f, 1f);
        Vector3f lightDirection = new Vector3f(-1f, -2f, -5f);

        // paralleles Licht aus einer Richtung erzeugen
        DirectionalLight light =
            new DirectionalLight(lightColor, lightDirection);
        light.setInfluencingBounds(bounds);

        // und der Wurzel hinzufgen
        root.addChild(light);

        //
        // Szene anzeigen
        //

        // ein 3D-Canvas mit Default-Konfiguration erzeugen
        GraphicsConfiguration c = SimpleUniverse.getPreferredConfiguration();
        Canvas3D canvas = new Canvas3D(c);

        // Universum erzeugen und Szene einhngen
        SimpleUniverse universe = new SimpleUniverse(canvas);
        universe.addBranchGraph(root);

        // etwas zurcktreten, damit alles sichtbar wird
        universe.getViewingPlatform().setNominalViewingTransform();

        // Hauptfenster der Gre 400 x 400 mit Schliemglichkeit erzeugen
        Frame frame = new Frame("Java3D: c't interactiv");
        frame.setSize(400, 400);
        frame.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) { System.exit(0); }
        });

        // 3D-Canvas dem Fenster hinzufgen und Fenster anzeigen
        frame.add(BorderLayout.CENTER, canvas);
        frame.show();
    }
}
