unit DISimpleU;  // 14-MAR-99 as (Arne Schpers)
{ Einfache Abfrage von Tastatur, Maus und Joystick
  ber DirectInput }

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Forms, Dialogs,
  DXTimer,   // schneller Timer
  DInput,    // Erik Ungers Header, ab ca. 05-APR-99
  DXInputAS, Menus, StdCtrls; // DirectInput-Komponenten

type
  TDISimpleForm = class(TForm)
    gKeyboard: TGroupBox;
    eKeyboard: TEdit;
    gMouse: TGroupBox;
    Label1: TLabel;
    lMouseX: TLabel;
    Label2: TLabel;
    lMouseY: TLabel;
    Label3: TLabel;
    lMouseZ: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    lMouseButton0: TLabel;
    lMouseButton1: TLabel;
    lMouseButton2: TLabel;
    Label8: TLabel;
    lMouseAccX: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label7: TLabel;
    Label11: TLabel;
    lMouseAccY: TLabel;
    lMouseAccZ: TLabel;
    gJoystick: TGroupBox;
    Label12: TLabel;
    lJoyX: TLabel;
    Label14: TLabel;
    lJoyY: TLabel;
    Label16: TLabel;
    lJoyZ: TLabel;
    Label18: TLabel;
    lJoyButtons: TLabel;
    Label13: TLabel;
    lJoyHat: TLabel;
    lJoyHasFF: TLabel;
    Label15: TLabel;
    lJoyPoll: TLabel;
    Label17: TLabel;
    Label19: TLabel;
    Label20: TLabel;
    Label21: TLabel;
    Label22: TLabel;
    Label23: TLabel;
    lJoyRX: TLabel;
    lJoyRY: TLabel;
    lJoyRZ: TLabel;
    lKeyboard: TLabel;
    cEnable: TCheckBox;
    cTabStops: TCheckBox;
    Label24: TLabel;
    Label25: TLabel;
    lMX: TLabel;
    Label26: TLabel;
    lMY: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure cEnableClick(Sender: TObject);
    procedure cTabStopsClick(Sender: TObject);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
  private
    DXTimer: TDXTimer;
    MouseAccX, MouseAccY, MouseAccZ: Integer;
  private  // Joystick-Abzhlerei
    JoyEnumerationPending: Boolean;
    procedure JoyEnumerationDone(Sender: TObject);
  protected
    procedure OnDXTimer(Sender: TObject);
    procedure CheckKeyboard;
    procedure CheckMouse;
    procedure CheckJoystick;
  end;

var
  DISimpleForm: TDISimpleForm;

implementation
{$R *.DFM}

procedure TDISimpleForm.FormCreate(Sender: TObject);
begin
  // DIKeyboard und DIMouse werden von DXInputAS automatisch
  // angelegt. DIJoy1 und DIJoy2 nicht, weil das bei FF-Gerten
  // einen Moment dauert. Damit die Anwendung nicht so lange
  // hngt, luft das ber einen separaten Thread
  JoyEnumerationPending := True;
  gJoyStick.Visible := False;
  TDIJoyEnumerator.Create(JoyEnumerationDone);
  // Timer zur Abfrage, luft hier (ausnahmsweise) durch,
  // damit fehlgeschlagene Abfragen auch sichtbar werden
  DXTimer := TDXTimer.Create(Self);
  with DXTimer do
  begin
    Enabled := True; Interval := 20; OnTimer := OnDXTimer;
  end;
end;

procedure TDISimpleForm.JoyEnumerationDone(Sender: TObject);
var JoyCount: Integer;
begin
  JoyCount := TDIJoyEnumerator(Sender).JoyCount;
  if JoyCount = 0 then gJoystick.Caption := 'Joysticks (none)'
   else if JoyCount > 1 then gJoystick.Caption :=
     Format('Joysticks (1 of %d)',[JoyCount]);
  lJoyHasFF.Visible := (DIJoy1 <> nil) and DIJoy1.ForceFeedback;
  if DIJoy1 <> nil then  // mindestens ein Joystick vorhanden
    with DIJoy1 do
    begin  // Productname des Joysticks
      gJoyStick.Caption := gJoyStick.Caption + ': '+ ProductName;
      // Im Vordergrund wollen wir das gute Stck allein haben
      CooperativeLevel := DISCL_FOREGROUND or DISCL_EXCLUSIVE;
      // Alle Achsen auf -1000 .. + 1000 skalieren
      SetRangeProperty(DIPROP_RANGE,-1000,1000,-1);
      // Nullzone 15%
      SetDWordProperty(DIPROP_DEADZONE,15*100,-1);
      // Sttigungsbereich ab 95%
      SetDWordProperty(DIPROP_SATURATION,95*100,-1);
      // Fr FF-Joysticks: automatische Zentrierung aus
      SetDWordProperty(DIPROP_AUTOCENTER,DIPROPAUTOCENTER_OFF,-1);
    end;
  gJoyStick.Visible := True;
  JoyEnumerationPending := False;
end;

procedure TDISimpleForm.cEnableClick(Sender: TObject);
begin
  // Reaktion des Editfelds auf WM_KEYxxx an/aus
  eKeyboard.Enabled := cEnable.Checked;
  if eKeyboard.Enabled then ActiveControl := eKeyboard;
end;

procedure TDISimpleForm.cTabStopsClick(Sender: TObject);
var x: Integer;
begin  // TabStop fr Controls mit eigenem Fokus an/aus
  for x := 0 to ComponentCount-1 do
    if Components[x] is TWinControl then
      TWinControl(Components[x]).TabStop :=
         cTabStops.Checked;
end;

procedure TDISimpleForm.OnDXTimer(Sender: TObject);
begin
  CheckKeyboard; CheckMouse; CheckJoystick;
end;

// "Makro". XRef: CheckMouse, CheckJoystick
procedure ShowInt(L: TLabel; Val: Integer);
begin
  L.Caption := IntToStr(Val);
end;

procedure TDISimpleForm.CheckKeyboard;  // auch im Hintergrund
var x,y: Cardinal; SKeys: String;
begin
  SKeys := '';
  with DIKeyboard do
  begin
    Poll;  // Acquire und bertrag nach Data
    for x := 0 to 255 do
      if Data[x] and $80 <> 0 then
        // Anzeige der Namen ber Suche in den Elementen
        for y := 0 to ElementCount-1 do
          with Elements[y]^ do
            if dwOfs = x then
            begin
              SKeys := SKeys + ' ' + StrPas(tszName);
              Break;
            end;
  end;
  // Editfeld wird auch ber WM_KEY.. versorgt
  eKeyboard.Text := Copy(SKeys,2,255);
  lKeyboard.Caption := Copy(SKeys,2,255);
end;

procedure TDISimpleForm.FormMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin  // zum Vergleich 
  ShowInt(lMX,X); ShowInt(lMY,Y);
end;

procedure TDISimpleForm.CheckMouse;  // auch im Hintergrund
begin
  with DIMouse do
  begin
    Poll;  // Acquire, GetDeviceState (= bertrag nach Data)
    with Data do
    begin
      ShowInt(lMouseX,lX); ShowInt(lMouseY,lY);
      ShowInt(lMouseZ,lZ);  // Rdchen der IntelliMouse
      // akkumulierte Bewegung
      Inc(MouseAccX,lX); ShowInt(lMouseAccX,MouseAccX);
      Inc(MouseAccY,lY); ShowInt(lMouseAccY,MouseAccY);
      Inc(MouseAccZ,lZ); ShowInt(lMouseAccZ,MouseAccZ);
      // Maustasten (Button3 unbercksichtigt)
      ShowInt(lMouseButton0,rgbButtons[0]);
      ShowInt(lMouseButton1,rgbButtons[1]);
      ShowInt(lMouseButton2,rgbButtons[2]);
    end;
  end;
end;

procedure TDISimpleForm.CheckJoystick;  // nur im Vordergrund
var x: Integer; SButtons: String;
begin
  if JoyEnumerationPending or (DIJoy1 = nil) then Exit;
  with DIJoy1 do
  begin
    if FAILED(Poll) then
    begin
      lJoyPoll.Caption := 'FAILED'; Exit;
    end;
    lJoyPoll.Caption := 'OK';
    with Data do
    begin  // sechs Achsen (lZ = Schubkontrolle)
      ShowInt(lJoyX,lX); ShowInt(lJoyY,lY); ShowInt(lJoyZ,lZ);
      // RZ gibt's zumindest beim SideWinder. Der Rest...
      ShowInt(lJoyRX,lRX); ShowInt(lJoyRY,lRY);
      ShowInt(lJoyRZ,lRZ);
      // Knpfe (maximal 32). Der SideWinder hat immerhin 9
      SButtons := '';
      for x := 0 to 31 do
        if rgbButtons[x] and $80 <> 0 then
          SButtons := SButtons + ' '+IntToStr(x);
      if SButtons = '' then SButtons := ' (none)';
      lJoyButtons.Caption := Copy(SButtons,2,255);
      // Kopfschalter: -1 = Center, 0 = Nord, 9000 = Ost etc.
      ShowInt(lJoyHat,rgdwPOV[0]);
    end;
  end;
end;

end.
