'==================== Variablen deklarieren ====================
DECLARE FUNCTION GetCount(BYVAL Path$) as long
DECLARE FUNCTION GetFld$(fld$)
DECLARE SUB SetCounter
DECLARE SUB ConvertFile(BYVAL File$)
DECLARE SUB ShellExecute LIB "shell32" (BYVAL hWnd&,BYVAL Operation&,BYVAL File$,BYVAL Parameters&,BYVAL Directory&,BYVAL Show&) ALIAS "ShellExecuteA"

GLOBAL Src$,Dest$,FileTypes$(14),FileNum%(14),Ext$(14),DefSrc$
GLOBAL Total&,Current&,FileName$,Path$,FileType%,Dpi%,Color%,Ratio&
GLOBAL fr as boolean,fh as boolean,fw as boolean
GLOBAL md as boolean,vr&,vh&,vw&

Dest$=""
DefSrc$="*.*"
Src$=DefSrc
md=false

Dpi%=300               'Standard-Einstellungen
Color%=4               'des Dialogfeldes beim
FileType%=1            'Start des Scripts

FileNum%(1)=772
FileTypes$(1)="TIFF Bitmap (TIF)"
Ext$(1)="TIF"
	FileNum%(2)=773
	FileTypes$(2)="CompuServe Bitmap (GIF)"
	Ext$(2)="GIF"
FileNum%(3)=774
FileTypes$(3)="JPEG Bitmap (JPG)"
Ext$(3)="JPG"
	FileNum%(4)=769
	FileTypes$(4)="Windows Bitmap (BMP)"
	Ext$(4)="BMP"
FileNum%(5)=1799
FileTypes$(5)="Corel PHOTO-PAINT 7 (CPT)"
Ext$(5)="CPT"
	FileNum%(6)=1792
	FileTypes$(6)="Corel PHOTO-PAINT 5/6 (CPT)"
	Ext$(6)="CPT"
FileNum%(7)=770
FileTypes$(7)="Paintbrush (PCX)"
Ext$(7)="PCX"
	FileNum%(8)=771
	FileTypes$(8)="Targa Bitmap (TGA)"
	Ext$(8)="TGA"
FileNum%(9)=777
FileTypes$(9)="Wavelet Compressed Bitmap (WVL)"
Ext$(9)="WVL"
	FileNum%(10)=787
	FileTypes$(10)="GEM Paint File (IMG)"
	Ext$(10)="IMG"
FileNum%(11)=800
FileTypes$(11)="CALS Compressed Bitmap (CAL)"
Ext$(11)="CAL"
	FileNum%(12)=788
	FileTypes$(12)="Adobe Photoshop (PSD)"
	Ext$(12)="PSD"
FileNum%(13)=802
FileTypes$(13)="Portable Network Graphic (PNG)"
Ext$(13)="PNG"
	FileNum%(14)=1289
	FileTypes$(14)="Encapsulated PostScript (EPS)"
	Ext$(14)="EPS"

'==================== Hauptdialog ====================
BEGIN DIALOG OBJECT MainDialog 240, 138, "BitmapWandler", SUB MainDlgFunc
	TEXT  5, 6, 55, 8, .Text1, "&Quelldateien:"
	TEXTBOX  67, 4, 124, 13, .Source
	PUSHBUTTON  197, 4, 36, 14, .Browse1, "Suchen..."
	TEXT  5, 23, 58, 8, .Text2, "&Zielverzeichnis:"
	TEXTBOX  67, 21, 124, 13, .Destination
	PUSHBUTTON  197, 21, 36, 14, .Browse2, "Suchen..."
	TEXT  5, 40, 60, 8, .Text3, "&Zielformat:"
	DDLISTBOX  68, 39, 124, 105, .FileFormat
	GROUPBOX  6, 56, 170, 78, .Group1, "Bild neu erstellen"
	CHECKBOX  13, 69, 50, 10, .Check1, "&Auflsung:"
	SPINCONTROL  68, 68, 34, 12, .Resolution
	TEXT  105, 70, 12, 8, .Text4, "dpi"
	CHECKBOX  13, 84, 50, 10, .Check2, "&Breite:"
	SPINCONTROL  68, 84, 34, 12, .Width
	TEXT  105, 86, 20, 8, .Text5, "Pixel"
	CHECKBOX  13, 100, 50, 10, .Check3, "&Hhe:"
	SPINCONTROL  68, 100, 34, 12, .Height
	TEXT  105, 102, 20, 8, .Text6, "Pixel"
	CHECKBOX  13, 117, 120, 10, .Ratio, "Seitenverhltnis beibehalten"
	OKBUTTON  185, 60, 48, 14, .OK
	CANCELBUTTON  186, 82, 48, 14, .Cancel
END DIALOG

SUB MainDlgFunc(BYVAL CtrlID%, BYVAL Event%)
DIM f as boolean
SELECT CASE Event
	CASE 0
		f=MainDialog.Check1.GETVALUE()
		MainDialog.Resolution.ENABLE f
		MainDialog.Text4.ENABLE f
		f=MainDialog.Check2.GETVALUE()
		MainDialog.Width.ENABLE f
		MainDialog.Text5.ENABLE f
		f=MainDialog.Check3.GETVALUE()
		MainDialog.Height.ENABLE f
		MainDialog.Text6.ENABLE f
		MainDialog.Ratio.Enable FALSE
	CASE 1
		SELECT CASE CtrlID
		  CASE MainDialog.Source.GETID()
		  	if not md then
			  tx$=MainDialog.Source.GETTEXT()
			  MainDialog.Destination.SETTEXT GetFld(tx$)
			endif
		  CASE MainDialog.Destination.GETID()
			md=(MainDialog.Destination.GETTEXT()<>"")
		END SELECT
	CASE 2
		SELECT CASE CtrlID
			CASE MainDialog.Browse1.GETID()
				tx$=MainDialog.Source.GETTEXT()
				fld$=GETFOLDER(GetFld(tx))
				IF fld<>"" THEN
					if right(fld,1)<>"\" then fld=fld+"\"
					tx$=MainDialog.Source.GETTEXT()
					tx$=MID(tx,LEN(GetFld(tx))+1)
					if tx$="" then tx$="*.*"
					fld=fld+tx
					MainDialog.Source.SETTEXT fld
					if not md then MainDialog.Destination.SETTEXT GetFld(fld)
				ENDIF
			CASE MainDialog.Browse2.GETID()
				fld$=GETFOLDER(MainDialog.Destination.GETTEXT())
				IF fld<>"" THEN
					if right(fld,1)<>"\" then fld=fld+"\"
					MainDialog.Destination.SETTEXT fld
					md=TRUE
				ENDIF
			CASE MainDialog.Check1.GETID()
				f=MainDialog.Check1.GETVALUE()
				MainDialog.Resolution.ENABLE f
				MainDialog.Text4.ENABLE f
			CASE MainDialog.Check2.GETID()
				f=MainDialog.Check2.GETVALUE()
				MainDialog.Width.ENABLE f
				MainDialog.Text5.ENABLE f
				MainDialog.Ratio.Enable f and MainDialog.Check3.GETVALUE()
			CASE MainDialog.Check3.GETID()
				f=MainDialog.Check3.GETVALUE()
				MainDialog.Height.ENABLE f
				MainDialog.Text6.ENABLE f
				MainDialog.Ratio.Enable f and MainDialog.Check2.GETVALUE()
			CASE MainDialog.Ratio.GetID()
				Ratio=MainDialog.Ratio.GetValue()
		END SELECT
	CASE 4
		IF MainDialog.Source.GETTEXT()="" THEN
			MainDialog.Source.SETTEXT DefSrc$
			MainDialog.Destination.SETTEXT ""
		ENDIF
		IF MainDialog.Destination.GETTEXT()="" THEN
			MainDialog.Destination.SETTEXT GetFld(MainDialog.Source.GETTEXT())
		ENDIF
END SELECT
END SUB

BEGIN DIALOG OBJECT Dialog2 205, 77, "Umwandeln...", SUB Convert
	TEXT  6, 6, 37, 8, .Text1, "Wandle um:"
	TEXT  47, 6, 150, 8, .FileName, "Dateiname"
	PROGRESS 5, 37, 195, 8, .Progress
	TEXT  78, 25, 50, 8, .Counter, "1 von 1000"
	CANCELBUTTON  82, 54, 40, 14, .Cancel
END DIALOG

SUB Convert(BYVAL CtrlID%, BYVAL Event%)
SELECT CASE Event
	CASE 0
		Dialog2.FileName.SETTEXT "Zhle Dateien. Bitte warten..."
		Dialog2.Counter.SETVISIBLE FALSE
		Dialog2.Progress.SETVISIBLE FALSE
		Dialog2.Cancel.SETVISIBLE FALSE
		Dialog2.Counter.SETSTYLE 64
		Total=GetCount(Src$)
		If Total=0 then
			Message "Keine Dateien vorhanden, die den Vorgaben entsprechen."
			Dialog2.CloseDialog 1
		else
			SetCounter
			Dialog2.Progress.SETMAXRANGE Total
			Dialog2.Progress.SETMINRANGE 0
			Dialog2.Progress.SETINCREMENT 1
			Dialog2.Progress.SETVALUE 0
			Dialog2.Counter.SETVISIBLE TRUE
			Dialog2.Progress.SETVISIBLE TRUE
			Dialog2.Cancel.SETVISIBLE TRUE
			Dialog2.SETTIMER 10
			FileName$=FINDFIRSTFOLDER(Src$,167)
		endif
	CASE 5
		if FileName$="" then
			Dialog2.CloseDialog 1
		else
			Current=Current+1
			Dialog2.FileName.SETTEXT FileName$
			SetCounter
			ConvertFile(FileName$)
			Dialog2.Progress.STEP
			FileName$=FINDNEXTFOLDER()
		endif		
END SELECT
END SUB

MainDialog.FileFormat.SETARRAY FileTypes
MainDialog.FileFormat.SETSELECT 1
MainDialog.Check1.SETTHREESTATE FALSE
MainDialog.Check2.SETTHREESTATE FALSE
MainDialog.Check3.SETTHREESTATE FALSE
MainDialog.Ratio.SETTHREESTATE FALSE
MainDialog.Resolution.SETVALUE 96
MainDialog.Width.SETVALUE 100
MainDialog.Height.SETVALUE 100
MainDialog.Source.SETTEXT DefSrc$

Retry:
Current=0
ret%=DIALOG(MainDialog)
if ret%<>1 then stop
Src$=MainDialog.Source.GETTEXT()
if src$="" then
	Message "Geben Sie Format und Verzeichnis der Quelldateien an."+CHR(13)+\\
			"Sie knnen '*' und '?' als Platzhalter verwenden"
	Goto Retry
endif
Dest$=MainDialog.Destination.GETTEXT()
if dest$="" then
	Message "Geben Sie das Zielverzeichnis an, in dem"+\\
			" die gewandelten Dateien gespeichert werden sollen."
	Goto Retry
else
	if right(dest$,1)<>"\" and right(dest$,1)<>"/" \\
						then dest$=dest$+"\"
endif
i&=LEN(src$)
do while i>0 and mid(src$,i,1)<>"/" and mid(src$,i,1)<>"\"
	i=i-1
loop
Path$=left(src$,i)
FileType%=MainDialog.FileFormat.GETSELECT()
fr=MainDialog.Check1.GETVALUE()
fw=MainDialog.Check2.GETVALUE()
fh=MainDialog.Check3.GETVALUE()
vr=MainDialog.Resolution.GETVALUE()
vh=MainDialog.Height.GETVALUE()
vw=MainDialog.Width.GETVALUE()
if fr and vr=0 then
	Message "Ungltige Auflsung"
	goto Retry
endif
if fw and vw=0 then
	Message "Ungltige Breite"
	goto Retry
endif
if fh and vh=0 then
	Message "Ungltige Hhe"
	goto Retry
endif
ret%=DIALOG(Dialog2)
goto Retry

FUNCTION GetCount(BYVAL Path$) as long
c&=0
s$=FINDFIRSTFOLDER(Path$,167)
DO WHILE s$<>""
	c=c+1
	s$=FINDNEXTFOLDER()
LOOP
GetCount=c
END Function

SUB SetCounter
	Dialog2.Counter.SETTEXT STR(Current)+" of "+STR(Total)
END SUB

SUB ConvertFile(BYVAL File$)
withobject "CorelPhotopaint.Automation.8"
i&=LEN(File$)
do while i>0 and mid(File$,i,1)<>"."
	i=i-1
loop
if i=0 then i=len(File$)+1
OutFile$=Dest$+Left(File,i-1)+"."+Ext$(FileType%)
.FileOpen Path$+File$, 0, 0, 0, 0, 0, 1, 1
.BindToActiveDocument
xdpi&=.GetDocumentXdpi()
ydpi&=.GetDocumentYdpi()
h&=.GetDocumentHeight()
w&=.GetDocumentWidth()
if fr THEN
	h=h*vr\xdpi
	w=w*vr\ydpi
	xdpi=vr
	ydpi=vr
ENDIF
IF fw and not fh then 
	h=h*vw\w
	w=vw
ELSEIF fh and not fw then 
	w=w*vh\h
	h=vh
ELSEIF fh and fw then 
	IF Ratio THEN
		IF w*vh\h>vw THEN
			h=h*vw\w
			w=vw
		ELSE
			w=w*vh\h
			h=vh
		ENDIF
	ELSE
		h=vh
		w=vw
	ENDIF
ENDIF
.ImageResample w, h, xdpi, ydpi, TRUE

SELECT CASE .GetDocumentType()     'wenn in GIF gewandelt werden soll, mu die
	CASE 1,5,6,7                  'Datei in 8Bit Farbtiefe gewandelt werden
		IF FileNum(FileType)=773 THEN .ImageConvert 4, 1, 0, 0, 0, 0, 0, 256
END SELECT
IF FileNum(FileType)=774 THEN .FilterJPG 50,FALSE,0,0,FALSE
IF FileNum(FileType)=773 THEN .FilterGIF FALSE,FALSE,0,255,70,192,192,192
'Parameter fr den JPG- und GIF-Filter festlegen
.FileSave OutFile$, FileNum(FileType), 0
.FileClose
end withobject
END SUB

FUNCTION GetFld$(fld$)
	FOR i%=LEN(fld$) TO 1 STEP -1
		if instr("/\",mid(fld$,i,1)) then EXIT FOR
	NEXT i
	GetFld=LEFT(fld,i)
END FUNCTION
