// c't Programmierkurs
// Autor: Matthias Kalle Dalheimer, 1999
// Euro5.java
// Liest eine Datei namens in.dat mit Whrungsbetrgen, die als DM
// interpretiert werden, konvertiert diese und schreibt die
// Ergebnisse in eine Datei namens out.dat.

import java.io.*;

class Euro5
{
    final static double EURONACHDM = 1.95583;
    public static void main( String[] args ) {
	// Variablen deklarieren
	String eingabezeile;
	double dm_betrag, euro_betrag;
	BufferedReader in = null;
	BufferedWriter out = null;
	
	// Reader erzeugen, ffnet gleichzeitig Datei
	try {
	    in = new BufferedReader (
		     new InputStreamReader (
		         new FileInputStream( "in.dat" ) ) );
	} catch( FileNotFoundException e ) {
	    System.out.println( "Konnte in.dat nicht finden und " +
				"zum Lesen ffnen" );
	    System.exit( 1 );
	}
	
	// Writer erzeugen, ffnet gleichzeitig Datei
	try {
	    out = new BufferedWriter (
		      new OutputStreamWriter (
		          new FileOutputStream( "out.dat" ) ) ); 
	} catch( IOException e ) {
	    System.out.println( "Konnte out.dat nicht zum " +
				"Schreiben ffnen" );
	    try {
		in.close();
	    } catch( IOException e1 ) {
		System.out.println( "Panik! Nicht einmal mehr " +
				    "Aufrumen kann man!" );
	    }
	    System.exit( 2 );
	}
	
	// zeilenweise einlesen, konvertieren und herausschreiben
	try {
	    eingabezeile = in.readLine();
	    while( eingabezeile != null ) {
		dm_betrag = 
		    Double.valueOf( eingabezeile ).doubleValue(); 
		euro_betrag = dm_betrag / EURONACHDM;
		out.write( "" + euro_betrag );
		out.newLine();
		eingabezeile = in.readLine();
	    }
	} catch( IOException e ) {
	    System.out.println( "Fehler beim Lesen oder Schreiben" );
	}
	
	// Dateien schlieen
	try {
	    in.close();
	    out.close();
	} catch( IOException e ) {
	    System.out.println( "Selbst beim Schlieen kann" +
				"noch etwas schief gehen" );
	}
    }
}

