REM BackItUp.VBS (c) c't/Tobias Weltner

set fs = CreateObject("Scripting.FileSystemObject")
set WSHShell = CreateObject("WScript.Shell")

erneuert = 0
neukopiert = 0
uptodate = 0
unzutreffend = 0
neuordner = 0
problem = 0


' ---------------------------------------------------------------------
' Syntax: BackItUp quelle, ziel, extensionen, modus
' quelle: Ordner mit den Originalen
' ziel:	  Ordner mit den Sicherheitskopien
' extensionen: Liste der Dateiextensionen, die gesichert werden sollen
'              Extensionen durch Semikola trennen: ";vbs;doc;txt;"
' modus:  1	auch Unterordner sichern
'	  2	alle Dateien sichern
'	  4	immer neu kopieren
'

BackItUp "C:\WINDOWS\DESKTOP\CT", "C:\BACKUP1", "", 1+2

' ---------------------------------------------------------------------

' Statusreport fr 10 Sekunden anzeigen:
r = neukopiert & " Dateien neu kopiert" + vbCr
r = r &  erneuert & " Dateien aktualisiert" + vbCr
r = r & uptodate & " Dateien befanden sich auf aktuellem Stand" + vbCr
r = r & unzutreffend & " Dateien entsprachen nicht den Auswahlkriterien." + vbCr
r = r & problem & " Dateien konnten aufgrund von Fehlern nicht kopiert werden." + vbCr
r = r & neuordner & " neue Ordner angelegt."
WSHShell.Popup r, 10, "Report", vbInformation


sub BackItUp(original, ziel, extensionen, mode)
	' "\" am Ende des Pfadnamens entfernen, falls vorhanden:
	if right(original,1)="\" then original=left(original, len(original)-1)
	if right(ziel,1)="\" then ziel=left(ziel, len(ziel)-1)

	' Fehler abfangen:
	if not fs.FolderExists(original) then
		fehler = "Quell-Ordner """ & original & """ existiert nicht!"
	end if
	
	if not fs.FolderExists(ziel) then
		fehler = "Ziel-Ordner """ & ziel & """ existiert nicht!"
	end if
	
	if not fehler="" then
		MsgBox fehler, vbCritical
		WScript.Quit
	end if

	' Quellordner sichern:
	set ordner = fs.GetFolder(original)
	BackupOrdner ordner, original, ziel, extensionen, mode		
end sub


sub BackupOrdner(folderobj, original, sicherung, extensionen, mode)
	' Dateien in diesem Ordner sichern
	BackupFiles folderobj, original, sicherung, extensionen, mode

	' Unterordner in diesem Ordner sichern
	' (rekursiver Aufruf)
	if (mode and 1) then
		for each unterordner in folderobj.subfolders
			BackupOrdner unterordner, original, sicherung, extensionen, mode
		next
	end if
end sub

sub BackupFiles(ordner, original, sicherung, extensionen, mode)
	' alle Dateien in diesem Ordner auflisten
	for each datei in ordner.files
		' Dateiextension der aktuellen Datei ermitteln:
		extension = ";" & lcase(fs.GetExtensionName(datei.Path)) & ";"

		' bei mode=2 oder passender Extension sichern:
		if (mode and 2) or (Instr(lcase(extensionen), extension) >0) then
			' Original wann zuletzt gendert?
			alteroriginal = datei.DateLastModified

			' liegt die Originaldatei in einem Unterordner?
			' Pfad der Datei bestimmen:
			dateipfad = datei.path
			' Dateinamen vom Pfad entfernen:
			dateipfad = left(dateipfad, InstrRev(dateipfad, "\"))
			' nur das Unterverzeichnis des Originale-Ordners briglassen:
			dateipfad = mid(dateipfad, len(original)+1)
			' Sicherungsordner + evtl. Unterordner:
			sicherungsordner = sicherung + dateipfad
			
			' Zieldateiname:
			zieldatei = sicherungsordner & datei.Name
			' Existiert bereits die Sicherungskopie?
			zieldateiexist = fs.FileExists(zieldatei)
			if zieldateiexist then
				' von wann ist die Sicherungskopie?
				alterziel = fs.GetFile(zieldatei).DateLastModified
			else
				alterziel = CDate("1.1.80")
				flag = true
			end if

			' Sicherungskopie ist veraltet oder mode=4:
			if (alteroriginal>alterziel) or (mode and 4) then
				ok = CopyIt(datei,sicherungsordner)
				if flag and ok then
					neukopiert = neukopiert + 1
				elseif ok then
					erneuert = erneuert + 1
				else
					problem = problem + 1
				end if
			else
				uptodate = uptodate + 1
			end if
		else
			unzutreffend = unzutreffend + 1
		end if
	next
end sub
		
function CopyIt(filehandle, zielordner)
	' kopiert die Datei
	on error resume next
	if not fs.FolderExists(zielordner) then
		fs.CreateFolder zielordner
		neuordner = neuordner + 1
	end if
	ziel = zielordner & filehandle.name
	filehandle.copy ziel, true
	if err.number=0 then
		CopyIt = true
	else
		CopyIt = false
		err.clear
	end if
end function