unit SDateimanager;

{The Little Richard Editor
 (C) 1996, 1997, 1998 by Johannes Leckebusch
 20. 11. 1998}
// Anpassung an D4 durch Uses FixD4LB in SmallLittleFrame

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, FileCtrl, Grids, Outline, DirOutln, ComCtrls, ExtCtrls, Menus,
  Tabs, Buttons, SLREdit, ImgList;

type
  TDateiManagerForm = class(TForm)
    Statusleiste: TPanel;
    VerzeichnisPanel: TPanel;
    Datei: TMenuItem;
    Oeffnen: TMenuItem;
    Verschieben: TMenuItem;
    Kopieren: TMenuItem;
    Loeschen: TMenuItem;
    Umbenennen: TMenuItem;
    Eigenschaften: TMenuItem;
    N1: TMenuItem;
    Beenden: TMenuItem;
    Schaltleiste: TPanel;
    SpeedDateiOeffnen: TSpeedButton;
    SpeedVerschieben: TSpeedButton;
    SpeedKopieren: TSpeedButton;
    SpeedLoeschen: TSpeedButton;
    SpeedUmbenennen: TSpeedButton;
    SpeedEigenschaften: TSpeedButton;
    LabelDateiName: TLabel;
    Laufwerk: TLabel;
    VerzeichnisStruktur: TDirectoryListBox;
    NeuesVerzeichnis: TMenuItem;
    Haupmenue: TMainMenu;
    DateiPopupMenu: TPopupMenu;
    Oeffnen1: TMenuItem;
    Verschieben1: TMenuItem;
    Kopieren1: TMenuItem;
    Loeschen1: TMenuItem;
    Umbenennen1: TMenuItem;
    Eigenschaften1: TMenuItem;
    VerzeichnisPopupMenu: TPopupMenu;
    Verzeichniserzeugen1: TMenuItem;
    LaufwerkVzPanel: TPanel;
    SpeedNeuVerzeichnis: TSpeedButton;
    Laufwerke: TDriveComboBox;
    NeuerDateimanager1: TMenuItem;
    SpeedDateiManager: TSpeedButton;
    SpeedButton1Refresh: TSpeedButton;
    Anzeigeaktualisieren1: TMenuItem;
    Anzeigeaktualisieren2: TMenuItem;
    PanelFilesAndFavs: TPanel;
    SpeedAnwendungoeffnen: TSpeedButton;
    PanelStatusButtons: TPanel;
    ButtonAbbrechen: TButton;
    ButtonSpeichern: TButton;
    ButtonLaden: TButton;
    PopupMenuHistory: TPopupMenu;
    Historyloeschen: TMenuItem;
    N2: TMenuItem;
    Historyspeichern1: TMenuItem;
    Historyladen1: TMenuItem;
    EintragzuHistoryhinzufuegen1: TMenuItem;
    PopupMenuFavourites: TPopupMenu;
    Verzeichnishinzufgen1: TMenuItem;
    Verzeichnisentfernen1: TMenuItem;
    PanelFavs: TPanel;
    PanelFavsHeader: TPanel;
    Label3: TLabel;
    ButtonAddFav: TButton;
    ButtonRemFav: TButton;
    ListViewFavourites: TListView;
    PanelFavourCurDir: TPanel;
    LabelFavCurdir: TLabel;
    Splitter1: TSplitter;
    SplitterDirListFileFav: TSplitter;
    FavouritesSpeichern: TMenuItem;
    FavouritesLaden: TMenuItem;
    ImageListFavs: TImageList;
    PopupMenuSelHistory: TPopupMenu;
    SelektierteHistory1: TMenuItem;
    SelHis: TMenuItem;
    Favoriten1: TMenuItem;
    Verzeichnishinzufgen2: TMenuItem;
    Verzeichnisentfernen2: TMenuItem;
    N4: TMenuItem;
    Favoritenspeichern1: TMenuItem;
    Favoritenladen1: TMenuItem;
    HistoryListe1: TMenuItem;
    Eintrageinfgen1: TMenuItem;
    Eintraglschen1: TMenuItem;
    N5: TMenuItem;
    Historyspeichern2: TMenuItem;
    Historyladen2: TMenuItem;
    PanelFileHeader: TPanel;
    Label1: TLabel;
    ComboBoxDateiauswahlHistory: TComboBox;
    Panel1: TPanel;
    Label2: TLabel;
    ButtonHistroyLoeschen: TButton;
    ButtonHistoryEinfuegen: TButton;
    ButtonHistorySpeichern: TButton;
    ButtonHistoryLaden: TButton;
    DateiListe: TFileListBox;
    PanelFileBottom: TPanel;
    Dateityp: TLabel;
    DateiFilterComboBox: TFilterComboBox;
    SpeedButtonOpenPicture: TSpeedButton;
    InEditoralsTextOeffnen2: TMenuItem;
    Nichtvorhandeneloeschen1: TMenuItem;
    Nichtvorhandeneloeschen2: TMenuItem;
    NichtvorhandeneHisloeschen1: TMenuItem;
    NichtvorhandeneHisloeschen2: TMenuItem;
    Verzeichnisloeschen1: TMenuItem;
    InpassendesFensteralsDateioeffnen1: TMenuItem;
    InTextfensteroeffnen1: TMenuItem;
    InpassendesFensteralsDateioeffnen2: TMenuItem;
    N6: TMenuItem;
    DateilisteinTextfenster1: TMenuItem;
    SpeedButtonDateiliste: TSpeedButton;
    PanelListButtons: TPanel;
    CheckBoxPfad: TCheckBox;
    CheckBoxStatistik: TCheckBox;
    PanelFilterButton: TPanel;
    ButtonFilter: TButton;
    ListBoxDateiattribute: TListBox;
    N3: TMenuItem;
    SelektiertesVerzeichnisentfernen1: TMenuItem;
    SpeedButtonUploadFile: TSpeedButton;
    SpeedButtonUploadDir: TSpeedButton;
    SpeedButtonGetHostDir: TSpeedButton;
    EditHostname: TEdit;
    procedure BeendenClick(Sender: TObject);
    procedure VerzeichnisStrukturChange(Sender: TObject);
    procedure DateiListeChange(Sender: TObject);
    procedure DateiClick(Sender: TObject);
    procedure LoeschenClick(Sender: TObject);
    procedure EigenschaftenClick(Sender: TObject);
    procedure DateiAendern(Sender: TObject);
    procedure OeffnenClick(Sender: TObject);
    procedure DateiListeMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure VerzeichnisStrukturDragOver(Sender, Source: TObject; X,
      Y: Integer; State: TDragState; var Accept: Boolean);
    procedure VerzeichnisStrukturDragDrop(Sender, Source: TObject; X,
      Y: Integer);
    procedure DateiListeEndDrag(Sender, Target: TObject; X, Y: Integer);
    procedure NeuesVerzeichnisClick(Sender: TObject);
    procedure DateiListeDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure DateiListeDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure NeuerDateimanager1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure SpeedDateiManagerClick(Sender: TObject);
    procedure SpeedButton1RefreshClick(Sender: TObject);
    procedure ListViewFavouritesClick(Sender: TObject);
    procedure SpeedDateiOeffnenClick(Sender: TObject);
    procedure DateiListeClick(Sender: TObject);
    procedure ComboBoxDateiauswahlHistoryKeyDown(Sender: TObject;
      var Key: Word; Shift: TShiftState);
    procedure ButtonAddFavClick(Sender: TObject);
    procedure ButtonRemFavClick(Sender: TObject);
    procedure ComboBoxDateiauswahlHistoryChange(Sender: TObject);
    procedure PanelFileHeaderResize(Sender: TObject);
    procedure HistoryloeschenClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Historyspeichern1Click(Sender: TObject);
    procedure Historyladen1Click(Sender: TObject);
    procedure EintragzuHistoryhinzufuegen1Click(Sender: TObject);
    procedure PanelFileBottomResize(Sender: TObject);
    procedure FavouritesSpeichernClick(Sender: TObject);
    procedure FavouritesLadenClick(Sender: TObject);
    procedure ButtonSortFavClick(Sender: TObject);
    procedure ButtonAbbrechenClick(Sender: TObject);
    procedure SelHisClick(Sender: TObject);
    procedure PopupMenuSelHistoryPopup(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure SpeedButtonOpenPictureClick(Sender: TObject);
    procedure Nichtvorhandeneloeschen1Click(Sender: TObject);
    procedure NichtvorhandeneHisloeschen1Click(Sender: TObject);
    procedure Verzeichnisloeschen1Click(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure InTextfensteroeffnen1Click(Sender: TObject);
    procedure DateilisteinTextfenster1Click(Sender: TObject);
    procedure ButtonLadenClick(Sender: TObject);
    procedure DateiFilterComboBoxChange(Sender: TObject);
    procedure ButtonFilterClick(Sender: TObject);
    procedure ListViewFavouritesKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure SelektiertesVerzeichnisentfernen1Click(Sender: TObject);
    procedure SpeedButtonUploadFileClick(Sender: TObject);
    procedure SpeedButtonUploadDirClick(Sender: TObject);
    procedure SpeedButtonGetHostDirClick(Sender: TObject);
  private
    { Private-Deklarationen }
    Init:      Boolean;
    isModal:   Boolean;
    ShiftDrag: TShiftState;
    NoDrag:    BOOLEAN;
    FMyEditor: TEditForm;
    FSelfDestroy: Boolean;
    FFilterIndex: Integer;
    OldItems:     String;
    function LiesMyEditor: TEditForm;
    procedure SchreibMyEditor (E: TEditForm);
    function LiesSelfDestroy: Boolean;
    procedure SchreibSelfDestroy (sd: Boolean);
    procedure AenderungBestaetigen (const ACaption, FromFile, ToFile: String);
    function AktuellesVerzeichnis: String;
    function readDateiauswahl: String;
    procedure writeDateiauswahl (CONST d: String);
    procedure MakeFavlist;
    procedure SetzeFavourites;
    function LiesFilterIndex: Integer;
    procedure SchreibFilterIndex (fi: Integer);
  public
    { Public-Deklarationen }
    NameSet:  BOOLEAN;
    constructor ECreate (AOwner: TComponent; SelfDestroy, doModal: Boolean;
                sCaption, sButton, sFile, sFilter: String;
                iDateifilter: Integer;
                bLadenEnable, bLadenDefault,
                bSpeicherEnable, bSpeicherDefault: BOOLEAN); //override;
    property  MyEditor: TEditForm read LiesMyEditor write SchreibMyEditor;
    property  SelfDestroy: Boolean read LiesSelfDestroy write SchreibSelfDestroy;
    property  Dateiauswahl: String read readDateiauswahl write writeDateiauswahl;
    property  Filterindex: Integer read LiesFilterIndex write SchreibFilterIndex;
  end;

var
  DateiManagerForm: TDateiManagerForm;

implementation

{$R *.DFM}

USES DateiAttribute, AendernDialog, MyFmxUtils, SmallLittleFrame,
{$IFDEF Explorer}
  IExplorer,
{$ENDIF}
  SGlobalEinstellungen, Bild, WinExc32;

constructor TDateiManagerForm.ECreate (AOwner: TComponent; SelfDestroy, doModal: Boolean;
            sCaption, sButton, sFile, sFilter: String;
            iDateifilter: Integer;
            bLadenEnable, bLadenDefault,
            bSpeicherEnable, bSpeicherDefault: BOOLEAN);
VAR ifound:  Integer;
begin
  Create (AOwner);
  FSelfDestroy := SelfDestroy;
  isModal := doModal;
  Caption := sCaption;
  IF sButton <> '' THEN BEGIN
    IF bLadenDefault THEN ButtonLaden.Caption := sButton
    ELSE IF bSpeicherDefault THEN ButtonSpeichern.Caption := sButton;
  END (* IF *);
  IF sFile <> '' THEN Dateiauswahl := sFile;

  IF LRFrame.DateiFilter <> '' THEN
    DateiFilterComboBox.Filter := LRFrame.DateiFilter;
//  DateiFilterComboBox.ItemIndex := FFilterIndex;
  IF sFilter <> '' THEN BEGIN
    DateiFilterComboBox.ItemIndex := 0;
    iFound := POS (UpperCase (sFilter), AnsiUpperCase (DateiFilterComboBox.Mask));
//showMessage ('Maske: ' + DateiFilterComboBox.Mask + ', iFound: ' + IntToStr (iFound) + ' ' + sFilter);
    WHILE (DateiFilterComboBox.ItemIndex < DateiFilterComboBox.Items.Count - 1)
           AND (iFound <= 0) DO BEGIN
      DateiFilterComboBox.ItemIndex := DateiFilterComboBox.ItemIndex + 1;
      iFound := POS (UpperCase (sFilter), AnsiUpperCase (DateiFilterComboBox.Mask));
//showMessage ('Maske: ' + DateiFilterComboBox.Mask + ', iFound: ' + IntToStr (iFound) + ' ' + sFilter);
    END (* WHILE *);
    IF iFound <= 0 THEN BEGIN
      showMessage ('Filter "' + sFilter + '" nicht gefunden!');
      FilterIndex := iDateifilter;
    END
    ELSE FilterIndex := DateiFilterComboBox.ItemIndex;
  END
  ELSE BEGIN
    FilterIndex := iDateifilter;
    DateiFilterComboBox.ItemIndex := FFilterIndex;
  END (* ELSE *);
  ButtonLaden.Enabled := bLadenEnable;
  ButtonLaden.Default := bLadenDefault;
  ButtonSpeichern.Enabled := bSpeicherEnable;
  ButtonSpeichern.Default := bSpeicherDefault;
end (* ECreate *);

function TDateiManagerForm.LiesFilterIndex: Integer;
begin
  Result := DateiFilterComboBox.ItemIndex;
end;

procedure TDateiManagerForm.SchreibFilterIndex (fi: Integer);
begin
  FFilterIndex := fi;
  DateiFilterComboBox.ItemIndex := FFilterIndex;
//showMessage ('SchreibFilterIndex: ' + IntToStr (fi));
end;

function TDateiManagerForm.readDateiauswahl: String;
begin
  Result := ComboBoxDateiAuswahlHistory.Text;
end (* readDateiauswahl *);

procedure TDateiManagerForm.writeDateiauswahl (const D: String);
begin
  ComboBoxDateiAuswahlHistory.Text := D;
end (* writeDateiauswahl *);

function TDateiManagerForm.LiesMyEditor: TEditForm;
begin
  Result := FMyEditor;
end (* LiesMyEditor *);

procedure TDateiManagerForm.SchreibMyEditor (E: TEditForm);
begin
  FMyEditor := E;
  ButtonSpeichern.Enabled := TRUE;
  ButtonSpeichern.Default := TRUE;
  ButtonLaden.Enabled := FALSE;
end (* SchreibMyEditor *);

function TDateiManagerForm.LiesSelfDestroy: Boolean;
begin
  Result := FSelfDestroy;
end (* LiesSelfDestroy *);

procedure TDateiManagerForm.SchreibSelfDestroy (sd: Boolean);
begin
  FSelfDestroy := sd;
end (* SchreibSelfDestroy *);

procedure TDateiManagerForm.BeendenClick(Sender: TObject);
begin
  Close;
end;

procedure TDateiManagerForm.VerzeichnisStrukturChange(Sender: TObject);

begin
  try
//    Caption := Verzeichnisstruktur.Directory;

    Laufwerk.Caption := Format (
      'Laufwerk: %s: %n MB; Frei: %n MB',
      [Verzeichnisstruktur.Drive,
       DiskSize (ORD (Verzeichnisstruktur.Drive) - ORD ('A') + 1) / 1048576,
       DiskFree (ORD (Verzeichnisstruktur.Drive) - ORD ('A') + 1) / 1048576]);

    WITH ListViewFavourites DO BEGIN
      IF NOT Init THEN BEGIN
        setzeFavourites;
      END (* IF NOT Init *);
      Init := FALSE;
    END (* WITH *);

  except
    showMessage ('Kein Datentrger in Laufwerk ' + Verzeichnisstruktur.Drive +
                 ':');
  end;
end;

procedure stripBrackets (VAR s: String);
VAR p: Integer;
BEGIN
  p := Pos ('[', s);

  IF (p > 0 ) AND (s [Length (s)] = ']') THEN BEGIN
    Delete (s, p, 1); Delete (s, Length (s), 1);
  END (* IF *);
END (* stripBrackets *);


procedure TDateiManagerForm.DateiListeChange(Sender: TObject);
VAR DerDateiName, fn:  String;
    FileSize:          Integer;
    FileDate:          TDateTime;
    i:                 Integer;
    Eintrag:           String;
    Stat:              String;
    Dateisumme:        Integer;

  procedure Filestatistik;
  begin
    IF FileSize < 1024 THEN
      Stat := Format ('%8d  Byte, %s', [//Eintrag,
        FileSize, DateTimeToStr (FileDate)])
    ELSE IF FileSize < 1048576 THEN
      Stat := Format ('%8n KByte, %s', [//Eintrag,
        FileSize / 1024, DateTimeToStr (FileDate)])
    ELSE
      Stat := Format ('%8n MByte, %s', [//Eintrag,
        FileSize / 1048576, DateTimeToStr (FileDate)]);
    Eintrag := Stat;
  end (* FileStatistik *);

begin (* DateilisteChange *)
  {VerzeichnisStruktur.Update;}
//  ListBoxDateiAttribute.Items := DateiListe.Items;
//showMessage ('Olditems prfen');
  IF DateiListe.Items.Text <> OldItems THEN BEGIN
//showmessage ('Clear Attribute');
    ListBoxDateiAttribute.Items.Clear;
//showMessage ('Items in Dateiattribute updaten');
    OldItems := '';
    Dateisumme := 0;
    FOR i := 0 TO Dateiliste.Items.Count - 1 DO BEGIN
      Eintrag := Dateiliste.Items [i];
      FileSize := 0;
      IF FileExists (Eintrag) THEN BEGIN
        IF HasAttr (Eintrag, FILE_ATTRIBUTE_Directory) OR HasAttr (Eintrag, faVolumeID) THEN BEGIN
//          FileDate := 0; //?
          FileDate := FileDateTime (Eintrag);
        END
        ELSE BEGIN
          FileSize := GetFileSize (Eintrag);
          Dateisumme := Dateisumme + Filesize;
          FileDate := FileDateTime (Eintrag);
        END;
//      IF CheckBoxPfad.Checked THEN Eintrag := DateiListe.Directory + '\' + Eintrag;
      END
      ELSE Eintrag := 'Datei ungltig!';

      FileStatistik;
// Das ist furchtbar langsam:
//      ListBoxDateiAttribute.Items.Append (Eintrag);
// Das geht viel schneller:
      OldItems := OldItems + Eintrag + crlf;
    END (* FOR *);
//showMessage ('Dateistatistik fertig');
// Und dann weisen wir einfach den ganzen String dem Textattribut zu:
    ListBoxDateiAttribute.Items.Text := OldItems;
//showMessage ('Olditems gesetzt: ' + OldItems);
    OldItems := DateiListe.Items.Text;
  END;

  ListBoxDateiAttribute.TopIndex := DateiListe.TopIndex;
  ListBoxDateiAttribute.ItemIndex := DateiListe.ItemIndex;

IF DateiListe = NIL THEN BEGIN
  showMessage ('Dateiliste = NIL');
  EXIT;
END (* IF Dateiliste NIL *);

  WITH DateiListe DO BEGIN
//showMessage ('ItemIndex: ' + IntToStr (ItemIndex) +
//'; Items.Count: ' + IntToStr (Items.Count));
    IF (ItemIndex >= 0) {AND (Items.Count > 0)} THEN BEGIN //D4 Bug - siehe FixD4LB
      DerDateiName := Items [ItemIndex];
//showMessage ('DerDateiName: "' + DerDateiName + '", FileName: "' + FileName + '"'); (**** Ups - die eckigen Klammern des Verzeichnisnamens! *)
      fn := FileName;
      stripBrackets (fn);
      fn := ExtractFileDir (fn);
//showMessage ('Verzeichnis setzen: "' + fn + '"');

//      IF (fn <> '') THEN // D4 Bug - siehe FixD4LB
        IF NOT setCurrentDir (fn) THEN
          (* Notwendig, wenn anderer Dateimanager mit abweichenden
             Directory aktiv war. Verstehe nicht, warum das nicht anders
             bzw. automatisch geht ... *)
          showMessage ('Konnte Verzeichnis "' +
            fn + '" nicht setzen');

      StripBrackets (DerDateiName);

{showMessage (DerDateiName);}

      {FileAttr := FileGetAttr (DerDateiName);}
      IF HasAttr (DerDateiName, FILE_ATTRIBUTE_Directory) OR HasAttr (DerDateiName, faVolumeID) THEN BEGIN
        FileSize := 0; FileDate := 0;
      END
      ELSE BEGIN
        FileSize := GetFileSize (DerDateiName);
        FileDate := FileDateTime (DerDateiName);
      END;

      IF FileSize < 1024 THEN
        LabelDateiName.Caption := Format ('%s, %d Byte, %s', [DerDateiname,
          FileSize, DateTimeToStr (FileDate)])
      ELSE IF FileSize < 1048576 THEN
        LabelDateiName.Caption := Format ('%s, %n KByte, %s', [DerDateiname,
          FileSize / 1024, DateTimeToStr (FileDate)])
      ELSE
        LabelDateiName.Caption := Format ('%s, %n MByte, %s', [DerDateiname,
          FileSize / 1048576, DateTimeToStr (FileDate)])
    END (* IF ItemIndex *)
    ELSE LabelDateiName.Caption := '<keine Datei ausgewhlt>';
  END (* WITH DateiListe *);
end;

procedure TDateiManagerForm.DateiClick(Sender: TObject);
VAR DateiAusgewaehlt: BOOLEAN;
begin
  DateiAusgewaehlt := DateiListe.ItemIndex >= 0;
  Oeffnen.Enabled := DateiAusgewaehlt;
  InEditoralsTextoeffnen2.Enabled := DateiAusgewaehlt;
  InpassendesFensteralsDateioeffnen2.Enabled := DateiAusgewaehlt;
  Verschieben.Enabled := DateiAusgewaehlt;
  Kopieren.Enabled := DateiAusgewaehlt;
  Loeschen.Enabled := DateiAusgewaehlt;
  Umbenennen.Enabled := DateiAusgewaehlt;
  Eigenschaften.Enabled := DateiAusgewaehlt;

  Oeffnen1.Enabled := DateiAusgewaehlt;
  InpassendesFensteralsDateioeffnen1.Enabled := DateiAusgewaehlt;
  InTextfensteroeffnen1.Enabled := DateiAusgewaehlt;
  Verschieben1.Enabled := DateiAusgewaehlt;
  Kopieren1.Enabled := DateiAusgewaehlt;
  Loeschen1.Enabled := DateiAusgewaehlt;
  Umbenennen1.Enabled := DateiAusgewaehlt;
  Eigenschaften1.Enabled := DateiAusgewaehlt;
end;

procedure TDateiManagerForm.LoeschenClick(Sender: TObject);
VAR DirName: String;
begin
  WITH DateiListe DO
    IF MessageDlg (Filename + ' lschen?', mtConfirmation,
      [mbYes, mbNo], 0) = mrYes THEN BEGIN
      IF HasAttr (Filename, faDirectory) THEN BEGIN
        DirName := ExtractFileName (FileName);
        DirName := Copy (DirName, 2, LENGTH (DirName) - 2);
        DirName := ExtractFileDir (FileName) + '\' + DirName;
        IF RemoveDir (DirName) THEN BEGIN
          Verzeichnisstruktur.Update;
          Update;
        END (* IF *)
      END
      ELSE
        IF DeleteFile (Filename) THEN Update;
    END (* IF loeschen *);
end;

procedure TDateiManagerForm.EigenschaftenClick(Sender: TObject);
VAR Attribute, NeueAttribute: Word;
begin
  WITH DateiAttributForm DO BEGIN
    IF DateiListe.ItemIndex = -1 THEN EXIT;
    LabelDateiname.Caption :=
      DateiListe.Items [DateiListe.ItemIndex];
    LabelPfadname.Caption :=
      DateiListe.Directory;
    try
      LabelAenderungsDatum.Caption := DateTimeToStr (FileDateTime (DateiListe.FileName));
    except
      LabelAenderungsDatum.Caption := '---';
    end;
    Attribute := FileGetAttr (LabelDateiname.Caption);

    NurLesen.Checked := (Attribute and faReadOnly) = faReadOnly;
    Verborgen.Checked := (Attribute and faHidden) = faHidden;
    System.Checked := (Attribute and faSysFile) = faSysFile;
    Laufwerk.Checked := (Attribute and faVolumeID) = faVolumeID;
    Verzeichnis.Checked := (Attribute and faDirectory) = faDirectory;
    Archiv.Checked := (Attribute and faArchive) = faArchive;
//    Datei.Checked := (Attribute and faAnyFile) = faAnyFile;
    IF ShowModal <> mrCancel THEN BEGIN
      NeueAttribute := Attribute;
      IF NurLesen.Checked THEN NeueAttribute := NeueAttribute OR faReadOnly
        ELSE NeueAttribute := NeueAttribute AND NOT faReadOnly;
      IF Verborgen.Checked THEN NeueAttribute := NeueAttribute OR faHidden
        ELSE NeueAttribute := NeueAttribute AND NOT faHidden;
      IF System.Checked THEN NeueAttribute := NeueAttribute OR faSysFile
        ELSE NeueAttribute := NeueAttribute AND NOT faSysFile;
      IF Laufwerk.Checked THEN NeueAttribute := NeueAttribute OR faVolumeID
        ELSE NeueAttribute := NeueAttribute AND NOT faVolumeID;
      IF Verzeichnis.Checked THEN NeueAttribute := NeueAttribute OR faDirectory
        ELSE NeueAttribute := NeueAttribute AND NOT faDirectory;
      IF Archiv.Checked THEN NeueAttribute := NeueAttribute OR faArchive
        ELSE NeueAttribute := NeueAttribute AND NOT faArchive;
{      IF Datei.Checked THEN NeueAttribute := NeueAttribute OR faAnyFile
        ELSE NeueAttribute := NeueAttribute AND NOT faAnyFile;
}
      IF NeueAttribute <> Attribute THEN
        FileSetAttr (LabelPfadname.Caption + '\' + LabelDateiname.Caption, NeueAttribute);

    END (* IF *);
  END (* WITH DateiAttributForm *);
end;

procedure TDateiManagerForm.AenderungBestaetigen (const ACaption, FromFile, ToFile: String);
BEGIN
  IF MessageDlg (Format ('%s %s nach %s?', [ACaption, FromFile, ToFile]),
                 mtConfirmation, [mbYes, mbNo], 0) = mrYes THEN BEGIN
    IF ACaption = 'Verschieben' THEN
      MoveFile (FromFile, ToFile)
    ELSE IF ACaption = 'Kopieren' THEN
      CopyFile (FromFile, ToFile, FALSE) {Da ist irgendwo der Wurm drin! Scheint Ziel
        fr ein Verzeichnis zu halten! }
    ELSE IF ACaption = 'Umbenennen' THEN
      RenameFile (FromFile, ToFile);
    DateiListe.Update;
  END (* IF *);
END (* AenderungBestaetigen *);

procedure TDateiManagerForm.DateiAendern(Sender: TObject);
begin
  WITH AendernDlg DO BEGIN
    IF (Sender = Verschieben) OR (Sender = SpeedVerschieben) OR (Sender = Verschieben1) THEN Caption := 'Verschieben'
    ELSE IF (Sender = Kopieren) OR (Sender = SpeedKopieren) OR (Sender = Kopieren1) THEN Caption := 'Kopieren'
    ELSE IF (Sender = Umbenennen) OR (Sender = SpeedUmbenennen) OR (Sender = Umbenennen1) THEN Caption := 'Umbenennen'
    ELSE Exit;
    CurrentDir.Caption := VerzeichnisStruktur.Directory;
    VonDateiName.Text := DateiListe.FileName;
    ZuDateiName.Text := '';
    IF (ShowModal <> mrCancel) AND (ZuDateiName.Text <> '') THEN
      AenderungBestaetigen (Caption, VonDateiName.Text, ZuDateiName.Text);
  END (* WITH *);
end;

procedure TDateiManagerForm.OeffnenClick(Sender: TObject);
VAR DirName, fn: String;
begin
  WITH DateiListe DO BEGIN
    fn := FileName; StripBrackets (fn);
{showMessage (fn);}
    IF HasAttr (fn, faDirectory) OR HasAttr (fn, faVolumeID) THEN BEGIN
      DirName := fn;
{ShowMessage (DirName);}
      {}
      Verzeichnisstruktur.Directory := DirName;
      VerzeichnisstrukturChange (Sender);
      {}
    END
    ELSE ExecuteFile (FileName, '', Directory, SW_SHOW);
  END (* WITH *);
end;

procedure TDateiManagerForm.DateiListeMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  IF NoDrag THEN Exit;
  IF Button = mbLeft THEN BEGIN
    ShiftDrag := Shift;
    WITH Sender AS TFileListBox DO BEGIN
      IF ItemAtPos (Point (X, Y), True) >= 0 THEN
        BeginDrag (False);
    END (* WITH *);
  END (* IF Button *);
end;

procedure TDateiManagerForm.VerzeichnisStrukturDragOver(Sender,
  Source: TObject; X, Y: Integer; State: TDragState; var Accept: Boolean);
begin
  IF Source IS TFileListBox THEN
    Accept := TRUE;
end;

procedure TDateiManagerForm.VerzeichnisStrukturDragDrop(Sender,
  Source: TObject; X, Y: Integer);
VAR
  Punkt:  TPoint;
  fn:     String;
  Modus:  String;
begin
{ShowMessage (TFIleListBox (source).Owner.ClassName);}
  IF (Source IS TFileListBox) {AND (Sender IS TDateiManagerForm)} THEN BEGIN
    Punkt.X := X; Punkt.Y := Y;
    fn := TFileListBox (Source).FileName;
    stripBrackets (fn);
{IF ssCtrl IN TDateiManagerForm (Sender).ShiftDrag THEN showMessage ('Verzeichnis Control') ELSE showMessage ('Verzeichnis No Control');}
    IF ssCtrl in TDateiManagerForm (TFileListBox (Source).Owner).ShiftDrag THEN Modus := 'Verschieben' ELSE Modus := 'Kopieren';
    {IF ssCtrl IN TDateiManagerForm (Sender).ShiftDrag THEN Modus := 'Verschieben' ELSE Modus := 'Kopieren';}
    WITH VerzeichnisStruktur DO
      try
        AenderungBestaetigen (Modus, fn,
          GetItemPath (ItemAtPos (Punkt, TRUE)) + '\');
      except
        on EStringListError do showMessage ('Kein gltiges Ziel!');
      end (* try *);
  END
  ELSE showMessage ('Problem beim Dateiverschieben');
end;

procedure TDateiManagerForm.DateiListeEndDrag(Sender, Target: TObject; X,
  Y: Integer);
begin
  IF (Target <> NIL) AND (Target IS TFileListBox) THEN BEGIN
//showMessage ('Target is TFileListBox');
    WITH Target AS TFileListBox DO BEGIN
      WITH Owner AS TDateiManagerForm DO BEGIN
        OldItems := '';
        DateiListe.Update;
      END (* WITH Owner *);
    END (* WITH Target *);
  END (* IF *);
end;

procedure TDateiManagerForm.NeuesVerzeichnisClick(Sender: TObject);
VAR altDir, neuDir: String;
begin
  altDir := VerzeichnisStruktur.Directory;
  neuDir := InputBox ('Verzeichnis anlegen', 'Neues Verzeichnis:', altDir);
  IF neuDir <> altDir then begin
    IF createDir (neuDir) THEN BEGIN
      VerzeichnisStruktur.Update; DateiListe.Update;
    END (* IF *)
    ELSE showMessage ('Kann "' + neuDir + '" nicht erzeugen');
  end;
end;

procedure TDateiManagerForm.DateiListeDragOver(Sender, Source: TObject; X,
  Y: Integer; State: TDragState; var Accept: Boolean);
begin
  IF Source IS TFileListBox THEN
    Accept := TRUE;
end;

procedure TDateiManagerForm.DateiListeDragDrop(Sender, Source: TObject; X,
  Y: Integer);
VAR
  fn, dest:     String;
  Modus:        String;
begin
{ShowMessage (TFIleListBox (source).Owner.ClassName);}
  IF (Source IS TFileListBox) {AND (Sender IS TDateiManagerForm)} THEN BEGIN
    fn := TFileListBox (Source).FileName;
    stripBrackets (fn);
    dest := Dateiliste.Directory;
    IF not (dest [Length (dest)] = '\') THEN dest := dest + '\';
    IF ssCtrl in TDateiManagerForm (TFileListBox (Source).Owner).ShiftDrag THEN Modus := 'Verschieben' ELSE Modus := 'Kopieren';
      try
        AenderungBestaetigen (Modus, fn, dest);
      except
        on EStringListError do showMessage ('Kein gltiges Ziel!');
      end (* try *);
  END
  ELSE showMessage ('Problem beim Dateiverschieben');
end;

procedure TDateiManagerForm.NeuerDateimanager1Click(Sender: TObject);
VAR DatMan: TDateiManagerForm;
begin
  DatMan := TDateiManagerForm.ECreate (Self, TRUE, FALSE, 'Favoritenbrowser',
    '', '', '', 0, TRUE, FALSE, TRUE, FALSE);
  DatMan.Show;
end;

procedure TDateiManagerForm.FormShow(Sender: TObject);
VAR myIcon:               TBitmap; //TIcon;
begin
//showMessage ('FormShow');
  IF Dateiliste.Items.Count > 0 THEN
    Dateiliste.ItemIndex := 0;
  WITH ComboBoxDateiauswahlHistory DO BEGIN
    Items := LRFrame.HistoryListe;
    IF (Text = '') AND(ItemIndex = - 1) AND (Items.Count > 0) THEN
      ItemIndex := 0;
  END (* WITH *);
  VerzeichnisStrukturChange (Sender);
{  IF LRFrame.DateiFilter <> '' THEN
    DateiFilterComboBox.Filter := LRFrame.DateiFilter;}
//  DateiFilterComboBox.ItemIndex := FFilterIndex;
  DateiListe.Mask := DateiFilterComboBox.Mask;
  IF FileExists (ChangeFileExt (Application.Exename, '.BMP')) THEN BEGIN
    myIcon := TBitmap.Create;
    myIcon.LoadFromFile (ChangeFileExt (Application.Exename, '.BMP'));
    ImageListFavs.Add (myIcon, NIL);
  END (* IF *);
  MakeFavList;
end (* FormShow *);

procedure TDateiManagerForm.SpeedDateiManagerClick(Sender: TObject);
begin
  NeuerDateimanager1Click (Sender);
end;

procedure TDateiManagerForm.SpeedButton1RefreshClick(Sender: TObject);
begin
  Verzeichnisstruktur.Update;
  OldItems := '';
  DateiListe.Update;
end;

procedure TDateiManagerForm.ListViewFavouritesClick(Sender: TObject);
VAR  FavFilter:          String;
     FavStart, FavEnd:   Integer;
     FavStr:             String;
begin
//showMessage ('ListViewFavouritesClick');
  WITH ListViewFavourites DO BEGIN
    IF ItemFocused <> NIL THEN BEGIN
      FavStr := LRFrame.FavouriteListe [ListViewFavourites.Items.IndexOf (ItemFocused)];
      FavStart := Pos ('/', FavStr);
      FavEnd := Pos ('#', FavStr);
      IF FavStart > 0 THEN
        FavFilter := Copy (FavStr, FavStart + 1, FavStart - FavEnd)
      Else FavFilter := LRFrame.DateiFilter;
      IF FavFilter <> '' THEN DateiFilterComboBox.Filter := FavFilter;
      IF FavEnd > 0 THEN
        {DateiFilterComboBox.ItemIndex} FilterIndex := StrToInt (Copy (FavStr, FavEnd + 1, Length (FavStr))) - 1
      ELSE FilterIndex := LRFrame.Konfig.DateiFilterIndex - 1;
      Init := TRUE;
      DateiListe.Mask := DateiFilterComboBox.Mask;
      Verzeichnisstruktur.Directory := ItemFocused.Caption;
//      VerzeichnisstrukturChange (Sender);
    END (* IF ItemFocused *);
  END (* WITH ListViewFavourites *);
end (* ListViewFavouritesClick *);

procedure TDateiManagerForm.SpeedDateiOeffnenClick(Sender: TObject);
VAR DirName, fn: String;
begin
  NoDrag := TRUE;
  WITH DateiListe DO BEGIN
    fn := FileName; StripBrackets (fn);
    IF HasAttr (fn, faDirectory) OR HasAttr (fn, faVolumeID) THEN BEGIN
      DirName := fn;
      Verzeichnisstruktur.Directory := DirName;
      VerzeichnisstrukturChange (Sender);
    END
    ELSE
      IF UpperCase (ExtractFileExt (fn)) = '.EXE' THEN
        ExecuteFile (FileName, '', Directory, SW_SHOW)
      ELSE IF (UpperCase (ExtractFileExt (fn)) = '.BMP') OR
              (UpperCase (ExtractFileExt (fn)) = '.JPG') OR
              (UpperCase (ExtractFileExt (fn)) = '.JPEG') OR
              (UpperCase (ExtractFileExt (fn)) = '.GIF') OR
              (UpperCase (ExtractFileExt (fn)) = '.ICO') OR
              (UpperCase (ExtractFileExt (fn)) = '.EMF') OR
              (UpperCase (ExtractFileExt (fn)) = '.WMF') THEN
        WITH TBildForm.Create (LRFrame) DO BEGIN
          Image1.Picture.LoadFromFile (FileName);
          Caption := FileName;
    //      Height := Image1.Picture.Height + 27;
    //      Width := Image1.Picture.Width + 8;
          HorzScrollBar.Range := Image1.Picture.Width;
          VertScrollBar.Range := Image1.Picture.Height;
          Show;
        END (* WITH *)
{$IFDEF Explorer}
// Hat in der Praxis gestrt, wenn das Browserfenster geffnet wird,
// anstatt die HTML-Datei in einem Textfenster anzuzeigen. Sollte man
// hier eine andere Mimik einfhren???
{      ELSE IF LRFrame.IExplorerInstalliert AND
              ((UpperCase (ExtractFileExt (fn)) = '.HTM') OR
               (UpperCase (ExtractFileExt (fn)) = '.HTML')) THEN
        WITH TIExplorerForm.Create (LRFrame) DO BEGIN
            ComboBoxURL.text := 'file:///' + FileName;
            ButtonLoadClick (Sender);
            BringToFront;
        END (* WITH *)
}
{$ENDIF}
      ELSE BEGIN
        IF LRFrame.nichtNochmalLaden (FileName) THEN EXIT;
        WITH TEditForm.Create (LRFrame) DO BEGIN
          Open (FileName);
//          Show;
//          LRFrame.Warte (500);
// Kann man hier irgendwie den Editor mit dem neuen Textfenster in den Vordergrund bringen?
        END (* WITH *);
        IF ButtonLaden.Enabled THEN BEGIN
//showMessage ('ButtonLaden.Enabled - Close');
//          Close;
        END
        ELSE
showMessage ('No Close');
      END (* ELSE *);
  END (* WITH *);
end (* SpeedDateiOeffnenClick *);

procedure TDateiManagerForm.DateiListeClick(Sender: TObject);
begin
//  NoDrag := TRUE;
  ListBoxDateiAttribute.TopIndex := DateiListe.TopIndex;
  ListBoxDateiAttribute.ItemIndex := DateiListe.ItemIndex;
  ComboBoxDateiauswahlHistory.Text := DateiListe.FileName;
end;

procedure TDateiManagerForm.ComboBoxDateiauswahlHistoryKeyDown(
  Sender: TObject; var Key: Word; Shift: TShiftState);
VAR fn: String;
begin
  IF Key = vk_Return THEN BEGIN
    fn := ComboBoxDateiauswahlHistory.Text;
    IF fn = '' THEN EXIT;
    IF HasAttr (fn, faDirectory) OR HasAttr (fn, faVolumeID) THEN BEGIN
      showMessage ('Kann Ordner "' + fn + '" nicht in den Editor laden!');
    END
    ELSE
      IF UpperCase (ExtractFileExt (fn)) = '.EXE' THEN
        ExecuteFile (fn, '', DateiListe.Directory, SW_SHOW)
      ELSE
        WITH TEditForm.Create (LRFrame) DO
          Open (fn);
  END (* IF *);
end;

function TDateiManagerForm.AktuellesVerzeichnis: String;
begin
  Result := Dateiliste.Directory + '\' +
             DateiFilterComboBox.Mask +
                '/' + DateiFilterComboBox.Filter + '#' +
                IntToStr (DateiFilterCombobox.ItemIndex + 1);
end (* AktuellesVerzeichnis *);

procedure TDateiManagerForm.MakeFavlist;
VAR i:                    Integer;
    ListItem:             TListItem;
begin
  WITH ListViewFavourites DO BEGIN
    Visible := FALSE;
    FOR i := 0 TO Items.Count - 1 DO BEGIN
      Items.Delete (0);
    END (* FOR *);
//    Items.Clear; // hm - das lscht Spaltenbreite, obiges nicht!
    Columns[0].Width := ColumnTextWidth; // tut nicht - wieso?
    IF LRFrame.FavouriteListe <> NIL THEN BEGIN
      FOR i := 0 TO LRFrame.FavouriteListe.Count - 1 DO BEGIN
        ListItem := Items.Add;
        ListItem.Caption :=
          Copy (LRFrame.FavouriteListe.Strings [i], 1, Pos ('/', LRFrame.FavouriteListe.Strings [i]) - 1);        {ListString}
        IF ImageListFavs.Count > 0 THEN ListItem.ImageIndex := 0;
      END (* FOR *);
    END (* IF FavouriteListe <> NIL *);
    Visible := TRUE;
{showMessage ('ItemFocused: ' + Verzeichnisstruktur.Directory + ': ' + IntToStr (Integer
  (FindCaption (0, Verzeichnisstruktur.Directory (*AktuellesVerzeichnis*), TRUE, TRUE, FALSE))));
}
  END (* WITH ListViewFavourites *);
end (* MakeFavlist *);

procedure TDateiManagerForm.ButtonAddFavClick(Sender: TObject);
VAR Index:                Integer;
    i:                    Integer;
begin
  WITH LRFrame.FavouriteListe DO BEGIN
//    Index := IndexOf (AktuellesVerzeichnis);
// Funktioniert nicht, wenn Filter abweichend!
    Index := -1; i := 0;
    WHILE i < LRFrame.FavouriteListe.Count DO BEGIN
      IF Pos (Dateiliste.Directory + '\' + DateiFilterComboBox.Mask,
              LRFrame.FavouriteListe.Strings [i]) = 1 THEN BEGIN
        Index := i; i := LRFrame.FavouriteListe.Count;
      END (* IF *);
      INC (i);
    END (* WHILE *);
    IF Index <> -1 THEN Delete (Index);
    IF Count > 0 THEN
      WHILE (Count >= LRFrame.Konfig.MaxFavorite) AND (Count > 0) DO Delete (Count - 1);
//showMessage ('Jetzt Verzeichnis hinzufgen:');
    IF LRFrame.Konfig.MaxFavorite > 0 THEN
      Add (AktuellesVerzeichnis);
  END (* WITH FavouriteListe *);
//showMessage ('MakeFavList:');
  MakeFavList;
//showMessage ('setzeFavourites:');
  setzeFavourites;
end;

procedure TDateiManagerForm.ButtonRemFavClick(Sender: TObject);
VAR Index:                Integer;
    i:                    Integer;
begin
  WITH LRFrame.FavouriteListe DO BEGIN
//      Index := IndexOf ({AktuellesVerzeichnis}Dateiliste.Directory + '\' +
//             DateiFilterComboBox.Mask);
// Funktioniert so nicht ...
    Index := -1; i := 0;
    WHILE i < LRFrame.FavouriteListe.Count DO BEGIN
      IF Pos (Dateiliste.Directory + '\' + DateiFilterComboBox.Mask,
              LRFrame.FavouriteListe.Strings [i]) = 1 THEN BEGIN
        Index := i; i := LRFrame.FavouriteListe.Count;
      END (* IF *);
      INC (i);
    END (* WHILE *);
//showMessage ('Verzeichnis entfernen: ' + AktuellesVerzeichnis + ', Index: ' + IntToStr (Index));
//showMessage ('Verzeichnis entfernen: ' +
//  Dateiliste.Directory + '\' + DateiFilterComboBox.Mask +
//  ', Index: ' + IntToStr (Index));
    IF Index <> -1 THEN Delete (Index);
  END (* WITH *);
  MakeFavList;
  setzeFavourites;
end;

procedure TDateiManagerForm.ComboBoxDateiauswahlHistoryChange(
  Sender: TObject);
begin
  IF FileExists (ComboBoxDateiauswahlHistory.Text) THEN
    Dateiliste.Filename := ComboBoxDateiauswahlHistory.Text;
end;

procedure TDateiManagerForm.PanelFileHeaderResize(Sender: TObject);
begin
  ComboBoxDateiauswahlHistory.Width := PanelFileHeader.Width -
    ComboBoxDateiauswahlHistory.Left - 4 - PanelListButtons.Width;
end;

procedure TDateiManagerForm.HistoryloeschenClick(Sender: TObject);
begin
  WITH ComboBoxDateiauswahlHistory DO BEGIN
    Items.Delete (ItemIndex);
    IF (ItemIndex = - 1) AND (Items.Count > 0) THEN
      ItemIndex := 0;
    Text := Items [ItemIndex];
  END (* WITH *);
  LRFrame.HistoryListe.Assign (ComboBoxDateiauswahlHistory.Items);
end;

procedure TDateiManagerForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
//  LRFrame.HistoryListe.Assign (ComboBoxDateiauswahlHistory.Items);
  IF LRFrame.MyDateiManager = Self THEN BEGIN
    LRFrame.MyDateiManager := NIL;
    LRFrame.Konfig.DateiFilterIndex := Filterindex;
  END (* IF *);
//showMessage ('IF MyEditor = NIL THEN Release;');
//  IF MyEditor = NIL THEN Release;
  IF MyEditor <> NIL THEN BEGIN
    MyEditor.MyDateimanager := NIL;
  END (* IF *);
  IF FSelfDestroy THEN Release;
end;

procedure TDateiManagerForm.Historyspeichern1Click(Sender: TObject);
begin
  LRFrame.HistoryListe.Assign (ComboBoxDateiauswahlHistory.Items);
  IF AllgEinstellDialog = NIL THEN
    AllgEinstellDialog := TAllgEinstellDialog.Create (LRFrame);
  AllgEinstellDialog.BSpeichereHistoryClick(LRFrame);
end;

procedure TDateiManagerForm.Historyladen1Click(Sender: TObject);
begin
  IF AllgEinstellDialog = NIL THEN
    AllgEinstellDialog := TAllgEinstellDialog.Create (LRFrame);
  AllgEinstellDialog.BLadeHistoryClick(LRFrame);
  ComboBoxDateiauswahlHistory.Items := LRFrame.HistoryListe;
  LRFrame.HistoryListe.Assign (ComboBoxDateiauswahlHistory.Items);
end;


procedure TDateiManagerForm.EintragzuHistoryhinzufuegen1Click(
  Sender: TObject);
begin
  WITH ComboBoxDateiauswahlHistory DO BEGIN
    Items := LRFrame.HistoryListe;
    Items.Insert (0, Text);
  END (* WITH *);
  LRFrame.HistoryListe.Assign (ComboBoxDateiauswahlHistory.Items);
end;

procedure TDateiManagerForm.PanelFileBottomResize(Sender: TObject);
begin
  DateiFilterCombobox.Width := PanelFileBottom.Width -
    DateiFilterCombobox.Left - 4 - PanelFilterButton.Width;
end;

procedure TDateiManagerForm.FavouritesSpeichernClick(Sender: TObject);
begin
  IF AllgEinstellDialog = NIL THEN
    AllgEinstellDialog := TAllgEinstellDialog.Create (LRFrame);
  AllgEinstellDialog.ButtonFavSpeichernClick(LRFrame);
end;

procedure TDateiManagerForm.FavouritesLadenClick(Sender: TObject);
VAR i:                    Integer;
    ListItem:             TListItem;
begin
  IF AllgEinstellDialog = NIL THEN
    AllgEinstellDialog := TAllgEinstellDialog.Create (LRFrame);
  AllgEinstellDialog.ButtonFavLadenClick(LRFrame);
  WITH ListViewFavourites DO BEGIN
    Items.Clear;
    IF LRFrame.FavouriteListe <> NIL THEN BEGIN
      FOR i := 0 TO LRFrame.FavouriteListe.Count - 1 DO BEGIN
        ListItem := Items.Add;
        ListItem.Caption :=
          Copy (LRFrame.FavouriteListe.Strings [i], 1, Pos ('/', LRFrame.FavouriteListe.Strings [i]) - 1);
      END (* FOR *);
    END (* IF FavouriteListe <> NIL *);
  END (* WITH ListViewFavourites *);
end;

procedure TDateiManagerForm.ButtonSortFavClick(Sender: TObject);
begin
  ListViewFavourites.SortType := stText;
end;

procedure TDateiManagerForm.ButtonAbbrechenClick(Sender: TObject);
begin
  Close;
end;

procedure TDateiManagerForm.SelHisClick(Sender: TObject);
begin
 // what will we do?
  WITH Sender as TMenuItem DO BEGIN
    ComboBoxDateiauswahlHistory.Text := Caption;
    DateiListe.Filename := Caption;
    SpeedDateiOeffnenClick (Self);
  END (* WITH *);
end;

procedure TDateiManagerForm.PopupMenuSelHistoryPopup(Sender: TObject);
VAR  i:       Integer;
     menitem: TMenuItem;
begin
  i := PopupMenuSelHistory.Items.Count;
  WHILE (PopupMenuSelHistory.Items [i - 1].Caption <> '-') DO BEGIN
    DEC (i); PopupMenuSelHistory.Items.Delete (i);
  END (* WHILE *);
  WITH ComboBoxDateiAuswahlHistory DO BEGIN
    FOR i := 0 TO Items.Count DO BEGIN
      IF (ListViewFavourites.ItemFocused <> NIL) AND
         (ExtractFilePath (Items.Strings [i]) = ExtractFilePath (ListViewFavourites.ItemFocused.Caption))
      THEN BEGIN
        menitem := TMenuItem.Create (PopupMenuSelHistory);
        WITH menitem DO BEGIN
          Caption := ComboBoxDateiAuswahlHistory.Items [i];
          OnClick := SelHisClick;
        END (* WITH menitem *);
        PopupMenuSelHistory.Items.Add (menitem);
      END (* IF *);
    END (* FOR *);
  END (* WITH *);
end;

procedure TDateiManagerForm.FormCreate(Sender: TObject);
begin
  Init := TRUE;
end;

procedure TDateiManagerForm.SpeedButtonOpenPictureClick(Sender: TObject);
begin
  LRFrame.SpeedButtonOpenPictureClick (Sender);
end;

procedure TDateiManagerForm.Nichtvorhandeneloeschen1Click(Sender: TObject);
VAR i:  Integer;
begin
    IF LRFrame.FavouriteListe <> NIL THEN BEGIN
      i := 0;
      WHILE i < LRFrame.FavouriteListe.Count DO BEGIN
        IF NOT DirectoryExists (
          ExtractFileDIr (LRFrame.FavouriteListe.Strings [i]))
          THEN LRFrame.FavouriteListe.Delete (i)
          ELSE INC (i);
      END (* FOR *);
      MakeFavlist;
      SetzeFavourites;
    END (* IF FavouriteListe <> NIL *);
end;

procedure TDateiManagerForm.NichtvorhandeneHisloeschen1Click(
  Sender: TObject);
VAR i:  Integer;
begin
    IF LRFrame.HistoryListe <> NIL THEN BEGIN
      i := 0;
      WHILE i < LRFrame.HistoryListe.Count DO BEGIN
        IF NOT FileExists (
          (LRFrame.HistoryListe.Strings [i]))
          THEN LRFrame.HistoryListe.Delete (i)
          ELSE INC (i);
      END (* FOR *);
      WITH ComboBoxDateiauswahlHistory DO BEGIN
        Items := LRFrame.HistoryListe;
        IF (Text = '') AND(ItemIndex = - 1) AND (Items.Count > 0) THEN
          ItemIndex := 0;
      END (* WITH *);
    END (* IF FavouriteListe <> NIL *);
end;

procedure TDateiManagerForm.Verzeichnisloeschen1Click(Sender: TObject);
begin
  WITH Verzeichnisstruktur DO
    IF MessageDlg (Directory + ' lschen?', mtConfirmation,
      [mbYes, mbNo], 0) = mrYes THEN BEGIN
      IF RemoveDir (Directory) THEN BEGIN
          Update;
      END (* IF *)
    END (* IF loeschen *);
end (* Verzeichnisloeschen1Click *);

procedure TDateiManagerForm.setzeFavourites;
VAR i, j: Integer;
    cap:  String;
begin
  WITH ListViewFavourites DO BEGIN
    SetFocus;
    Selected :=
      FindCaption (0, Verzeichnisstruktur.Directory + '\', FALSE, TRUE, FALSE);
    IF Selected = NIL THEN
      Selected :=
        FindCaption (0, Verzeichnisstruktur.Directory + '\', TRUE, TRUE, FALSE);
    IF Selected = NIL THEN BEGIN
      i := Items.Count;
      WHILE (i > 0) AND (Selected = NIL) DO BEGIN
        DEC (i);
        cap := Items [i].Caption;
        j := Length (cap);
        WHILE (j > 0) AND (cap [j] <> '\') DO BEGIN
          Delete (cap, Length (cap), 1);
          DEC (j);
        END (* WHILE *);
        IF pos (cap, Verzeichnisstruktur.Directory) > 0
          THEN Selected := Items [i];
      END (* WHILE *);
    END (* IF *);
    IF Selected <> NIL THEN BEGIN
      Selected.MakeVisible (FALSE);
//showMessage ('ListViewFavs: Selected');
    END (* IF Selected *)
    ELSE BEGIN
//showMessage ('ListViewFavs: NOT Selected');
    END (* ELSE *);
  END (* WITH *);
end (* setzeFavourites *);

procedure TDateiManagerForm.FormPaint(Sender: TObject);
begin
// Wenn man das in OnActivate macht, klappt es nicht immer - ist anscheinend
// zu frh. So geht es offenbar!
  SetzeFavourites;
end;

procedure TDateiManagerForm.InTextfensteroeffnen1Click(Sender: TObject);
VAR DirName, fn: String;
begin
  WITH DateiListe DO BEGIN
    fn := FileName; StripBrackets (fn);
    IF HasAttr (fn, faDirectory) OR HasAttr (fn, faVolumeID) THEN BEGIN
      DirName := fn;
      Verzeichnisstruktur.Directory := DirName;
      VerzeichnisstrukturChange (Sender);
    END
    ELSE
      IF UpperCase (ExtractFileExt (fn)) = '.EXE' THEN
        ExecuteFile (FileName, '', Directory, SW_SHOW)
      ELSE IF (UpperCase (ExtractFileExt (fn)) = '.BMP') OR
              (UpperCase (ExtractFileExt (fn)) = '.JPG') OR
              (UpperCase (ExtractFileExt (fn)) = '.JPEG') OR
              (UpperCase (ExtractFileExt (fn)) = '.GIF') OR
              (UpperCase (ExtractFileExt (fn)) = '.ICO') OR
              (UpperCase (ExtractFileExt (fn)) = '.EMF') OR
              (UpperCase (ExtractFileExt (fn)) = '.WMF') THEN
        WITH TBildForm.Create (LRFrame) DO BEGIN
          Image1.Picture.LoadFromFile (FileName);
          Caption := FileName;
    //      Height := Image1.Picture.Height + 27;
    //      Width := Image1.Picture.Width + 8;
          HorzScrollBar.Range := Image1.Picture.Width;
          VertScrollBar.Range := Image1.Picture.Height;
          Show;
        END (* WITH *)
      ELSE BEGIN
        IF LRFrame.nichtNochmalLaden (FileName) THEN EXIT;
        WITH TEditForm.Create (LRFrame) DO BEGIN
          Open (FileName);
// Kann man hier irgendwie den Editor mit dem neuen Textfenster in den Vordergrund bringen?
        END (* WITH *);
        IF ButtonLaden.Enabled THEN Close;
      END (* ELSE *);
  END (* WITH *);
end;

procedure TDateiManagerForm.DateilisteinTextfenster1Click(Sender: TObject);
VAR i:           Integer;
    Eintrag:     String;
    Stat:        String;
    Dateisumme:  Integer;
    FileSize:    Integer;
    FileDate:    TDateTime;

  procedure Statistik;
  begin
    IF FileSize < 1024 THEN
      Stat := Format ('%20s, %8d  Byte, %s', [Eintrag,
        FileSize, DateTimeToStr (FileDate)])
    ELSE IF FileSize < 1048576 THEN
      Stat := Format ('%20s, %n8 KByte, %s', [Eintrag,
        FileSize / 1024, DateTimeToStr (FileDate)])
    ELSE
      Stat := Format ('%20s, %n8 MByte, %s', [Eintrag,
        FileSize / 1048576, DateTimeToStr (FileDate)]);
    Eintrag := Stat;
  end;

begin
  WITH TEditForm.Create (LRFrame) DO BEGIN
    Editor.Font.Name := 'Courier New';
    Dateisumme := 0;
    FOR i := 0 TO Dateiliste.Items.Count - 1 DO BEGIN
      Eintrag := Dateiliste.Items [i];
      IF HasAttr (Eintrag, FILE_ATTRIBUTE_Directory) OR HasAttr (Eintrag, faVolumeID) THEN BEGIN
        FileSize := 0; FileDate := 0;
      END
      ELSE BEGIN
        FileSize := GetFileSize (Eintrag);
        Dateisumme := Dateisumme + Filesize;
        FileDate := FileDateTime (Eintrag);
      END;
      IF CheckBoxPfad.Checked THEN Eintrag := DateiListe.Directory + '\' + Eintrag;

      IF CheckBoxStatistik.Checked THEN BEGIN
        Statistik;
      END (* IF *);
      Editor.Lines.Append (Eintrag);
    END (* FOR *);

    IF CheckBoxStatistik.Checked THEN BEGIN
      Editor.Lines.Append ('');
      Eintrag := 'Summe der Dateigren: ';
      FileSize := Dateisumme; FileDate := Now;
      Statistik;
      Editor.Lines.Append (Eintrag);
    END (* IF *);
  END (* WITH *);
end;

procedure TDateiManagerForm.ButtonLadenClick(Sender: TObject);
begin
  IF NOT isModal THEN SpeedDateiOeffnenClick (Self);
end;

procedure TDateiManagerForm.DateiFilterComboBoxChange(Sender: TObject);
begin
  FilterIndex := DateiFilterComboBox.ItemIndex;
end;

procedure TDateiManagerForm.ButtonFilterClick(Sender: TObject);
begin
  LRFrame.Konfig.DateiFilterIndex := DateiFilterComboBox.ItemIndex;
end;

procedure TDateiManagerForm.ListViewFavouritesKeyUp(Sender: TObject;
  var Key: Word; Shift: TShiftState);
begin
// Aktualisiert Verzeichnisse, wenn man im Favoritenbrowser den Balken mit den
// Cursortasten verschiebt. Funktioniert offenbar nur in diesem Event korrekt!
  ListViewFavouritesClick (Sender);
end;

procedure TDateiManagerForm.SelektiertesVerzeichnisentfernen1Click(
  Sender: TObject);
VAR  Index:   Integer;
begin
  WITH LRFrame.FavouriteListe DO BEGIN
    IF ListViewFavourites.Selected <> NIL THEN
      Index := ListViewFavourites.Selected.Index
    ELSE Index := -1;
    IF Index <> -1 THEN Delete (Index);
  END (* WITH *);
  MakeFavList;
  setzeFavourites;
end;

procedure TDateiManagerForm.SpeedButtonUploadFileClick(Sender: TObject);
VAR upload:  TextFile;
begin
  AssignFile (upload, 'upload.tmp');
  Rewrite (upload);
//  writeLn (upload, 'open ',  EditHostname.text);
  writeLn (upload, 'anonymus');
  writeLn (upload, 'binary');
  writeLn (upload, 'put ', ExtractFileName (Dateiliste.Filename), ' ',
                           ExtractFileName (Dateiliste.Filename));
  FileSetAttr (Dateiliste.Filename, FileGetAttr (Dateiliste.Filename) xor FILE_ATTRIBUTE_ARCHIVE);
  writeLn (upload, 'bye');
  CloseFile (upload);
  ExecuteFile ('ftp', '-s:upload.tmp ' + EditHostname.text, '', SW_SHOW);
end;

procedure TDateiManagerForm.SpeedButtonUploadDirClick(Sender: TObject);
VAR upload:  TextFile;
    i:       Integer;
    Eintrag: String;
begin
  AssignFile (upload, 'upload.tmp');
  Rewrite (upload);
//  writeLn (upload, 'open ',  EditHostname.text);
  writeLn (upload, 'anonymus');
  writeLn (upload, 'binary');

  FOR i := 0 TO Dateiliste.Items.Count - 1 DO BEGIN
    Eintrag := Dateiliste.Items [i];
    IF NOT (HasAttr (Eintrag, FILE_ATTRIBUTE_Directory) OR
            HasAttr (Eintrag, faVolumeID)) AND
            HasAttr (Eintrag, FILE_ATTRIBUTE_ARCHIVE) THEN BEGIN
      writeLn (upload, 'put ', Eintrag, ' ', Eintrag);
      FileSetAttr (Eintrag, FileGetAttr (Eintrag) xor FILE_ATTRIBUTE_ARCHIVE);
    END (* IF *);
  END (* FOR *);

  writeLn (upload, 'bye');
  CloseFile (upload);
  ExecuteFile ('ftp', '-s:upload.tmp ' + EditHostname.text, '', SW_SHOW);
end;

procedure TDateiManagerForm.SpeedButtonGetHostDirClick(Sender: TObject);
CONST cVerzeichnis = 'verzeichnis.rtf';
      cVerzeich =    'verzeich.txt';
      cMax =         10 * 1024 * 1024; // 10 MB auf T-Online
VAR upload:          TextFile;
    i, j, sum, dati: Integer;
    sumstr, linestr: String;
    EditForm:        TEditForm;
//    Source:          Integer;
begin
  AssignFile (upload, 'download.tmp');
  Rewrite (upload);
  writeLn (upload, 'anonymus');
  writeLn (upload, 'dir');
  writeLn (upload, 'bye');
  CloseFile (upload);

  AssignFile (upload, 'getdir.bat');
  Rewrite (upload);
  writeln (upload, 'del ' + cVerzeich);
  writeLn (upload, 'ftp -i -s:download.tmp ' + EditHostname.text + '>>' + cVerzeich);
//  writeLn (upload, 'pause');
  CloseFile (upload);
  IF FileExists (cVerzeich) THEN BEGIN
//    Source := FileOpen (cVerzeich, fmOpenReadWrite + fmShareDenyNone);
//    Source := FileCreate (cVerzeich);
//    FileClose (Source);
    DeleteFile (cVerzeich);
  END (* IF *);
  IF FileExists (cVerzeich) THEN BEGIN
    showMessage ('Zugriffs-Problem: Lschen von "' + cVerzeich + '" hat nicht geklappt');
  END;
  WinExecAndWait32 ('getdir.bat', SW_SHOW);
  IF FileExists (cVerzeich) THEN BEGIN
//showMessage ('IF FileExists THEN DeleteFile cVerzeichnis');
    IF FileExists (cVerzeichnis) THEN DeleteFile (cVerzeichnis);
//showMessage ('CopyFile cVerzeich, cVerzeichnis');
    CopyFile (cVerzeich, cVerzeichnis, TRUE);
    SpeedButton1RefreshClick (Sender);
    IF NOT FileExists (cVerzeichnis) THEN
      showMessage ('Datei "' + cVerzeichnis + '" konnte nicht kopiert werden!');
    EditForm := LRFrame.FindePfadNamen (Dateiliste.Directory + '\' + cVerzeichnis) as TEditForm;
    IF EditForm = NIL THEN
      EditForm := TEditForm.Create (LRFrame);
    WITH EditForm DO BEGIN
//showMessage ('Open cVerzeichnis');
      Editor.Update;
      Editor.Visible := FALSE;
      Editor.Font.Name := 'Courier New';
      Open (Dateiliste.Directory + '\' + cVerzeichnis);
      i := 0; dati := 0; sum := 0;
      LRFrame.Warte (500);
      WHILE (i < Editor.Lines.Count) DO BEGIN
        IF Pos ('homeadmin', Editor.Lines [i]) <= 0 {Editor.Lines [i] = ''} THEN
          Editor.Lines.Delete (i)
        ELSE BEGIN
          INC (dati);
          linestr := Copy (Editor.Lines [i], 33, Length (Editor.Lines [i]));
          j := 1;
          WHILE (linestr [j] = ' ') AND (j < Length (linestr)) DO INC (j);
          sumstr := '';
          WHILE (linestr [j] IN ['0'..'9']) AND (j < Length (linestr)) DO BEGIN
            sumstr := sumstr + linestr [j]; INC (j);
          END;
//showMessage ('sum: ' + sumstr + ', line: ' +linestr);
          IF sumstr <> '' THEN sum := sum + StrToInt (sumstr);
          Editor.Lines [i] := linestr;
          INC (i);
        END (* ELSE *);
      END (* WHILE *);
      Editor.Lines.Insert (0, 'Web-Verzeichnis ' + Dateiliste.Directory);
      Editor.Lines.Insert (1, 'Dateigre  -  Datum  -  Name');
      Editor.Lines.Insert (2, '');
      Editor.Lines.add ('');
      IF sum < 1024 THEN
        sumstr := Format ('%d Byte', [sum])
      ELSE IF sum < 1048576 THEN
        sumstr := Format ('%n KByte', [sum / 1024])
      ELSE
        sumstr := Format ('%n MByte', [sum / 1048576]);
      Editor.Lines.add (sumstr + ' in ' + IntToStr (dati) + ' Dateien');
      IF cmax - sum < 1024 THEN
        sumstr := Format ('%d Byte', [cmax - sum])
      ELSE IF cmax - sum < 1048576 THEN
        sumstr := Format ('%n KByte', [(cmax - sum) / 1024])
      ELSE
        sumstr := Format ('%n MByte', [(cmax - sum) / 1048576]);
      Editor.Lines.add ('Rest gegenber 10 MB: ' + sumstr);
      Editor.Selstart := 0;
      Editor.BringToFront;
      Editor.Visible := TRUE;
      LRFrame.BringToFront;
    END (* WITH *);
  END (* IF FileExists *)
  ELSE showMessage ('Datei: "' + cVerzeichnis + '" nicht vorhanden!');

end (* SpeedButtonGetHostDirClick *);

end.

