unit STexteinstellungen;

{The Little Richard Editor
 (C) 1996, 1997 by Johannes Leckebusch
 14. 12. 98}

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ComCtrls, ExtCtrls, Dialogs;

type
  TTextFormatDialog = class(TForm)
    RegisterPanel: TPanel;
    LROptionSchalter: TPanel;
    PageControl1: TPageControl;
    Absatzformat: TTabSheet;
    Anzeige: TTabSheet;
    Textmakros: TTabSheet;
    OKBtn: TButton;
    CancelBtn: TButton;
    HelpBtn: TButton;
    Randeinstellung: TGroupBox;
    UpDwnEinzug: TUpDown;
    EditEinzug: TEdit;
    EinzugLabel: TLabel;
    LinksLabel: TLabel;
    LinksEdit: TEdit;
    UpDwnLinks: TUpDown;
    RechtsLabel: TLabel;
    RechtsEdit: TEdit;
    UpDwnRechts: TUpDown;
    Uebernehmen: TButton;
    Tabulator: TGroupBox;
    UpDwnTabAbstand: TUpDown;
    EditTabAbstand: TEdit;
    TabLabel: TLabel;
    Label1: TLabel;
    Label2: TLabel;
    Schalter: TGroupBox;
    Makros: TGroupBox;
    ME1: TEdit;
    MB1: TButton;
    MB2: TButton;
    ME2: TEdit;
    MB3: TButton;
    ME3: TEdit;
    ME4: TEdit;
    MB4: TButton;
    ME5: TEdit;
    MB5: TButton;
    ME6: TEdit;
    MB6: TButton;
    ME7: TEdit;
    MB7: TButton;
    ME9: TEdit;
    MB8: TButton;
    ME10: TEdit;
    MB10: TButton;
    ME8: TEdit;
    MB9: TButton;
    BLadeMakro: TButton;
    BSpeichereMakro: TButton;
    ISOButton: TCheckBox;
    WortUmbruchButton: TCheckBox;
    OpenMakro: TOpenDialog;
    SaveMakro: TSaveDialog;
    LinealAnzeigenButton: TCheckBox;
    MaxTextlaenge: TGroupBox;
    EditMaxTextLaen: TEdit;
    ButtonStandardTextlaen: TButton;
    ButtonMediumTextlaen: TButton;
    ButtonMaxTextLaen: TButton;
    SeitenLayout: TGroupBox;
    EditZeichenProSeite: TEdit;
    UpDownZeichenProSeite: TUpDown;
    Label3: TLabel;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    AutoSaveButton: TCheckBox;
    Suchmarken: TTabSheet;
    GroupBoxSprungmarken: TGroupBox;
    ComboBoxTextmarken: TComboBox;
    Label4: TLabel;
    ButtonAnspringen: TButton;
    ButtonEinfuegen: TButton;
    ButtonLoeschen: TButton;
    ButtonNochmalSuchen: TButton;
    ButtonAlleLoeschen: TButton;
    ButtonSuchLaden: TButton;
    ButtonSuchSpeichern: TButton;
    SpeedSuchen: TSpeedButton;
    SpeedErsetzen: TSpeedButton;
    procedure OKBtnClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure CancelBtnClick(Sender: TObject);
    procedure UebernehmenClick(Sender: TObject);
    procedure MB1Click(Sender: TObject);
    procedure MB2Click(Sender: TObject);
    procedure MB3Click(Sender: TObject);
    procedure MB4Click(Sender: TObject);
    procedure MB5Click(Sender: TObject);
    procedure MB6Click(Sender: TObject);
    procedure MB7Click(Sender: TObject);
    procedure MB8Click(Sender: TObject);
    procedure MB9Click(Sender: TObject);
    procedure MB10Click(Sender: TObject);
    procedure WortumbruchButtonClick(Sender: TObject);
    procedure ISOButtonClick(Sender: TObject);
    procedure BLadeMakroClick(Sender: TObject);
    procedure BSpeichereMakroClick(Sender: TObject);
    procedure ME1Change(Sender: TObject);
    procedure LinealAnzeigenButtonClick(Sender: TObject);
    procedure ButtonStandardTextlaenClick(Sender: TObject);
    procedure ButtonMaxTextLaenClick(Sender: TObject);
    procedure ButtonMediumTextlaenClick(Sender: TObject);
    procedure EditMaxTextLaenChange(Sender: TObject);
    procedure EditZeichenProSeiteChange(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure AutoSaveButtonClick(Sender: TObject);
    procedure ButtonEinfuegenClick(Sender: TObject);
    procedure ButtonAnspringenClick(Sender: TObject);
    procedure ButtonNochmalSuchenClick(Sender: TObject);
    procedure ButtonLoeschenClick(Sender: TObject);
    procedure ButtonAlleLoeschenClick(Sender: TObject);
    procedure ButtonSuchSpeichernClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ButtonSuchLadenClick(Sender: TObject);
    procedure SpeedSuchenClick(Sender: TObject);
    procedure SpeedErsetzenClick(Sender: TObject);
  private
    { Private declarations }
    MakroEditiert: BOOLEAN;
    OldPfadname: String;
  public
    { Public declarations }
    noUpdate:        BOOLEAN;
    procedure        updateEinstellungen;
  end;

var
  TextFormatDialog: TTextFormatDialog;

implementation

{$R *.DFM}

USES SmallLittleFrame, SLREdit;

procedure TTextFormatDialog.OKBtnClick(Sender: TObject);
begin
  Close;
end;

procedure TTextFormatDialog.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  IF ModalResult = mrOk THEN BEGIN
    UebernehmenClick (Sender);
  END (* IF ModalResult *);
  TextFormatDialog := NIL;
end;

procedure TTextFormatDialog.CancelBtnClick(Sender: TObject);
begin
  Close;
end;

procedure TTextFormatDialog.UebernehmenClick(Sender: TObject);
VAR  Index:  Integer;
begin
  WITH LRFrame.ActiveMDIChild AS TEditForm DO BEGIN
    ComboBoxTextmarken.Items.SaveToFile (changeFileExt (Pfadname, '.sma'));
    WITH Editor DO BEGIN
      Paragraph.FirstIndent := UpDwnEinzug.Position;
      Paragraph.LeftIndent := UpDwnLinks.Position;
      Paragraph.RightIndent := UpDwnRechts.Position;
      Paragraph.TabCount := UpDwnTabAbstand.Position;
      WordWrap := WortUmbruchButton.Checked;
      MaxLength := StrToInt (EditMaxTextLaen.Text);
      LRFrame.Konfig.MaxTextLaenge := MaxLength;
      IF WordWrap THEN
        Scrollbars := ssVertical
      ELSE
        Scrollbars := ssBoth;
    END (* WITH *);
    ISOAnzeige := ISOButton.Checked;
    AutoSave := AutoSaveButton.Checked;
    {LRFrame.HistoryListeAnzeigen := CheckHistoryList.Checked;}
    WITH LRFrame.ActiveMDIChild AS TEditForm DO BEGIN
        TextMakroListe.Clear;
        FOR Index := 0 TO 10 DO BEGIN
          CASE Index OF
            0: TextMakroListe.Add (ME1.Text);
            1: TextMakroListe.Add (ME2.Text);
            2: TextMakroListe.Add (Me3.Text);
            3: TextMakroListe.Add (Me4.Text);
            4: TextMakroListe.Add (Me5.Text);
            5: TextMakroListe.Add (Me6.Text);
            6: TextMakroListe.Add (Me7.Text);
            7: TextMakroListe.Add (Me8.Text);
            8: TextMakroListe.Add (Me9.Text);
            9: TextMakroListe.Add (Me10.Text);
          END (* CASE *);
        END (* FOR *);
        IF MakroEditiert THEN TextMakroEditiert := TRUE;
    END (* WITH Application *);
    CursorDaten (Sender);
  END (* WITH *);
end;

procedure TTextFormatDialog.MB1Click(Sender: TObject);
begin
  WITH LRFrame.ActiveMDIChild AS TEditForm DO
    WITH Editor DO
      SelText := ME1.Text;
end;

procedure TTextFormatDialog.MB2Click(Sender: TObject);
begin
  WITH LRFrame.ActiveMDIChild AS TEditForm DO
    WITH Editor DO
      SelText := ME2.Text;
end;

procedure TTextFormatDialog.MB3Click(Sender: TObject);
begin
  WITH LRFrame.ActiveMDIChild AS TEditForm DO
    WITH Editor DO
      SelText := ME3.Text;
end;

procedure TTextFormatDialog.MB4Click(Sender: TObject);
begin
  WITH LRFrame.ActiveMDIChild AS TEditForm DO
    WITH Editor DO
      SelText := ME4.Text;
end;

procedure TTextFormatDialog.MB5Click(Sender: TObject);
begin
  WITH LRFrame.ActiveMDIChild AS TEditForm DO
    WITH Editor DO
      SelText := ME5.Text;
end;

procedure TTextFormatDialog.MB6Click(Sender: TObject);
begin
  WITH LRFrame.ActiveMDIChild AS TEditForm DO
    WITH Editor DO
      SelText := ME6.Text;
end;

procedure TTextFormatDialog.MB7Click(Sender: TObject);
begin
  WITH LRFrame.ActiveMDIChild AS TEditForm DO
    WITH Editor DO
      SelText := ME7.Text;
end;

procedure TTextFormatDialog.MB8Click(Sender: TObject);
begin
  WITH LRFrame.ActiveMDIChild AS TEditForm DO
    WITH Editor DO
      SelText := ME8.Text;
end;

procedure TTextFormatDialog.MB9Click(Sender: TObject);
begin
  WITH LRFrame.ActiveMDIChild AS TEditForm DO
    WITH Editor DO
      SelText := ME9.Text;
end;

procedure TTextFormatDialog.MB10Click(Sender: TObject);
begin
  WITH LRFrame.ActiveMDIChild AS TEditForm DO
    WITH Editor DO
      SelText := ME10.Text;
end;

procedure TTextFormatDialog.WortumbruchButtonClick(Sender: TObject);
begin
  WITH LRFrame.ActiveMDIChild AS TEditForm DO BEGIN
    WITH Editor DO BEGIN
      WordWrap := WortUmbruchButton.Checked;
      IF WordWrap THEN
        Scrollbars := ssVertical
      ELSE
        Scrollbars := ssBoth;
      Zeilenumbruch1.Checked := WordWrap;
    END (* WITH *);
  END (* WITH *);
end;

procedure TTextFormatDialog.ISOButtonClick(Sender: TObject);
begin
  WITH LRFrame.ActiveMDIChild AS TEditForm DO BEGIN
    ISOAnzeige := ISOButton.Checked;
  END;
end;

procedure TTextFormatDialog.BLadeMakroClick(Sender: TObject);
VAR Index: Integer;
begin
  WITH LRFrame.ActiveMDIChild AS TEditForm DO BEGIN
    IF OpenMakro.Execute THEN
      TextMakroListe.LoadFromFile (OpenMakro.FileName);
      FOR Index := 0 TO TextMakroListe.Count -1 DO BEGIN
        CASE Index OF
          0: ME1.Text := TextMakroListe.Strings [0];
          1: ME2.Text := TextMakroListe.Strings [1];
          2: ME3.Text := TextMakroListe.Strings [2];
          3: ME4.Text := TextMakroListe.Strings [3];
          4: ME5.Text := TextMakroListe.Strings [4];
          5: ME6.Text := TextMakroListe.Strings [5];
          6: ME7.Text := TextMakroListe.Strings [6];
          7: ME8.Text := TextMakroListe.Strings [7];
          8: ME9.Text := TextMakroListe.Strings [8];
          9: ME10.Text := TextMakroListe.Strings [9];
        END (* CASE *);
      END (* FOR *);
  END (* WITH *);
end;

procedure TTextFormatDialog.BSpeichereMakroClick(Sender: TObject);
VAR Index: Integer;
begin
  WITH LRFrame.ActiveMDIChild AS TEditForm DO BEGIN
    SaveMakro.FileName := ChangeFileExt (Application.ExeName, '.MAK');
    IF SaveMakro.Execute THEN BEGIN
      TextMakroListe.Clear;
      FOR Index := 0 TO 10 DO BEGIN
        CASE Index OF
          0: TextMakroListe.Add (ME1.Text);
          1: TextMakroListe.Add (ME2.Text);
          2: TextMakroListe.Add (Me3.Text);
          3: TextMakroListe.Add (Me4.Text);
          4: TextMakroListe.Add (Me5.Text);
          5: TextMakroListe.Add (Me6.Text);
          6: TextMakroListe.Add (Me7.Text);
          7: TextMakroListe.Add (Me8.Text);
          8: TextMakroListe.Add (Me9.Text);
          9: TextMakroListe.Add (Me10.Text);
        END (* CASE *);
      END (* FOR *);
      TextMakroListe.SaveToFile (SaveMakro.FileName);
      TextMakroEditiert := FALSE;
    END (* IF *);
  END (* WITH *);
end;

procedure TTextFormatDialog.ME1Change(Sender: TObject);
begin
  Makroeditiert := TRUE;
end;

procedure TTextFormatDialog.LinealAnzeigenButtonClick(Sender: TObject);
begin
  WITH LRFrame.ActiveMDIChild AS TEditForm DO BEGIN
    Lineal.Visible := LinealAnzeigenButton.Checked;
  END (* WITH *);
end;

procedure TTextFormatDialog.ButtonStandardTextlaenClick(Sender: TObject);
begin
  EditMaxTextLaen.Text := '0';
end;

procedure TTextFormatDialog.ButtonMaxTextLaenClick(Sender: TObject);
begin
  EditMaxTextLaen.Text := IntToStr (High (Integer) - 1024);
  {Editor.MaxLength := High (Integer) - 1024;}
end;

procedure TTextFormatDialog.ButtonMediumTextlaenClick(Sender: TObject);
begin
  EditMaxTextLaen.Text := IntToStr (High (Integer) DIV 2);
end;

procedure TTextFormatDialog.EditMaxTextLaenChange(Sender: TObject);
begin
  WITH LRFrame.ActiveMDIChild AS TEditForm DO BEGIN
    WITH Editor DO BEGIN
      IF EditMaxTextLaen.Text <> '' THEN
        MaxLength := StrToInt (EditMaxTextLaen.Text);
    END (* WITH *);
  END (* WITH *);
end;

procedure TTextFormatDialog.EditZeichenProSeiteChange(Sender: TObject);
begin
//  IF LRFrame.ActiveMDIChild = NIL THEN EXIT;
  WITH LRFrame.ActiveMDIChild AS TEditForm DO BEGIN
    WITH Editor DO BEGIN
      IF EditZeichenProSeite.Text <> '' THEN BEGIN
        IF UpDownZeichenProSeite.Position = 0 THEN
          UpDownZeichenProSeite.Position := LRFrame.Konfig.ZeichenAufSeite
        // Initialisierung
        ELSE BEGIN
//showMessage ('EditZeichenProSeiteChange: ' + EditZeichenProSeite.Text);
          ZeichenProSeite := StrToInt (EditZeichenProSeite.Text);
        END (* ELSE Initialisierung *);
      END (* IF *);
    END (* WITH *);
  END (* WITH *);
end;

procedure TTextFormatDialog.updateEinstellungen;
VAR Index: Integer;
begin
  IF noUpdate THEN EXIT;
  
  WITH LRFrame.ActiveMDIChild AS TEditForm DO BEGIN
    IF (ComboBoxTextmarken.ItemIndex < 0) AND (ComboBoxTextMarken.Items.Count > 0)
      THEN ComboBoxTextmarken.ItemIndex := 0;
    IF changeFileExt (Pfadname, '.sma') <> OldPfadname THEN BEGIN
      IF (OldPfadname <> '') AND (ComboBoxTextmarken.Items.Count > 0) THEN
        ComboBoxTextmarken.Items.SaveToFile (OldPfadname);
      ComboBoxTextmarken.Clear;
      IF FileExists (changeFileExt (Pfadname, '.sma')) THEN BEGIN
        ComboBoxTextmarken.Items.LoadFromFile (changeFileExt (Pfadname, '.sma'));
        WHILE (ComboBoxTextmarken.Items[0] = '') AND (ComboBoxTextmarken.Items.Count > 0) DO
          ComboBoxTextmarken.Items.Delete (0);
        ComboBoxTextmarken.ItemIndex := 0;
      END (* IF FileExists *);
      OldPfadName := changeFileExt (Pfadname, '.sma');
    END (* IF *);
  END (* WITH *);
  WITH LRFrame.ActiveMDIChild AS TEditForm DO BEGIN
    WITH Editor DO BEGIN
      UpDwnEinzug.Position := Paragraph.FirstIndent;
      UpDwnLinks.Position := Paragraph.LeftIndent;
      UpDwnRechts.Position := Paragraph.RightIndent;
      UpDwnTabAbstand.Position := Paragraph.TabCount;
      EditMaxTextLaen.Text := IntToStr (MaxLength);
      {WITH Owner AS TEditForm DO BEGIN}
        IsoButton.Checked := IsoAnzeige;
        AutoSaveButton.Checked := AutoSave;
        WortUmbruchButton.Checked := Wordwrap;
        LinealAnzeigenButton.Checked := Lineal.Visible;
  //      EditZeichenProSeite.Text := IntToStr (ZeichenProSeite);
  //showMessage ('!ZeichenProSeite: ' + IntToStr (ZeichenProSeite));
        UpDownZeichenProSeite.Position := ZeichenProSeite;
      {END (* WITH *);}
    END (* WITH Editor *);
  END (* WITH *);

  WITH LRFrame.ActiveMDIChild AS TEditForm DO BEGIN
    Makroeditiert := FALSE;
      FOR Index := 0 TO TextMakroListe.Count -1 DO BEGIN
        CASE Index OF
          0: ME1.Text := TextMakroListe.Strings [0];
          1: ME2.Text := TextMakroListe.Strings [1];
          2: ME3.Text := TextMakroListe.Strings [2];
          3: ME4.Text := TextMakroListe.Strings [3];
          4: ME5.Text := TextMakroListe.Strings [4];
          5: ME6.Text := TextMakroListe.Strings [5];
          6: ME7.Text := TextMakroListe.Strings [6];
          7: ME8.Text := TextMakroListe.Strings [7];
          8: ME9.Text := TextMakroListe.Strings [8];
          9: ME10.Text := TextMakroListe.Strings [9];
        END (* CASE *);
      END (* FOR *);
  END (* WITH Application *);
end (* updateEinstellungen *);

procedure TTextFormatDialog.FormActivate(Sender: TObject);
begin
  updateEinstellungen;
end;

procedure TTextFormatDialog.Button1Click(Sender: TObject);
begin
  UpDownZeichenProSeite.Position := 1500;
end;

procedure TTextFormatDialog.Button2Click(Sender: TObject);
begin
  UpDownZeichenProSeite.Position := 3500;
end;

procedure TTextFormatDialog.Button3Click(Sender: TObject);
begin
  UpDownZeichenProSeite.Position := 7500;
end;

procedure TTextFormatDialog.AutoSaveButtonClick(Sender: TObject);
begin
  WITH LRFrame.ActiveMDIChild AS TEditForm DO BEGIN
    AutoSave := AutoSaveButton.Checked;
  END;
end;

procedure TTextFormatDialog.ButtonEinfuegenClick(Sender: TObject);
begin
  WITH LRFrame.ActiveMDIChild AS TEditForm DO
    WITH Editor DO BEGIN
      IF (SelText <> '') THEN BEGIN
        IF (ComboBoxTextmarken.Items.IndexOf (SelText) = -1) THEN BEGIN
          ComboBoxTextmarken.ItemIndex :=
            ComboBoxTextmarken.Items.Add (SelText);
        END (* IF *)
        ELSE
          ComboBoxTextmarken.ItemIndex :=
            ComboBoxTextmarken.Items.IndexOf (SelText);
      END (* IF SelText <> '' *)
      ELSE
        showMessage ('Sie mssen zuerst eine Textstelle markieren');
    END (* WITH Editor *);
end;

procedure TTextFormatDialog.ButtonAnspringenClick(Sender: TObject);
VAR  suchpos: Integer;
begin
  WITH LRFrame.ActiveMDIChild AS TEditForm DO BEGIN
    WITH Editor DO BEGIN
      IF ComboBoxTextmarken.Text <> '' THEN BEGIN
        suchpos := findText (ComboBoxTextmarken.Text, 0, GetTextLen, []);
        IF suchpos > -1 THEN
          BEGIN
            SelStart := suchpos;
            SelLength := Length (ComboboxTextmarken.Text);
          END
        ELSE BEGIN
          LRFrame.FindDialog1.Findtext := ComboBoxTextmarken.Text;
          LRFrame.FindDialog1.Execute;
{          ShowMessage ('Textstelle "' + ComboBoxTextmarken.Text +
            '" nicht gefunden!');}
        END (* ELSE *);
      END (* IF *);
    END (* WITH EDITOR *);
//    SetFocus;
  END (* WITH ActiveMDIChild *);
end;

procedure TTextFormatDialog.ButtonNochmalSuchenClick(Sender: TObject);
VAR  suchpos: Integer;
begin
  WITH LRFrame.ActiveMDIChild AS TEditForm DO BEGIN
    WITH Editor DO BEGIN
      IF ComboBoxTextmarken.Text <> '' THEN BEGIN
        suchpos := findText (ComboBoxTextmarken.Text, SelStart + SelLength, GetTextLen, []);
        IF suchpos > -1 THEN
          BEGIN
            SelStart := suchpos;
            SelLength := Length (ComboboxTextmarken.Text);
          END
        ELSE BEGIN
          LRFrame.FindDialog1.Findtext := ComboBoxTextmarken.Text;
          LRFrame.FindDialog1.Execute;
{          ShowMessage ('Textstelle "' + ComboBoxTextmarken.Text +
            '" nicht gefunden!');
}
        END (* ELSE *);
      END (* IF *);
    END (* WITH EDITOR *);
//    SetFocus;
  END (* WITH ActiveMDIChild *);
end;

procedure TTextFormatDialog.ButtonLoeschenClick(Sender: TObject);
begin
  ComboBoxTextmarken.Items.Delete (ComboBoxTextmarken.ItemIndex);
  ComboBoxTextmarken.ItemIndex := 0;
end;

procedure TTextFormatDialog.ButtonAlleLoeschenClick(Sender: TObject);
begin
  ComboBoxTextmarken.Clear;
end;

procedure TTextFormatDialog.ButtonSuchSpeichernClick(Sender: TObject);
begin
  showMessage ('Hier sollte noch ein Dateidialog erscheinen!');
  WITH LRFrame.ActiveMDIChild AS TEditForm DO
    ComboBoxTextmarken.Items.SaveToFile (changeFileExt (Pfadname, '.sma'));
end;

procedure TTextFormatDialog.FormCreate(Sender: TObject);
begin
  WITH LRFrame.ActiveMDIChild AS TEditForm DO
   IF FileExists (changeFileExt (Pfadname, '.sma')) THEN BEGIN
     ComboBoxTextmarken.Items.LoadFromFile (changeFileExt (Pfadname, '.sma'));
       WHILE (ComboBoxTextmarken.Items.Count > 0) AND (ComboBoxTextmarken.Items[0] = '') DO
         ComboBoxTextmarken.Items.Delete (0);
     ComboBoxTextmarken.ItemIndex := 0;
     OldPfadName := changeFileExt (Pfadname, '.sma');
   END (* IF FileExists *);
end;

procedure TTextFormatDialog.ButtonSuchLadenClick(Sender: TObject);
begin
  showMessage ('Hier sollte noch ein Dateidialog erscheinen!');
  WITH LRFrame.ActiveMDIChild AS TEditForm DO
   IF FileExists (changeFileExt (Pfadname, '.sma')) THEN BEGIN
     ComboBoxTextmarken.Items.LoadFromFile (changeFileExt (Pfadname, '.sma'));
       WHILE (ComboBoxTextmarken.Items[0] = '') AND (ComboBoxTextmarken.Items.Count > 0) DO
         ComboBoxTextmarken.Items.Delete (0);
     ComboBoxTextmarken.ItemIndex := 0;
   END (* IF FileExists *);
end;

procedure TTextFormatDialog.SpeedSuchenClick(Sender: TObject);
begin
  LRFrame.SpeedSuchenClick (Sender);
end;

procedure TTextFormatDialog.SpeedErsetzenClick(Sender: TObject);
begin
  LRFrame.SpeedErsetzenClick (Sender);
end;

end.

