unit Bild;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Buttons;

type
  TBildForm = class(TForm)
    Panel1: TPanel;
    PanelStrechCheck: TPanel;
    CheckBoxStretched: TCheckBox;
    Image1: TImage;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure CheckBoxStretchedClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  BildForm: TBildForm;

implementation

uses SmallLittleFrame;

{$R *.DFM}

procedure TBildForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caFree;
  WITH LRFrame DO BEGIN
    IF ShutDown THEN EXIT;
    IF MDIChildCount <=1 THEN BEGIN
      SpeedSchliessen.Enabled := FALSE;
    END;
  END (* WITH *);
end;

procedure TBildForm.CheckBoxStretchedClick(Sender: TObject);
begin
  IF CheckBoxStretched.checked THEN BEGIN
    Image1.stretch := True;
    HorzScrollBar.Range := 0;
    VertScrollBar.Range := 0;
  END
  ELSE BEGIN
    Image1.stretch := FALSE;
    HorzScrollBar.Range := Image1.Picture.Width;
    VertScrollBar.Range := Image1.Picture.Height;
  END (* ELSE *);
end;


procedure TBildForm.FormCreate(Sender: TObject);
begin
  WITH LRFrame DO BEGIN
    IF {ActiveMDIChild = NIL} NOT SpeedSchliessen.Enabled THEN BEGIN
      SpeedSchliessen.Enabled := TRUE;
    END (* IF *);
  END (* WITH *);
end;

end.
