unit StringForm;

{The Little Richard Editor
 (C) 1996, 1997, 1998 by Johannes Leckebusch
 14. 07. 1998}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ComCtrls, ToolWin, Menus, ImgList;

type
  TStringDialog = class(TForm)
    StringMenu: TMainMenu;
    StringPopupMenu: TPopupMenu;
    Datei1: TMenuItem;
    Laden1: TMenuItem;
    Speichern1: TMenuItem;
    N1: TMenuItem;
    Schliessen1: TMenuItem;
    ToolBarStringDialog: TToolBar;
    ListViewStringDialog: TListView;
    EditStringDialog: TEdit;
    ToolBarStringButtons: TToolBar;
    ButtonAbbruch: TButton;
    ButtonOk: TButton;
    ButtonStringeinfuegen: TButton;
    ButtonStringLoeschen: TButton;
    ButtonStringsSortieren: TButton;
    ButtonUebernehmen: TButton;
    Listeladen1: TMenuItem;
    Listespeichern1: TMenuItem;
    N2: TMenuItem;
    Schliessen2: TMenuItem;
    Listesortieren1: TMenuItem;
    Abbrechen1: TMenuItem;
    Beenden1: TMenuItem;
    Listesortieren2: TMenuItem;
    ImageListStrings: TImageList;
    N3: TMenuItem;
    ElementandenAnfang1: TMenuItem;
    N4: TMenuItem;
    Elementeinsnachoben1: TMenuItem;
    Elementeinsnachunten1: TMenuItem;
    procedure Laden1Click(Sender: TObject);
    procedure ListViewStringDialogClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure ListViewStringDialogChange(Sender: TObject; Item: TListItem;
      Change: TItemChange);
    procedure ListViewStringDialogDblClick(Sender: TObject);
    procedure Speichern1Click(Sender: TObject);
    procedure ButtonStringLoeschenClick(Sender: TObject);
    procedure ButtonStringeinfuegenClick(Sender: TObject);
    procedure ButtonStringsSortierenClick(Sender: TObject);
    procedure ButtonOkClick(Sender: TObject);
    procedure Schlieen1Click(Sender: TObject);
    procedure Abbrechen1Click(Sender: TObject);
    procedure ButtonUebernehmenClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ElementandenAnfang1Click(Sender: TObject);
    procedure N3Click(Sender: TObject);
    procedure Elementeinsnachoben1Click(Sender: TObject);
    procedure Elementeinsnachunten1Click(Sender: TObject);
  private
    { Private-Deklarationen }
    FListe: TStringList;
//    FAuswahl: String;
//    FAusListe: TStringList;
    Dateivorwahl: String;
    function ReadListe: TStringList;
    function ReadAuswahlListe: TStringList;
    function ReadAuswahl: String;
    procedure StringListMachen (VAR SL: TStringList);
  public
    { Public-Deklarationen }
    constructor ECreate (AOwner: TComponent;
                sCaption, sButton, sFile: String;
                List: TStringList;
                iDateifilter: Integer;
                bLadenEnable, bLadenDefault,
                bSpeicherEnable, bSpeicherDefault, bMultiSelect: BOOLEAN); //override;
    property Liste: TStringList read ReadListe;
    property Auswahl: String read ReadAuswahl;
    property AuswahlListe: TStringList read ReadAuswahlListe;
    procedure DateiLaden (Name: String);
    procedure DateiSpeichern (Name: String);
    procedure StringListUebernehmen (SL: TStringList);
  end;

var
  StringDialog: TStringDialog;

implementation

uses SDateimanager, SmallLittleFrame;

{$R *.DFM}

constructor TStringDialog.ECreate (AOwner: TComponent;
                sCaption, sButton, sFile: String;
                List: TStringList;
                iDateifilter: Integer;
                bLadenEnable, bLadenDefault,
                bSpeicherEnable, bSpeicherDefault, bMultiSelect: BOOLEAN);
begin
  Create (AOwner);
  Caption := sCaption;
  IF sButton <> '' THEN BEGIN
    IF bLadenDefault THEN ButtonOk.Caption := sButton
    ELSE IF bSpeicherDefault THEN ButtonOk.Caption := sButton;
  END (* IF sButton *);
  IF sFile <> '' THEN Dateivorwahl := sFile;
  FListe := List;
  IF List <> NIL THEN StringListUebernehmen (List);
  ListViewStringDialog.MultiSelect := bMultiSelect;
end (* ECreate *);

function TStringDialog.ReadListe: TStringList;
begin
  Result := FListe;
end (* ReadListe *);

function TStringDialog.ReadAuswahlListe: TStringList;
VAR reslist:  TStringList;
    i:        Integer;
    Item:     TListItem;
begin
  WITH ListViewStringDialog DO BEGIN
    IF Selected <> NIL THEN BEGIN
      reslist := TStringList.Create;
      i := 0;
      Item := Selected;
      reslist.Add (Item.Caption);
      INC (i);
      WHILE i < SelCount DO BEGIN
        Item := GetNextItem (Item, sdAll, [isSelected]);
        IF Item.Selected THEN BEGIN
          reslist.Add (Item.Caption);
          INC (i);
        END (* IF Item.Selected *);
      END (* WHILE *);
      Result := reslist;
    END
    ELSE BEGIN
      Result := NIL;
    END;
// hm - mu ich "reslist" wieder freigeben - und falls ja, wo/wann???    
  END (* WITH *);
end (* ReadAuswahlListe *);

function TStringDialog.ReadAuswahl: String;
begin
//  Result := FAuswahl;
  WITH ListViewStringDialog DO BEGIN
    IF Selected <> NIL THEN BEGIN
      Result := Selected.Caption;
    END
    ELSE
      Result := '';
  END (* WITH *);
end (* ReadAuswahl *);

procedure TStringDialog.StringListUebernehmen (SL: TStringList);
VAR i:          Integer;
    ListItem:   TListItem;
begin
  WITH ListViewStringDialog DO BEGIN
    FOR i := 0 TO Items.Count - 1 DO BEGIN
      Items.Delete (0);
    END (* FOR *);
//    Items.Clear; // hm - das lscht Spaltenbreite, obiges nicht!
    FOR i := 0 TO SL.Count - 1 DO BEGIN
      ListItem := Items.Add;
      ListItem.Caption := SL.Strings [i];
      IF ImageListStrings.Count > 0 THEN ListItem.ImageIndex := 0;
    END (* FOR *);
  END (* WITH ListViewStringDialog *);
end (* StringListUebernehmen *);

procedure TStringDialog.StringListMachen (VAR SL: TStringList);
VAR i:    Integer;
begin
  WITH ListViewStringDialog DO BEGIN
    IF SL <> NIL THEN
      SL.Clear
    ELSE SL := TStringList.Create;
    FOR i := 0 TO Items.Count - 1 DO BEGIN
      SL.Add (Items.Item [i].Caption);
    END (* FOR *);
  END (* WITH *);
end (* StringListMachen *);

procedure TStringDialog.DateiLaden (Name: String);
VAR SL:         TStringList;
BEGIN
  SL := TStringList.Create;
  SL.LoadFromFile (Name);
  StringListUebernehmen (SL);
  SL.Destroy;
END (* DateiLaden *);

procedure TStringDialog.DateiSpeichern (Name: String);
VAR SL:         TStringList;
BEGIN
  SL := TStringList.Create;
  StringListMachen (SL);
  SL.SaveToFile (Name);
  SL.Destroy;
END (* DateiLaden *);

procedure TStringDialog.Laden1Click(Sender: TObject);
VAR mr:    TModalResult;
begin
  WITH
    TDateiManagerForm.ECreate (Self, FALSE, TRUE,
                               Caption + ' suchen', 'Liste laden',
                               Dateivorwahl, ExtractFileExt (Dateivorwahl) {'*.HIS'}, 0,
                               TRUE, TRUE, FALSE, FALSE) DO BEGIN
    mr := ShowModal;
    IF mr = mrOk THEN BEGIN
      DateiLaden (Dateiauswahl);
    END (* IF mrOk *);
    LRFrame.warte (300);
    Release;
  END (* WITH TDateiManagerForm *);
end (* Laden1Click *);

procedure TStringDialog.ListViewStringDialogClick(Sender: TObject);
VAR  LString: String;
begin
  WITH ListViewStringDialog DO BEGIN
    IF ItemFocused <> NIL THEN BEGIN
      LString := ItemFocused.Caption;
      EditStringDialog.Text := LString;
//      FAuswahl := LString;
    END (* IF ItemFocused *);
  END (* WITH *);
end;

procedure TStringDialog.FormShow(Sender: TObject);
VAR LString:    String;
begin
  WITH ListViewStringDialog DO BEGIN
    ItemFocused := Items.Item [0];
    IF ItemFocused <> NIL THEN BEGIN
      LString := ItemFocused.Caption;
      EditStringDialog.Text := LString;
//      FAuswahl := LString;
    END (* IF ItemFocused *);
  END (* WITH *);
end;

procedure TStringDialog.ListViewStringDialogChange(Sender: TObject;
  Item: TListItem; Change: TItemChange);
VAR LString:    String;
begin
  IF Change = ctState THEN
    WITH ListViewStringDialog DO BEGIN
      IF ItemFocused <> NIL THEN BEGIN
        LString := ItemFocused.Caption;
        EditStringDialog.Text := LString;
//        FAuswahl := LString;
      END (* IF ItemFocused *);
    END (* WITH *);
end;

procedure TStringDialog.ListViewStringDialogDblClick(Sender: TObject);
begin
  ListViewStringDialogClick (Sender);
  modalresult := mrOk;
end;

procedure TStringDialog.Speichern1Click(Sender: TObject);
VAR mr:    TModalResult;
begin
  WITH
    TDateiManagerForm.ECreate (Self, FALSE, TRUE,
                               Caption + ' speichern', 'Liste speichern',
                               Dateivorwahl, ExtractFileExt (Dateivorwahl) {'*.HIS'}, 0,
                               FALSE, FALSE, TRUE, TRUE) DO BEGIN
    mr := ShowModal;
    IF mr = mrOk THEN BEGIN
      DateiSpeichern (Dateiauswahl);
    END (* IF mrOk *);
    LRFrame.warte (300);
    Release;
  END (* WITH TDateiManagerForm *);
end (* Speichern1Click *);

procedure TStringDialog.ButtonStringLoeschenClick(Sender: TObject);
VAR ListItem: TListItem;
begin
  ListItem := ListViewStringDialog.FindCaption (0, EditStringDialog.Text,
                                                FALSE, TRUE, FALSE);
  IF ListItem <> NIL THEN BEGIN
    WITH ListViewStringDialog DO BEGIN
      Items.Delete (Items.IndexOf (ListItem));
    END (* WITH *);
  END (* IF *);
end;

procedure TStringDialog.ButtonStringeinfuegenClick(Sender: TObject);
VAR ListItem: TListItem;
begin
  WITH ListViewStringDialog DO BEGIN
    IF FindCaption (0, EditStringDialog.Text, FALSE, TRUE, FALSE) = NIL THEN BEGIN
      ListItem := Items.Add;
      ListItem.Caption := EditStringDialog.Text;
    END (* IF *);
  END (* WITH *);
end;

procedure TStringDialog.ButtonStringsSortierenClick(Sender: TObject);
begin
  ListViewStringDialog.SortType := stText;
end;

procedure TStringDialog.ButtonOkClick(Sender: TObject);
begin
  StringListMachen (FListe);
end;

procedure TStringDialog.Schlieen1Click(Sender: TObject);
begin
  Close;
end;

procedure TStringDialog.Abbrechen1Click(Sender: TObject);
begin
  Close;
end;

procedure TStringDialog.ButtonUebernehmenClick(Sender: TObject);
begin
  StringListMachen (FListe);
end;

procedure TStringDialog.FormCreate(Sender: TObject);
VAR  myIcon:               TBitmap; //TIcon;
begin
  IF FileExists (ExtractFilePath (Application.Exename) + 'buch.bmp') THEN BEGIN
    myIcon := TBitmap.Create;
    myIcon.LoadFromFile (ExtractFilePath (Application.Exename) + 'buch.bmp');
    ImageListStrings.Add (myIcon, NIL);
  END (* IF *);
end;

procedure TStringDialog.ElementandenAnfang1Click(Sender: TObject);
VAR ListItem: String;
    h:        TListItem;
begin
  WITH ListViewStringDialog, Items DO BEGIN
    IF Selected <> NIL THEN BEGIN
      ListItem := Selected.Caption;
      Delete (IndexOf (Selected));
      h := Insert (0);
      h.Caption := ListItem;
      h.Selected := TRUE; h.Focused := TRUE;
      h.MakeVisible (TRUE);
    END (* IF *);
  END (* WITH *);
end;

procedure TStringDialog.N3Click(Sender: TObject);
VAR ListItem: String;
    h:        TListItem;
begin
  WITH ListViewStringDialog, Items DO BEGIN
    IF Selected <> NIL THEN BEGIN
      ListItem := Selected.Caption;
      Delete (IndexOf (Selected));
      h := Add;
      h.Caption := ListItem;
      h.Selected := TRUE; h.Focused := TRUE;
      h.MakeVisible (TRUE);
    END (* IF *);
  END (* WITH *);
end;

procedure TStringDialog.Elementeinsnachoben1Click(Sender: TObject);
VAR ListItem: String;
    h:        TListItem;
    Index:    Integer;
begin
  WITH ListViewStringDialog, Items DO BEGIN
    IF Selected <> NIL THEN BEGIN
      ListItem := Selected.Caption;
      Index := IndexOf (Selected);
      IF Index > 0 THEN DEC (Index);
      Delete (IndexOf (Selected));
      h := Insert (Index);
      h.Caption := ListItem;
      h.Selected := TRUE; h.Focused := TRUE;
      h.MakeVisible (TRUE);
    END (* IF *);
  END (* WITH *);
end;

procedure TStringDialog.Elementeinsnachunten1Click(Sender: TObject);
VAR ListItem: String;
    h:        TListItem;
    Index:    Integer;
begin
  WITH ListViewStringDialog, Items DO BEGIN
    IF Selected <> NIL THEN BEGIN
      ListItem := Selected.Caption;
      Index := IndexOf (Selected);
      INC (Index);
      Delete (IndexOf (Selected));
      h := Insert (Index);
      h.Caption := ListItem;
      h.Selected := TRUE; h.Focused := TRUE;
      h.MakeVisible (TRUE);
    END (* IF *);
  END (* WITH *);
end;

end.
