unit ct_ogl;

interface
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, OpenGL;

type
  TOpenGL_box = class(TForm)
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private { Private-Deklarationen }
    DC: HDC;
    hrc: HGLRC;
    Palette: HPALETTE;
    procedure SetDCPixelFormat;
    procedure InitializeLight;
    procedure InitializeMaterial;
    procedure Buildlist_Wuerfel;
    procedure Build_Texture(var List_n:GLint;BMP_name:string);
    procedure DrawScene;
  protected
    procedure WMPaint(var Msg: TWMPaint); message WM_PAINT;
  public
    { Public-Deklarationen }
  end;

{$A-}
type
  BMPheader=record
    FileType:word;             {immer MB}
    Size:longint;              {Gre der BMP-Datei in Bytes}
    Reserved1, Reserved2:word; {reserviert}
    Offset:longint;            {Offset der Imagedaten in Bytes}
  end;

  BMPInfoHeader=record
    Size:longint;         {Lnge von BMPinfo in Bytes}
    Width:longint;        {Breite vom Image in Pixel}
    Height:longint;       {Hhe vom Image in Pixel}
    Planes:word;          {Anzahl der Planes (immer 1)}
    Colorbits:word;       {Bits fr Colorinformationen pro Pixel}
    Compression:longint;  {Comprimierung}
    ImageSize:longint;    {Imagegre in Bytes}
    XpixPerMeter:longint; {Pixels pro Meter in X}
    YpixPerMeter:longint; {Pixels pro Meter in Y}
    ColorUsed:longint;    {Anzahl der Farben}
    Important:longint;    {Anzahl der "important" Farben}
  end;
{$A+}

var
  OpenGL_box: TOpenGL_box;
  gldAspect : GLdouble;
  Const_Max_Texture_Size,Wuerfel,Texture_1,Texture_2,Shademode:GLint;
  Zoom,Alpha: GLfloat;
  Const_gl_Version,BMP_name:string;
  Matrix: Array[0..15] of GLfloat;
  Axis:Array [0..2] of GLfloat;
  Background:boolean;

implementation
{$R *.DFM}

procedure TOpenGL_box.FormCreate(Sender: TObject);
const glfLightModelAmbient: Array[0..3] of GLfloat =(0.2,0.2,0.2,1.0);
begin
  Shademode:=1; Zoom:=2.5; Background:=true;
// *** Erzeugen des Rendering Kontext (RC)
  DC:= GetDC(Handle);
  SetDCPixelFormat;
  hrc:= wglCreateContext(DC);
  wglMakeCurrent(DC, hrc);
// *** Abfragen der OpenGL-Impelmentierung
  Const_gl_Version:= glGetString(GL_VERSION);
  glGetIntegerv(GL_MAX_TEXTURE_SIZE, @const_MAX_TEXTURE_SIZE);
  glEnable(GL_DEPTH_TEST);               // Einschalten depth testing
//  glEnable(GL_CULL_FACE);           // Einschalten backface culling
// *** Initialisieren verschiedener Variablen
  glMatrixMode(GL_MODELVIEW);                       // Modelviewmatix
  glLoadIdentity;
  glRotatef(45,1,0,0);
  glRotatef(30,0,-1,0);
  glGetFloatv(GL_MODELVIEW_MATRIX, @Matrix);
// *** Lichtquelle und Material initialisieren
  glEnable(GL_LIGHTING);
  glEnable(GL_COLOR_MATERIAL);
  glLightModeli(GL_LIGHT_MODEL_LOCAL_VIEWER, 0);
  glLightModeli(GL_LIGHT_MODEL_TWO_SIDE, 1);
  glLightModelfv(GL_LIGHT_MODEL_AMBIENT, @glfLightModelAmbient);
  InitializeLight;
  InitializeMaterial;
  gldAspect := ClientWidth/ClientHeight;
  Build_texture(Texture_1, 'texture.bmp');    // Displaylist erzeugen
  Build_texture(Texture_2, 'back.bmp');
  BuildList_Wuerfel;
  DrawScene;                                    // zeichnen der Scene
end;

procedure TOpenGL_box.SetDCPixelFormat;
var    hHeap: THandle;
  nColors, i: Integer;
  lpPalette : PLogPalette;
  byRedMask, byGreenMask, byBlueMask: Byte;
  nPixelFormat: Integer;
  pfd: TPixelFormatDescriptor;
begin
  FillChar(pfd, SizeOf(pfd), 0);
  with pfd do begin
    nSize     := sizeof(pfd);               // Lnge der pfd-Struktur
    nVersion  := 1;                         // Version
    dwFlags   := PFD_DRAW_TO_WINDOW or PFD_SUPPORT_OPENGL or
                 PFD_DOUBLEBUFFER;          // Flags
    iPixelType:= PFD_TYPE_RGBA;             // RGBA Pixel Type
    cColorBits:= 24;                        // 24-bit color
    cDepthBits:= 32;                        // 32-bit depth buffer
    iLayerType:= PFD_MAIN_PLANE;            // Layer Type
  end;
  nPixelFormat:= ChoosePixelFormat(DC, @pfd);
  SetPixelFormat(DC, nPixelFormat, @pfd);
// *** Palettenoptimierung wenn erforderlich
  DescribePixelFormat(DC, nPixelFormat,
                      sizeof(TPixelFormatDescriptor),pfd);
  if ((pfd.dwFlags and PFD_NEED_PALETTE) <> 0) then begin
    nColors  := 1 shl pfd.cColorBits;
    hHeap    := GetProcessHeap;
    lpPalette:= HeapAlloc
       (hHeap,0,sizeof(TLogPalette)+(nColors*sizeof(TPaletteEntry)));
    lpPalette^.palVersion := $300;
    lpPalette^.palNumEntries := nColors;
    byRedMask  := (1 shl pfd.cRedBits) - 1;
    byGreenMask:= (1 shl pfd.cGreenBits) - 1;
    byBlueMask := (1 shl pfd.cBlueBits) - 1;
    for i := 0 to nColors - 1 do begin
      lpPalette^.palPalEntry[i].peRed  :=
        (((i shr pfd.cRedShift)  and byRedMask)  *255)DIV byRedMask;
      lpPalette^.palPalEntry[i].peGreen:=
        (((i shr pfd.cGreenShift)and byGreenMask)*255)DIV byGreenMask;
      lpPalette^.palPalEntry[i].peBlue :=
        (((i shr pfd.cBlueShift) and byBlueMask) *255)DIV byBlueMask;
      lpPalette^.palPalEntry[i].peFlags:= 0;
    end;
    Palette:= CreatePalette(lpPalette^);
    HeapFree(hHeap, 0, lpPalette);
    if (Palette <> 0) then begin
      SelectPalette(DC, Palette, False);
      RealizePalette(DC);
    end;
  end;
end;

procedure TOpenGL_box.InitializeLight;
const
  glfLightAmbient  : Array[0..3] of GLfloat = (0.3, 0.3, 0.3, 1.0);
  glfLightDiffuse  : Array[0..3] of GLfloat = (0.7, 0.7, 0.7, 1.0);
  glfLightSpecular : Array[0..3] of GLfloat = (0.8, 0.8, 0.8, 1.0);
  glfLight0Position: Array[0..3] of GLfloat = (0.0, 0.0, 3.0, 0.0);
begin
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity;
  glEnable(GL_LIGHT0);
  glLightfv(GL_LIGHT0, GL_POSITION ,@glfLight0Position);
  glLightfv(GL_LIGHT0, GL_AMBIENT,  @glfLightAmbient);
  glLightfv(GL_LIGHT0, GL_DIFFUSE,  @glfLightDiffuse);
  glLightfv(GL_LIGHT0, GL_SPECULAR, @glfLightSpecular);
end;

procedure TOpenGL_box.InitializeMaterial;
const
  glfMatrialAmbient : Array[0..3] of GLfloat = (0.5, 0.5, 0.5, 1.0);
  glfMatrialDiffuse : Array[0..3] of GLfloat = (0.5, 0.5, 0.5, 1.0);
  glfMatrialSpecular: Array[0..3] of GLfloat = (0.7, 0.7, 0.7, 1.0);
  glfMatrialShine:  GLfloat = 90;
begin
  glMaterialfv(GL_FRONT, GL_AMBIENT,   @glfMatrialAmbient);
  glMaterialfv(GL_FRONT, GL_DIFFUSE,   @glfMatrialDiffuse);
  glMaterialfv(GL_FRONT, GL_SPECULAR,  @glfMatrialSpecular);
  glMaterialf (GL_FRONT, GL_SHININESS, glfMatrialShine);
end;

procedure TOpenGl_Box.Build_Texture(var List_n:GLint;BMP_name:string);
var Size:GLint;
    X:longint;
    BMP_file:file;
    BMP_Info:BMPInfoHeader;
    BMP_header:BMPheader;
    BMP_buffer,BMP_buffer4:pointer;
    R,G,B:GLubyte;
    pbuffer,pbuffer4:^GLubyte;
begin
// *** Einlesen des Texture Bitmaps
  AssignFile(BMP_file, BMP_name);
  Reset(BMP_file, 1);
  BlockRead(BMP_file,BMP_header ,SizeOf(BMP_header));
  BlockRead(BMP_file,BMP_info, SizeOf(BMP_info));
  Size:=BMP_header.Size- SizeOf(BMP_header)- SizeOf(BMP_info);
  GetMem(BMP_buffer, Size);
  GetMem(BMP_buffer4, Size*4 div 3);
  BlockRead(BMP_file, BMP_buffer^, Size);
  CloseFile(BMP_file);
// *** convertierung von RGB-Image in RGBA-Image
  pbuffer:= BMP_buffer;
  pbuffer4:= BMP_buffer4;
  for X:=1 to (Size div 3) do begin
    B:= pbuffer^; inc(pbuffer);
    G:= pbuffer^; inc(pbuffer);
    R:= pbuffer^; inc(pbuffer);
    pbuffer4^:= R; inc(pbuffer4);
    pbuffer4^:= G; inc(pbuffer4);
    pbuffer4^:= B; inc(pbuffer4);
    pbuffer4^:= 255; inc(pbuffer4);                      // Alpha=255
  end;
  list_n:= glGenLists(1);              // Erzeugung einer Displaylist
  glNewList (List_n, GL_COMPILE);
    glPixelStorei(GL_UNPACK_ALIGNMENT, 4);
    glPixelStorei(GL_UNPACK_ROW_LENGTH, 0);
    glPixelStorei(GL_UNPACK_SKIP_ROWS, 0);
    glPixelStorei(GL_UNPACK_SKIP_PIXELS, 0);
    glTexImage2D(GL_TEXTURE_2D,0,4,BMP_Info.Width,BMP_Info.Height,0,
                 GL_RGBA,GL_UNSIGNED_BYTE,BMP_buffer4);
  glEndList;
  FreeMem(BMP_buffer);
  FreeMem(BMP_buffer4);
end;

procedure TOpenGl_Box.Buildlist_Wuerfel;
begin
  glColorMaterial(GL_BACK, GL_AMBIENT_AND_DIFFUSE);
  glColor3f(1, 0, 0);                   // Farbe der Rckseiten : rot
  glColorMaterial(GL_FRONT,GL_AMBIENT_AND_DIFFUSE);
  Wuerfel:=glGenLists(1);                // Erzeugung der Displaylist
  glNewList(Wuerfel, GL_COMPILE);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
  glTexEnvi(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_DECAL);
  glCallList(Texture_1);
    glEnable(GL_TEXTURE_2D);
    glBegin(GL_POLYGON);                     // 1. Flche mit Texture
      glColor3f(1, 1, 1);
      glNormal3f(0.0, 0.0, 1.0);
      glTexCoord2f(1.0 ,0.0); glVertex3f(-1.0, -1.0, 1.0);
      glTexCoord2f(1.0, 1.0); glVertex3f( 1.0, -1.0, 1.0);
      glTexCoord2f(0.0, 1.0); glVertex3f( 1.0,  1.0, 1.0);
      glTexCoord2f(0.0, 0.0); glVertex3f(-1.0,  1.0, 1.0);
    glEnd;
    gldisable(GL_TEXTURE_2D);
    glBegin(GL_POLYGON);                     // 2. Flche, Farbe wei
      glColor3f(1, 1, 1);
      glNormal3f( 0.0,  0.0, -1.0);
      glVertex3f( 1.0,  1.0, -1.0);
      glVertex3f( 1.0, -1.0, -1.0);
      glVertex3f(-1.0, -1.0, -1.0);
      glVertex3f(-1.0,  1.0, -1.0);
    glEnd;
    glColor3f(1, 1 ,0);
    glBegin(GL_POLYGON);
      glNormal3f( 0.0, -1.0,  0.0);
      glVertex3f(-1.0, -1.0, -1.0);
      glVertex3f( 1.0, -1.0, -1.0);
      glVertex3f( 1.0, -1.0,  1.0);
      glVertex3f(-1.0, -1.0,  1.0);
    glEnd;
    glColor3f(0,1,0);
    glBegin(GL_POLYGON);
      glNormal3f(1.0,  0.0,  0.0);
      glVertex3f(1.0,  1.0,  1.0);
      glVertex3f(1.0, -1.0,  1.0);
      glVertex3f(1.0, -1.0, -1.0);
      glVertex3f(1.0,  1.0, -1.0);
    glEnd;
    glColor3f(1,0,1);
    glBegin(GL_POLYGON);
      glNormal3f( 0.0, 1.0,  0.0);
      glVertex3f(-1.0, 1.0, -1.0);
      glVertex3f(-1.0, 1.0,  1.0);
      glVertex3f( 1.0, 1.0,  1.0);
      glVertex3f( 1.0, 1.0, -1.0);
    glEnd;
    glBegin(GL_TRIANGLES);            // 1 Polygon als 2 GL_TRIANGLES
      glColor3f(0,0,1);
      glNormal3f(-1.0,  0.0,  0.0);
      glVertex3f(-1.0,  1.0,  1.0);
      glVertex3f(-1.0,  1.0, -1.0);
      glVertex3f(-1.0, -1.0, -1.0);
      glVertex3f(-1.0,  1.0,  1.0);
      glVertex3f(-1.0, -1.0, -1.0);
      glVertex3f(-1.0, -1.0,  1.0);
    glEnd;
  glEndList ();
end;

procedure TOpenGl_Box.DrawScene;
const Clip_Data: Array[0..3] of GLdouble= (0.0, -1, 0.0, 0.5);
begin
  glClearColor(0, 0, 0.25, 1);                     // HintergundFarbe
  glClear(GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT);
  glMatrixMode(GL_PROJECTION);                   // Projekton whlen
  glLoadIdentity;
  glOrtho(-Zoom, Zoom, -Zoom/gldAspect, Zoom/gldAspect, -20, 20);
  glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
  glMatrixMode(GL_MODELVIEW);                   // Rotation berechnen
  glLoadIdentity;                              // Einheitsmatix laden
  glDisable(GL_CLIP_PLANE0);
  if Background then begin                       // Hintergund Bitmap
    glCallList(Texture_2);
    glEnable(GL_TEXTURE_2D);
    glBegin(GL_QUADS);
      glTexCoord2f(0,0);glVertex3f(-Zoom, -Zoom/gldAspect, -10);
      glTexCoord2f(1,0);glVertex3f( Zoom, -Zoom/gldAspect, -10);
      glTexCoord2f(1,1);glVertex3f( Zoom,  Zoom/gldAspect, -10);
      glTexCoord2f(0,1);glVertex3f(-Zoom,  Zoom/gldAspect, -10);
    glEnd;
    glDisable(GL_TEXTURE_2D);
  end
  else begin
    glEnable(GL_BLEND);                    // Farbabstufung mit Blend
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    glBegin(GL_QUADS);                           // Rechteck zeichnen
      glColor4f(1.0, 1.0, 1.0, 0.0);
      glNormal3f(0.0, 0.0, 1.0);
      glVertex3f(-Zoom, -Zoom/gldAspect, -10);
      glVertex3f( Zoom, -Zoom/gldAspect, -10);
      glColor4f(1.0, 1.0, 1.0, 1.0);
      glVertex3f( Zoom,  Zoom/gldAspect, -10);
      glVertex3f(-Zoom,  Zoom/gldAspect, -10);
    glEnd;
    glDisable(GL_BLEND);
  end;
  glRotatef(Alpha, Axis[0], Axis[1], Axis[2]);  // drehen der Objekte
  Alpha:=0;                                  // Rcksetzen vom Winkel
  glMultMatrixf(@Matrix );     // zustzliche Drehung mit letzem Wert
  glGetFloatv(GL_MODELVIEW_MATRIX, @Matrix);      // Rotation sichern
  glLoadIdentity;                       //        Einheitsmatix Laden
  glTranslatef(0.5, 0.0, 0.0);          // bewegen um 0.5 nach rechts
  glMultMatrixf(@Matrix );              //   Multiplikation mit Matix
  glClipPlane(GL_CLIP_PLANE0, @Clip_Data);    // Clipplane definieren
  glEnable(GL_CLIP_PLANE0);
  case Shademode of                 // Darstellungsmodus der Polygone
    1:GlPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
    2:GlPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
    3:GlPolygonMode(GL_FRONT_AND_BACK, GL_POINT);
  end;
  glCallList(Wuerfel);                      // Aufruf der Displaylist
  if GLGetError <> GL_NO_ERROR then                  // Fehlerprfung
    MessageDlg('Error in OpenGL scene gefunden!', mtError, [mbOk], 0);
  SwapBuffers(DC);                                 // Sichtbar machen
end;

procedure TOpenGl_box.WMPaint(var Msg: TWMPaint);
var  ps : TPaintStruct;
begin
  BeginPaint(Handle, ps);
  DrawScene;
  EndPaint(Handle, ps);
end;

procedure TOpenGL_box.FormResize(Sender: TObject);
begin
// ***Aktualisierung des Viewports, wenn sich die Fenstergre ndert
  if ClientWidth  < 100 then ClientWidth :=100;            // min:100
  if ClientHeight < 100 then ClientHeight:=100;            // min:100
  gldAspect := ClientWidth / ClientHeight;
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity;
  gLOrtho(-Zoom, Zoom, -Zoom/gldAspect, Zoom/gldAspect, -20, 20);
  glViewport(0, 0, ClientWidth,ClientHeight);//Viewport Transformation
  InvalidateRect(Handle, nil, False);        // Neuzeichnen anfordern
end;

procedure TOpenGL_box.FormDestroy(Sender: TObject);
begin
// *** Lschen des rendering context (RC)
  glDeleteLists(Texture_1,1);
  glDeleteLists(Texture_2,1);
  glDeleteLists(Wuerfel,1);
  wglMakeCurrent(0, 0);
  wglDeleteContext(hrc);
  ReleaseDC(Handle, DC);
  if (Palette <> 0) then DeleteObject(Palette);
end;

procedure TOpenGL_box.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  case Key of
  27: Close;              // ESC zum Beenden
  109,189: begin          // "-" verkeinern
             Zoom:=Zoom + 0.5;
             InvalidateRect(Handle, nil, False);
           end;
  107,187: begin          // "+" vergrern
             if Zoom > 0.5 then Zoom:= Zoom - 0.5;
             InvalidateRect(Handle, nil, False);
           end;
  66 :begin               // "b" - Hintergund texture EIN /AUS
        Background:= not(Background);
        InvalidateRect(Handle, nil, False);  // Neuzeichnen anfordern
      end;
  83: begin               // "s" - Darstellungsmodus umschalten
        Inc(ShadeMode);
        if ShadeMode= 4 then ShadeMode:= 1;
        InvalidateRect(Handle, nil, False);  // Neuzeichnen anfordern
      end;
// *** drehen duch Cursortasten steuern
  37: begin               // *** drehen nach links
        Alpha:= -15; Axis[0]:= 0; Axis[1]:= 1; Axis[2]:= 0;
        InvalidateRect(Handle, nil, False);  // Neuzeichnen anfordern
      end;
  38: begin                // *** drehen nach oben
        Alpha:= -15; Axis[0]:= 1; Axis[1]:= 0; Axis[2]:= 0;
        InvalidateRect(Handle, nil, False);  // Neuzeichnen anfordern
      end;
  39: begin               // *** drehen nach rechts
        Alpha:= 15; Axis[0]:= 0; Axis[1]:= 1; Axis[2]:= 0;
        InvalidateRect(Handle, nil, False);  // Neuzeichnen anfordern
      end;
  40: begin               // *** drehen nach unten
        Alpha:= 15; Axis[0]:= 1; Axis[1]:= 0; Axis[2]:= 0;
        InvalidateRect(Handle, nil, False);  // Neuzeichnen anfordern
      end;
  end;
end;

end.
