// Begonnen: April 99
// Stand: 22. 10. 99
// Version: 0.22

//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#include <values.h>
#include <math.h>
#include <stddef.h>
#include <stdio.h>
#include <stdlib.h>
#pragma hdrstop

#include "SysUtils.hpp"
#include "CLRFrame.h"
#include "CLREdit.h"
#include "GlobalEinstellungen.h"
#include "StringForm.h"
#include "Bild.h"
#include "jpeg.hpp"
//#include "gifimage.hpp"
//#include "PLL_path.h"
#include "WinExc32.hpp"
#include "ShellApi.hpp"
//#include "MyFmxutils.hpp"
//#include "PllMenu.h"
//---------------------------------------------------------------------------
#pragma resource "*.dfm"
TFrameForm *FrameForm;

//---------------------------------------------------------------------------
void __fastcall TFrameForm::AppMessageHandler (tagMSG &Msg, bool &Handled)
{
  if (Msg.message == WM_KEYDOWN) {
    lastKey = Msg.wParam;
    lastKeyData = Msg.lParam;
  }
  Handled = false;
}
//---------------------------------------------------------------------------
__fastcall TFrameForm::TFrameForm(TComponent* Owner)
	: TForm(Owner)
{
  Application->OnHint = DisplayHint;
//  Application->OnMessage = AppMessageHandler;
//  Application->OnIdle = IdleHandler;
}
//---------------------------------------------------------------------------
int __stdcall EnumFontsProc (TLogFontA &LogFont, TTextMetricA &/*TextMetric*/,
							 int /*FontType*/, Pointer Data)
{
  ((TStrings *)Data)->Add((AnsiString)LogFont.lfFaceName);
  return 1;
} // EnumFontsProc
//---------------------------------------------------------------------------
void __fastcall TFrameForm::GetFontNames (void){
  if (Konfig.UseFontfilter){
    FrameForm->IniFile->ReadSection ("Fontfilter", FontName->Items);
  }
  else {
    HDC hDC = GetDC (0);
    void * cTmp = (void *)FontName->Items;
    EnumFonts (hDC, NULL, (FONTENUMPROC) EnumFontsProc, (long) cTmp);
    ReleaseDC (0, hDC);
  }
  FontName->Sorted = TRUE;
}
//---------------------------------------------------------------------------
void __fastcall TFrameForm::DisplayHint (TObject *Sender){
  StatusBar1->Panels->Items [0]->Text = Application->Hint;
}
//---------------------------------------------------------------------------
int __fastcall TFrameForm::GetTextHeight (AnsiString header)
{
// create a compatible DC -- do not need a bitmap
  HDC hdc = ::CreateCompatibleDC (Printer()->Handle);
  ::SaveDC (hdc);
// create a big rect for bounds

  LOGFONT logfont;
  int bufsize = GetObject (FrameForm->DefaultFont->Handle, 0, &logfont);
  SelectObject (hdc, &logfont);
//  SelectObject (hdc, FrameForm->DefaultFont->Handle);
  SetMapMode (hdc, MM_TEXT);
//  SetMapMode (hdc, MM_LOMETRIC);

  RECT rect = {0x0000, 0x0000, 0x7fff, 0x7fff};

  DRAWTEXTPARAMS DrawTextParams;

  DrawTextParams.cbSize = sizeof (DRAWTEXTPARAMS);
  DrawTextParams.iTabLength = 8;
  DrawTextParams.iLeftMargin = 0;
  DrawTextParams.iRightMargin = 0;
  DrawTextParams.uiLengthDrawn = 0;

  int height;

  height = DrawTextEx (hdc, header.c_str(), header.Length(), &rect,
                       DT_CALCRECT + DT_EXTERNALLEADING,
                       &DrawTextParams);
  ::RestoreDC (hdc, -1);
  ::DeleteDC (hdc);
  return height;
}
//---------------------------------------------------------------------------
void __fastcall TFrameForm::IdleHandler (TObject *Sender, bool &done)
{
  if (doIdle) {
    ShowMessage ("Idle");
    doIdle = false;
  }
}
//---------------------------------------------------------------------------
void __fastcall TFrameForm::CloseProgram1Click(TObject *Sender)
{
  Close (); // Rahmenfenster schlieen
}
//---------------------------------------------------------------------------
void __fastcall TFrameForm::New1Click(TObject *Sender)
{
  Application->CreateForm (__classid (TEditForm), &EditForm);
 // untergeordnetes Formular erzeugen und anzeigen
}
//---------------------------------------------------------------------------
void __fastcall TFrameForm::Open1Click(TObject *Sender)
{
//ShowMessage ("Oeffnen: " + DateiFilter);

  if (DateiFilter != "") DateiOeffnenDialog->Filter = DateiFilter;
// Ups - geht nicht:
  DateiOeffnenDialog->HistoryList = FrameForm->HistoryListe;
/*  TEditForm *EdForm;
  if (EdForm = dynamic_cast <TEditForm *> (ActiveMDIChild)){
    DateiOeffnenDialog->InitialDir = ExtractFileDir (EdForm->Pfad);
  }
  else
    DateiOeffnenDialog->InitialDir = ExtractFileDir (Application->ExeName);
*/
  DateiOeffnenDialog->InitialDir = GetCurrentDir ();
  if (DateiOeffnenDialog->Execute()) {
    if (nichtNochmalLaden (DateiOeffnenDialog->FileName)) return;
    if (istGrafikdatei (DateiOeffnenDialog->FileName)) {
      Application->CreateForm (__classid (TBildForm), &BildForm);
      BildForm->Image1->Picture->LoadFromFile (DateiOeffnenDialog->FileName);
      BildForm->Caption = DateiOeffnenDialog->FileName;
    }
    else {
      EditForm = new TEditForm (this);
      EditForm->Oeffnen (DateiOeffnenDialog->FileName);
    }
  }

//  TDateiManagerForm* DateiManagerForm;
/*
__fastcall TDateiManagerForm(Classes::TComponent* AOwner, bool SelfDestroy, bool doModal, AnsiString
        sCaption, AnsiString sButton, AnsiString sFile, AnsiString sFilter, int iDateifilter, bool bLadenEnable
        , bool bLadenDefault, bool bSpeicherEnable, bool bSpeicherDefault, Classes::TStringList* HistoryL,
        Classes::TStringList* FavouriteL, AnsiString Dateif, int DateiFilterI, int MaxFav);
*/
/*
  DateiManagerForm = new TDateiManagerForm (this, false, true,
    "Textdatei laden", "In Textfenster laden", "", "",
    Konfig.DateiFilterIndex,
    true, true, false, false,
    HistoryListe, FavouriteListe, DateiFilter, Konfig.MaxFavorite);
*/
}
//---------------------------------------------------------------------------
void __fastcall TFrameForm::Tiled1Click(TObject *Sender)
{
  Tile (); // offene, untergeordnete Fenster nebeneinander anordnen
}
//---------------------------------------------------------------------------
void __fastcall TFrameForm::Overlap1Click(TObject *Sender)
{
  Cascade (); // offene, untergeordnete Fenster berlappend anordnen
}
//---------------------------------------------------------------------------
void __fastcall TFrameForm::Symboleanordnen1Click(TObject *Sender)
{
  ArrangeIcons (); // Symbole aller untergeordneten Fenster anordnen
}
//---------------------------------------------------------------------------
void __fastcall TFrameForm::AlleSchliessen ()
{
  int i;
  TEditForm *EdForm;
  TBildForm *BildForm;
  for (i=0; i <= MDIChildCount - 1; i++){
    if (EdForm = dynamic_cast <TEditForm*> (MDIChildren [i])){
      EdForm->Close2Click (MDIChildren [0]);
    } // if
    else
    if (BildForm = dynamic_cast <TBildForm*> (MDIChildren [i])){
      BildForm->Close();
    } // else
  } // for
}
//---------------------------------------------------------------------------
void __fastcall TFrameForm::AlleSpeichern(TObject *Sender)
{
  int i;
  TEditForm *EdForm;
  TBildForm *BildForm;
  for (i=0; i <= FrameForm->MDIChildCount - 1; i++){
    if (EdForm = dynamic_cast <TEditForm*> (FrameForm->MDIChildren [i])){
      EdForm->Save1Click (Sender);
    } // if
  } // for
}
//---------------------------------------------------------------------------
TForm* __fastcall TFrameForm::findePfadnamen (AnsiString pn)
{
  int i = 0;
  TForm *result = NULL;
  while (i < MDIChildCount){
    TEditForm *EdForm = dynamic_cast <TEditForm*> (MDIChildren [i]);
    if (EdForm && (AnsiUpperCase (pn) == AnsiUpperCase (EdForm->Pfad))){
      result = this->MDIChildren [i]; break;
    }
    i++;
  }
  return result;
} // findePfadnamen
//---------------------------------------------------------------------------
bool __fastcall TFrameForm::nichtNochmalLaden (AnsiString pn)
{
  bool result = false;
  if (Konfig.KeineDuplikateLaden) {
    TMsgDlgButtons buttons;
    buttons << mbYes << mbNo;
    result = ((findePfadnamen (pn) != NULL) &&
      (MessageDlg ("Warnung! Datei '" + pn + "' ist schon vorhanden. Nochmal laden?",
        mtWarning, buttons, 0) != mrYes));
  };
  return result;
} // nichtNochmalLaden
//---------------------------------------------------------------------------
bool __fastcall TFrameForm::istGrafikdatei (AnsiString fn)
{
  return
    (AnsiUpperCase (ExtractFileExt (fn)) == ".JPG") ||
    (AnsiUpperCase (ExtractFileExt (fn)) == ".JPEG") ||
    (AnsiUpperCase (ExtractFileExt (fn)) == ".GIF") ||
    (AnsiUpperCase (ExtractFileExt (fn)) == ".BMP") ||
    (AnsiUpperCase (ExtractFileExt (fn)) == ".ICO") ||
    (AnsiUpperCase (ExtractFileExt (fn)) == ".EMF") ||
    (AnsiUpperCase (ExtractFileExt (fn)) == ".WMF");
} // istGrafikdatei
//---------------------------------------------------------------------------
void __fastcall TFrameForm::Portstesten1Click(TObject *Sender)
{
/*  Application->CreateForm (__classid (TPortDialog), &PortDialog);
  PortDialog->Show (); // untergeordnetes Formular erzeugen und anzeigen
*/
}
//---------------------------------------------------------------------------
void __fastcall TFrameForm::ReplaceDialog1Find(TObject *Sender)
{
  int i = 0;
  if (ActiveMDIChild == NULL) return;
  TEditForm *EdForm;
  TReplaceDialog *RDialog;
  if (EdForm = dynamic_cast <TEditForm *> (ActiveMDIChild)){
    RDialog = dynamic_cast <TReplaceDialog *> (Sender);
    while (true) {
      if (EdForm->Editor->SelText != RDialog->FindText)
        FindDialog1Find (Sender);
      if (EdForm->Editor->SelLength == 0) break;
      EdForm->Editor->SelText = RDialog->ReplaceText; i++;
      if (!RDialog->Options.Contains (frReplaceAll)) break;
    }
  }
}
//---------------------------------------------------------------------------
void __fastcall TFrameForm::FindDialog1Find(TObject *Sender)
{
  if (ActiveMDIChild == NULL) return;
  TEditForm *EdForm;
  TFindDialog *FDialog;
  int Rslt;
  if (EdForm = dynamic_cast <TEditForm *> (ActiveMDIChild)){
    FDialog = dynamic_cast <TFindDialog *> (Sender);
    TSearchTypes SOptions;
    if (FDialog->Options.Contains (frWholeWord)) SOptions << stWholeWord;
    if (FDialog->Options.Contains (frMatchCase)) SOptions << stMatchCase;
    Rslt = EdForm->Editor->FindText (FDialog->FindText,
    						  EdForm->Editor->SelStart + EdForm->Editor->SelLength,
                              EdForm->Editor->GetTextLen (), SOptions);
    if (Rslt > -1){
      EdForm->Editor->SelStart = Rslt;
      EdForm->Editor->SelLength = FDialog->FindText.Length();
    }
    else {
      EdForm->Editor->SelLength = 0;
      Application->MessageBox (FDialog->FindText.c_str(),
      						   "String nicht gefunden:", MB_OK);
    }
  } // if is TEditForm
}
//---------------------------------------------------------------------------
void __fastcall TFrameForm::LoadMenu (TMenuItem *Menu, AnsiString MenuTitle)
{
  int           itemindex;
  AnsiString    mCaption;
  for (itemindex = 0; itemindex < Menu->Count; itemindex++){
    if (Menu->Items[itemindex]->Caption != "-"){
      mCaption = MenuFile->ReadString (MenuTitle,
        Menu->Items[itemindex]->Name,
        Menu->Items[itemindex]->Caption);
      Menu->Items[itemindex]->Caption = mCaption;
    }
    if (Menu->Items[itemindex]->Count > 0)
      LoadMenu (Menu->Items[itemindex],
                MenuTitle + Menu->Items[itemindex]->Name);
  } // for
}
//---------------------------------------------------------------------------
void __fastcall TFrameForm::SaveMenu (TMenuItem *Menu, AnsiString MenuTitle)
{
  int           itemindex;
  for (itemindex = 0; itemindex < Menu->Count; itemindex++){
    if (Menu->Items[itemindex]->Caption != "-"){
      MenuFile->WriteString (MenuTitle,
        Menu->Items[itemindex]->Name,
        Menu->Items[itemindex]->Caption);
    }
    if (Menu->Items[itemindex]->Count > 0)
      SaveMenu (Menu->Items[itemindex],
                MenuTitle + Menu->Items[itemindex]->Name);
  } // for
}
//---------------------------------------------------------------------------
void __fastcall TFrameForm::doLoadMenu (void)
{
//return;
  if (MainMenu->Items->Count > 0)
    LoadMenu (MainMenu->Items, "MainMenu");
  if (MainPopupMenu->Items->Count > 0)
    LoadMenu (MainPopupMenu->Items, "MainPopupMenu");
}
//---------------------------------------------------------------------------
void __fastcall TFrameForm::doSaveMenu (void)
{
//return;
  if (MainMenu->Items->Count > 0)
    SaveMenu (MainMenu->Items, "MainMenu");
  if (MainPopupMenu->Items->Count > 0)
    SaveMenu (MainPopupMenu->Items, "MainPopupMenu");
/*    if (EditorMainMenu->Items->Count > 0)
      FrameForm->SaveMenu (EditorMainMenu->Items, "EditorMainMenu");
    if (EditorPopupMenu->Items->Count > 0)
      FrameForm->SaveMenu (EditorPopupMenu->Items, "EditorPopupMenu");
*/
}
//---------------------------------------------------------------------------
void __fastcall TFrameForm::doSaveKonfig (void)
{

  try {
//ShowMessage (ChangeFileExt (Application->ExeName, ".HIS"));
    HistoryListe->SaveToFile (ChangeFileExt (Application->ExeName, ".HIS"));
  }
  catch (EFCreateError*)
  {
    ShowMessage ("Kann History-Datei nicht anlegen!");
  }

  if ((ProjektName != "") && (UpperCase (ProjektName) != ExtractFileName (ChangeFileExt (Application->ExeName, ".HIS")))) {
    if (ExtractFilePath (ProjektName) == "")
      ProjektName = ExtractFilePath (Application->ExeName) + ProjektName;
    try {
      ProjektListe->SaveToFile (ProjektName);
    }
    catch (EFCreateError*) {
      ShowMessage ("Kann Projekt-Liste nicht anlegen!");
    }
  }

  try {
    FavouriteListe->SaveToFile (ChangeFileExt (Application->ExeName, ".FAV"));
  }
  catch (EFCreateError*)
  {
    ShowMessage ("Kann Favourite-Datei nicht anlegen");
  }
  try {
    AnwendungsListe->SaveToFile (ChangeFileExt (Application->ExeName, ".ANW"));
  }
  catch (EFCreateError*)
  {
    ShowMessage ("Kann Anwendungs-Datei nicht anlegen");
  }

//  IniFile->WriteBool ("GlobalSettings", "HistoryAnzeigen", Konfig.HistoryAnzeigen);
  IniFile->WriteBool ("GlobalSettings", "AusHistoryLaden", Konfig.AusHistoryLaden);
  IniFile->WriteBool ("GlobalSettings", "SchaltleisteAnzeigen", Konfig.SchaltleisteAnzeigen);
  IniFile->WriteBool ("GlobalSettings", "Schaltleiste2Anzeigen", Konfig.Schaltleiste2Anzeigen);
  IniFile->WriteBool ("GlobalSettings", "MediaLeisteAnzeigen", Konfig.Schaltleiste3Anzeigen);
  IniFile->WriteBool ("GlobalSettings", "LinealAnzeigen", Konfig.LinealAnzeigen);
  IniFile->WriteBool ("GlobalSettings", "ISOAnzeigen", Konfig.ISOAnzeigen);
  IniFile->WriteBool ("GlobalSettings", "WortUmbruch", Konfig.WortUmbruch);
  IniFile->WriteBool ("GlobalSettings", "SaveTextWindow", Konfig.SaveTextWindow);
//  IniFile->WriteBool ("GlobalSettings", "TextModus", Konfig.TextModus);
  IniFile->WriteBool ("GlobalSettings", "BAKErstellen", Konfig.BAKErstellen);
//  IniFile->WriteBool ("GlobalSettings", "TerminalStart", Konfig.TerminalStart);
  IniFile->WriteBool ("GlobalSettings", "StatusLeiste", Konfig.StatusLeiste);
  IniFile->WriteBool ("GlobalSettings", "AutoSaveAbfrage", Konfig.AutoSaveAbfrage);
  IniFile->WriteBool ("GlobalSettings", "Schaltleiste3Anzeigen", Konfig.Schaltleiste3Anzeigen);
  IniFile->WriteBool ("GlobalSettings", "AutoSaveKonfig", Konfig.AutoSaveKonfig);
  IniFile->WriteBool ("GlobalSettings", "NoExplorerTest", Konfig.NoExplorerTest);
  IniFile->WriteBool ("GlobalSettings", "AutoSyntaxHighlight", Konfig.AutoSyntaxHighlight);

  IniFile->WriteBool ("GlobalSettings", "AutoTagAssistant", Konfig.AutoTagAssistant);
  IniFile->WriteBool ("GlobalSettings", "AutoUmlaut", Konfig.AutoUmlaut);
  IniFile->WriteBool ("GlobalSettings", "AutoDateienMerken", Konfig.AutoDateienMerken);
  IniFile->WriteBool ("GlobalSettings", "KeineDuplikateLaden", Konfig.KeineDuplikateLaden);
  IniFile->WriteBool ("GlobalSettings", "IncBackup", Konfig.IncBackup);
  IniFile->WriteBool ("GlobalSettings", "AutoWebfenster", Konfig.AutoWebfenster);
  IniFile->WriteBool ("GlobalSettings", "AutoHomepage", Konfig.AutoHomepage);
  IniFile->WriteBool ("GlobalSettings", "AutoOnline", Konfig.AutoOnline);
  IniFile->WriteBool ("GlobalSettings", "WebMinimiert", Konfig.WebMinimiert);
  IniFile->WriteString ("GlobalSettings", "PrintHeader", Konfig.PrintHeader);
  IniFile->WriteString ("GlobalSettings", "PrintFooter", Konfig.PrintFooter);
  IniFile->WriteBool ("GlobalSettings", "FitPicture", Konfig.FitPicture);
  IniFile->WriteBool ("GlobalSettings", "DontShowShareware", Konfig.DontShowShareware);
  IniFile->WriteBool ("GlobalSettings", "UseFontfilter", Konfig.UseFontfilter);

  IniFile->WriteInteger ("GlobalSettings", "MaxHistory", Konfig.MaxHistory);
  IniFile->WriteInteger ("GlobalSettings", "MaxTextLaenge", Konfig.MaxTextLaenge);
  IniFile->WriteInteger ("GlobalSettings", "ZeichenAufSeite", Konfig.ZeichenAufSeite);
  IniFile->WriteInteger ("GlobalSettings", "MaxFavorite", Konfig.MaxFavorite);
  IniFile->WriteInteger ("GlobalSettings", "saveIntervall", Konfig.saveIntervall);
  IniFile->WriteInteger ("GlobalSettings", "LastHistory", Konfig.LastHistory);
  IniFile->WriteInteger ("GlobalSettings", "DateiFilterIndex", Konfig.DateiFilterIndex);
  IniFile->WriteInteger ("GlobalSettings", "NIncBackup", Konfig.NIncBackup);
  IniFile->WriteInteger ("GlobalSettings", "AnzeigeHistory", Konfig.AnzeigeHistory);
  IniFile->WriteInteger ("GlobalSettings", "BrowserBackup", Konfig.BrowserBackup);
  IniFile->WriteInteger ("GlobalSettings", "LeftMargin", Konfig.LeftMargin);
  IniFile->WriteInteger ("GlobalSettings", "RightMargin", Konfig.RightMargin);
  IniFile->WriteInteger ("GlobalSettings", "TopMargin", Konfig.TopMargin);
  IniFile->WriteInteger ("GlobalSettings", "BottomMargin", Konfig.BottomMargin);
  IniFile->WriteInteger ("GlobalSettings", "HeaderMargin", Konfig.HeaderMargin);
  IniFile->WriteInteger ("GlobalSettings", "FooterMargin", Konfig.FooterMargin);

  IniFile->WriteInteger ("GlobalSettings", "RegCode", Konfig.RegCode);

// ------------- Old SLRE style config files:
/*
  FILE *KonfigFile;
  AnsiString KonfigName;

  KonfigName = ChangeFileExt (Application->ExeName, ".CFS");
  KonfigFile = fopen (KonfigName.c_str(), "wb");
  fwrite (&Konfig, sizeof (TKonfiguration), 1, KonfigFile);
  fclose (KonfigFile);
*/

// old style SLRE winconfig
/*  FILE *WindowFile;
  AnsiString WindowName;
*/
  DefaultWindow.FramePos = Position;
  DefaultWindow.FrameWin = WindowState;
  if ((WindowState != wsMaximized) && (!DefaultWindow.FrameWinDefault)){
    DefaultWindow.FrameLeft = Left; DefaultWindow.FrameTop = Top;
    DefaultWindow.FrameHeight = Height; DefaultWindow.FrameWidth = Width;
  }

  IniFile->WriteBool ("MainWindow", "WinDefault", DefaultWindow.FrameWinDefault);
  IniFile->WriteInteger ("MainWindow", "Position", DefaultWindow.FramePos);
  IniFile->WriteInteger ("MainWindow", "WindowState", DefaultWindow.FrameWin);
  IniFile->WriteInteger ("MainWindow", "Left", DefaultWindow.FrameLeft);
  IniFile->WriteInteger ("MainWindow", "Top", DefaultWindow.FrameTop);
  IniFile->WriteInteger ("MainWindow", "Height", DefaultWindow.FrameHeight);
  IniFile->WriteInteger ("MainWindow", "Width", DefaultWindow.FrameWidth);

  IniFile->WriteBool ("TextWindow", "WinDefault", DefaultWindow.ChildWinDefault);
  IniFile->WriteInteger ("TextWindow", "Position", DefaultWindow.ChildPos);
  IniFile->WriteInteger ("TextWindow", "WindowState", DefaultWindow.ChildWin);
  IniFile->WriteInteger ("TextWindow", "Left", DefaultWindow.ChildLeft);
  IniFile->WriteInteger ("TextWindow", "Top", DefaultWindow.ChildTop);
  IniFile->WriteInteger ("TextWindow", "Height", DefaultWindow.ChildHeight);
  IniFile->WriteInteger ("TextWindow", "Width", DefaultWindow.ChildWidth);
/*
  WindowName = ChangeFileExt (Application->ExeName, ".WIN");
  WindowFile = fopen (WindowName.c_str(), "wb");
  fwrite (&DefaultWindow, sizeof (TWindowEinstellungen), 1, WindowFile);
  fclose (WindowFile);
*/

  // --------------------- DefaultFont -------------------------------
  TFontEinstellungen TextAttr;
  if (DefaultFont != NULL){
    TextAttr.col = FrameForm->DefaultFont->Color;
    TextAttr.Nam = FrameForm->DefaultFont->Name;
    TextAttr.Pit = FrameForm->DefaultFont->Pitch;
    TextAttr.Siz = FrameForm->DefaultFont->Size;
    TextAttr.Styl = FrameForm->DefaultFont->Style;
    TextAttr.Hei = FrameForm->DefaultFont->Height;

    IniFile->WriteString ("DefaultFont", "Comment", "Do not change this manually, use the Font Dialog!");
    IniFile->WriteInteger ("DefaultFont", "Color", TextAttr.col);
    IniFile->WriteString ("DefaultFont", "Name", TextAttr.Nam);
    IniFile->WriteInteger ("DefaultFont", "Pitch", TextAttr.Pit);
    IniFile->WriteInteger ("DefaultFont", "Size", TextAttr.Siz);
    IniFile->WriteBool ("DefaultFont", "fsBold", TextAttr.Styl.Contains (fsBold));
    IniFile->WriteBool ("DefaultFont", "fsItalic", TextAttr.Styl.Contains (fsItalic));
    IniFile->WriteBool ("DefaultFont", "fsUnderline", TextAttr.Styl.Contains (fsUnderline));
    IniFile->WriteBool ("DefaultFont", "fsStrikeout", TextAttr.Styl.Contains (fsStrikeOut));
    IniFile->WriteInteger ("DefaultFont", "Height", TextAttr.Hei);

// ------------------------ Projekte -----------------------------
//    IniFile->WriteString ("Projects", "ActualProject", AllgEinstellDialog->ComboBoxProjekte->Text);
// In GlobalEinstellungen
  }

  // --------------------- DateiFilter -------------------------------
/*ShowMessage ("Schreiben: " + Dateifilter);
  IniFile->WriteString ("Filter", "DateiFilter", DateiFilter);
*/
} // doSaveKonfig

//---------------------------------------------------------------------------
void __fastcall TFrameForm::FontNameChange(TObject *Sender)
{
  if (ActiveMDIChild == NULL) return;
  TEditForm *EdForm;
  if (EdForm = dynamic_cast <TEditForm *> (ActiveMDIChild)){
    if ((FUpdating) /*|| (EdForm->Editor->SelLength == 0)*/) return;
    EdForm->Editor->SelAttributes->Name = FontName->Items->Strings [FontName->ItemIndex];
    EdForm->Editor->Modified = true; EdForm->CursorDaten (Sender);
/*    EdForm->Editor->Hide(); // must do this ...
    EdForm->Editor->Show(); // ... and this ...
    EdForm->Editor->SetFocus(); // and that to get focus back
    // to the text window
*/
// the following does NOT work:
/*    EdForm->BringToFront();
    EdForm->Editor->SetFocus ();
*/
// but this works:
    ::BringWindowToTop (ActiveMDIChild->Handle);
    ::SetFocus (((TEditForm*) ActiveMDIChild)->Editor->Handle);

  } // if EdForm
}
//---------------------------------------------------------------------------
void __fastcall TFrameForm::FontSizeChange(TObject *Sender)
{
  if (ActiveMDIChild == NULL) return;
  TEditForm *EdForm;
  if (EdForm = dynamic_cast <TEditForm *> (ActiveMDIChild)){
//    EdForm->Editor->SelAttributes->Name = FontName->Items->Strings [FontName->ItemIndex];
    int fontsize = atoi (FontSize->Text.c_str());
    if ((!FUpdating) && (fontsize)) {
      if (fontsize < 1) {
        ShowMessage ("The number must be between 1 and 1638.");
        FontSize->Text = 1;
      }
      else if (fontsize > 1638) {
        ShowMessage ("The number must be between 1 and 1638.");
        FontSize->Text = 1638;
      }
      EdForm->Editor->SelAttributes->Size = atoi (FontSize->Text.c_str());
      EdForm->Editor->Modified = true; EdForm->CursorDaten (Sender);
    } // if !FUpdating
  } // if EdForm
}
//---------------------------------------------------------------------------
void __fastcall TFrameForm::SpeedButtonSaveClick(TObject *Sender)
{
  TEditForm *EdForm;
  if (EdForm = dynamic_cast <TEditForm *> (ActiveMDIChild)){
    EdForm->Save1Click (EdForm);
  }
}
//---------------------------------------------------------------------------
void __fastcall TFrameForm::SpeedButtonCloseClick(TObject *Sender)
{
  TEditForm *EdForm;
  TBildForm *BildForm;
  if (EdForm = dynamic_cast <TEditForm *> (ActiveMDIChild)){
    EdForm->Close2Click (EdForm);
  }
  else
  if (BildForm = dynamic_cast <TBildForm*> (ActiveMDIChild)){
    BildForm->Close ();
  }
}
//---------------------------------------------------------------------------

void __fastcall TFrameForm::SpeedButtonBoldClick(TObject *Sender)
{
// All these buttons must have AllowAllUp == TRUE and different Groupindices!
  TEditForm *EdForm;
  if (EdForm = dynamic_cast <TEditForm *> (ActiveMDIChild)){
    if (!FUpdating) {
      if (SpeedButtonBold->Down)
        EdForm->Editor->SelAttributes->Style = EdForm->Editor->SelAttributes->Style << fsBold;
      else
        EdForm->Editor->SelAttributes->Style = EdForm->Editor->SelAttributes->Style >> fsBold;
      EdForm->Editor->Modified = true;
    }
  }
}
//---------------------------------------------------------------------------
void __fastcall TFrameForm::SpeedButtonItalicClick(TObject *Sender)
{
// All these buttons must have AllowAllUp == TRUE and different Groupindices!
  TEditForm *EdForm;
  if (EdForm = dynamic_cast <TEditForm *> (ActiveMDIChild)){
      if (SpeedButtonItalic->Down)
        EdForm->Editor->SelAttributes->Style = EdForm->Editor->SelAttributes->Style << fsItalic;
      else
        EdForm->Editor->SelAttributes->Style = EdForm->Editor->SelAttributes->Style >> fsItalic;
      EdForm->Editor->Modified = true;
  }
}
//---------------------------------------------------------------------------
void __fastcall TFrameForm::SpeedButtonUnderlineClick(TObject *Sender)
{
// All these buttons must have AllowAllUp == TRUE and different Groupindices!
  TEditForm *EdForm;
  if (EdForm = dynamic_cast <TEditForm *> (ActiveMDIChild)){
    if (!FUpdating) {
      if (SpeedButtonUnderline->Down)
        EdForm->Editor->SelAttributes->Style = EdForm->Editor->SelAttributes->Style << fsUnderline;
     else
        EdForm->Editor->SelAttributes->Style = EdForm->Editor->SelAttributes->Style >> fsUnderline;
      EdForm->Editor->Modified = true;
    }
  }
}
//---------------------------------------------------------------------------

void __fastcall TFrameForm::SpeedButtonProtectClick(TObject *Sender)
{
  TEditForm *EdForm;
  if (EdForm = dynamic_cast <TEditForm *> (ActiveMDIChild)){
    if (!FUpdating) {
      EdForm->Editor->SelAttributes->Protected = SpeedButtonProtect->Down;
      EdForm->Editor->Modified = true;
    }
  }
}
//---------------------------------------------------------------------------

void __fastcall TFrameForm::AlignClick(TObject *Sender)
{
  TEditForm *EdForm;
  if (EdForm = dynamic_cast <TEditForm *> (ActiveMDIChild)){
    if (!FUpdating) {
      TControl *oAliBtn = (TControl*)(Sender);
      EdForm->Editor->Paragraph->Alignment = (TAlignment)oAliBtn->Tag;
      EdForm->Editor->Modified = true;
    }
  }
}

//---------------------------------------------------------------------------
void __fastcall TFrameForm::SpeedButtonBulletsClick(TObject *Sender)
{
  TEditForm *EdForm;
  if (EdForm = dynamic_cast <TEditForm *> (ActiveMDIChild)){
    if (!FUpdating) {
      EdForm->Editor->Paragraph->Numbering = (TNumberingStyle)SpeedButtonBullets->Down;
      EdForm->Editor->Modified = true;
    }
  }
}
//---------------------------------------------------------------------------
void __fastcall TFrameForm::SpeedButtonFindClick(TObject *Sender)
{
  TEditForm *EdForm;
  if (EdForm = dynamic_cast <TEditForm *> (ActiveMDIChild)){
    EdForm->Find1Click (EdForm);
  }
}
//---------------------------------------------------------------------------
void __fastcall TFrameForm::SpeedButtonReplaceClick(TObject *Sender)
{
  TEditForm *EdForm;
  if (EdForm = dynamic_cast <TEditForm *> (ActiveMDIChild)){
    EdForm->Replace1Click (EdForm);
  }
}
//---------------------------------------------------------------------------
void __fastcall TFrameForm::SpeedButtonCutClick(TObject *Sender)
{
  TEditForm *EdForm;
  if (EdForm = dynamic_cast <TEditForm *> (ActiveMDIChild)){
    EdForm->Cut1Click (EdForm);
  }
}
//---------------------------------------------------------------------------
void __fastcall TFrameForm::SpeedButtonCopyClick(TObject *Sender)
{
  TEditForm *EdForm;
  if (EdForm = dynamic_cast <TEditForm *> (ActiveMDIChild)){
    EdForm->Copy1Click (EdForm);
  }
}
//---------------------------------------------------------------------------
void __fastcall TFrameForm::SpeedButtonPasteClick(TObject *Sender)
{
  TEditForm *EdForm;
  if (EdForm = dynamic_cast <TEditForm *> (ActiveMDIChild)){
    EdForm->Paste1Click (EdForm);
  }
}
//---------------------------------------------------------------------------
void __fastcall TFrameForm::SpeedButtonUndoClick(TObject *Sender)
{
  TEditForm *EdForm;
  if (EdForm = dynamic_cast <TEditForm *> (ActiveMDIChild)){
    if (EdForm->Editor->HandleAllocated())
      SendMessage (EdForm->Editor->Handle, EM_UNDO, 0, 0);
  }
}
//---------------------------------------------------------------------------
void __fastcall TFrameForm::SpeedButtonPrintClick(TObject *Sender)
{
  TEditForm *EdForm;
  TBildForm *BildForm;
  if (EdForm = dynamic_cast <TEditForm *> (ActiveMDIChild)){
    doPrintDialog = true;
    EdForm->Print1Click (EdForm);
  }
  else if (BildForm = dynamic_cast <TBildForm*> (ActiveMDIChild)){
    BildForm->Bilddrucken1Click (BildForm);
  }
}
//---------------------------------------------------------------------------
void __fastcall TFrameForm::GlobalSettings1Click(TObject *Sender)
{
  if (AllgEinstellDialog == NULL) {
    Application->CreateForm (__classid (TAllgEinstellDialog), &AllgEinstellDialog);
    AllgEinstellDialog->Show (); // untergeordnetes Formular erzeugen und anzeigen
  }
  else
  {
    AllgEinstellDialog->Visible = true;
    AllgEinstellDialog->BringToFront ();
  }
}
//---------------------------------------------------------------------------

// old style SLRE window configfile:
/*
  FILE *WindowFile;
  AnsiString WindowName;

  WindowName = ChangeFileExt (Application->ExeName, ".WIN");
  WindowFile = fopen (WindowName.c_str(), "rb");

  if (WindowFile != NULL) {
    fread (&DefaultWindow, sizeof (TWindowEinstellungen), 1, WindowFile);
    fclose (WindowFile);
    if (!DefaultWindow.FrameWinDefault){
      Top = DefaultWindow.FrameTop; Left = DefaultWindow.FrameLeft;
      Height = DefaultWindow.FrameHeight; Width = DefaultWindow.FrameWidth;
      Position = DefaultWindow.FramePos;
      WindowState = DefaultWindow.FrameWin;
    }
*/
// Fenster-Voreinstellungen:
/*
  if (FrameForm->DefaultWindow.FrameWinDefault == true) {
    Position = FrameForm->DefaultWindow.FramePos;
    WindowState = FrameForm->DefaultWindow.FrameWin;
    switch (FrameForm->DefaultWindow.FramePos) {
      case poDefaultPosOnly:
      case poScreenCenter:
      		Height = FrameForm->DefaultWindow.FrameHeight;
      		Width = FrameForm->DefaultWindow.FrameWidth;
            break;
      case poDefaultSizeOnly:
      		Top = FrameForm->DefaultWindow.FrameTop;
      		Left = FrameForm->DefaultWindow.FrameLeft;
            break;
    }
  }
  else {
    Height = FrameForm->DefaultWindow.FrameHeight;
    Width = FrameForm->DefaultWindow.FrameWidth;
    Top = FrameForm->DefaultWindow.FrameTop;
    Left = FrameForm->DefaultWindow.FrameLeft;
  }
  } // if KonfigFile
  else {
    ShowMessage ("Keine Window-Konfigurationsdatei vorhanden, setze Standardwerte");
  };
*/
// old SLRE style font config:
/*
  FILE *FontFile;
  AnsiString FontName;
  TFontEinstellungen TextAttr;

  FontName = ChangeFileExt (Application->ExeName, ".FON");
  FontFile = fopen (FontName.c_str(), "rb");

  if (FontFile != NULL) {
    fread (&TextAttr, sizeof (TFontEinstellungen), 1, FontFile);
    fclose (FontFile);
    FrameForm->DefaultFont = new TFont;
    FrameForm->DefaultFont->Color = TextAttr.col;
    FrameForm->DefaultFont->Name = TextAttr.Nam;
    FrameForm->DefaultFont->Pitch = TextAttr.Pit;
    FrameForm->DefaultFont->Size = TextAttr.Siz;
    FrameForm->DefaultFont->Style = TextAttr.Styl;
    FrameForm->DefaultFont->Height = TextAttr.Hei;
  }
  else
    ShowMessage ("Kein Default-Font gefunden!");
*/

void __fastcall TFrameForm::OpenFirstDocsInHistory1Click(TObject *Sender)
{
  int i = 0;
  if (ProjektListe->Count > 0){
    while ((i < ProjektListe->Count)){
      if (FileExists (ProjektListe->Strings [i])){
        if (istGrafikdatei (ProjektListe->Strings [i])) {
      Application->CreateForm (__classid (TBildForm), &BildForm);
      BildForm->Image1->Picture->LoadFromFile (ProjektListe->Strings [i]);
      BildForm->Caption = ProjektListe->Strings [i];
      BildForm->Position = ProjektFile->ReadInteger (BildForm->Caption, "Position", poDesigned);
      BildForm->WindowState = ProjektFile->ReadInteger (BildForm->Caption, "WindowState", wsNormal);
      BildForm->Left = ProjektFile->ReadInteger (BildForm->Caption, "Left", 0);
      BildForm->Top = ProjektFile->ReadInteger (BildForm->Caption, "Top", 0);
      BildForm->Height = ProjektFile->ReadInteger (BildForm->Caption, "Height", 420);
      BildForm->Width = ProjektFile->ReadInteger (BildForm->Caption, "Width", 420);
        }
      else{
        EditForm = new TEditForm (this);
        EditForm->Editor->Perform (WM_SETREDRAW, false, 0);

        EditForm->Oeffnen (ProjektListe->Strings [i]);
        EditForm->Position = ProjektFile->ReadInteger (EditForm->Pfad, "Position", poDesigned);
        EditForm->WindowState = ProjektFile->ReadInteger (EditForm->Pfad, "WindowState", wsNormal);
        EditForm->Left = ProjektFile->ReadInteger (EditForm->Pfad, "Left", 0);
        EditForm->Top = ProjektFile->ReadInteger (EditForm->Pfad, "Top", 0);
        EditForm->Height = ProjektFile->ReadInteger (EditForm->Pfad, "Height", 420);
        EditForm->Width = ProjektFile->ReadInteger (EditForm->Pfad, "Width", 420);
        EditForm->Editor->ReadOnly = ProjektFile->ReadBool (EditForm->Pfad, "ReadOnly", false);
        EditForm->Editor->WordWrap = ProjektFile->ReadBool (EditForm->Pfad, "WordWrap", true);
        EditForm->backwards = ProjektFile->ReadBool (EditForm->Pfad, "backwards", false);
        EditForm->SpeedButtonWriteback->Down = EditForm->backwards;
        EditForm->Editor->Update(); //nderung !!
        EditForm->Editor->SelStart = ProjektFile->ReadInteger (EditForm->Pfad, "Cursor", 0);
        EditForm->virtualSelStart = EditForm->Editor->SelStart;
        EditForm->Editor->Perform (WM_SETREDRAW, true, 0);
        EditForm->Editor->Refresh();
//        EditForm->CursorDaten(EditForm);

      } // else
        i++;
      } // if FileExists
      else {
        ShowMessage ("Die Datei '" + ProjektListe->Strings [i] + "' ist nicht vorhanden!");
        ProjektListe->Delete (i);
      }
    } // while
  }
  else {
    while ((i < HistoryListe->Count) && (i < Konfig.LastHistory)){
      if (FileExists (HistoryListe->Strings [i])){
        if (istGrafikdatei (HistoryListe->Strings [i])) {
      Application->CreateForm (__classid (TBildForm), &BildForm);
      BildForm->Image1->Picture->LoadFromFile (HistoryListe->Strings [i]);
      BildForm->Caption = HistoryListe->Strings [i];
      BildForm->Position = ProjektFile->ReadInteger (BildForm->Caption, "Position", poDesigned);
      BildForm->WindowState = ProjektFile->ReadInteger (BildForm->Caption, "WindowState", wsNormal);
      BildForm->Left = ProjektFile->ReadInteger (BildForm->Caption, "Left", 0);
      BildForm->Top = ProjektFile->ReadInteger (BildForm->Caption, "Top", 0);
      BildForm->Height = ProjektFile->ReadInteger (BildForm->Caption, "Height", 420);
      BildForm->Width = ProjektFile->ReadInteger (BildForm->Caption, "Width", 420);
        }
      else{
        EditForm = new TEditForm (this);
        EditForm->Editor->Perform (WM_SETREDRAW, false, 0);
        EditForm->Oeffnen (HistoryListe->Strings [i]);
        EditForm->Position = ProjektFile->ReadInteger (EditForm->Pfad, "Position", poDesigned);
        EditForm->WindowState = ProjektFile->ReadInteger (EditForm->Pfad, "WindowState", wsNormal);
        EditForm->Left = ProjektFile->ReadInteger (EditForm->Pfad, "Left", 0);
        EditForm->Top = ProjektFile->ReadInteger (EditForm->Pfad, "Top", 0);
        EditForm->Height = ProjektFile->ReadInteger (EditForm->Pfad, "Height", 420);
        EditForm->Width = ProjektFile->ReadInteger (EditForm->Pfad, "Width", 420);
        EditForm->Editor->ReadOnly = ProjektFile->ReadBool (EditForm->Pfad, "ReadOnly", false);
        EditForm->Editor->WordWrap = ProjektFile->ReadBool (EditForm->Pfad, "WordWrap", true);
        EditForm->backwards = ProjektFile->ReadBool (EditForm->Pfad, "backwards", false);
        EditForm->SpeedButtonWriteback->Down = EditForm->backwards;
        EditForm->Editor->Update(); // nderung!!!
        EditForm->Editor->SelStart = ProjektFile->ReadInteger (EditForm->Pfad, "Cursor", 0);
        EditForm->virtualSelStart = EditForm->Editor->SelStart;
        EditForm->Editor->Perform (WM_SETREDRAW, true, 0);
        EditForm->Editor->Refresh();
//        EditForm->CursorDaten(EditForm);
      } // else
      i++;
      }
      else {
        ShowMessage ("Die Datei '" + HistoryListe->Strings [i] + "' ist nicht vorhanden!");
        HistoryListe->Delete (i);
      }
    } // while
  }
}

void __fastcall TFrameForm::FormActivate(TObject *Sender)
{
unsigned char name[80];
// Notwendig, da sonst bei jedem Anklicken neu gestartet!
  if (Initialisiert) return;

// ShowMessage ("FrameForm::FormCreate");
// Hier, da das im C++-Builder in OnCreate nicht richtig funktioniert!
// ---------------- Konfigurationsdatei ".CFS"

  IniFile = new TIniFile (ChangeFileExt (Application->ExeName, ".INI"));

  MenuName = IniFile->ReadString ("Menus", "ActualMenu",
    ChangeFileExt (Application->ExeName, ".MEN"));
//ShowMessage (MenuName);
  MenuFile = new TIniFile (MenuName);
  doLoadMenu ();
//  delete MenuFile;
//  DeleteFile (MenuName);
//  MenuFile = new TIniFile (MenuName);
//  doSaveMenu ();

//  Konfig.HistoryAnzeigen = IniFile->ReadBool ("GlobalSettings", "HistoryAnzeigen", false);
  Konfig.AusHistoryLaden = IniFile->ReadBool ("GlobalSettings", "AusHistoryLaden", true);
  Konfig.SchaltleisteAnzeigen = IniFile->ReadBool ("GlobalSettings", "SchaltleisteAnzeigen", true);
  Konfig.Schaltleiste2Anzeigen = IniFile->ReadBool ("GlobalSettings", "Schaltleiste2Anzeigen", true);
  Konfig.Schaltleiste3Anzeigen = IniFile->ReadBool ("GlobalSettings", "MediaLeisteAnzeigen", true);
  Konfig.LinealAnzeigen = IniFile->ReadBool ("GlobalSettings", "LinealAnzeigen", true);
  Konfig.ISOAnzeigen = IniFile->ReadBool ("GlobalSettings", "ISOAnzeigen", true);
  Konfig.WortUmbruch = IniFile->ReadBool ("GlobalSettings", "WortUmbruch", true);
  Konfig.SaveTextWindow = IniFile->ReadBool ("GlobalSettings", "SaveTextWindow", true);
//  Konfig.TextModus = IniFile->ReadBool ("GlobalSettings", "TextModus", false);
  Konfig.BAKErstellen = IniFile->ReadBool ("GlobalSettings", "BAKErstellen", true);
//  Konfig.TerminalStart = IniFile->ReadBool ("GlobalSettings", "TerminalStart", false);
  Konfig.StatusLeiste = IniFile->ReadBool ("GlobalSettings", "StatusLeiste", true);
  Konfig.AutoSaveAbfrage = IniFile->ReadBool ("GlobalSettings", "AutoSaveAbfrage", false);
  Konfig.Schaltleiste3Anzeigen = IniFile->ReadBool ("GlobalSettings", "Schaltleiste3Anzeigen", true);
  Konfig.AutoSaveKonfig = IniFile->ReadBool ("GlobalSettings", "AutoSaveKonfig", true);
  Konfig.NoExplorerTest = IniFile->ReadBool ("GlobalSettings", "NoExplorerTest", false);
  Konfig.AutoSyntaxHighlight = IniFile->ReadBool ("GlobalSettings", "AutoSyntaxHighlight", false);

  Konfig.AutoTagAssistant = IniFile->ReadBool ("GlobalSettings", "AutoTagAssistant", false);
  Konfig.AutoUmlaut = IniFile->ReadBool ("GlobalSettings", "AutoUmlaut", false);
  Konfig.AutoDateienMerken = IniFile->ReadBool ("GlobalSettings", "AutoDateienMerken", true);
  Konfig.KeineDuplikateLaden = IniFile->ReadBool ("GlobalSettings", "KeineDuplikateLaden", true);
  Konfig.IncBackup = IniFile->ReadBool ("GlobalSettings", "IncBackup", false);
  Konfig.AutoWebfenster = IniFile->ReadBool ("GlobalSettings", "AutoWebfenster", false);
  Konfig.AutoHomepage = IniFile->ReadBool ("GlobalSettings", "AutoHomepage", false);
  Konfig.AutoOnline = IniFile->ReadBool ("GlobalSettings", "AutoOnline", false);
  Konfig.WebMinimiert = IniFile->ReadBool ("GlobalSettings", "WebMinimiert", false);
  Konfig.PrintHeader = IniFile->ReadString ("GlobalSettings", "PrintHeader", "");
  Konfig.PrintFooter = IniFile->ReadString ("GlobalSettings", "PrintFooter", "");
  Konfig.FitPicture = IniFile->ReadBool ("GlobalSettings", "FitPicture", true);
  Konfig.DontShowShareware = IniFile->ReadBool ("GlobalSettings", "DontShowShareware", true);
  Konfig.UseFontfilter = IniFile->ReadBool ("GlobalSettings", "UseFontfilter", true);

  Konfig.MaxHistory = IniFile->ReadInteger ("GlobalSettings", "MaxHistory", 500);
  Konfig.MaxTextLaenge = IniFile->ReadInteger ("GlobalSettings", "MaxTextLaenge", MAXINT - 1024);
  Konfig.ZeichenAufSeite = IniFile->ReadInteger ("GlobalSettings", "ZeichenAufSeite", 3500);
  Konfig.MaxFavorite = IniFile->ReadInteger ("GlobalSettings", "MaxFavorite", 500);
  Konfig.saveIntervall = IniFile->ReadInteger ("GlobalSettings", "saveIntervall", 30);
  Konfig.LastHistory = IniFile->ReadInteger ("GlobalSettings", "LastHistory", 0);
  Konfig.DateiFilterIndex = IniFile->ReadInteger ("GlobalSettings", "DateiFilterIndex", 0);
  Konfig.NIncBackup = IniFile->ReadInteger ("GlobalSettings", "NIncBackup", 0);
  Konfig.AnzeigeHistory = IniFile->ReadInteger ("GlobalSettings", "AnzeigeHistory", 10);
  Konfig.BrowserBackup = IniFile->ReadInteger ("GlobalSettings", "BrowserBackup", 10);
  Konfig.LeftMargin = IniFile->ReadInteger ("GlobalSettings", "LeftMargin", 20);
  Konfig.RightMargin = IniFile->ReadInteger ("GlobalSettings", "RightMargin", 20);
  Konfig.TopMargin = IniFile->ReadInteger ("GlobalSettings", "TopMargin", 20);
  Konfig.BottomMargin = IniFile->ReadInteger ("GlobalSettings", "BottomMargin", 20);
  Konfig.HeaderMargin = IniFile->ReadInteger ("GlobalSettings", "HeaderMargin", 10);
  Konfig.FooterMargin = IniFile->ReadInteger ("GlobalSettings", "FooterMargin", 10);

  Konfig.RegCode = IniFile->ReadInteger ("GlobalSettings", "RegCode", 0);

// ------------------------------------------------------------------------
// ---------------- Fenster-Konfigurationsdatei ".WIN"

  DefaultWindow.FrameWinDefault = IniFile->ReadBool ("MainWindow", "WinDefault", true);
  DefaultWindow.FramePos = IniFile->ReadInteger ("MainWindow", "Position", poDesigned);
  DefaultWindow.FrameWin = IniFile->ReadInteger ("MainWindow", "WindowState", wsNormal);
  DefaultWindow.FrameLeft = IniFile->ReadInteger ("MainWindow", "Left", 0);
  DefaultWindow.FrameTop = IniFile->ReadInteger ("MainWindow", "Top", 0);
  DefaultWindow.FrameHeight = IniFile->ReadInteger ("MainWindow", "Height", 420);
  DefaultWindow.FrameWidth = IniFile->ReadInteger ("MainWindow", "Width", 420);

  DefaultWindow.ChildWinDefault = IniFile->ReadBool ("TextWindow", "WinDefault", true);
  DefaultWindow.ChildPos = IniFile->ReadInteger ("TextWindow", "Position", poDesigned);
  DefaultWindow.ChildWin = IniFile->ReadInteger ("TextWindow", "WindowState", wsNormal);
  DefaultWindow.ChildLeft = IniFile->ReadInteger ("TextWindow", "Left", 0);
  DefaultWindow.ChildTop = IniFile->ReadInteger ("TextWindow", "Top", 0);
  DefaultWindow.ChildHeight = IniFile->ReadInteger ("TextWindow", "Height", 420);
  DefaultWindow.ChildWidth = IniFile->ReadInteger ("TextWindow", "Width", 420);

  Top = DefaultWindow.FrameTop; Left = DefaultWindow.FrameLeft;
  Height = DefaultWindow.FrameHeight; Width = DefaultWindow.FrameWidth;
  Position = DefaultWindow.FramePos;
  WindowState = DefaultWindow.FrameWin;

// ---------------- Font-Konfigurationsdatei ".FON"
  TFontEinstellungen TextAttr;
  bool Bold; bool Italic; bool Underline; bool Strikeout;

  TextAttr.col = IniFile->ReadInteger ("DefaultFont", "Color", 0);
  TextAttr.Nam = IniFile->ReadString ("DefaultFont", "Name", "Times New Roman");
  TextAttr.Pit = IniFile->ReadInteger ("DefaultFont", "Pitch", 0);
  TextAttr.Siz = IniFile->ReadInteger ("DefaultFont", "Size", 12);
  Bold = IniFile->ReadBool ("DefaultFont", "fsBold", false);
  Italic = IniFile->ReadBool ("DefaultFont", "fsItalic", false);
  Underline = IniFile->ReadBool ("DefaultFont", "fsUnderline", false);
  Strikeout = IniFile->ReadBool ("DefaultFont", "fsStrikeout", false);
  TextAttr.Hei = IniFile->ReadInteger ("DefaultFont", "Height", -16);

  if (Bold) TextAttr.Styl << fsBold;
  if (Italic) TextAttr.Styl << fsBold;
  if (Underline) TextAttr.Styl << fsBold;
  if (Strikeout) TextAttr.Styl << fsBold;

  FrameForm->DefaultFont = new TFont;
  FrameForm->DefaultFont->Color = TextAttr.col;
  FrameForm->DefaultFont->Name = TextAttr.Nam;
  FrameForm->DefaultFont->Pitch = TextAttr.Pit;
  FrameForm->DefaultFont->Size = TextAttr.Siz;
  FrameForm->DefaultFont->Style = TextAttr.Styl;
  FrameForm->DefaultFont->Height = TextAttr.Hei;

  GetFontNames ();

// ---------------------------- PLL init -------------------------------------
// ---------------------------------------------------------------------------
//   get_PLL_environment();
//   sprintf(name, "%sS\\SYS\\EDI_INIT", hu_drive);
//   read_path_file(name);
// ---------------------------------------------------------------------------
// ---------------------------- PLL init end ---------------------------------


//  ReadPllIniFile();

// --------------------- DateiFilter -------------------------------
//  IniFile->WriteString ("Filter", "DateiFilter", Dateifilter);
  DateiFilter = IniFile->ReadString ("Filter", "DateiFilter",
    "RTF-Dateien (*.rtf)|*.rtf|Textdateien (*.txt)|*.txt|DOS-Dateien (*.dos)|*.dos|Alle Dateien (*.*)|*.*");
//ShowMessage ("Geladen: " + DateiFilter);

// ------------------------ Projekte -----------------------------
/*   AllgEinstellDialog->ComboBoxProjekte->Text =
     IniFile->ReadString ("Projects", "ActualProject", ChangeFileExt (Application->ExeName, ".HIS"));
*/ // In GlobalEinstellungen
  ProjektName = IniFile->ReadString ("Projects", "ActualProject", ChangeFileExt (Application->ExeName, ".HIS"));
  ProjektFile = new TIniFile (ExtractFilePath (Application->ExeName) + ChangeFileExt (ProjektName, ".WIN"));

  PanelSpeed1->Visible = Konfig.SchaltleisteAnzeigen;
  PanelSpeedFont->Visible = Konfig.Schaltleiste2Anzeigen;
  PanelMedia->Visible = Konfig.Schaltleiste3Anzeigen;
  StatusBar1->Visible = Konfig.StatusLeiste;

  unsigned long Volume;
  waveOutGetVolume (0, (LPDWORD) &Volume);
//  Volume = ((Volume & 0xFFFF)+ (Volume >> 16)) / 2;

  TrackBarLoudnessLeft->Max = 65535;
  TrackBarLoudnessLeft->Frequency = TrackBarLoudnessLeft->Max / 6;
  TrackBarLoudnessRight->Max = 65535;
  TrackBarLoudnessRight->Frequency = TrackBarLoudnessRight->Max / 6;
  TrackBarLoudnessLeft->Position = Volume & 0xFFFF;
  TrackBarLoudnessRight->Position = Volume >> 16;

//------------------------- Historyliste etc. -------------------------------
//ShowMessage (ChangeFileExt (Application->ExeName, ".HIS"));
  HistoryListe = new TStringList;
  try {
    HistoryListe->LoadFromFile (ChangeFileExt (Application->ExeName, ".HIS"));
  }
  catch (EFOpenError*) {
    ShowMessage ("Keine History-Liste gefunden!");
  }

  ProjektListe = new TStringList;
  if ((ProjektName != "") && (UpperCase (ProjektName) != ExtractFileName (ChangeFileExt (Application->ExeName, ".HIS")))) {
    try {
      ProjektListe->LoadFromFile (ProjektName);
    }
    catch (EFOpenError*) {
      ShowMessage ("Keine Projekt-Liste gefunden!");
    }
  }

  FavouriteListe = new TStringList;
  try {
    FavouriteListe->LoadFromFile (ChangeFileExt (Application->ExeName, ".FAV"));
  }
  catch (EFOpenError*) {
    ShowMessage ("Keine Favoriten-Liste gefunden!");
  }

  AnwendungsListe = new TStringList;
  try {
    AnwendungsListe->LoadFromFile (ChangeFileExt (Application->ExeName, ".ANW"));
  }
  catch (EFOpenError*) {
    ShowMessage ("Keine Anwendungs-Liste gefunden!");
  }
/**/
  if (Konfig.AusHistoryLaden)
    OpenFirstDocsInHistory1Click (this);
  Initialisiert = true;
/**/
  // might comment out for debugging:
  Timer1->Interval = 1000;
}
//---------------------------------------------------------------------------
void __fastcall TFrameForm::OpenLastDocument1Click(TObject *Sender)
{
  if (HistoryListe->Count > 0) {
    if (FileExists (HistoryListe->Strings [0])){
      EditForm = new TEditForm (this);
      EditForm->Oeffnen (HistoryListe->Strings [0]);
    }
    else {
      ShowMessage ("Die Datei '" + HistoryListe->Strings [0] + "' ist nicht vorhanden!");
      HistoryListe->Delete (0);
    }
  } // while
}
//---------------------------------------------------------------------------
void __fastcall TFrameForm::FormClose(TObject *Sender,
      TCloseAction &Action)
{
// Hier, da das im C++-Builder in OnDestroy nicht richtig funktioniert!
  shutdown = true;
  Timer1->Interval = 0;
   if (Konfig.AutoDateienMerken) {
     Konfig.LastHistory = 0;
     if (MDIChildCount > 0) ProjektListe->Clear ();
     int i;
     TEditForm *EdForm;
     TBildForm *BildForm;

// Hm - irgendwie den bisherigen Inhalt der Projekt-Windowliste lschen!
/*     delete ProjektListe;

     ProjektFile = new TIniFile (ExtractFilePath (Application->ExeName) + ChangeFileExt (ProjektName, ".WIN"));
*/
     for (i = 0; i < MDIChildCount; i++){
       if (EdForm = dynamic_cast <TEditForm*> (MDIChildren [i])){
         Konfig.LastHistory++;
         EdForm->Save1Click (Sender);
         ProjektListe->Insert (0, EdForm->Pfad);
         ProjektFile->WriteInteger (EdForm->Pfad, "Position", EdForm->Position);
         ProjektFile->WriteInteger (EdForm->Pfad, "WindowState", EdForm->WindowState);
         ProjektFile->WriteInteger (EdForm->Pfad, "Left", EdForm->Left);
         ProjektFile->WriteInteger (EdForm->Pfad, "Top", EdForm->Top);
         ProjektFile->WriteInteger (EdForm->Pfad, "Height", EdForm->Height);
         ProjektFile->WriteInteger (EdForm->Pfad, "Width", EdForm->Width);
         ProjektFile->WriteInteger (EdForm->Pfad, "Cursor", EdForm->Editor->SelStart);
         ProjektFile->WriteBool (EdForm->Pfad, "ReadOnly", EdForm->Editor->ReadOnly);
         ProjektFile->WriteBool (EdForm->Pfad, "WordWrap", EdForm->Editor->WordWrap);
         ProjektFile->WriteBool (EdForm->Pfad, "backwards", EdForm->backwards);

// -- siehe CLREdit::FormCloseQuery!
//         EdForm->Speichern1Click (Sender);
       } // if TEditForm*
       else
       if (BildForm = dynamic_cast <TBildForm*> (MDIChildren [i])){
         Konfig.LastHistory++;

// -------------------------------------------------
//         BildForm->Speichern1Click (Sender);
    // History-Liste updaten:

          int Index;

          // Feststellen, ob Datei in Projektliste schon verzeichnet:
          Index = FrameForm->ProjektListe->IndexOf (BildForm->Caption);
          // Falls ja, entfernen, um sie nach vorne zu bringen:
          if (Index != -1) FrameForm->ProjektListe->Delete (Index);
          // History-Liste krzen, falls sie MaxHistory (noch) bersteigt:
          // ...
          // Feststellen, ob Datei in Historyliste schon verzeichnet:
          Index = FrameForm->HistoryListe->IndexOf (BildForm->Caption);
          // Falls ja, entfernen, um sie nach vorne zu bringen:
          if (Index != -1) FrameForm->HistoryListe->Delete (Index);
          // History-Liste krzen, falls sie MaxHistory (noch) bersteigt:
          // ...
          // Aktuelle Datei an erster Stelle einfgen:
          if (FrameForm->Konfig.MaxHistory > 0)
            FrameForm->HistoryListe->Insert (0, BildForm->Caption);
// -------------------------------------------------
           ProjektListe->Insert (0, BildForm->Caption);
           ProjektFile->WriteInteger (BildForm->Caption, "Position", BildForm->Position);
           ProjektFile->WriteInteger (BildForm->Caption, "WindowState", BildForm->WindowState);
           ProjektFile->WriteInteger (BildForm->Caption, "Left", BildForm->Left);
           ProjektFile->WriteInteger (BildForm->Caption, "Top", BildForm->Top);
           ProjektFile->WriteInteger (BildForm->Caption, "Height", BildForm->Height);
           ProjektFile->WriteInteger (BildForm->Caption, "Width", BildForm->Width);
        } // if BildForm
      } // for
    }
  doSaveKonfig ();
} // FormClose
//---------------------------------------------------------------------------

void __fastcall TFrameForm::History1Click(TObject *Sender)
{
  int           i, max, off;
  TMenuItem     *menitem;
  const int     cBreak = 30;

  i = History1->Count;
  while (History1->Items [i - 1]->Caption != "-"){
    i--; History1->Delete (i);
  }
  i = History2->Count;
  while (History2->Items [i - 1]->Caption != "-"){
    i--; History2->Delete (i);
  }

  if (HistoryListe->Count < Konfig.AnzeigeHistory)
    max = HistoryListe->Count - 1;
  else
    max = Konfig.AnzeigeHistory - 1;

  off = 0;
  for (i = 0; i <= max; i++){
    if (fmodl (i + 1, cBreak) == 0) {
      menitem = new TMenuItem (MainMenu);
      menitem->Break = mbBarBreak;
      History1->Add (menitem);
    } // if
    while (findePfadnamen (HistoryListe->Strings [i + off]) != NULL) {
      off++;
    } // while

    if (i + off + 1 >= HistoryListe->Count) break;

    menitem = new TMenuItem (MainMenu);
    menitem->Caption = HistoryListe->Strings [i + off];
    menitem->OnClick = DateiMenuEndeClick;
    History1->Add (menitem);

    menitem = new TMenuItem (MainPopupMenu);
    menitem->Caption = HistoryListe->Strings [i + off];
    menitem->OnClick = DateiMenuEndeClick;
    History2->Add (menitem);
  } // for
}
//---------------------------------------------------------------------------
void __fastcall TFrameForm::DateiMenuEndeClick (TObject *Sender)
{
  TMenuItem *menitem = dynamic_cast <TMenuItem*> (Sender);
  if (!FileExists (menitem->Caption)) {
    ShowMessage ("Die Datei '" + menitem->Caption + "' ist nicht vorhanden!");
    return;
  } // if
  EditForm = new TEditForm (this);
  EditForm->Oeffnen (menitem->Caption);
}
//---------------------------------------------------------------------------
void __fastcall TFrameForm::Historybrowseroeffnen1Click(TObject *Sender)
{
  // Hier Stringlistendialog ffnen ...
  int           i;
  TModalResult  mr;
  TStringDialog* StringDialog;
  StringDialog = new TStringDialog (this, "Historyliste",
    "Datei(en) laden", ChangeFileExt (Application->ExeName, ".HIS"),
    HistoryListe, 0, true, true, false, false, true);
  mr = StringDialog->ShowModal ();
  if (mr == mrOk) {
    HistoryListe = StringDialog->Liste;
    if (StringDialog->AuswahlListe != NULL) {
      for (i = 0; i < StringDialog->AuswahlListe->Count; i++) {
        if (FileExists (StringDialog->AuswahlListe->Strings [i])) {
          if (nichtNochmalLaden (StringDialog->AuswahlListe->Strings [i]))
            continue;
          EditForm = new TEditForm (this);
          EditForm->Oeffnen (StringDialog->AuswahlListe->Strings [i]);
        } // if FileExists
        else ShowMessage ("Die Datei '" + StringDialog->AuswahlListe->Strings [i] +
                          "' existiert nicht!");
      } // for
    } // if Auswahlliste != NULL
  }
  else
  if (mr == mrYes) {
    HistoryListe = StringDialog->Liste;
  };
  delete StringDialog;
}
//---------------------------------------------------------------------------

void __fastcall TFrameForm::SpeedButtonPreviousClick(TObject *Sender)
{
  Previous ();
}
//---------------------------------------------------------------------------

void __fastcall TFrameForm::SpeedButtonNextClick(TObject *Sender)
{
  Next ();
}
//---------------------------------------------------------------------------

void __fastcall TFrameForm::LoadFilename (AnsiString FileName)
  {
  TEditForm *EdForm = dynamic_cast <TEditForm*> (ActiveMDIChild);
  if (EdForm == NULL) return;
//  ShowMessage ("'" + FileName + "'");
  if (FileExists (FileName))
    {
    if (findePfadnamen(FileName)) ReadMethods = ReadOnly;
    EditForm = new TEditForm (this);
    EditForm->Oeffnen (FileName);
    if (ReadMethods == ReadOnly) EditForm->Editor->ReadOnly = true;
    else                         EditForm->Editor->ReadOnly = false;
    }
  else
    {
    ShowMessage ("'" + FileName + "' does not exist");
    }
  }

void __fastcall TFrameForm::SpeedButtonLoadFromCursorClick(TObject *Sender)
{
  AnsiString          NameAtCursor;
  TEditForm *EdForm = dynamic_cast <TEditForm*> (ActiveMDIChild);
  if (EdForm == NULL) return;
  NameAtCursor = EdForm->GetNameAtCursor ();
  if (AnsiCompareText(ExtractFileExt(NameAtCursor),".BAK") == 0)
      ReadMethods = ReadOnly;
  LoadFilename(NameAtCursor);
}
//---------------------------------------------------------------------------

void __fastcall TFrameForm::PLL11Click(TObject *Sender)
{
  char* string;
  char Info [250];
  if (ActiveMDIChild == NULL) return;
  TEditForm *EdForm;
  if (EdForm = dynamic_cast <TEditForm *> (ActiveMDIChild)){
    string = EdForm->CString;
    sprintf (Info, "Aktuelle Zeile: '%s'", string);
    ShowMessage (Info);
  }
}
//---------------------------------------------------------------------------

void __fastcall TFrameForm::UpdateStatusBar(void)
{
#define K 0x400
#define M 0x100000
#define G 0x40000000

AnsiString      status1, freesuff, sizesuff;
__int64         dsksize, dskfree;

  dskfree = DiskFree (0); dsksize = DiskSize (0);

  if (dskfree < K)
    freesuff = Format ("%d Byte", ARRAYOFCONST (((int) dskfree)));
  else if (dskfree < M)
    freesuff = Format ("%n KB", ARRAYOFCONST (((double) dskfree / K)));
  else if (dskfree < G)
    freesuff = Format ("%n MB", ARRAYOFCONST (((double) dskfree / M)));
  else
    freesuff = Format ("%n GB", ARRAYOFCONST (((double) dskfree / G)));

  if (dsksize < K)
    sizesuff = Format ("%d Byte", ARRAYOFCONST (((int) dsksize)));
  else if (dsksize < M)
    sizesuff = Format ("%n KB", ARRAYOFCONST (((double) dsksize / K)));
  else if (dsksize < G)
    sizesuff = Format ("%n MB", ARRAYOFCONST (((double) dsksize / M)));
  else
    sizesuff = Format ("%n GB", ARRAYOFCONST (((double) dsksize / G)));

  status1 = "CurDir: " + GetCurrentDir () + ", free: " + freesuff +
            ", siz: " + sizesuff;
  if (StatusBar1 != NULL) StatusBar1->Panels->Items [1]->Text = status1;
}
//---------------------------------------------------------------------------
void __fastcall TFrameForm::Timer1Timer(TObject *Sender)
{
  int           day;
  AnsiString    dayStr;
  int           i;
  TEditForm*     EdForm;

/*  if (!MenuInit){
    doLoadMenu();
    MenuInit = true;
  }
*/

  day = DayOfWeek (Date());
  switch (day){
    case 1:  dayStr = "Sonntag"; break;
    case 2:  dayStr = "Montag"; break;
    case 3:  dayStr = "Dienstag"; break;
    case 4:  dayStr = "Mittwoch"; break;
    case 5:  dayStr = "Donnerstag"; break;
    case 6:  dayStr = "Freitag"; break;
    case 7:  dayStr = "Samstag"; break;
  }
  Tagesanzeige->Caption = dayStr;
  Datumsanzeige->Caption = DateToStr (Date()) + " " +
    TimeToStr (Time()) + "h";

  lastSave++;
  if ((Konfig.saveIntervall !=0) &&
      ((lastSave >= Konfig.saveIntervall) ||
        ((Konfig.BrowserBackup > 0) && (lastUserinput == 0)))) { // Bugfix!!!

    if (lastSave >= Konfig.saveIntervall) {
      lastSave = 0;
      IsAutoSave = true;
      if (Konfig.AutoSaveKonfig == true)
        doSaveKonfig ();
    } // if lastSave

    if (lastUserinput == 0) {
      for (i = 0; i < MDIChildCount; i++) {
        if (EdForm = dynamic_cast <TEditForm*> (MDIChildren [i])) {
          if ((EdForm->AutoSave) && (EdForm->Editor->Modified)) {
// Nur fr Hypertext - noch nicht implementiert
//            TextFilesUpdated = true;
            EdForm->Save1Click (Sender);
          } // if AutoSave
    int oldLastUserinput = lastUserinput;
    lastUserinput = 0;
          EdForm->CursorDaten (EdForm);
    lastUserinput = oldLastUserinput;
        } // if EdForm
      } // for
    } // if lastUserinput
  } // if saveIntervall

  if ((EdForm = dynamic_cast <TEditForm*> (ActiveMDIChild)) &&
   ((lastUserinput + 1 < Konfig.saveIntervall) ||
     Konfig.saveIntervall == 0)){
    int oldLastUserinput = lastUserinput;
//    lastUserinput = 0;
    EdForm->CursorDaten (EdForm);
    lastUserinput = oldLastUserinput;
  }

  if (lastUserinput > -1) lastUserinput--;

  // Anzeige Current-Dir aktualisieren:
  UpdateStatusBar ();
}
//---------------------------------------------------------------------------

void __fastcall TFrameForm::FormCreate(TObject *Sender)
{
  Caption = cTitle + " " + cVersion;// DateFullYear = true; ?
}
//---------------------------------------------------------------------------

void __fastcall TFrameForm::SpeedButtonOpenPictureClick(TObject *Sender)
{
/*  OpenPictureDialog1->DefaultExt = GraphicExtension (__classid
        (Graphics::TBitmap)); */
/*  OpenPictureDialog1->Filter = GraphicFilter(__classid
        (TGIFImage)); */
  OpenPictureDialog1->Filter = GraphicFilter(__classid
        (Graphics::TGraphic));
  if (OpenPictureDialog1->Execute ()) {
    Application->CreateForm (__classid (TBildForm), &BildForm);
    BildForm->Image1->Picture->LoadFromFile (OpenPictureDialog1->FileName);
    BildForm->Caption = OpenPictureDialog1->FileName;
//    BildForm->Show ();
  } // if OpenPictureDialog1
}
//---------------------------------------------------------------------------



void __fastcall TFrameForm::SpeedButtonLoadmediaClick(TObject *Sender)
{
//  if (DateiFilter != "") DateiOeffnenDialog->Filter = DateiFilter;
  DateiOeffnenDialog->Filter =
    "Wave-Dateien (*.WAV)|*.WAV|Audio-CD (*.CDA)|*.CDA";
  DateiOeffnenDialog->InitialDir = ExtractFileDir (Application->ExeName);

  if (DateiOeffnenDialog->Execute()) {
    MediaPlayer1->FileName = DateiOeffnenDialog->FileName;
    MediaPlayer1->Open();
  } // if DateiOeffnen
}
//---------------------------------------------------------------------------

void __fastcall TFrameForm::TrackBarLoudnessLeftChange(TObject *Sender)
{
  unsigned int /*long*/ Volume;
  Volume = TrackBarLoudnessLeft->Position + (TrackBarLoudnessRight->Position << 16);
  waveOutSetVolume (0 /*(void*) MediaPlayer1->DeviceID */,
    (DWORD) Volume);
}
//---------------------------------------------------------------------------

void __fastcall TFrameForm::TrackBarLoudnessRightChange(TObject *Sender)
{
  unsigned int /*long*/ Volume;
  Volume = TrackBarLoudnessLeft->Position + (TrackBarLoudnessRight->Position << 16);
  waveOutSetVolume (0 /*(void*) MediaPlayer1->DeviceID */,
    (DWORD) Volume);
}
//---------------------------------------------------------------------------

void __fastcall TFrameForm::CreateMenuFile1Click(TObject *Sender)
{
  doSaveMenu ();
}
//---------------------------------------------------------------------------

void __fastcall TFrameForm::DeleteMenuFile1Click(TObject *Sender)
{
  delete MenuFile;
  DeleteFile (MenuName);
  MenuFile = new TIniFile (MenuName);
}
//---------------------------------------------------------------------------

void __fastcall TFrameForm::Dir1Click(TObject *Sender)
{
//  system ("c:\\edi\\edi.exe");
  WinExecAndWait32 ("c:\\edi\\edi.exe", SW_SHOW);
//  ExecuteFile (FileName, '', Directory, SW_SHOW);
//  ExecuteFile ("edi.exe", "", "c:\\edi\\", SW_SHOW);
// ShellExecute ... ???
  ShowMessage ("ok?");
}
//---------------------------------------------------------------------------

void __fastcall TFrameForm::Menu1Click(TObject *Sender)
{
/*  char test [256];
  if (Menu_X == NULL) {
    Application->CreateForm (__classid (TMenu_X), &Menu_X);
    Menu_X->Caption = "Throw";
    Menu_X->Menu->Caption = "Drcken Sie eine Taste";
    Menu_X->ShowModal (); // untergeordnetes Formular erzeugen und anzeigen
  }
  else
  {
    Menu_X->ShowModal (); // untergeordnetes Formular erzeugen und anzeigen
//    AllgEinstellDialog->Visible = true;
//    AllgEinstellDialog->BringToFront ();
  }
  //Menu_X->PLL_Key
  strcpy (test, Menu_X->Menu->Caption.c_str());
  Menu_X->Menu->Caption = test;
*/
}
//---------------------------------------------------------------------------

void __fastcall TFrameForm::SpeedButtonSaveAsClick(TObject *Sender)
{
  TEditForm *EdForm;
  if (EdForm = dynamic_cast <TEditForm *> (ActiveMDIChild)){
    EdForm->SaveAs1Click (EdForm);
  }
}
//---------------------------------------------------------------------------


void __fastcall TFrameForm::SpeedButtonFavouritesClick(TObject *Sender)
{
  // Hier Stringlistendialog ffnen ...
  int           i;
  TModalResult  mr;
  FavouriteListe = new TStringList;
  FavouriteListe->Sorted = true;
  FavouriteListe->Duplicates = dupIgnore;
  FavouriteListe->Add (ExtractFileDir (Application->ExeName));
  // list must not be null!
  for (i = 0; i < HistoryListe->Count; i++){
    FavouriteListe->Add (ExtractFileDir (HistoryListe->Strings [i]));
  };

  TStringDialog* StringDialog;
  StringDialog = new TStringDialog (this, "Favoritenliste",
    "Aus Pfad laden", ChangeFileExt (Application->ExeName, ".FAV"),
    FavouriteListe, 0, true, true, false, false, false);
  mr = StringDialog->ShowModal ();
  if (mr == mrOk) {
//    HistoryListe = StringDialog->Liste;
    if (StringDialog->Auswahl != NULL) {
      SetCurrentDir (StringDialog->Auswahl);
      Open1Click (this);
    } // if Auswahlliste != NULL
  }
/*  else
  if (mr == mrYes) {
    HistoryListe = StringDialog->Liste;
  };
*/
  delete StringDialog;
//  delete FavouriteListe; //??
}
//---------------------------------------------------------------------------
void __fastcall TFrameForm::StatusBar1DrawPanel(TStatusBar *StatusBar,
      TStatusPanel *Panel, const TRect &Rect)
{
  if ((Panel->Index == 0) && (Panel->Text != ""))
    StatusBar1->Canvas->Brush->Color = clInfoBk;
  else
    StatusBar1->Canvas->Brush->Color = StatusBar1->Brush->Color;

  StatusBar1->Canvas->FillRect (Rect);
  StatusBar1->Canvas->TextRect (Rect, Rect.Left + 5, Rect.Top + 2, Panel->Text);
}
//---------------------------------------------------------------------------

TMemoryStream *SoundStream = new TMemoryStream();

void __fastcall TFrameForm::Play1Click(TObject *Sender)
{
  if (SoundStream == NULL){
    ShowMessage ("No sound loaded!");
    return;
  }
//  sndPlaySound ((LPCSTR) SoundStream->Memory, SND_MEMORY | SND_ASYNC);
  sndPlaySound ((LPCSTR) SoundStream->Memory, SND_MEMORY | SND_SYNC);
}
//---------------------------------------------------------------------------

void __fastcall TFrameForm::LoadSound1Click(TObject *Sender)
{
  if (DateiFilter != "") DateiOeffnenDialog->Filter = DateiFilter;
  DateiOeffnenDialog->InitialDir = GetCurrentDir ();
  if (SoundStream == NULL) SoundStream = new TMemoryStream();
  if (DateiOeffnenDialog->Execute()) {
    SoundStream->LoadFromFile (DateiOeffnenDialog->FileName);
  }
}
//---------------------------------------------------------------------------

