// Stand: 24. 06. 99
// Version: 0.17

//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "StringForm.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TStringDialog *StringDialog;
//---------------------------------------------------------------------------
__fastcall TStringDialog::TStringDialog(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------
__fastcall TStringDialog::TStringDialog(TComponent* Owner,
                    AnsiString sCaption,
                    AnsiString sButton,
                    AnsiString sFile,
                    TStringList* List,
                    int iDateifilter,
                    bool bLadenEnable,
                    bool bLadenDefault,
                    bool bSpeicherEnable,
                    bool bSpeicherDefault,
                    bool bMultiSelect)
                    : TForm (Owner)
{
  Caption = sCaption;
  if (sButton != "") {
    if (bLadenDefault) ButtonOk->Caption = sButton;
    else if (bSpeicherDefault) ButtonOk->Caption = sButton;
  }
  if (sFile != "") Dateivorwahl = sFile;
  FListe = List;
  if (List != NULL) StringListUebernehmen (List);
  ListViewStringDialog->MultiSelect = bMultiSelect;
} // TStringDialog
//---------------------------------------------------------------------------
void __fastcall TStringDialog::StringListUebernehmen (TStringList* SL)
{
  int           i;
  TListItem*    ListItem;
  int           maxLength = 0;
  const int     xOffset = 50;
/*
  for (i = 0; i < ListViewStringDialog->Items->Count; i++){
    ListViewStringDialog->Items->Delete(i);
  } // for
*/
// hm - das lscht Spaltenbreite, obiges nicht! Geht aber auch nicht!
  ListViewStringDialog->Items->Clear ();
  ListViewStringDialog->Items->BeginUpdate();
  for (i = 0; i < SL->Count; i ++){
    ListItem = ListViewStringDialog->Items->Add ();
    ListItem->Caption = SL->Strings [i];
    int length = ListViewStringDialog->StringWidth (ListItem->Caption);
    if (length + xOffset > maxLength) maxLength = length + xOffset;
    if (ImageListStrings->Count > 0) ListItem->ImageIndex = 0;
  } // for
  ListView_SetColumnWidth (ListViewStringDialog->Handle, NULL, maxLength);
  ListViewStringDialog->Items->EndUpdate();
//  ListViewStringDialog->Column [0]->Width = ColumnTextWidth;
}
//---------------------------------------------------------------------------
void __fastcall TStringDialog::FormCreate(TObject *Sender)
{
  if (FileExists (ExtractFilePath (Application->ExeName) + "buch.bmp")){
    Graphics::TBitmap* myIcon = new (Graphics::TBitmap);
    myIcon->LoadFromFile (ExtractFilePath (Application->ExeName) + "slr.bmp");
    ImageListStrings->Add (myIcon, NULL);
  } // if
}
//---------------------------------------------------------------------------
void __fastcall TStringDialog::FormShow(TObject *Sender)
{
  ListViewStringDialog->ItemFocused = ListViewStringDialog->Items->Item [0];
  if (ListViewStringDialog->ItemFocused != NULL) {
    EditStringDialog->Text = ListViewStringDialog->ItemFocused->Caption;
    ListViewStringDialog->Selected = ListViewStringDialog->ItemFocused;
  }
}
//---------------------------------------------------------------------------

void __fastcall TStringDialog::ListViewStringDialogClick(TObject *Sender)
{
  if (ListViewStringDialog->ItemFocused != NULL) {
    EditStringDialog->Text = ListViewStringDialog->ItemFocused->Caption;
  }
}
//---------------------------------------------------------------------------

void __fastcall TStringDialog::ListViewStringDialogChange(TObject *Sender,
      TListItem *Item, TItemChange Change)
{
  if (ListViewStringDialog->ItemFocused != NULL) {
    EditStringDialog->Text = ListViewStringDialog->ItemFocused->Caption;
  }
}
//---------------------------------------------------------------------------

void __fastcall TStringDialog::ListViewStringDialogDblClick(
      TObject *Sender)
{
  ListViewStringDialogClick (Sender);
  ModalResult = mrOk;
}
//---------------------------------------------------------------------------

void __fastcall TStringDialog::ButtonEintragHinzufuegenClick(
      TObject *Sender)
{
  TListItem*     ListItem;
  if (ListViewStringDialog->FindCaption (0, EditStringDialog->Text, false, true, false) == NULL){
    ListItem = ListViewStringDialog->Items->Add ();
    ListItem->Caption = EditStringDialog->Text;
  }
}
//---------------------------------------------------------------------------

void __fastcall TStringDialog::ButtonEintragLoeschenClick(TObject *Sender)
{
  TListItem*     ListItem;
  ListItem = ListViewStringDialog->FindCaption (0, EditStringDialog->Text, false, true, false);
  if (ListItem != NULL)
    ListViewStringDialog->Items->Delete (ListViewStringDialog->Items->IndexOf (ListItem));
}
//---------------------------------------------------------------------------

void __fastcall TStringDialog::ButtonEintraegeSortierenClick(
      TObject *Sender)
{
  ListViewStringDialog->SortType = stText;
}
//---------------------------------------------------------------------------


void __fastcall TStringDialog::ButtonOkClick(TObject *Sender)
{
  StringListMachen (FListe);
  ModalResult = mrOk;
}
//---------------------------------------------------------------------------
void __fastcall TStringDialog::StringListMachen (TStringList* SL)
{
  int           i;
  if (SL != NULL) SL->Clear ();
  else SL = new TStringList;
  for (i=0; i < ListViewStringDialog->Items->Count; i++) {
    SL->Add (ListViewStringDialog->Items->Item [i]->Caption);
  }
}
//---------------------------------------------------------------------------
void __fastcall TStringDialog::DateiLaden (AnsiString Name)
{
  TStringList* SL;
  SL = new TStringList;
  SL->LoadFromFile (Name);
  StringListUebernehmen (SL);
  delete SL;
}
//---------------------------------------------------------------------------
void __fastcall TStringDialog::DateiSpeichern (AnsiString Name)
{
  TStringList* SL;
  SL = new TStringList;
  StringListMachen (SL);
  SL->SaveToFile (Name);
  delete SL;
}
//---------------------------------------------------------------------------
void __fastcall TStringDialog::ButtonUebernehmenClick(TObject *Sender)
{
  StringListMachen (FListe);
}
//---------------------------------------------------------------------------

void __fastcall TStringDialog::Listeladen1Click(TObject *Sender)
{
//  if (DateiFilter != "") DateiOeffnenDialog->Filter = DateiFilter;
  OpenDialog1->Title = "Historyliste laden";
  OpenDialog1->InitialDir = ExtractFileDir (Application->ExeName);
  if (OpenDialog1->Execute()) {
    DateiLaden (OpenDialog1->FileName);
  }
}
//---------------------------------------------------------------------------

void __fastcall TStringDialog::Listespeichern1Click(TObject *Sender)
{
  SaveDialog1->Title = "Historyliste speichern";
  SaveDialog1->InitialDir = ExtractFileDir (Application->ExeName);
  if (SaveDialog1->Execute()) {
    DateiSpeichern (SaveDialog1->FileName);
  }
}
//---------------------------------------------------------------------------
void __fastcall TStringDialog::Abbrechen1Click(TObject *Sender)
{
//  Close ();
  ModalResult = mrCancel;
}
//---------------------------------------------------------------------------
void __fastcall TStringDialog::Abbrechen2Click(TObject *Sender)
{
//  Close ();
  ModalResult = mrCancel;
}
//---------------------------------------------------------------------------

void __fastcall TStringDialog::ElementandenAnfang1Click(TObject *Sender)
{
  AnsiString    ListItem;
  TListItem*    h;

  if (ListViewStringDialog->Selected != NULL){
    ListItem = ListViewStringDialog->Selected->Caption;
    ListViewStringDialog->Items->Delete
      (ListViewStringDialog->Items->IndexOf
        (ListViewStringDialog->Selected));
    h = ListViewStringDialog->Items->Insert (0);
    h->Caption = ListItem;
    h->Selected = true; h->Focused = true;
    h->MakeVisible (true);
  };
}
//---------------------------------------------------------------------------

void __fastcall TStringDialog::ElementansEnde1Click(TObject *Sender)
{
  AnsiString    ListItem;
  TListItem*    h;

  if (ListViewStringDialog->Selected != NULL){
    ListItem = ListViewStringDialog->Selected->Caption;
    ListViewStringDialog->Items->Delete
      (ListViewStringDialog->Items->IndexOf
        (ListViewStringDialog->Selected));
    h = ListViewStringDialog->Items->Add ();
    h->Caption = ListItem;
    h->Selected = true; h->Focused = true;
    h->MakeVisible (true);
  };
}
//---------------------------------------------------------------------------

void __fastcall TStringDialog::Elementeinsnachoben1Click(TObject *Sender)
{
  AnsiString    ListItem;
  TListItem*    h;
  int           Index;

  if (ListViewStringDialog->Selected != NULL){
    ListItem = ListViewStringDialog->Selected->Caption;
    Index = ListViewStringDialog->Items->IndexOf
        (ListViewStringDialog->Selected);
    if (Index > 0) Index--;
    ListViewStringDialog->Items->Delete
      (ListViewStringDialog->Items->IndexOf
        (ListViewStringDialog->Selected));
    h = ListViewStringDialog->Items->Insert (Index);
    h->Caption = ListItem;
    h->Selected = true; h->Focused = true;
    h->MakeVisible (true);
  };
}
//---------------------------------------------------------------------------
TStringList* __fastcall TStringDialog::ReadListe ()
{
  return FListe;
}
//---------------------------------------------------------------------------
TStringList* __fastcall TStringDialog::ReadAuswahlListe ()
{
  TStringList*  reslist;
  int           i;
  TListItem*    Item;
  TItemStates   States;
  if (ListViewStringDialog->Selected != NULL) {
    reslist = new TStringList;
    i = 0;
    Item = ListViewStringDialog->Selected;
    reslist->Add (Item->Caption);
    i++;
    States << isSelected;
    while (i < ListViewStringDialog->SelCount){
      Item = ListViewStringDialog->GetNextItem (Item, sdAll, States);
      if (Item->Selected) {
        reslist->Add (Item->Caption);
        i++;
      } // if Item->Selected
    } // while
    return reslist;
  } // if Selected != NULL
  else return NULL;
}
//---------------------------------------------------------------------------
AnsiString __fastcall TStringDialog::ReadAuswahl ()
{
  if (ListViewStringDialog->Selected != NULL) {
    return ListViewStringDialog->Selected->Caption;
  }
  else return "";
}
//---------------------------------------------------------------------------
void __fastcall TStringDialog::Elementeinsnachunten1Click(TObject *Sender)
{
  AnsiString    ListItem;
  TListItem*    h;
  int           Index;

  if (ListViewStringDialog->Selected != NULL){
    ListItem = ListViewStringDialog->Selected->Caption;
    Index = ListViewStringDialog->Items->IndexOf
        (ListViewStringDialog->Selected);
    Index++;
    ListViewStringDialog->Items->Delete
      (ListViewStringDialog->Items->IndexOf
        (ListViewStringDialog->Selected));
    h = ListViewStringDialog->Items->Insert (Index);
    h->Caption = ListItem;
    h->Selected = true; h->Focused = true;
    h->MakeVisible (true);
  };
}
//---------------------------------------------------------------------------

void __fastcall TStringDialog::ListViewStringDialogKeyDown(TObject *Sender,
      WORD &Key, TShiftState Shift)
{
  TShiftState leer;
  if ((Shift == leer) && (Key == VK_ESCAPE)) {
    Close();
  }
}
//---------------------------------------------------------------------------

