program hackread;
{liest Rohdaten aus einer Telefonkarte und dekodiert sie.}
{Geht sicher noch einfacher...   ist naemlich}
{Carsten Meyer's erster Turbo-Pascal-Versuch am PC}
{Mac-Version HyperCard XCMD ebenfalls verfgbar}

uses crt;

 const

   OutPort = $378;      {Rechnerabhngig!!}
   InPort = $379;

   AllOff = 0;
   Clk0Rst0 = 213;
   Clk1Rst0 = 197;
   Clk0Rst1 = 149;
   Clk1Rst1 = 133;

 var
   n,m,OutByte,Position,Rest,Code,Pruef,Hersteller,Jahr,Monat: word;
   TempStr, NumStr, SerNrStr: String[10];
   BitArray: array[0..127] of word;
   WertArray: array[0..15] of String[5];
   HerstellerArray: array[0..15] of String[31];

 procedure wait;    {begnadete Warteschleife}
 begin
   for n := 1 to 10 do
     ;
 end;

 procedure ResetSequenz;
{Karte zurcksetzen}
 begin
   port[OutPort] := Clk0Rst0;
   wait;
   port[OutPort] := Clk0Rst1;
   for n := 1 to 10 do
     begin
       wait;
       port[OutPort] := Clk1Rst1;
       wait;
       port[OutPort] := Clk0Rst1;
     end;
   port[OutPort] := Clk0Rst0;
 end;

 function ReadBit: Integer;
{einzelnes Bit lesen und Clock-Impuls fr nchstes Bit erzeugen}
 begin
   wait;
   ReadBit := 0;
   if Port[InPort] > 127 then
     ReadBit := 1;
   port[OutPort] := Clk1Rst0;
   wait;
   port[OutPort] := Clk0Rst0;
 end;

 procedure ReadArray;
{Array rckwrts einlesen}
   var
     count: Integer;
 begin
   ResetSequenz;
   for count := 127 downto 0 do
     BitArray[count] := ReadBit;
   port[OutPort] := AllOff;
 end;

 function AddBits (Start: integer): integer;
{Bits eines Byte addieren, fr Gebhrenstand}
   var
     count, temp: integer;
 begin
   temp := 0;
   for count := Start to Start + 7 do
     temp := temp + BitArray[count];
   AddBits := temp;
 end;

 function ShiftNibble (Start: integer): Integer;
{Bits eines Nibble sammeln}
   var
     count, temp: word;
 begin
   temp := 0;
   for count := Start to Start + 3 do
     begin
       m:=BitArray[count];
       temp := temp * 2 + BitArray[count];
     end;
   ShiftNibble := temp;
 end;

begin {main}
 for n:=0 to 15 do
    WertArray[n]:='--,--';
 for n:=0 to 15 do
    HerstellerArray[n]:='unbekannt';
 WertArray[3]:='01,50';
 WertArray[4]:='06,00';
 WertArray[5]:='12,00';
 WertArray[6]:='60,00';
 WertArray[7]:='50,00';
 HerstellerArray[0]:='Orga Kartensysteme';
 HerstellerArray[1]:='Giesecke & Devrient';
 HerstellerArray[2]:='Oldenbourg Datensysteme';
 HerstellerArray[3]:='Gemplus';
 HerstellerArray[4]:='Solaic';
 HerstellerArray[5]:='Uniqa';
 HerstellerArray[6]:='Schlumberger';
 ReadArray;

 {Reststand in Pfennigen berechnen}
 Position := 24;   {Startadresse der Gebhren-Bits}
 m := 1;
 for n := 1 to 5 do
 begin
   Rest := Rest + m * AddBits(Position);
   m:=m*8;
   Position := Position + 8;
 end;

 SerNrStr := ''; {Seriennummer zusammensetzen}
 for n := 1 to 5 do
   begin
     Str(ShiftNibble(Position):1,TempStr);
     Position := Position + 4;
     SerNrStr := SerNrStr+TempStr;
   end;
 Monat := ShiftNibble(Position);
 Position := Position + 4;
 Jahr := 80+ShiftNibble(Position);
 if Jahr < 85 then
   Jahr := Jahr+10;
 Position := Position + 4;
 Code := ShiftNibble(Position);
 Position := Position + 4;
 Pruef := ShiftNibble(Position);
 Position := Position + 4;
 Hersteller := ShiftNibble(Position);

 writeln;  {oder clrscr;}
 writeln('Hack-O-Mat Kartenleser by Carsten Meyer (C) 8/1993');
 writeln('Rohdaten rckwrts:');
 for n := 0 to 63 do {Rohdaten anzeigen}
   write(BitArray[n] : 1);
 writeln;
 for n := 64 to 127 do
   write(BitArray[n] : 1);
 writeln;
 n:=Rest div 100;
 m:=Rest mod 100;
 writeln('Restbetrag: ', n,' DM ',m:2,' Pfennige (nicht gerundet)');
 writeln('Seriennummer: ', SerNrStr);
 writeln('Monat: ', Monat);
 writeln('Jahr: ', Jahr);
 writeln('Preis-Code: ', Code, ' (',WertArray[Code],' DM)');
 writeln('Prfwert: ', Pruef);
 writeln('Hersteller-Code: ', Hersteller, ' (',HerstellerArray[Hersteller],')');
end. {main}

