;       Makecodes der Umschalttasten

Special DB 54   ; Shift right
        DB 42   ; Shift left
        DB 29   ; Ctrl
        DB 56   ; Alt
        DB 70   ; Scroll Lock
        DB 69   ; Num Lock
        DB 58   ; Caps Lock
        DB 82   ; Insert

; deutsche Umkodiertabelle, je 2 Bytes pro Eintrag:
; ASCII mit Shift, ASCII ohne Shift, Tastennum. (Kommentar)

GerTbl  db 1BH,1BH  ; 01  esc   esc
        db '!','1'  ; 02  !     1
        db '"','2'  ; 03  "     2
        db 15H,'3'  ; 04        3
        db '$','4'  ; 05  $     4
        db '%','5'  ; 06  %     5
        db '&','6'  ; 07  &     6
        db '/','7'  ; 08  /     7
        db '(','8'  ; 09  (     8
        db ')','9'  ; 10  )     9
        db '=','0'  ; 11  =     0
        db '?',0e1h ; 12  ?     
        db 60H,27H  ; 13  `     '
        db 08H,08H  ; 14  bs    bs

        db 00H,09H  ; 15  nul   tab
        db 'Qq'     ; 16
        db 'Ww'     ; 17
        db 'Ee'     ; 18
        db 'Rr'     ; 19
        db 'Tt'     ; 20
        db 'Yy'     ; 21
        db 'Uu'     ; 22
        db 'Ii'     ; 23
        db 'Oo'     ; 24
        db 'Pp'     ; 25
        db 9ah,81h  ; 26
        db '*','+'  ; 27
        db 0DH,0DH  ; 28  cr     cr

        db -1,-1    ; 29  ctrl
        db 'Aa'     ; 30  A     a
        db 'Ss'     ; 31  S     s
        db 'Dd'     ; 32  D     d
        db 'Ff'     ; 33  F     f
        db 'Gg'     ; 34  G     g
        db 'Hh'     ; 35  H     h
        db 'Jj'     ; 36  J     j
        db 'Kk'     ; 37  K     k
        db 'Ll'     ; 38  L     l
        db 99h,94h  ; 39       
        db 8eh,84h  ; 40       
mf1     label word
;       db 0f8h,'^' ; 41       ^   MF
;       db '><'     ; 41  >     <   AT
        db '^','#'  ; 41  ^     #   ; hier wird gepatcht!
        db -1,-1    ; 42  shift
mf2     label word
;       db 027h,'#' ; 43  #     '   MF
;       db '^','#'  ; 43  ^     #   AT
        db '>','<'  ; 43  >     <   ; hier wird gepatcht!
        db 'Zz'     ; 44  Z     z
        db 'Xx'     ; 45  X     x
        db 'Cc'     ; 46  C     c
        db 'Vv'     ; 47  V     v
        db 'Bb'     ; 48  B     b
        db 'Nn'     ; 49  N     n
        db 'Mm'     ; 50  M     m
        db ';',','  ; 51  ;     ,
        db ':','.'  ; 52  ;     .
        db '_','-'  ; 53  _     -
        db -1,-1    ; 54

        db 00H,2AH  ; 55  prtscr
        db -1,-1    ; 56  shift
        db 20H,20H  ; 57  space
        db '>','<'  ; 86  >     <

; nicht alle Tasten sind mit ALT definiert
; je 3 Bytes: Tastennummer, code mit ALT, code mit ALT SHIFT

AltTbl  db 03,     -1,    '@'     ; 2

at1     label byte
        db 41,    248,    '~'     ; #/^
mf3     label byte
        db 43,    '\',    '|'     ; </>
        db 26,    '[',    '{'     ; 
        db 27,    ']',    '}'     ; */+
        db -1                     ; end marker

; 5 Tabellen fr Grafikzeichen

AltGrTbls   dw  AltGrTbl      ; normal, Alt Ctlr f5
            dw  GSet1         ; Alt Ctrl f6
            dw  GSet2         ; Alt Ctrl f7
            dw  GSet3         ; Alt Ctrl f8
            dw  GSet4         ; Alt Ctrl f9

; "kleine" Zeichen auf der MF-Tastatur
;  und griechische Zeichen sind mit ALT CTRL erreichbar
;  je 2 Bytes:  Tastennummer ASCII-Code

AltGrTbl db 03,    253     ; 2  superscript 2
        db 04,     252     ; 3  superscript n
        db 05,     156     ; 4  pound sign
        db 08,     '{'     ; 7
        db 09,     '['     ; 8
        db 10,     ']'     ; 9
        db 11,     '}'     ; 0
        db 12,     '\'     ; ?/
        db 16,     '@'     ; Q
        db 17,     251     ; 
        db 18,     238     ; 
        db 19,     231     ; 
        db 20,     233     ; 
        db 21,     157     ; 
        db 23,     244     ; 
        db 24,     234     ; 
        db 25,     227     ; 
        db 27,     '~'     ; */+
        db 30,     224     ; 
        db 31,     229     ; 
        db 32,     235     ; 
        db 33,     232     ; 
        db 34,     226     ; 
        db 36,     245     ; 
mf4     label byte
        db 43,     '|'     ; </>
        db 44,     228     ; 
        db 46,     155     ; 
        db 48,     225     ; 
        db 49,     239     ; 
        db 50,     230     ; 
        db 51,     249     ;   (,)
        db 52,     250     ;   (.)
        db 53,     246     ;   keypad / (and -)
        db 57,     255     ; special space
        db 74,     254     ;   keypad -
        db 75,     172     ;  keypad 4
        db 78,     241     ;   keypad +
        db 80,     171     ;  keypad 2
        db -1              ; end marker

;--------------
; box with simple outlines

Gset1   db 17,     0b0h   ; w 25 %
        db 31,     0b1h   ; s 50 %
        db 45,     0b2h   ; x 75 %
        db 22,     0dbh   ; u 100%
        db 36,     0dfh   ; j upper half
        db 50,     0dch   ; m lower half
        db 37,     0ddh   ; k left half
        db 51,     0deh   ; , right half

        db 18,     0dah
        db 19,     0c2h
        db 20,     0c4h
        db 44,     0bfh
        db 32,     0c3h
        db 33,     0c5h
        db 34,     0b3h
        db 35,     0b4h
        db 46,     0c0h
        db 47,     0c1h
        db 48,     0c4h
        db 49,     0d9h
        db -1

; box with double outlines

Gset2   db 18,     0c9h
        db 19,     0cbh
        db 20,     0cdh
        db 44,     0bbh
        db 32,     0cch
        db 33,     0ceh
        db 34,     0bah
        db 35,     0b9h
        db 46,     0c8h
        db 47,     0cah
        db 48,     0cdh
        db 49,     0bch
        db -1

; box with double outlines hor / single outlines ver

Gset3   db 18,     0d5h
        db 19,     0d1h
        db 20,     0cdh
        db 44,     0b8h
        db 32,     0c6h
        db 33,     0d8h
        db 34,     0b3h
        db 35,     0b5h
        db 46,     0d4h
        db 47,     0cfh
        db 48,     0cdh
        db 49,     0beh
        db -1

; box with double outlines ver / single outlines hor

Gset4   db 18,     0d6h
        db 19,     0d2h
        db 20,     0c4h
        db 44,     0b7h
        db 32,     0c7h
        db 33,     0d7h
        db 34,     0bah
        db 35,     0b6h
        db 46,     0d3h
        db 47,     0d0h
        db 48,     0c4h
        db 49,     0bdh
        db -1
;--------------
; Tabelle der Controlzeichen fr

;            1    2    3    4    5    6    7    8    9    0
CtrlTBL   db 01BH,000H,000H,000H,000H,000H,01EH,000H,000H,000H
          db 000H,01FH,000H,07FH,  -1,011H,017H,005H,012H,014H
          db 019H,015H,009H,00FH,010H,01BH,01DH,00AH,  -1,001H
          db 013H,004H,006H,007H,008H,00AH,00BH,00CH,  -1,  -1
          db   -1,  -1,  -1,01AH,018H,003H,016H,002H,00EH,00DH
          db   -1,  -1,01FH,  -1,  -1,  -1,020H
;--------------
NPad      db 07H,08H,09H,  -1
          db 04H,05H,06H,  -1
          db 01H,02H,03H
          db 00H,  -1

CtrlNPad  db 119,141,132,142
          db 115,143,116,144
          db 117,145,118
          db 146,147

AltNPad   db 151,152,153,154
          db 155,156,157,158
          db 159,160,161
          db 162,163

;-- apostrophe tables -------------------------
if apox
Apo     dw  0
ApoPtr  dw  0
ApoTbl  db  027h              ;'
        db  'a',0a0h,'e',082h,'i',0a1h,'o',0a2h
        db  'u',0a3h,'E',090h,'c',087h,'C',080h,'y',098h
        db  '!',173,'?',168
        db  -1
        db  '`'
        db  'a',085h,'e',08ah,'i',08dh,'o',095h,'u',097h
        db  -1
        db  '^'
        db  'a',083h,'e',088h,'i',08ch,'o',093h,'u',096h
        db  -1
        db  '~'
        db  'n',0a4h,'N',0a5h
        db  -1
        db  248      ; ''
        db  'a',086h,'A',08fh
        db  -1
        db  -1
endif
;-------------------------------------
update    db    0
gselect   db    0
id        label word
id1       db    0
id2       db    0
AltFlg    db    0
;-------------------------------------
oldv      db    0
oldvec    dw    0,0
oldv16    dw    0,0
