PROGRAM ScanCode;
{fr alle Tastaturen, PC und AT}
uses crt; {Turbo 4.0}
  {$i misc}

var
  s : str4;
  s2 : String[2];
  ascii : Char;
  code : Byte;
  wholecode : Integer ABSOLUTE ascii;

  KbFlag : Byte ABSOLUTE $40 : $17;
  KbFlag1 : Byte ABSOLUTE $40 : $18;
  KbFlag2 : Byte ABSOLUTE $40 : $97;
  KbFlag3 : Byte ABSOLUTE $40 : $96;

  BufferHead : Integer ABSOLUTE $40 : $1A;
  BufferTail : Integer ABSOLUTE $40 : $1C;

  {mit dieser Routine greift man direkt auf den Tastatur-}
  {buffer zu, bevor INT 16 eingreift}

  PROCEDURE ReadKBDDirect
    (VAR code : Byte; VAR c : Char);
  BEGIN
    REPEAT UNTIL BufferHead <> BufferTail;
    code := Mem[$40:BufferHead+1];
    c := Chr(Mem[$40:BufferHead]);

    BufferHead := BufferHead+2;     {Integer - Ringpuffer}
    IF BufferHead = $3E THEN BufferHead := $1E;
  END;

  {mit dieser Routine holt man Tastencodes auf}
  {dem "normalen" Weg ber INT 16}

  PROCEDURE ReadKBDInt16
    (VAR code : Byte; VAR c : Char);
  BEGIN
    INLINE(
      $31/$C0             {xor ax,ax}
      /$CD/$16            {int $16}
      /$C4/$7E/< code     {les di,[bp+<code]}
      /$26                {es:}
      /$88/$25            {mov [di],ah}
      /$C4/$7E/< c        {les di,[bp+<c]}
      /$26                {es:}
      /$88/$05            {mov [di],al}
      );
  END;

BEGIN
  ClrScr;
  Highvideo;
  WriteLn;
  WriteLn(' *** ScanCode, Ver 2.2, 16-jun-88 -mat *** ');
  WriteLn;
  WriteLn(' Zeigt Tastencodes und ASCII-Werte.');
  WriteLn(' Ende mit < CTRL ALT C >.');
  WriteLn;
  Lowvideo;
  WriteLn(' Scancode   Ascii      ',
  'InsCapNumScrAltCtlShrShl  InsCapNumScrPauSysAltCtl');
  Gotoxy(24,10);
  Writeln
  ('TErModResAck---CapNumScr  ID-ID-NL-MF-RAlRCtE0-E1-');

  REPEAT
    ReadKBDDirect(code, ascii); {<- hier Routine wechseln}
    case ascii of
    #8,#10,#13 : s2 := ' ';
    #7 : s2 := #7' ';
    else s2 := ascii;
    end;

    HighVideo;
    GotoXY(1,8);
    Write(#13,                          {zum Zeilenanfang}
    ' $',ByteToHex(code),code:4,  {scancode hex + dezimal}
    '    $',ByteToHex(Ord(ascii)),        {ASCII-Wert hex}
    '   >', s2, '<   ',                    {ASCII-Zeichen}
    BinOut(KbFlag), '  ',                  {KB-Flag 40:17}
    BinOut(KbFlag1));                      {KB-Flag 40:18}
    GotoXY(25,11);
    Write(
    BinOut(KbFlag2), '  ',                 {KB-Flag 40:97}
    BinOut(KbFlag3));                      {KB-Flag 40:96}

  UNTIL ((KbFlag AND $c) = $c) AND (code = $2e);
END.
