program autopark;
{c't - A.S. 6/88  Turbo Pascal 4.0 }
{$R-,S-,I-,D-,T-,F-,V+,B-,N-,L+ }
{$M 1024,0,0 }

uses DOS,CRT;
const timeout         =  182; { fr 10 Sekunden }

      Master_Steuer   = $20;
      Enable_ISR      = $0B;

      direkt:boolean  =false;
      parked:boolean  =false;
      intsema:boolean =false;
      time_cnt:integer=0;

var reg               :registers;
    Master_ISR        :byte;
    alt_8             :pointer;
    alt_13            :pointer;
    vektor            :pointer;
    parkzyl           :word;
    error             :integer;

{ Einige wichtige Inline-Macros, vervollstndigen
  den Umgang von Interrupts unter Turbo-Pascal 4.0.
  Inline-Macros werden vom Compiler direkt als Code
  eingebunden.}
{**************************************************}

procedure CLI; inline ($FA);
procedure STI; inline ($FB);

procedure get_regs;
  { Setzt die Prozessorregister auf die Werte
    AX, BX etc. innerhalb einer INTERRUPT-Routine  }
 inline ($8B/$46/$16/$50/$9D/{Flags vom INTR-Stapel}
         $8B/$46/$10/        {AX       "           }
         $8B/$5E/$0E/        {BX       "           }
         $8B/$4E/$0C/        {CX       "           }
         $8B/$56/$0A/        {DX       "           }
         $8B/$76/$08/        {SI       "           }
         $8B/$7E/$06/        {DI       "           }
         $8E/$46/$02);       {ES       "           }

{      gegebenenfalls zustzlich, falls DS bentigt
       oder DS oder BP verndert wird
   inline(                    PUSH    DS
                              PUSH    BP
         $8C/$5E/$04);         DS      von Stapel  }



procedure set_regs;
   { Setzt die Werte AX,BX, etc. innerhalb einer
     INTERRUPT-Routine auf die aktuellen Inhalte
     der Prozessorregister                         }
inline  ($89/$46/$10/        {AX   auf INTR-Stapel }
         $9C/$58/$89/$46/$16/{Flags    "           }
         $89/$5E/$0E/        {BX       "           }
         $89/$4E/$0C/        {CX       "           }
         $89/$56/$0A/        {DX       "           }
         $89/$76/$08/        {SI       "           }
         $89/$7E/$06/        {DI       "           }
         $8C/$46/$02);       {ES       "           }
{ gegebenenfalls zustzlich
                             POP      BP
        $8C/$5E/$04/         DS      auf Stapel
                             POP      DS           }

procedure call_int(vektor:pointer);
inline ($8F/$06/vektor/   {hole Adresse vom Stack }
        $8F/$06/vektor+2/ {       "               }
        $9C/              { PushF                 }
        $FA/              { CLI                   }
        $FF/$1E/vektor);  { CALL FAR [vektor]     }

{*************************************************}

Procedure seek(n:word);
begin
if n=0 then reg.ah:=$11   { recalibrate }
       else reg.ah:=$0C;  { seek        }
reg.dx:=$0080;
reg.ch:=lo(n);
reg.cl:=hi(n) shl 6;
direkt:=true;
intr($13,reg);
direkt:=false;
end;

procedure int_8;
interrupt;
begin
call_int (alt_8);
if not parked then
  { ... and not intsema,
    falls kein Parken whrend Disk-Operation       }

     begin
     if time_cnt < timeout then
        inc (time_cnt)
    else
       begin
       port[Master_steuer]:=Enable_ISR;
       Master_ISR:=port[Master_steuer];
       if (Master_ISR and 7) = 0 then
         begin
         seek (parkzyl);
         parked:=true;
         end;
      end
   end
end;

procedure int_13
      (flags,cs,ip,ax,bx,cx,dx,si,di,ds,es,bp:word);
interrupt;
begin
{intsema=true  falls kein Parken whrend Disk-Op.  }
if (lo(dx) = $80) and not direkt then
    begin
      if parked then seek(0);
      parked:=false;
      time_cnt:=0;
     end;
Get_regs;
call_int (alt_13);
Set_regs;
{intsema=false  falls kein Parken whrend Disk-Op. }

end;

begin
if paramcount > 0 then
   val (paramstr(1),parkzyl,error);
if (paramcount = 0) or (error > 0) then
  begin
  write ('gewnschter Parkzylinder: ');
  readln (parkzyl);
  end;
getIntVec ($13,alt_13);
setintVec ($13,@int_13);
getIntVec ($8,alt_8);
setIntVec ($8,@int_8);
write ('Autopark fr Parkzylinder ');
  writeln (parkzyl, ' installiert');
keep (0);
end.


