program showint;
{$R-,S-,I-,D-,T-,F-,V+,B-,N-,L+ }
{$M 1024,0,0 }
{c't - A.S. 6/88  Turbo Pascal 4.0 )
{Anzeige von Hardware-Interrupts}
uses DOS,CRT;
var inttable            :array [0..255] of pointer;
    i                   :integer;
    aufrufe             :integer;
    ch                  :char;
    altx,alty           :integer;
    exitsave            :pointer;
    var shot            :integer;
    screen              :array [1..25,1..80,0..1] of
                         byte absolute $B800:00;
    ISR_M,IRR_M,IRM_M   :byte;
    ISR_S,IRR_S,IRM_S   :byte;

procedure call_old_int(vektor:pointer);
begin
inline ($9C/$FF/$9E/vektor)
end;

Procedure writebin (x,y,b:byte);
var i:integer;
begin
 for i:=1 to 8 do
   begin
   if b>=$80 then screen[y,x+i,0]:=$31
             else screen[y,x+i,0]:=$30;
   b:=b shl 1
   end;
end;

procedure show_is (inter:byte);
begin
 port[$20]:=$0B;  writebin (50,1,port[$20]);
 port[$A0]:=$0B;  writebin (60,1,port[$A0]);
end;

procedure show (inter:byte);
var x:byte;
begin
 shot:=5;
 show_IS (inter);
 call_old_int(inttable[inter]);
end;


{ Master-Interrupts }
procedure int8h;
interrupt;
begin
 port[$20]:=$0B;
 ISR_M:=port[$20];
 dec (shot);
 if (shot = 0) or (ISR_M > 1) then show ($8)
             else call_old_int(inttable[8]);
end;

procedure int9h; interrupt; begin show ($9) end;
procedure intAh; interrupt; begin show ($A) end;
procedure intBh; interrupt; begin show ($B) end;
procedure intCh; interrupt; begin show ($C) end;
procedure intDh; interrupt; begin show ($D) end;
procedure intEh; interrupt; begin show ($E) end;
procedure intFh; interrupt; begin show ($F) end;

procedure int70h; interrupt; begin show ($70) end;
procedure int71h; interrupt; begin show ($71) end;
procedure int72h; interrupt; begin show ($72) end;
procedure int73h; interrupt; begin show ($73) end;
procedure int74h; interrupt; begin show ($74) end;
procedure int75h; interrupt; begin show ($75) end;
procedure int76h; interrupt; begin show ($76) end;
procedure int77h; interrupt; begin show ($77) end;

{$F+}Procedure Myexit {F-};
  Begin
   for i:=0 to 255 do setintVec (i,inttable[i]);
   ExitProc:=Exitsave;
   nosound;
  End;

begin
for i:=0 to 255 do getintVec (i,inttable[i]);
exitsave:=exitproc;
exitproc:=@myexit;
ch:=' ';
aufrufe:=0;
setintvec ($8,@int8h); setintvec ($9,@int9h);
setintvec ($A,@intAh); setintvec ($B,@intBh);
setintvec ($C,@intCh); setintvec ($D,@intDh);
setintvec ($E,@intEh); setintvec ($F,@intFh);

setintvec ($70,@int70h); setintvec ($71,@int71h);
setintvec ($72,@int72h); setintvec ($73,@int73h);
setintvec ($74,@int74h); setintvec ($75,@int75h);
setintvec ($76,@int76h); setintvec ($77,@int77h);

clrscr;
keep(0);
end.
