#define STRICT

#include "wclsinc.h"
#include "msghash.h"

MessageMap::MessageMap()
{
  pTable=new MSGHashTable(&AbstractWindow::HandleMessage,DefaultHashSize);
}

void MessageMap::Message(UINT Message,PMSGHandler pHandler)
{
  pTable->AddMessage(Message,pHandler);
}

MessageMap::~MessageMap()
{
  delete pTable;
}

void MetaClass::Message(UINT Message,PMSGHandler pHandler)
{
  if (!pMap) // Noch keine lokale Messagemap vorhanden ?
    pMap= CreateOwnMessageMap();

  pMap->Message(Message,pHandler);
}

MessageMap *MetaClass::CreateOwnMessageMap()
{
  return new MessageMap();
}

MessageMap *MetaClass::GetMap()
{
  if (!pMap)
    pMap= CreateOwnMessageMap();

  return pMap;
}

void MetaClass::DeleteInstance(AbstractWindow * pWindow)
{
  delete pWindow;
}

MetaClass::MetaClass()
{
  pMap=NULL;
}

MetaClass::~MetaClass()
{
  if (pMap) delete pMap;
}

AbstractWindow::AbstractWindow(MetaClass *pMeta,HWND hWnd)
{
  WinHandle=hWnd;
  pMetaClass=pMeta;
  pMSGHashTable= pMeta->GetHashTable();
}

AbstractWindow::~AbstractWindow()
{
}

/* Zentrale Nachrichtenbehandlung */

LRESULT AbstractWindow::HandleMessage(UINT msg, WPARAM wParam, LPARAM lParam)
{
  return CallDefProc(msg,wParam,lParam);
}

LRESULT AbstractWindow::AbstractWndProc(HWND hWnd,
                                        AbstractWindow *w,UINT uMsg,
                                        WPARAM wParam,LPARAM lParam)
{
   if (w) {
    if (uMsg==WM_NCDESTROY) {
      w->gMetaClass()->DeleteInstance(w);
      return 0;
    }
      return (w->*(*w->pMSGHashTable)[uMsg])(uMsg,wParam,lParam);
  } else
      return DefWindowProc(hWnd,uMsg,wParam,lParam);
}
