// Implementations-Datei der Klasse Fahrzeug (Fahrzeug.m)
#import "Fahrzeug.h"
#include <stdio.h>
#include <sys/malloc.h>

@implementation Fahrzeug

- init
{ [super init];  // initialisiert Variablen der Superklasse
  meinLabel = NULL;
  posX = posY = 0.0;
  return self;
}

- setLabel:(char *)aLabel
{ if (meinLabel != NULL)
    free (meinLabel);  // alten Speicher freigenen
  if (aLabel != NULL) {  // Speicher fr Label besorgen
    meinLabel = (char *) malloc (strlen(aLabel) + 1);
    strcpy (meinLabel, aLabel);
  }
  else
    meinLabel = NULL;
    return self;
}

- (char *)label
{ return meinLabel;
}

- moveTo:(float)newX :(float)newY
{ posX = newX;
  posY = newY;
  return self;
}

- dump
{ printf ("%s ", [[self class] name]);
  printf ("'%s' ", meinLabel);    // oder: [self label]
  printf ("an Position (%f,%f)\n", posX, posY);
  return self;
}

- free
{ if (meinLabel)  // selbstgeholten Speicher freigeben
    free (meinLabel);
  return ([super free]);
}

- read:(NXTypedStream*)stream
{ [super read:stream];
  NXReadTypes(stream, "ff*", &posX, &posY, &meinLabel);
  return self;
}

- write:(NXTypedStream*)stream
{ [super write:stream];
  NXWriteTypes(stream, "ff*", &posX, &posY, &meinLabel);
  return self;
}
@end
