;-----------------------------------------------------------;
Title W32ACL_P.ASM ;					    ;
;							    ;
;  Grafik-Prozeduren (256 Farben) fr ET4000/W32P unter TP  ;
;  Auflsungen: 640*480, 800*600, 1024*768, 1280*1024       ;
;  !!! N I C H T TASM, sondern MASM verwenden !!!           ;
;							    ;
;  J.Petsch  Tel: 030 8382524				    ;
;-----------------------------------------------------------;
                   .386
Data            SEGMENT  PARA  PUBLIC 'DATA' Use16
;-------------------------------
;  Alle durch ACLInit initialisierten Werte sind vor dem
;  Verlassen einer PROC wieder herzustellen.
;                                          nach ACLInit
MMUMemBP0       EQU     DWORD PTR [7F00H]
MMUMemBP1       EQU     DWORD PTR [7F04H]
MMUMemBP2       EQU     DWORD PTR [7F08H]
MMUCntrl        EQU     BYTE PTR [7F13H]  ; = 71H

OpStat          EQU     BYTE PTR [7F31H]
SyncEn          EQU     BYTE PTR [7F32H]  ; = 01
IRMask          EQU     BYTE PTR [7F34H]  ; = 00
IRtStat         EQU     BYTE PTR [7F35H]
ACLStat         EQU     BYTE PTR [7F36H]

PatAddr         EQU     DWORD PTR [7F80H]
SrcAddr         EQU     DWORD PTR [7F84H]
PatYOffs        EQU     WORD PTR [7F88H]  ; = BPL -1
SrcYOffs        EQU     WORD PTR [7F8AH]  ; = BPL -1
DestYOffs       EQU     WORD PTR [7F8CH]  ; = BPL -1
VirtBusSize     EQU     BYTE PTR [7F8EH]  ; = 0 ( 1 Byte)
XYDir           EQU     BYTE PTR [7F8FH]  ; = 0 (X/Y increasing)
PatWrap         EQU     BYTE PTR [7F90H]  ; = 77H  (No Wrap)
SrcWrap         EQU     BYTE PTR [7F92H]  ; = 77H  (No Wrap)
XPos            EQU     WORD PTR [7F94H]  ; = 0
YPos            EQU     WORD PTR [7F96H]  ; = 0
XCount          EQU     WORD PTR [7F98H]
YCount          EQU     WORD PTR [7F9AH]
RoutCntrl       EQU     BYTE PTR [7F9CH]  ; = 0  (No CPU used)
RldCntrl        EQU     BYTE PTR [7F9DH]  ; = 0
BackGndROP      EQU     BYTE PTR [7F9EH]
ForeGndROP      EQU     BYTE PTR [7F9FH]
DestAddr        EQU     DWORD PTR [7FA0H]
IntPatAddr      EQU     DWORD PTR [7FA4H]
IntSrcAddr      EQU     DWORD PTR [7FA8H]
DeltaMinor	EQU	WORD PTR [7FACH]
DeltaMajor	EQU	WORD PTR [7FAEH]

BpL             DW      1024            ; Byte per Line
Data            ENDS
;-------------------------------
Code            SEGMENT  PARA  PUBLIC 'CODE'  USE16
                ASSUME CS:Code, DS:Data, ES:Data
;-------------------------------
PUBLIC ACLInit     ; Initialisiert den ACL
PUBLIC PutVliCopy  ; Zeichnet vertikale Gerade
PUBLIC PutHliCopy  ; Zeichnet horizontale Gerade
PUBLIC PutLine	   ; Zeichnet geneigte Gerade
PUBLIC FillSprite  ; Fllt Flche mit Farbe      (PatternCopy)
PUBLIC BitBlT      ; Fhrt BitBlockTransfer aus  ( ROP = Var )
PUBLIC WaitForSync ; Wartet auf Strahlrcklauf
;-------------------------------
SetUp           MACRO
                PUSH    BP
                MOV     BP,SP
                PUSH    DS
                MOV     AX,0B800H
                MOV     ES,AX
                ENDM
;---------------
GetMemAddr      MACRO        ; Berechnet EDX:= Y*BpL +X
                MOVZX   EAX,[X]         ; EAX:= X
                MOVZX   EBX,[Y]         ; EBX:= Y
                MOVZX   EDX,[BpL]
                IMUL    EDX,EBX         ; EDX:= Y *BpL
                ADD     EDX,EAX         ; EDX:= Y *BpL +X
                ENDM
;---------------
BuildPattern    MACRO           ; Legt 4 Byte Farbe an Addr #0 ab
                SUB     EAX,EAX
                MOV     ES:[PatAddr],EAX   ; PatAddr:= 0
                MOV     ES:[MMUMemBP1],EAX ; MMUMemBP1:= 0
                MOV     AL,[Farbe]
                MOV     AH,AL          ; AX:=Farbe:Farbe
                MOV     BX,AX          ; BX:=Farbe:Farbe
                SHL     EAX,16         ; EAX:=Farbe:Farbe:0:0
		MOV	AX,BX	       ; EAX = Farbe:Farbe:Farbe:Farbe
		MOV	BX,2000H       ; ES:BX-> BA000H
		MOV	ES:[BX],EAX
                ENDM
;---------------
Return          MACRO   ParamCount
                POP     DS
                POP     BP
                RET     ParamCount SHL 1
                ENDM
;---------------
WaitForQueue    MACRO          ; Wartet auf eine leere Queue
LOCAL           WFQ
WFQ:            TEST    BYTE PTR ES:[ACLStat],01
                JNZ     SHORT WFQ
                ENDM
;---------------
WaitForACL      MACRO       ; Wartet darauf, da der ACL seinen..
LOCAL           WFA         ; .. Auftrag erledigt hat
WFA:            TEST    BYTE PTR ES:[ACLStat],02
                JNZ     SHORT WFA
                ENDM
;-------------------------------
; Initialisiert den ACL und setzt BpL (BytePerline)
;  Aufruf: ACLInit (GraphMode : WORD);
;
GraphMode       EQU     BYTE PTR [BP+6]
;...............
ACLInit         PROC    FAR
                SetUp                   ; ES-> B800H
                MOV     AL,[GraphMode]
                MOV     BX,1280
                CMP     AL,3FH          ; 1280 * 1024 ?
                JZ      SHORT ACLInit_2
                MOV     BX,1024
                CMP     AL,38H          ; 1024 * 768 ?
                JZ      SHORT ACLInit_2
                MOV     BX,800
                CMP     AL,30H          ; 800 * 600 ?
                JZ      SHORT ACLInit_2
                MOV     BX,640          ; nimm an 640 * 480
ACLInit_2:
                MOV     [BpL],BX
                MOV     AH,0            ; Set Graph Mode
                INT     10H             ; VIDEO BIOS
                WaitForQueue
                MOV     ES:[MMUCntrl],71H
                MOV     ES:[SyncEn],01  ; Wr to full queue w. s.
                MOV     ES:[IRMask],0   ; No Interrupts enabled
                MOV     AX,[BpL]
                DEC     AX
                MOV     ES:[DestYOffs],AX   ; DestYOffs:=BpL-1
                MOV     ES:[PatYOffs],AX    ; PatYOffs:=BpL-1
                MOV     ES:[SrcYOffs],AX    ; SrcYOffs:=BpL-1
                MOV     ES:[VirtBusSize],0  ; 1 Byte
                MOV     ES:[XYDir],0        ; X/Y increasing
                MOV     ES:[PatWrap],77H    ; No Wrap
                MOV     ES:[SrcWrap],77H    ; No Wrap
                MOV     ES:[XPos],0
                MOV     ES:[YPos],0
                MOV     ES:[RoutCntrl],0 ; No CPU Data/Addr used
                MOV     ES:[RldCntrl],0
                WaitForACL
                Return  1
ACLInit 	ENDP
;----------------------------------------
;  Zeichnet eine Vertikale durch fortlaufendes Kopieren.
;  Aufruf: PutVliCopy (X, Y, Lnge, Farbe : WORD);
;
X               EQU     WORD PTR [BP+12]
Y               EQU     WORD PTR [BP+10]
Laenge          EQU     WORD PTR [BP+8]
Farbe           EQU     BYTE PTR [BP+6]
;...............
PutVliCopy      PROC    FAR
                SetUp
                GetMemAddr                   ; EDX:=Y*BpL +X
                WaitForQueue
                MOV     ES:[DestAddr],EDX    ; DestAddr:=Y*BpL +X
		BuildPattern		     ; Screen #0:= 4 * Pixel mit Farbe
                MOV     ES:[PatWrap],02H     ; 1 Line * 4 Byte
                MOV     ES:[ForegndROP],0F0H ; PatternCopy (P)
                MOV     ES:[XCount],0        ; XCount:=0
                MOV     AX,[Laenge]
                DEC     AX
                MOV     ES:[YCount],AX       ; YCount:=Lnge-1
                WaitForACL
                MOV     ES:[OpStat],09       ; Starte ACL
                WaitForQueue
                MOV     ES:[PatWrap],77H     ; No Wrap
                Return  4
PutVliCopy      ENDP
;----------------------------------------
;  Zeichnet eine Horizontale durch fortlaufendes Kopieren.
;  Aufruf: PutHliCPU (X, Y, Lnge, Farbe : WORD);
;
X               EQU     WORD PTR [BP+12]
Y               EQU     WORD PTR [BP+10]
Laenge          EQU     WORD PTR [BP+8]
Farbe           EQU     BYTE PTR [BP+6]
;...............
PutHliCopy	PROC	FAR
                SetUp
		GetMemAddr		     ; EDX:= Y*BpL +X
                WaitForQueue
		MOV	ES:[DestAddr],EDX    ; DestAddr:= Y*BpL +X
		BuildPattern		     ; Screen #0:= 4 * Pixel mit Farbe
                MOV     ES:[PatWrap],02H     ; 1 Line * 4 Byte
                MOV     ES:[ForegndROP],0F0H ; PatternCopy (P)
		MOV	CX,[Laenge]
		JCXZ	SHORT PutHliCopy_0
                DEC     CX
		MOV	ES:[XCount],CX	     ; XCount:=Lnge-1
                INC     CX
		MOV	ES:[YCount],0	     ; YCount:=0
		WaitForACL
                MOV     ES:[OpStat],09       ; Starte ACL
                WaitForQueue
PutHliCopy_0:
                MOV     ES:[PatWrap],77H     ; No Wrap
                Return  4
PutHliCopy	ENDP
;----------------------------------------
;  Zeichnet eine Gerade von X,Y nach XE,YE mit Farbe
;  Aufruf: PutLine (X, Y, XE, YE, Farbe : WORD);
;
X               EQU     WORD PTR [BP+14]
Y               EQU     WORD PTR [BP+12]
XE              EQU     WORD PTR [BP+10]
YE              EQU     WORD PTR [BP+8]
Farbe           EQU     BYTE PTR [BP+6]
;...............
PutLine         PROC    FAR
                SetUp
;
;  DltX:= X-XE
;  Xdir:=$81
;  IF DeltX < 0 THEN
;  BEGIN
;    DeltX:=-DeltX
;    Xdir:=$80
;  END
;
		MOV	SI,[X]
		SUB	SI,[XE]		; SI:=DeltX
		MOV	CL,81H		; Xdir:=1
		JNB	SHORT PutLine_2
		NEG	SI
		MOV	CL,80H		; Xdir:= 0
PutLine_2:
;
;  DltY:= Y-YE
;  Ydir:=$02
;  IF DeltY < 0 THEN
;  BEGIN
;    DeltY:=-DeltY
;    Ydir:=$00
;  END
;
		MOV	DI,[Y]
		SUB	DI,[YE]		; DI:=DltY
		MOV	CH,02		; Ydir:=1
		JNB	SHORT PutLine_4
		NEG	DI
		MOV	CH,0		; Ydir:=0
PutLine_4:
;
;  TempDir:= Xdir OR Ydir
;
		OR	CL,CH		; CL:=|1|0|0|0|0|0|Ydir|XDir|
;
;  DestAddr:= Y * BpL + X
;
		GetMemAddr
		WaitForACL
		MOV	ES:[DestAddr],EDX
;
;  Screen #0:= 4 Pixel mit Farbe;
;
		BuildPattern
;
;  DestYOffs:=BpL-1
;
		MOV	AX,[BpL]
		DEC	AX
		MOV	ES:[DestYOffs],AX
;
;  PatWrap:=02	   ( Vert: 1 Line, Hor: 4 Byte )
;
		MOV	ES:[PatWrap],02H
;
;  ForegndROP:=0F0H   (	PatternCopy (P) )
;
		MOV	ES:[ForegndROP],0F0H	; PatternCopy (P)
;
;  IF DeltX < DeltY THEN
;  BEGIN
;    Adir:=0
;    DeltaMinor:=DeltX
;    DeltaMajor:=DeltY
;    XCount:=0FFFH
;    YCount:=DeltY-1
;  END
;  ELSE BEGIN
;    Adir:=04
;    DeltaMajor:=DeltX
;    DeltaMinor:=DeltY
;    XCount:=DeltX-1
;    YCount:=0FFFH
;  END
		CMP	SI,DI			; DeltX < DeltY ?
		JB	SHORT PutLine_6
;
;  DeltX >= DeltY
;
		MOV	AL,04			; Adir:=1

		MOV	ES:[DeltaMajor],SI	; DeltaMajor:=DeltX
		MOV	ES:[DeltaMinor],DI	; DeltaMinor:=DeltY

		DEC	SI
		MOV	ES:[XCount],SI		; XCount:=DeltX-1
		MOV	ES:[YCount],0FFFH	; YCount:=0FFFH

		JMP	SHORT PutLine_8
;--------------
;  DeltX < DeltY
;
PutLine_6:	MOV	AL,0			; Adir:=0

		MOV	ES:[DeltaMinor],SI	; DeltaMinor:=DeltX
		MOV	ES:[DeltaMajor],DI	; DeltaMajor:=DeltY

		MOV	ES:[XCount],0FFFH	; XCount:=0FFFH
		DEC	DI
		MOV	ES:[YCount],DI		; YCount:=DeltY-1
PutLine_8:
;
;  XYDir:= TempDir OR Adir
;
		OR	AL,CL		; AL:=|1|0|0|0|0|Adir|Ydir|XDir|	;
		MOV	ES:[XYDir],AL
;
;  Starte ACL
;
		WaitForACL
		MOV	ES:[OpStat],09	; Resume/Restore ACL Operation
;
;  PatWrap:=77H	 ( No Wrap )
;
		WaitForQueue
		MOV	ES:[PatWrap],77H

		Return	5
PutLine		ENDP
;------------------------------
;  Fllt ein Sprite durch Patterncopy
;  Aufruf: FillSprite (X, Y, Breite, Hoehe, Farbe : WORD);
;
X               EQU     WORD PTR [BP+14]
Y               EQU     WORD PTR [BP+12]
Breite          EQU     WORD PTR [BP+10]
Hoehe           EQU     WORD PTR [BP+8]
Farbe           EQU     BYTE PTR [BP+6]
;...............
FillSprite      PROC    FAR
                SetUp
                GetMemAddr                   ; EDX:=Y*BpL +X
                WaitForQueue
                MOV     ES:[DestAddr],EDX    ; Obere linke Ecke
                BuildPattern   ; Screen #0:= 4 Pixel mit Farbe
                MOV     ES:[PatWrap],02      ; 1 Line * 4 Byte
                MOV     ES:[ForegndROP],0F0H ; PatternCopy (P)
                MOV     AX,[Breite]
                DEC     AX
                MOV     ES:[XCount],AX       ; XCount:=Breite-1
                MOV     AX,[Hoehe]
                DEC     AX
                MOV     ES:[YCount],AX       ; YCount:=Hhe-1
                WaitForACL
                MOV     ES:[OpStat],9        ; Starte ACL
                WaitForQueue
                MOV     ES:[PatWrap],77H     ; No Wrap
                Return  5
FillSprite      ENDP
;----------------------------------------
;  Fhrt einen BitBlockTransfer aus
;  Aufruf: BitBlT (BitBlData : POINTER);
;
Xs              EQU     WORD PTR [SI+00] ; Source
Ys              EQU     WORD PTR [SI+02]
Xp              EQU     WORD PTR [SI+04] ; Pattern
Yp              EQU     WORD PTR [SI+06]
Xd              EQU     WORD PTR [SI+08] ; Destination
Yd              EQU     WORD PTR [SI+10]
Breite          EQU     WORD PTR [SI+12]
Hoehe           EQU     WORD PTR [SI+14]
FgROP           EQU     BYTE PTR [SI+16]
;
BitBlDataPtr    EQU     DWORD PTR [BP+6]
;...............
BitBlT          PROC    FAR
                SetUp
                MOVZX   EAX,[BpL]
                LDS     SI,[BitBlDataPtr] ; DS:SI-> Array
;  Erweitere 16 Bit auf 32 Bit
                MOVZX   EBX,[Xs]        ; EBX:= Xs
                MOVZX   EDX,[Ys]        ; EDX:= Ys
                MOVZX   EBP,[Xd]        ; EBP:= Xd
                MOVZX   EDI,[Yd]        ; EDI:= Yd
;  Bestimme die Richtung
                CMP     DI,DX           ; Yd < Ys ?
                JL      SHORT BitBlT_2
                JG      SHORT BitBlT_3  ; Yd > Ys ?
; Yd = Ys
                CMP     BP,BX           ; Xd > Xs ?
                JG      BitBlT_5
;  Yd = Ys und Xd <= Xs
BitBlT_2:       IMUL    EDX,EAX         ; EDX:= Ys *BPL
                ADD     EDX,EBX         ; EAX:= Ys *BPL +Xs
                IMUL    EDI,EAX         ; EDI:= Yd *BPL
                ADD     EDI,EBP         ; EDI:= Yd *BPL +Xd
                MOVZX   EBX,[Yp]        ; EBX:= Yp
                IMUL    EBX,EAX         ; EBX:= Yp *BPL
                MOVZX   EAX,[Xp]        ; EAX:= Xp
                ADD     EBX,EAX         ; EBX:= Yp *BPL +Xp
                MOV     AL,0            ; Ydir:= 0  Xdir:= 0
BitBlT_4:
;  Jetzt ist AL = XYDirection
;            EDI = DestAddr, EDX = SrcAddr, EBX = PatAddr
                WaitForQueue
                MOV     ES:[XYDir],AL
                MOV     ES:[DestAddr],EDI
                MOV     ES:[PatAddr],EBX
                MOV     ES:[SrcAddr],EDX

                MOV     AX,[Breite]
                DEC     AX
                MOV     ES:[XCount],AX     ; XCount:=Breite-1
                MOV     AX,[Hoehe]
                DEC     AX
                MOV     ES:[YCount],AX     ; YCount:=Hhe-1
                MOV     AL,[FgROP]
                MOV     ES:[ForeGndROP],AL ; logische Verknpfung
                WaitForACL
                MOV     ES:[OpStat],9      ; Starte ACL
                WaitForQueue
                MOV     ES:[XYDir],0
                Return  2
;...............
;  Yd > Ys
BitBlT_3:       MOVZX   ECX,[Hoehe]
                DEC     CX           ; ECX:= H -1
                ADD     EDX,ECX      ; EDX:= (Ys +H -1)
                IMUL    EDX,EAX      ; EDX:= (Ys +H -1) *BpL
                ADD     EDX,EBX      ; EDX:= (Ys +H -1) *BpL +Xs
                ADD     EDI,ECX      ; EDI:= (Yd +H -1)
                IMUL    EDI,EAX      ; EDI:= (Yd +H -1) *BpL
                ADD     EDI,EBP      ; EDI:= (Yd +H -1) *BpL +Xd
                MOVZX   EBX,[Yp]     ; EBX:= Yp
                ADD     EBX,ECX      ; EBX:= (Yp +H -1)
                IMUL    EBX,EAX      ; EBX:= (Yp +H -1) *BpL
                MOVZX   EAX,[Xp]     ; EAX:= Xp
                ADD     EBX,EAX      ; EBX:= (Yp +H -1) *BpL +Xp

                MOV     AL,2         ; Ydir:= 1  Xdir = 0
                JMP     BitBlT_4
;...............
;  Yd = Ys;  Xd > Xs
BitBlT_5:       MOVZX   ECX,[Breite] ; ECX:= Breite
                DEC     CX           ; ECX:= Breite -1
                IMUL    EDX,EAX      ; EDX:= Ys *BpL
                ADD     EDX,EBX      ; EDX:= Ys *BpL +Xs
                ADD     EDX,ECX      ; EDX:= Ys *BpL +Xs +Br -1
                IMUL    EDI,EAX      ; EDI:= Yd *BpL
                ADD     EDI,EBP      ; EDI:= Yd *BpL +Xd
                ADD     EDI,ECX      ; EDI:= Yd *BpL +Xd +Br -1
                MOVZX   EBX,[Yp]     ; EBX:= Yp
                IMUL    EBX,EAX      ; EBX:= Yp *BpL
                MOVZX   EAX,[Xp]     ; EAX:= Xp
                ADD     EBX,EAX      ; EBX:= Yp *BpL +Xp
                ADD     EBX,ECX      ; EBX:= Yp *BpL +Xp +Br -1

                MOV     AL,1         ; Ydir = 0  Xdir = 1
                JMP     BitBlT_4
BitBlT          ENDP
;------------------------------------
;  Wartet auf ansteigende Flanke des Vertical-Sync-Impulses.
WaitForSync     PROC   FAR
                MOV    DX,3DAH             ; DX-> STATUS-Register
                MOV    AH,8                ; AH-> SYNC-Bit
WaitForSync_2:
                IN     AL,DX               ; Hole STATUS
                TEST   AL,AH               ; SYNC = 0 ?
                JNZ    SHORT WaitForSync_2 ; Nein, warte
WaitForSync_4:
                IN     AL,DX               ; Hole STATUS
                TEST   AL,AH               ; SYNC = 1 ?
                JZ     SHORT WaitForSync_4 ; Nein, warte
                RET
WaitForSync     ENDP
;--------------------------------------------
CODE            ENDS
                END

