/** GetTime.C (c) Jrg Scholvin/as  **

Dieses Programm sollte am Anfang der autoexec.bat aufgerufen
werden. Es speichert Boot-Modus und die Ein- sowie und die in
den Alarmzeitregistern des CMOS-RAM gesicherte letzte Ausschaltzeit
in eine Textdatei

Compiler: Borland C++ 3.1, (kompatibel gehalten zu TC 2.0)
*/

#include <conio.h>
#include <dos.h>
#include <io.h>
#include <process.h>
#include <stdio.h>
#include <time.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>

#define TEXTFILE    "C:\ZEIT.LOG"  /* Name der Datei*/

typedef unsigned char byte ;

int init=0,aktdst=0,nowarm=0,timemark=0;
FILE *fptr;

int opendat (void) {   /* Textdatei ffnen oder erstellen   */
  int found =0;

  fptr=fopen(TEXTFILE,"rt");  /*Existiert Textdatei ?       */
  if (fptr!=NULL) {          /*hier ggf. den letzten Eintrag*/
  found=1;                   /*einlesen => Startzeit        */
  fclose (fptr);}
  fptr=fopen(TEXTFILE,"a+t");
  if (fptr==NULL) {   /* Datei kann nicht erstellt werden: */
    clrscr();
    printf("*** Fehler bei Dateierstellung von (%s) ***\n",
           TEXTFILE);
    exit(-1);
  }
  return found;
}

void WriteRTC (byte index, byte wert) {
  __emit__ (0xfa);     /* oder _disable() in BC 3.1 */
  outportb (0x70,index);
  outportb (0x71,wert);
  __emit__ (0xfb);    /* oder  _enable()  in BC 3.1*/;
}

int ReadRTC (byte index) {
  byte b;
  __emit__ (0xfa);     /* oder _disable() in BC 3.1 */
  outportb   (0x70,index);
  b=inportb  (0x71);
  __emit__ (0xfb);    /* oder  _enable()  in BC 3.1*/;
  return b;
}

byte bcd2int (byte bcd) {
return (((bcd >>4)*10)+(bcd&15));
}

void isdst (struct tm *d) {

/*bestimmt in tm.isdst ob Datum in europische Sommerzeit (=1) fllt*/

byte mon;                         /* aktueller  Monat         */
byte startmon = 3, startlen =31;  /* Monat + Lnge fr Beginn */
byte endmon   = 9, endlen   =30;  /* Monat + Lnge fr Ende   */

if (d->tm_year >= 96) {endmon=10; endlen=31;}

mon= d->tm_mon+1;
if ((mon<startmon) || (mon > endmon)) d->tm_isdst=0;
 else if ((mon>startmon) && (mon < endmon)) d->tm_isdst=1;
  else if (mon == startmon) {
   if (d->tm_mday-d->tm_wday < startlen-6) d->tm_isdst=0;
    else d->tm_isdst=1;
    if ((d->tm_wday == 0) && (d->tm_hour < 2)) d->tm_isdst = 0;
    }
  else if (mon == endmon) {
   if (d->tm_mday-d->tm_wday < endlen-6) d->tm_isdst=1;
    else d->tm_isdst=0;
    if ((d->tm_wday==0) && (d->tm_hour < 2)) d->tm_isdst = 1;
    }
}

void setpara (char c) {   /*Komandozeilen-Parameter*/
switch (toupper (c)) {
   case 'S': aktdst=1;   return; /* aktiviert Sommer/Winterzeit */
   case 'K': nowarm=1;   return; /* ignoriert Warmstarts        */
   case 'M': timemark=1; return; /* benutze eigenes Resetflag   */
   case 'I': init=1;     return;
   }
 return;
}

/* Hauptprogramm:
   Zeit aus den Alarmregistern des CMOS-RAMs lesen und sichern.
   Danach die Alarmregister lschen */

void main(int _argc, char *_argv[]) {
  char day[7*3]=
   {"So\0" "Mo\0" "Di\0" "Mi\0" "Do\0" "Fr\0" "Sa\0" };
  char dst[2*3] ={"WZ\0" "SZ\0"};
  byte sec,min,hour,days, dstflag;
  char s[64];
  char komment[64] ={"\0"};
  struct tm   dt;
  time_t      t;
  unsigned int far *ResFlag ;
  char             *ResTyp;
  int  i,j;
  char *blank = " ";

  init=!opendat();
  if (init) fprintf (fptr,"Ein/Ausschalt-Logdatei * c''t 11/94 *");

  for (i=1;i<_argc;i++) {
    if (_argv[i][0] =='-') {
      j=0;
      while (_argv[i][j++] != 0)  setpara (_argv[i][j]);
      }
    else {
      strcat (komment,blank);
      strcat (komment,_argv[i]);
     }
  }

  ResFlag= (unsigned int far *) MK_FP (0x40, 0x72);
  sec =ReadRTC (1);             /* <Auschalt-Sekunden> + DST     */
  min =ReadRTC (3);             /* <Ausschalt-Minute>  + Valid   */
  hour=ReadRTC (5);             /* <Ausschalt-Stunde>  + berlauf*/
  dstflag = (sec & 0x80) >> 7;  /* <Sommerzeit-Flag>             */
  days =(hour & 0xC0)  >> 6;    /* <Anzahl Tage bis maximal 4  > */

  /* Die Werte aus dem BCD-Format in Integer umwandeln: */

  sec =bcd2int  (sec  & 0x7F);
  min =bcd2int  (min  & 0x7F);
  hour=bcd2int  (hour & 0x3F);

  if (*ResFlag==0)            ResTyp="Kaltstart\0";
   else if (*ResFlag==0x7463) ResTyp="Zeitmarke\0";
     else {
     ResTyp="Warmstart\0";
     if (nowarm) exit(0);
     }

  /* die aktuelle Zeit => Einschaltzeit registrieren */

  putenv ("TZ=MEZ-1MES");   /* MEZ mit Sommerzeitzone definieren    */
  time(&t);                 /* Unix-Zeit (GMT) in Long   ab 1.1.70  */
  dt=*localtime (&t);       /* Zeit in tm-Struktur                  */
  isdst (&dt);              /* Sommerzeit/Winterzeit-Bestimmung     */
   if (!init && aktdst) {
     printf ("alt %d neu %d",dstflag,dt.tm_isdst);
     if (dstflag != dt.tm_isdst)   { /* nderung Sommer/Winter ?    */
      if (dstflag == 0) t=t+3600;   /* 1h hinzu                     */
        else            t=t-3600;   /*    oder abziehen             */
     dstflag=dt.tm_isdst;
     dt=*localtime(&t);     /* Neue Zeit in Struktur                */
     stime (&t);            /* und Rechner                          */
     dt.tm_isdst=dstflag;   /* Sommerzeitflag eintragen             */
    }
  }

  if (!init && (*ResFlag != 0x7463))
  {
  sprintf(s,"      Aus um %2d:%02d:%02d, Tagesberlufe:%02d ",
            hour,min,sec,days);
  printf(s); fprintf(fptr,"%s\n",s);
  }
  WriteRTC(1,dt.tm_isdst << 7);
  WriteRTC(3,0);  WriteRTC(5,0); /*Init CMOS*/
  sprintf(s,"\n%s um %2d:%02d:%02d %s am %s, %02d.%02d.%2d %s",
          ResTyp,dt.tm_hour,dt.tm_min,dt.tm_sec,&dst[dt.tm_isdst*3],
          &day[dt.tm_wday*3],dt.tm_mday,dt.tm_mon+1,
          dt.tm_year, komment);
  printf(s);
  fprintf(fptr,"%s\n",s);
  fclose(fptr);
  if (timemark) *ResFlag=0x7463;
}
