 ;MicroControllerPascal compiler, vers. 4.19 copyright (C) KSC 1986, 1990
 ; With code generation for 8031
 ;{ mit modifiziertem iodriver.asm von C.Meyer 8/94, Teile (C) KSC     }
 ;{ tcycle=1.0851 us bei 11,059 MHz Takt, 27128 EPROM                  }
 ;{ Da nur rund 60 Bytes RAM zur Verfgung stehen, wurde konsequent    }
 ;{ auf lokale Variable verzichtet. Der verwendete KSC-Pascal-Compiler }
 ;{ Version 4.19 legt leider auch lokale Variable dauerhaft und nicht  }
 ;{ auf dem Stack ab. Ferner wird ein berschreiben benachbarter Bytes }
 ;{ durch den Parser in Kauf genommen, wenn diese zur Laufzeit gerade  }
 ;{ nicht verwendet werden. Vorsicht also bei eigenen Erweiterungen.   }
 ;
 ;{ Erweiterungen gegenber der verffentlichten Version:              }
 ;{ Stand-Alone-Betrieb mit P1.7 an Masse, Auftrennen der Verbindung   }
 ;{ hlt die Anzeige an. Zeigt nun auch den Inhalt von Speicherkarten. }
 ;
 ;{ m-Befehl akzeptiert nun die Angabe einer Basisadresse, zB. m 02    }
 ;{ listet den Inhalt ab Adresse $0200 auf (nur bei "greren" Karten).}
 ;{ r und w inkrementieren automatisch. s und d sind nicht mehr auf 8  }
 ;{ Zeichen beschrnkt, sondern akzeptieren unbegrenzt lange Strings.  }
 ;{ 10 ms Wartezeit nach jedem Zeichen fr die Programmierung sind     }
 ;{ nach wie vor erforderlich! }
 ;
 ;{ Befehle t und k geben den Inhalt von Telefon- und KV-Karten for-   }
 ;{ matiert aus. Bei Speicherkarten ohne Versicherten-Template zeigt   }
 ;{ k nur den Inhalt ab $30 als ASCII-File an. Beide Befehle haben     }
 ;{ keine Parameter. }
 ;
 ;program cardterm;
 ;
 ;  const
$DEBUG


	NAME	CARDTERM

	USING	3
	USING	2
	USING	1
	USING	0

 ;    VersStr = 'c''t-CardTerminal (C) C.Meyer 9/94 V0.9';

?CARDTERM?C	SEGMENT	CODE
	RSEG	?CARDTERM?C

VERSSTR:	DB	026H
	DB	063H
	DB	027H
	DB	074H
	DB	02DH
	DB	043H
	DB	061H
	DB	072H
	DB	064H
	DB	054H
	DB	065H
	DB	072H
	DB	06DH
	DB	069H
	DB	06EH
	DB	061H
	DB	06CH
	DB	020H
	DB	028H
	DB	043H
	DB	029H
	DB	020H
	DB	043H
	DB	02EH
	DB	04DH
	DB	065H
	DB	079H
	DB	065H
	DB	072H
	DB	020H
	DB	039H
	DB	02FH
	DB	039H
	DB	034H
	DB	020H
	DB	056H
	DB	030H
	DB	02EH
	DB	039H
 ;    ProtStr = '  Protokoll: ';

	RSEG	?CARDTERM?C

PROTSTR:	DB	0DH
	DB	020H
	DB	020H
	DB	050H
	DB	072H
	DB	06FH
	DB	074H
	DB	06FH
	DB	06BH
	DB	06FH
	DB	06CH
	DB	06CH
	DB	03AH
	DB	020H
 ;    HexStr = '0123456789ABCDEF';

	RSEG	?CARDTERM?C

HEXSTR:	DB	010H
	DB	030H
	DB	031H
	DB	032H
	DB	033H
	DB	034H
	DB	035H
	DB	036H
	DB	037H
	DB	038H
	DB	039H
	DB	041H
	DB	042H
	DB	043H
	DB	044H
	DB	045H
	DB	046H
 ;    BinStr = '01';

	RSEG	?CARDTERM?C

BINSTR:	DB	02H
	DB	030H
	DB	031H
 ;
 ;    ZWDStr = 'Siemens 2-Draht Bus ';

	RSEG	?CARDTERM?C

ZWDSTR:	DB	014H
	DB	053H
	DB	069H
	DB	065H
	DB	06DH
	DB	065H
	DB	06EH
	DB	073H
	DB	020H
	DB	032H
	DB	02DH
	DB	044H
	DB	072H
	DB	061H
	DB	068H
	DB	074H
	DB	020H
	DB	042H
	DB	075H
	DB	073H
	DB	020H
 ;    DRDStr = 'Siemens 3-Draht Bus ';

	RSEG	?CARDTERM?C

DRDSTR:	DB	014H
	DB	053H
	DB	069H
	DB	065H
	DB	06DH
	DB	065H
	DB	06EH
	DB	073H
	DB	020H
	DB	033H
	DB	02DH
	DB	044H
	DB	072H
	DB	061H
	DB	068H
	DB	074H
	DB	020H
	DB	042H
	DB	075H
	DB	073H
	DB	020H
 ;    I2CStr = 'Philips I2C Bus ';

	RSEG	?CARDTERM?C

I2CSTR:	DB	010H
	DB	050H
	DB	068H
	DB	069H
	DB	06CH
	DB	069H
	DB	070H
	DB	073H
	DB	020H
	DB	049H
	DB	032H
	DB	043H
	DB	020H
	DB	042H
	DB	075H
	DB	073H
	DB	020H
 ;    TelStr = 'Telefonkarte ';

	RSEG	?CARDTERM?C

TELSTR:	DB	0DH
	DB	054H
	DB	065H
	DB	06CH
	DB	065H
	DB	066H
	DB	06FH
	DB	06EH
	DB	06BH
	DB	061H
	DB	072H
	DB	074H
	DB	065H
	DB	020H
 ;    unbStr = 'unbekannt, ';

	RSEG	?CARDTERM?C

UNBSTR:	DB	0BH
	DB	075H
	DB	06EH
	DB	062H
	DB	065H
	DB	06BH
	DB	061H
	DB	06EH
	DB	06EH
	DB	074H
	DB	02CH
	DB	020H
 ;    ATRStr = 'ATR = ';

	RSEG	?CARDTERM?C

ATRSTR:	DB	06H
	DB	041H
	DB	054H
	DB	052H
	DB	020H
	DB	03DH
	DB	020H
 ;    ValErrStr = 'Val Err';

	RSEG	?CARDTERM?C

VALERRSTR:	DB	07H
	DB	056H
	DB	061H
	DB	06CH
	DB	020H
	DB	045H
	DB	072H
	DB	072H
 ;    CmdErrStr = 'Cmd Err';

	RSEG	?CARDTERM?C

CMDERRSTR:	DB	07H
	DB	043H
	DB	06DH
	DB	064H
	DB	020H
	DB	045H
	DB	072H
	DB	072H
 ;
 ;    high=true;

HIGH	EQU	01H
 ;    low=false;

LOW	EQU	00H
 ;    dta=0;                 { ISO-I/O-Lines P1 }

DTA	EQU	00H
 ;    clk=1;

CLK	EQU	01H
 ;    rst=2;

RST	EQU	02H
 ;    skt=4;                 { Schaltkontakt }

SKT	EQU	04H
 ;    switch=7;              { Betriebsart }

SWITCH	EQU	07H
 ;    CdOff=$F8;             { fr Kartenleseroutine }

CDOFF	EQU	0F8H
 ;    CdOn=$F1;

CDON	EQU	0F1H
 ;    CdI2Cidle=$F3;

CDI2CIDLE	EQU	0F3H
 ;
 ;    I2CreadC=$A1;

I2CREADC	EQU	0A1H
 ;    I2CwriteC=$A0;

I2CWRITEC	EQU	0A0H
 ;    ZWDreadC=$30;

ZWDREADC	EQU	030H
 ;    ZWDwriteC=$38;

ZWDWRITEC	EQU	038H
 ;    ZWDreadProtC=$34;

ZWDREADPROTC	EQU	034H
 ;    ZWDwriteProtC=$3C;

ZWDWRITEPROTC	EQU	03CH
 ;    ZWDreadSecC=$31;

ZWDREADSECC	EQU	031H
 ;    ZWDwriteSecC=$39;

ZWDWRITESECC	EQU	039H
 ;    ZWDcompvC=$3B;

ZWDCOMPVC	EQU	03BH
 ;    DRDreadC=$0E;

DRDREADC	EQU	0EH
 ;    DRDwriteC=$33;

DRDWRITEC	EQU	033H
 ;    DRDwriteProtC=$30;

DRDWRITEPROTC	EQU	030H
 ;
 ;    NoATRC=$F;

NOATRC	EQU	0FH
 ;    Tel0prtkC=0;

TEL0PRTKC	EQU	00H
 ;    Tel1prtkC=2;

TEL1PRTKC	EQU	02H
 ;    Tel2prtkC=4;

TEL2PRTKC	EQU	04H
 ;    I2CprtkC=$8;

I2CPRTKC	EQU	08H
 ;    ZWDprtkC=$A;

ZWDPRTKC	EQU	0AH
 ;    DRDprtkC=$9;

DRDPRTKC	EQU	09H
 ;
 ;  var
 ;    ptr:byte;
?CARDTERM?D	SEGMENT	DATA
 RSEG	?CARDTERM?D
PTR:	DS	01H
 ;    cliBuf: packed array[0..6] of byte;   { fr Parser/CLI }
 RSEG	?CARDTERM?D
CLIBUF:	DS	07H
 ;    dataBuf: packed array[0..3] of byte;  { fr fast alles }
 RSEG	?CARDTERM?D
DATABUF:	DS	04H
 ;    aInt:integer;
 RSEG	?CARDTERM?D
AINT:	DS	02H
 ;    device,count: byte;
 RSEG	?CARDTERM?D
DEVICE:	DS	01H
 RSEG	?CARDTERM?D
COUNT:	DS	01H
 ;    a,b,c,d,e,f,g,i,j,x,y: Byte;
 RSEG	?CARDTERM?D
A:	DS	01H
 RSEG	?CARDTERM?D
B:	DS	01H
 RSEG	?CARDTERM?D
C:	DS	01H
 RSEG	?CARDTERM?D
D:	DS	01H
 RSEG	?CARDTERM?D
E:	DS	01H
 RSEG	?CARDTERM?D
F:	DS	01H
 RSEG	?CARDTERM?D
G:	DS	01H
 RSEG	?CARDTERM?D
I:	DS	01H
 RSEG	?CARDTERM?D
J:	DS	01H
 RSEG	?CARDTERM?D
X:	DS	01H
 RSEG	?CARDTERM?D
Y:	DS	01H
 ;    z: char;
 RSEG	?CARDTERM?D
Z:	DS	01H
 ;    adrLo,adrHi,value: Byte;
 RSEG	?CARDTERM?D
ADRLO:	DS	01H
 RSEG	?CARDTERM?D
ADRHI:	DS	01H
 RSEG	?CARDTERM?D
VALUE:	DS	01H
 ;    ISOprtk,ISOstruc,ISOsize,ISOlng: byte; { ATR = Kartenprotokoll }
 RSEG	?CARDTERM?D
ISOPRTK:	DS	01H
 RSEG	?CARDTERM?D
ISOSTRUC:	DS	01H
 RSEG	?CARDTERM?D
ISOSIZE:	DS	01H
 RSEG	?CARDTERM?D
ISOLNG:	DS	01H
 ;    noCard,MonDisp,ErrCond: boolean;
?CARDTERM?B	SEGMENT	BIT
 RSEG	?CARDTERM?B
NOCARD:	DBIT	01H
 RSEG	?CARDTERM?B
MONDISP:	DBIT	01H
 RSEG	?CARDTERM?B
ERRCOND:	DBIT	01H
 ;
 ;
 ;{************************* Low-Level-Routinen ****************************}
 ;
 ;  procedure wait(zehntelsec:integer);
 RSEG	?CARDTERM?D
ZEHNTELSEC:	DS	02H
 ;  var
 ;    countInt:Integer;
 RSEG	?CARDTERM?D
COUNTINT:	DS	02H
 ;{ Zehntelsekunden abgestimmt auf 11,059 MHz Takt }
 ;  begin
	RSEG	?CARDTERM?C

WAIT:
 ;    for countInt:= 0 to zehntelsec*43 do
	MOV	COUNTINT,#LOW(00H)
	MOV	COUNTINT+01H,#00H
?L0:
	MOV	R4,#LOW(02BH)
	MOV	R5,#HIGH(02BH)
	MOV	R2,ZEHNTELSEC
	MOV	R3,ZEHNTELSEC+01H
	LCALL	?IMUL
 ;      for x:=0 to 253 do;
	MOV	A,COUNTINT
	SETB	C
	SUBB	A,R2
	MOV	A,COUNTINT+01H
	XRL	A,#080H
	XRL	03H,#080H
	SUBB	A,R3
	JC	$+5
	LJMP	?L1
	MOV	X,#00H
?L2:
	MOV	A,X
	SETB	C
	SUBB	A,#0FDH
	JC	$+5
	LJMP	?L3
	INC	X
	SJMP	?L2
?L3:
	INC	COUNTINT
	CLR	A
	CJNE	A,COUNTINT,$+5
	INC	COUNTINT+01H
	SJMP	?L0
?L1:
 ;  end;
	RET
 ;
 ;  procedure pwait;
 ;{ 10 ms Programmierzeit fr EEPROM bei 11,059 MHz }
 ;  begin
	RSEG	?CARDTERM?C

PWAIT:
 ;    for y:= 0 to 4 do
	MOV	Y,#00H
?L4:
 ;      for x:=0 to 255 do;
	MOV	A,Y
	SETB	C
	SUBB	A,#04H
	JC	$+5
	LJMP	?L5
	MOV	X,#00H
?L6:
	MOV	A,X
	SETB	C
	SUBB	A,#0FFH
	JC	$+5
	LJMP	?L7
	INC	X
	MOV	A,X
	JZ	$+5
	SJMP	?L6
	NOP
?L7:
	INC	Y
	SJMP	?L4
?L5:
 ;  end;
	RET
 ;
 ;  procedure rwait;
 ;{ Timing fr Lesen: Luxus-NOP, incl. Aufruf 10 us bei 11,059 MHz }
 ;  begin
	RSEG	?CARDTERM?C

RWAIT:
 ;    y:=y;
	MOV	Y,Y
 ;    y:=y;
	MOV	Y,Y
 ;  end;
	RET
 ;
 ;{************************* allgemeine Routinen ***************************}
 ;
 ;  procedure SendStat(State:Boolean);
 RSEG	?CARDTERM?B
STATE:	DBIT	01H
 ;  begin
	RSEG	?CARDTERM?C

SENDSTAT:
 ;    if State then
	JB	STATE,$+6
	LJMP	?L8
 ;      write(serial,'OK',char(13))
	SJMP	$+5
?S298:
	DB	02H
?S299:
	DB	04FH
	DB	04BH
	MOV	DPTR,#?S299
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	R7,#02H
	MOV	R6,#00H
	LCALL	?WRITS
	MOV	A,#0DH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
 ;    else
	LJMP	?L9
?L8:
 ;      write(serial,'ERROR',char(13));
	SJMP	$+8
?S334:
	DB	05H
?S335:
	DB	045H
	DB	052H
	DB	052H
	DB	04FH
	DB	052H
	MOV	DPTR,#?S335
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	R7,#05H
	MOV	R6,#00H
	LCALL	?WRITS
	MOV	A,#0DH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
?L9:
 ;  end;
	RET
 ;
 ;  function NumToHex (theByte: byte): string[2];
 RSEG	?CARDTERM?D
THEBYTE:	DS	01H
 RSEG	?CARDTERM?D
NUMTOHEX?RET:	DS	03H
 ;  begin
	RSEG	?CARDTERM?C

NUMTOHEX:
 ;   NumToHex := '00';
	SJMP	$+5
?S371:
	DB	02H
?S372:
	DB	030H
	DB	030H
	MOV	DPTR,#?S371
	MOV	R1,#NUMTOHEX?RET
	MOV	07H,#03H
	LCALL	?MASSI4
 ;   for x := 2 downto 1 do
	MOV	X,#02H
?L10:
 ;     begin
	MOV	A,X
	CLR	C
	SUBB	A,#01H
	JNC	$+5
	LJMP	?L11
 ;       y := theByte and $F;
	MOV	A,THEBYTE
	ANL	A,#0FH
	MOV	Y,A
 ;       theByte := theByte shr 4;
	MOV	A,#04H
	MOV	R6,A
	MOV	A,THEBYTE
	CLR	C
	RRC	A
	DJNZ	R6,$-2
	MOV	THEBYTE,A
 ;       NumToHex[x] := char(HexStr[y + 1]);
	MOV	A,X
	ADD	A,#NUMTOHEX?RET
	MOV	R0,A
	MOV	A,Y
	ADD	A,#01H
	MOV	DPTR,#HEXSTR
	ADD	A,DPL
	MOV	DPL,A
	JNC	$+4
	INC	DPH
	CLR	A
	MOVC	A,@A+DPTR
	MOV	@R0,A
 ;     end;
	DEC	X
	SJMP	?L10
?L11:
 ;  end;
	RET
 ;
 ;  function NumToBin (theByte: byte): string[4];
 RSEG	?CARDTERM?D
THEBYTE:	DS	01H
 RSEG	?CARDTERM?D
NUMTOBIN?RET:	DS	05H
 ;  begin
	RSEG	?CARDTERM?C

NUMTOBIN:
 ;   NumToBin := '0000';
	SJMP	$+7
?S445:
	DB	04H
?S446:
	DB	030H
	DB	030H
	DB	030H
	DB	030H
	MOV	DPTR,#?S445
	MOV	R1,#NUMTOBIN?RET
	MOV	07H,#05H
	LCALL	?MASSI4
 ;   for x := 4 downto 1 do
	MOV	X,#04H
?L12:
 ;     begin
	MOV	A,X
	CLR	C
	SUBB	A,#01H
	JNC	$+5
	LJMP	?L13
 ;       y := theByte and 1;
	MOV	A,THEBYTE
	ANL	A,#01H
	MOV	Y,A
 ;       theByte := theByte shr 1;
	MOV	A,#01H
	MOV	R6,A
	MOV	A,THEBYTE
	CLR	C
	RRC	A
	DJNZ	R6,$-2
	MOV	THEBYTE,A
 ;       NumToBin[x] := char(BinStr[y + 1]);
	MOV	A,X
	ADD	A,#NUMTOBIN?RET
	MOV	R0,A
	MOV	A,Y
	ADD	A,#01H
	MOV	DPTR,#BINSTR
	ADD	A,DPL
	MOV	DPL,A
	JNC	$+4
	INC	DPH
	CLR	A
	MOVC	A,@A+DPTR
	MOV	@R0,A
 ;     end;
	DEC	X
	SJMP	?L12
?L13:
 ;  end;
	RET
 ;
 ;
 ;{************************** I2C-Bus-Routinen *****************************}
 ;
 ;  function sendbyteI2C (daten: Byte): boolean;
 RSEG	?CARDTERM?D
DATEN:	DS	01H
 RSEG	?CARDTERM?B
SENDBYTEI2C?RET:	DBIT	01H
 ;{ sendet Byte, liefert True, wenn bertragung erfolgreich }
 ;  begin
	RSEG	?CARDTERM?C

SENDBYTEI2C:
 ;    for x := 7 downto 0 do
	MOV	X,#07H
?L14:
 ;      begin
	MOV	A,X
	CLR	C
	SUBB	A,#00H
	JNC	$+5
	LJMP	?L15
 ;        if ((daten shr x) and 1) = 1 then
	MOV	A,X
	MOV	R4,A
	MOV	A,DATEN
	LCALL	?BSHR
	ANL	A,#01H
	XRL	A,#01H
	JZ	$+5
	LJMP	?L16
 ;          P1.dta:=high
 ;        else
	SETB	P1
	LJMP	?L17
?L16:
 ;          P1.dta:=low;
	CLR	P1
?L17:
 ;        rwait;
	LCALL	RWAIT
 ;        P1.clk:=high;
	SETB	P1.01H
 ;        rwait;
	LCALL	RWAIT
 ;        P1.clk:=low;
	CLR	P1.01H
 ;        rwait;
	LCALL	RWAIT
 ;      end;
	DEC	X
	MOV	A,X
	INC	A
	JZ	$+5
	SJMP	?L14
	NOP
?L15:
 ;{ Quittierungsbit lesen }
 ;    P1.dta:=high;
	SETB	P1
 ;    rwait;
	LCALL	RWAIT
 ;    P1.clk:=high;
	SETB	P1.01H
 ;    rwait;
	LCALL	RWAIT
 ;    sendByteI2C := not P1.dta;
	MOV	C,P1
	CPL	C
	MOV	SENDBYTEI2C?RET,C
 ;    P1.clk:=low;
	CLR	P1.01H
 ;  end;
	RET
 ;
 ;  procedure receiveByteI2C (var daten: Byte; letzte: boolean);
 RSEG	?CARDTERM?D
DATEN:	DS	02H
 RSEG	?CARDTERM?B
LETZTE:	DBIT	01H
 ;{ Empfngt ein Datenbyte ber den I2C-Bus }
 ;{ daten:  empfangenes Datenbyte;  }
 ;{ letzte: Flag ob dieses Byte das letzte ist. Wenn ja, }
 ;{ dann invertiertes Quittungsbit senden }
 ;{ Am Anfang mu SCL=L sein, am Schlu ist SCL=L }
 ;  begin
	RSEG	?CARDTERM?C

RECEIVEBYTEI2C:
 ;    P1.dta:=high;
	SETB	P1
 ;    daten := 0;
	MOV	R0,DATEN
	MOV	@R0,#00H
 ;    P1.clk:=low;
	CLR	P1.01H
 ;    for x := 7 downto 0 do
	MOV	X,#07H
?L18:
 ;      begin
	MOV	A,X
	CLR	C
	SUBB	A,#00H
	JNC	$+5
	LJMP	?L19
 ;        P1.clk:=high;
	SETB	P1.01H
 ;        rwait;
	LCALL	RWAIT
 ;        daten := daten shl 1;
	MOV	R0,DATEN
	MOV	R1,DATEN
	MOV	A,#01H
	MOV	R6,A
	MOV	A,@R1
	CLR	C
	RLC	A
	DJNZ	R6,$-2
	MOV	@R0,A
 ;        if P1.dta then
	JB	P1,$+6
	LJMP	?L20
 ;          daten := succ(daten);
	MOV	R0,DATEN
	MOV	R1,DATEN
	MOV	A,@R1
	ADD	A,#01H
	MOV	@R0,A
?L20:
 ;        P1.clk:=low;
	CLR	P1.01H
 ;        rwait;
	LCALL	RWAIT
 ;      end;
	DEC	X
	MOV	A,X
	INC	A
	JZ	$+5
	SJMP	?L18
	NOP
?L19:
 ;{ Quittierungsbit senden }
 ;    if letzte then
	JB	LETZTE,$+6
	LJMP	?L21
 ;      P1.dta:=high
 ;    else
	SETB	P1
	LJMP	?L22
?L21:
 ;      P1.dta:=low;
	CLR	P1
?L22:
 ;    rwait;
	LCALL	RWAIT
 ;    P1.clk:=high;
	SETB	P1.01H
 ;    rwait;
	LCALL	RWAIT
 ;    P1.clk:=low;
	CLR	P1.01H
 ;    rwait;
	LCALL	RWAIT
 ;    P1.dta:=high;
	SETB	P1
 ;  end;
	RET
 ;
 ;  function SendI2C: boolean;
 RSEG	?CARDTERM?B
SENDI2C?RET:	DBIT	01H
 ;{ sendet kompletten Datenblock ber I2C-Datenbus. }
 ;{ SendI2C: TRUE - alles OK, FALSE - Error }
 ;  begin
	RSEG	?CARDTERM?C

SENDI2C:
 ;    P1.dta:=low;            { Start I2C }
	CLR	P1
 ;    rwait;
	LCALL	RWAIT
 ;    P1.clk:=low;
	CLR	P1.01H
 ;    if not SendByteI2C(device) then
	MOV	DATEN,DEVICE
	LCALL	SENDBYTEI2C
	JNB	SENDBYTEI2C?RET,$+6
	LJMP	?L23
 ;      begin
 ;        sendI2C := False;
	CLR	SENDI2C?RET
 ;        P1.dta:=low;        { Stop I2C }
	CLR	P1
 ;        rwait;
	LCALL	RWAIT
 ;        P1.clk:=high;
	SETB	P1.01H
 ;        rwait;
	LCALL	RWAIT
 ;        P1.dta:=high;
	SETB	P1
 ;        exit;
	RET
 ;      end;
?L23:
 ;    for y := 0 to count-1 do
	MOV	Y,#00H
?L24:
	MOV	A,COUNT
	CLR	C
	SUBB	A,#01H
 ;      begin
	MOV	R6,A
	MOV	A,Y
	SETB	C
	SUBB	A,R6
	JC	$+5
	LJMP	?L25
 ;        if not sendByteI2C(dataBuf[y]) then
	MOV	A,Y
	ADD	A,#DATABUF
	MOV	R0,A
	MOV	DATEN,@R0
	LCALL	SENDBYTEI2C
	JNB	SENDBYTEI2C?RET,$+6
	LJMP	?L26
 ;          begin
 ;            SendI2C := false;
	CLR	SENDI2C?RET
 ;            P1.dta:=low;        { Stop I2C }
	CLR	P1
 ;            rwait;
	LCALL	RWAIT
 ;            P1.clk:=high;
	SETB	P1.01H
 ;            rwait;
	LCALL	RWAIT
 ;            P1.dta:=high;
	SETB	P1
 ;            exit;
	RET
 ;          end;
?L26:
 ;      end; { For }
	INC	Y
	MOV	A,Y
	JZ	$+5
	SJMP	?L24
	NOP
?L25:
 ;    sendI2C := True;
	SETB	SENDI2C?RET
 ;    P1.dta:=low;            { Stop I2C }
	CLR	P1
 ;    rwait;
	LCALL	RWAIT
 ;    P1.clk:=high;
	SETB	P1.01H
 ;    rwait;
	LCALL	RWAIT
 ;    P1.dta:=high;
	SETB	P1
 ;  end;
	RET
 ;
 ;  function receiveI2C: boolean;
 RSEG	?CARDTERM?B
RECEIVEI2C?RET:	DBIT	01H
 ;{ Empfngt kompletten Datenblock ber I2C-Bus. }
 ;{ addr:		I2C-Adresse fr Lesen }
 ;{ cnt:	    Anzahl der zu empfangenden Datenbytes }
 ;{ dataBuf:	empfangener Datenblock }
 ;{ receiveI2C: TRUE - alles OK, FALSE - Error }
 ;    var
 ;      letzte: boolean;
 RSEG	?CARDTERM?B
LETZTE:	DBIT	01H
 ;  begin
	RSEG	?CARDTERM?C

RECEIVEI2C:
 ;    P1.dta:=low;            { Start I2C }
	CLR	P1
 ;    rwait;
	LCALL	RWAIT
 ;    P1.clk:=low;
	CLR	P1.01H
 ;{ Bausteinadresse schreiben }
 ;    if sendbyteI2C(device) = false then
	MOV	DATEN,DEVICE
	LCALL	SENDBYTEI2C
	MOV	C,SENDBYTEI2C?RET
	MOV	A,#00H
	RLC	A
	MOV	R6,A
	MOV	A,#00H
	XRL	A,R6
	JZ	$+5
	LJMP	?L27
 ;      begin
 ;        receiveI2C := false;
	CLR	RECEIVEI2C?RET
 ;        P1.dta:=low;        { Stop I2C }
	CLR	P1
 ;        rwait;
	LCALL	RWAIT
 ;        P1.clk:=high;
	SETB	P1.01H
 ;        rwait;
	LCALL	RWAIT
 ;        P1.dta:=high;
	SETB	P1
 ;        exit;     {Fehler}
	RET
 ;      end;
?L27:
 ;    P1.dta:=high;           { fr lesen }
	SETB	P1
 ;    letzte := false;
	CLR	LETZTE
 ;    for y := 0 to count-1 do
	MOV	Y,#00H
?L28:
	MOV	A,COUNT
	CLR	C
	SUBB	A,#01H
 ;      begin
	MOV	R6,A
	MOV	A,Y
	SETB	C
	SUBB	A,R6
	JC	$+5
	LJMP	?L29
 ;        if y = count-1 then
	MOV	A,COUNT
	CLR	C
	SUBB	A,#01H
	XRL	A,Y
	JZ	$+5
	LJMP	?L30
 ;          letzte := true;
	SETB	LETZTE
?L30:
 ;        receivebyteI2C(dataBuf[y], letzte);
	MOV	A,Y
	ADD	A,#DATABUF
	MOV	R0,A
	MOV	DATEN,R0
	MOV	DATEN+01H,R1
	MOV	C,LETZTE
	MOV	LETZTE,C
	LCALL	RECEIVEBYTEI2C
 ;      end;{for}
	INC	Y
	MOV	A,Y
	JZ	$+5
	SJMP	?L28
	NOP
?L29:
 ;    receiveI2C := true; {alles ok}
	SETB	RECEIVEI2C?RET
 ;    P1.dta:=low;        { Stop I2C }
	CLR	P1
 ;    rwait;
	LCALL	RWAIT
 ;    P1.clk:=high;
	SETB	P1.01H
 ;    rwait;
	LCALL	RWAIT
 ;    P1.dta:=high;
	SETB	P1
 ;  end;
	RET
 ;
 ;  procedure I2CCmd(MemCmd:byte);
 RSEG	?CARDTERM?D
MEMCMD:	DS	01H
 ;  begin
	RSEG	?CARDTERM?C

I2CCMD:
 ;    P1:=CdI2Cidle;
	MOV	P1,#0F3H
 ;    dataBuf[0]:=adrLo;
	MOV	DATABUF,ADRLO
 ;    dataBuf[1]:=value;
	MOV	DATABUF+01H,VALUE
 ;    case MemCmd of
 ;      I2CwriteC:
	MOV	A,MEMCMD
	XRL	A,#0A0H
	JZ	$+5
	LJMP	?L34
 ;{ Byte ber I2C schreiben: }
 ;        begin
?L33:
 ;          count:=2;
	MOV	COUNT,#02H
 ;{ obere Adressbits in Block Select einfgen }
 ;          device:=I2CWriteC or (adrHi shl 1);
	MOV	A,#01H
	MOV	R6,A
	MOV	A,ADRHI
	CLR	C
	RLC	A
	DJNZ	R6,$-2
	ORL	A,#0A0H
	MOV	DEVICE,A
 ;          ErrCond:=sendI2C;
	LCALL	SENDI2C
	MOV	C,SENDI2C?RET
	MOV	ERRCOND,C
 ;          pwait;
	LCALL	PWAIT
 ;        end;
?L31:
	LJMP	?L35
 ;      I2CreadC:
?L34:
	MOV	A,MEMCMD
	XRL	A,#0A1H
	JZ	$+5
	LJMP	?L38
 ;{ 4 Bytes ber I2C lesen: }
 ;        begin
?L37:
 ;          count:=1;
	MOV	COUNT,#01H
 ;          device:=I2CWriteC or (adrHi shl 1);
	MOV	A,#01H
	MOV	R6,A
	MOV	A,ADRHI
	CLR	C
	RLC	A
	DJNZ	R6,$-2
	ORL	A,#0A0H
	MOV	DEVICE,A
 ;          ErrCond:=sendI2C;
	LCALL	SENDI2C
	MOV	C,SENDI2C?RET
	MOV	ERRCOND,C
 ;          device:=I2CreadC or (adrHi shl 1);
	MOV	A,#01H
	MOV	R6,A
	MOV	A,ADRHI
	CLR	C
	RLC	A
	DJNZ	R6,$-2
	ORL	A,#0A1H
	MOV	DEVICE,A
 ;          count:=4;
	MOV	COUNT,#04H
 ;          if receiveI2C then;
	LCALL	RECEIVEI2C
	JB	RECEIVEI2C?RET,$+6
	LJMP	?L39
?L39:
 ;        end;
?L35:
	LJMP	?L40
 ;      end;
?L38:
?L40:
 ;  end;
	RET
 ;
 ;{*********************** Zweidraht-Bus-Routinen **************************}
 ;
 ;  procedure ZWDByteSend;
 ;{ Byte in y senden }
 ;  begin
	RSEG	?CARDTERM?C

ZWDBYTESEND:
 ;    for x := 0 to 7 do
	MOV	X,#00H
?L41:
 ;    begin
	MOV	A,X
	SETB	C
	SUBB	A,#07H
	JC	$+5
	LJMP	?L42
 ;      P1.clk:=low;
	CLR	P1.01H
 ;      if (y and 1) = 1 then
	MOV	A,Y
	ANL	A,#01H
	XRL	A,#01H
	JZ	$+5
	LJMP	?L43
 ;        P1.dta:=high
 ;      else
	SETB	P1
	LJMP	?L44
?L43:
 ;        P1.dta:=low;
	CLR	P1
?L44:
 ;      y:=y shr 1;
	MOV	A,#01H
	MOV	R6,A
	MOV	A,Y
	CLR	C
	RRC	A
	DJNZ	R6,$-2
	MOV	Y,A
 ;      P1.clk:=high;
	SETB	P1.01H
 ;    end;
	INC	X
	SJMP	?L41
?L42:
 ;  end;
	RET
 ;
 ;  procedure ZWDByteRecv;
 ;{ geliefertes Byte in y bergeben }
 ;  begin
	RSEG	?CARDTERM?C

ZWDBYTERECV:
 ;    y:=0;
	MOV	Y,#00H
 ;    for x := 0 to 7 do
	MOV	X,#00H
?L45:
 ;      begin
	MOV	A,X
	SETB	C
	SUBB	A,#07H
	JC	$+5
	LJMP	?L46
 ;        P1.clk:=low;
	CLR	P1.01H
 ;        rwait;
	LCALL	RWAIT
 ;        P1.clk:=high;
	SETB	P1.01H
 ;        y := y shr 1;
	MOV	A,#01H
	MOV	R6,A
	MOV	A,Y
	CLR	C
	RRC	A
	DJNZ	R6,$-2
	MOV	Y,A
 ;        if P1.dta then
	JB	P1,$+6
	LJMP	?L47
 ;          y:=y or $80;
	MOV	A,Y
	ORL	A,#080H
	MOV	Y,A
?L47:
 ;      end;
	INC	X
	SJMP	?L45
?L46:
 ;  end;
	RET
 ;
 ;  procedure ZWDCmd(MemCmd:byte);
 RSEG	?CARDTERM?D
MEMCMD:	DS	01H
 ;{ Befehl, Adresse und Datenbyte ber Zweidraht-IF schreiben }
 ;{ liefert 4 Datenbytes (0 bei Processing Mode) in dataBuf }
 ;  begin
	RSEG	?CARDTERM?C

ZWDCMD:
 ;    P1.clk:=high;
	SETB	P1.01H
 ;    rwait;
	LCALL	RWAIT
 ;    P1.dta:=low;
	CLR	P1
 ;    rwait;
	LCALL	RWAIT
 ;    y:=MemCmd;
	MOV	Y,MEMCMD
 ;    ZWDByteSend;
	LCALL	ZWDBYTESEND
 ;    y:=adrLo;
	MOV	Y,ADRLO
 ;    ZWDByteSend;
	LCALL	ZWDBYTESEND
 ;    y:=value;
	MOV	Y,VALUE
 ;    ZWDByteSend;
	LCALL	ZWDBYTESEND
 ;    P1.clk:=low;
	CLR	P1.01H
 ;    P1.dta:=low;
	CLR	P1
 ;    rwait;
	LCALL	RWAIT
 ;    P1.clk:=high;
	SETB	P1.01H
 ;    rwait;
	LCALL	RWAIT
 ;    P1.dta:=high;
	SETB	P1
 ;    rwait;
	LCALL	RWAIT
 ;
 ;    case MemCmd of
 ;      ZWDwriteC, ZWDwriteProtC, ZWDwriteSecC, ZWDcompvC:
	MOV	A,MEMCMD
	XRL	A,#038H
	JZ	$+5
	LJMP	?L51
?L50:
	LJMP	?L52
?L51:
	MOV	A,MEMCMD
	XRL	A,#03CH
	JZ	$+5
	LJMP	?L54
?L52:
	LJMP	?L55
?L54:
	MOV	A,MEMCMD
	XRL	A,#039H
	JZ	$+5
	LJMP	?L57
?L55:
	LJMP	?L58
?L57:
	MOV	A,MEMCMD
	XRL	A,#03BH
	JZ	$+5
	LJMP	?L60
 ;{ Warten auf "End of Processing" }
 ;        repeat
?L58:
?L61:
 ;          P1.clk:=low;
	CLR	P1.01H
 ;          rwait;
	LCALL	RWAIT
 ;          P1.clk:=high;
	SETB	P1.01H
 ;          rwait;
	LCALL	RWAIT
 ;        until P1.dta;
	JNB	P1,?L61
?L48:
	LJMP	?L62
 ;      ZWDreadC, ZWDreadProtC, ZWDreadSecC:
?L60:
	MOV	A,MEMCMD
	XRL	A,#030H
	JZ	$+5
	LJMP	?L65
?L64:
	LJMP	?L66
?L65:
	MOV	A,MEMCMD
	XRL	A,#034H
	JZ	$+5
	LJMP	?L68
?L66:
	LJMP	?L69
?L68:
	MOV	A,MEMCMD
	XRL	A,#031H
	JZ	$+5
	LJMP	?L71
 ;{ 4 Bytes in dataBuf ablegen }
 ;        for j:=0 to 3 do
?L69:
	MOV	J,#00H
?L72:
 ;        begin
	MOV	A,J
	SETB	C
	SUBB	A,#03H
	JC	$+5
	LJMP	?L73
 ;          ZWDByteRecv;
	LCALL	ZWDBYTERECV
 ;          dataBuf[j]:=y;
	MOV	A,J
	ADD	A,#DATABUF
	MOV	R0,A
	MOV	@R0,Y
 ;        end;
	INC	J
	SJMP	?L72
?L73:
?L62:
	LJMP	?L74
 ;    end;
?L71:
?L74:
 ;{ Abbrechen durch Reset }
 ;    P1.clk:=low;
	CLR	P1.01H
 ;    rwait;
	LCALL	RWAIT
 ;    P1.rst:=high;
	SETB	P1.02H
 ;    rwait;
	LCALL	RWAIT
 ;    P1.rst:=low;
	CLR	P1.02H
 ;  end;
	RET
 ;
 ;{*********************** Dreidraht-Bus-Routinen **************************}
 ;
 ;  procedure CardReset;
 ;  begin
	RSEG	?CARDTERM?C

CARDRESET:
 ;    P1:=CdOn;
	MOV	P1,#0F1H
 ;    rwait;
	LCALL	RWAIT
 ;    P1.rst:=high;
	SETB	P1.02H
 ;    rwait;
	LCALL	RWAIT
 ;    P1.clk:=high;
	SETB	P1.01H
 ;    rwait;
	LCALL	RWAIT
 ;    P1.clk:=low;
	CLR	P1.01H
 ;    rwait;
	LCALL	RWAIT
 ;    P1:=CdOn;
	MOV	P1,#0F1H
 ;  end;
	RET
 ;
 ;  procedure CardPOR;
 ;  begin
	RSEG	?CARDTERM?C

CARDPOR:
 ;    P1:=CdOff;
	MOV	P1,#0F8H
 ;    pwait;
	LCALL	PWAIT
 ;    CardReset;
	LCALL	CARDRESET
 ;  end;
	RET
 ;
 ;  procedure DRDCmd(MemCmd:byte);
 RSEG	?CARDTERM?D
MEMCMD:	DS	01H
 ;{ Befehl, Adresse und Datenbyte ber Dreidraht-IF schreiben }
 ;{ liefert 4 Datenbytes (0 bei Processing Mode) in dataBuf }
 ;  begin
	RSEG	?CARDTERM?C

DRDCMD:
 ;    CardReset;
	LCALL	CARDRESET
 ;    rwait;
	LCALL	RWAIT
 ;    P1.rst:=high;
	SETB	P1.02H
 ;{ obere zwei Adressbits in Command unterbringen, SLE4418 hat 1 KByte }
 ;    y:=MemCmd or (adrHi shr 6);
	MOV	A,#06H
	MOV	R6,A
	MOV	A,ADRHI
	CLR	C
	RRC	A
	DJNZ	R6,$-2
	ORL	A,MEMCMD
	MOV	Y,A
 ;    ZWDByteSend;
	LCALL	ZWDBYTESEND
 ;    y:=adrLo;
	MOV	Y,ADRLO
 ;    ZWDByteSend;
	LCALL	ZWDBYTESEND
 ;    y:=value;
	MOV	Y,VALUE
 ;    ZWDByteSend;
	LCALL	ZWDBYTESEND
 ;    P1.clk:=low;
	CLR	P1.01H
 ;    rwait;
	LCALL	RWAIT
 ;    P1.dta:=high;
	SETB	P1
 ;    P1.rst:=low;
	CLR	P1.02H
 ;
 ;    case MemCmd of
 ;      DRDwriteC, DRDwriteProtC:
	MOV	A,MEMCMD
	XRL	A,#033H
	JZ	$+5
	LJMP	?L78
?L77:
	LJMP	?L79
?L78:
	MOV	A,MEMCMD
	XRL	A,#030H
	JZ	$+5
	LJMP	?L81
 ;{ Warten auf "End of Processing" mit 50 kHz Takt }
 ;        for x:=0 to 202 do
?L79:
	MOV	X,#00H
?L82:
 ;          begin
	MOV	A,X
	SETB	C
	SUBB	A,#0CAH
	JC	$+5
	LJMP	?L83
 ;            P1.clk:=low;
	CLR	P1.01H
 ;            rwait;
	LCALL	RWAIT
 ;            P1.clk:=high;
	SETB	P1.01H
 ;          end;
	INC	X
	SJMP	?L82
?L83:
?L75:
	LJMP	?L84
 ;      DRDreadC:
?L81:
	MOV	A,MEMCMD
	XRL	A,#0EH
	JZ	$+5
	LJMP	?L87
 ;{ 4 Bytes in dataBuf ablegen }
 ;        for j:=0 to 3 do
?L86:
	MOV	J,#00H
?L88:
 ;        begin
	MOV	A,J
	SETB	C
	SUBB	A,#03H
	JC	$+5
	LJMP	?L89
 ;          ZWDByteRecv;
	LCALL	ZWDBYTERECV
 ;          dataBuf[j]:=y;
	MOV	A,J
	ADD	A,#DATABUF
	MOV	R0,A
	MOV	@R0,Y
 ;        end;
	INC	J
	SJMP	?L88
?L89:
?L84:
	LJMP	?L90
 ;    end;
?L87:
?L90:
 ;    P1.clk:=low;
	CLR	P1.01H
 ;  end;
	RET
 ;
 ;
 ;{*********************** Telefonkarten-Routinen **************************}
 ;
 ;  function TCdShiftNibble: byte;
 RSEG	?CARDTERM?D
TCDSHIFTNIBBLE?RET:	DS	01H
 ;{ Bits eines Nibble sammeln }
 ;  begin
	RSEG	?CARDTERM?C

TCDSHIFTNIBBLE:
 ;    x:= 0;
	MOV	X,#00H
 ;    for y := 0 to 3 do
	MOV	Y,#00H
?L91:
 ;      begin
	MOV	A,Y
	SETB	C
	SUBB	A,#03H
	JC	$+5
	LJMP	?L92
 ;        x:=x shr 1;
	MOV	A,#01H
	MOV	R6,A
	MOV	A,X
	CLR	C
	RRC	A
	DJNZ	R6,$-2
	MOV	X,A
 ;        if P1.dta then
	JB	P1,$+6
	LJMP	?L93
 ;          x:=x + 8;
	MOV	A,X
	ADD	A,#08H
	MOV	X,A
?L93:
 ;        P1.clk := high;
	SETB	P1.01H
 ;        rwait;
	LCALL	RWAIT
 ;        P1.clk := low;
	CLR	P1.01H
 ;        rwait;
	LCALL	RWAIT
 ;      end;
	INC	Y
	SJMP	?L91
?L92:
 ;    TCdShiftNibble:= x;
	MOV	TCDSHIFTNIBBLE?RET,X
 ;  end;
	RET
 ;
 ;  function TCdShiftByte: byte;
 RSEG	?CARDTERM?D
TCDSHIFTBYTE?RET:	DS	01H
 ;{ Bits eines Byte sammeln }
 ;  begin
	RSEG	?CARDTERM?C

TCDSHIFTBYTE:
 ;    x:= 0;
	MOV	X,#00H
 ;    for y := 0 to 7 do
	MOV	Y,#00H
?L94:
 ;      begin
	MOV	A,Y
	SETB	C
	SUBB	A,#07H
	JC	$+5
	LJMP	?L95
 ;        x:=x shr 1;
	MOV	A,#01H
	MOV	R6,A
	MOV	A,X
	CLR	C
	RRC	A
	DJNZ	R6,$-2
	MOV	X,A
 ;        if P1.dta then
	JB	P1,$+6
	LJMP	?L96
 ;          x:=x + 128;
	MOV	A,X
	ADD	A,#080H
	MOV	X,A
?L96:
 ;        P1.clk := high;
	SETB	P1.01H
 ;        rwait;
	LCALL	RWAIT
 ;        P1.clk := low;
	CLR	P1.01H
 ;        rwait;
	LCALL	RWAIT
 ;      end;
	INC	Y
	SJMP	?L94
?L95:
 ;    TCdShiftByte:= x;
	MOV	TCDSHIFTBYTE?RET,X
 ;  end;
	RET
 ;
 ;  function TCdAddByte: byte;
 RSEG	?CARDTERM?D
TCDADDBYTE?RET:	DS	01H
 ;{ Bits eines Byte addieren, fr Gebhrenstand }
 ;  begin
	RSEG	?CARDTERM?C

TCDADDBYTE:
 ;    x:=0;
	MOV	X,#00H
 ;    for y := 0 to 7 do
	MOV	Y,#00H
?L97:
 ;      begin
	MOV	A,Y
	SETB	C
	SUBB	A,#07H
	JC	$+5
	LJMP	?L98
 ;        if P1.dta then
	JB	P1,$+6
	LJMP	?L99
 ;          x:=x+1;
	MOV	A,X
	ADD	A,#01H
	MOV	X,A
?L99:
 ;        P1.clk := high;
	SETB	P1.01H
 ;        rwait;
	LCALL	RWAIT
 ;        P1.clk := low;
	CLR	P1.01H
 ;        rwait;
	LCALL	RWAIT
 ;      end;
	INC	Y
	SJMP	?L97
?L98:
 ;    TCdAddByte:=x;
	MOV	TCDADDBYTE?RET,X
 ;  end;
	RET
 ;
 ;  procedure TelCmd;
 ;{ Schreiben: Bit in adrLo adressieren und mit value Pulsen brennen }
 ;{ Lesen: nchste 4 Bytes in dataBuf zurckliefern. }
 ;  begin
	RSEG	?CARDTERM?C

TELCMD:
 ;    CardReset;
	LCALL	CARDRESET
 ;
 ;    if value>0 then
	MOV	A,VALUE
	SETB	C
	SUBB	A,#00H
	JNC	$+5
	LJMP	?L100
 ;{ Schreiben: Bit adressieren und 10ms-Pulse geben }
 ;      begin
 ;        if adrLo>0 then
	MOV	A,ADRLO
	SETB	C
	SUBB	A,#00H
	JNC	$+5
	LJMP	?L101
 ;          for j:= 1 to adrLo do
	MOV	J,#01H
?L102:
 ;            begin
	MOV	A,J
	SETB	C
	SUBB	A,ADRLO
	JC	$+5
	LJMP	?L103
 ;              P1.clk:=high;
	SETB	P1.01H
 ;              rwait;
	LCALL	RWAIT
 ;              P1.clk:=low;
	CLR	P1.01H
 ;            end;
	INC	J
	MOV	A,J
	JZ	$+5
	SJMP	?L102
	NOP
?L103:
?L101:
 ;        for j:= 0 to value-1 do
	MOV	J,#00H
?L104:
	MOV	A,VALUE
	CLR	C
	SUBB	A,#01H
 ;          begin
	MOV	R6,A
	MOV	A,J
	SETB	C
	SUBB	A,R6
	JC	$+5
	LJMP	?L105
 ;            P1.rst:=high;
	SETB	P1.02H
 ;            rwait;
	LCALL	RWAIT
 ;            P1.rst:=low;
	CLR	P1.02H
 ;            rwait;
	LCALL	RWAIT
 ;            P1.clk:=high;
	SETB	P1.01H
 ;            pwait;
	LCALL	PWAIT
 ;            P1.clk:=low;
	CLR	P1.01H
 ;            rwait;
	LCALL	RWAIT
 ;          end;
	INC	J
	MOV	A,J
	JZ	$+5
	SJMP	?L104
	NOP
?L105:
 ;      end
 ;    else
	LJMP	?L106
?L100:
 ;{ Lesen: Byte adressieren }
 ;      begin
 ;        if adrLo>0 then
	MOV	A,ADRLO
	SETB	C
	SUBB	A,#00H
	JNC	$+5
	LJMP	?L107
 ;          for j:= 1 to adrLo*8 do
	MOV	J,#01H
?L108:
	MOV	B,#08H
	MOV	A,ADRLO
	MUL	AB
 ;            begin
	MOV	R6,A
	MOV	A,J
	SETB	C
	SUBB	A,R6
	JC	$+5
	LJMP	?L109
 ;              P1.clk:=high;
	SETB	P1.01H
 ;              rwait;
	LCALL	RWAIT
 ;              P1.clk:=low;
	CLR	P1.01H
 ;            end;
	INC	J
	MOV	A,J
	JZ	$+5
	SJMP	?L108
	NOP
?L109:
?L107:
 ;        for j:=0 to 3 do
	MOV	J,#00H
?L110:
 ;          dataBuf[j]:=TcdShiftByte;
	MOV	A,J
	SETB	C
	SUBB	A,#03H
	JC	$+5
	LJMP	?L111
	MOV	A,J
	ADD	A,#DATABUF
	MOV	R0,A
	PUSH	00H
	LCALL	TCDSHIFTBYTE
	POP	00H
	MOV	@R0,TCDSHIFTBYTE?RET
	INC	J
	SJMP	?L110
?L111:
 ;      end;
?L106:
 ;  end;
	RET
 ;
 ;
 ;{*************** Karten-Initialisierung und ATR-Routinen *****************}
 ;
 ;  function CardInit: boolean;
 RSEG	?CARDTERM?B
CARDINIT?RET:	DBIT	01H
 ;{ liefert TRUE wenn Karte steckt }
 ;  begin
	RSEG	?CARDTERM?C

CARDINIT:
 ;    CardInit:=(P1.skt=(not noCard));
	MOV	C,P1.04H
	MOV	A,#00H
	RLC	A
	MOV	R6,A
	MOV	C,NOCARD
	CPL	C
	CLR	A
	RLC	A
	XRL	A,R6
	ADD	A,#0FFH
	CPL	C
	MOV	CARDINIT?RET,C
 ;    if P1.4=noCard then
	MOV	C,P1.04H
	MOV	A,#00H
	RLC	A
	MOV	R6,A
	MOV	C,NOCARD
	MOV	A,#00H
	RLC	A
	XRL	A,R6
	JZ	$+5
	LJMP	?L112
 ;      begin
 ;        write(display,char(12),'Karte einsetzen!');
	MOV	A,#0CH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#01H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	SJMP	$+19
?S1870:
	DB	010H
?S1871:
	DB	04BH
	DB	061H
	DB	072H
	DB	074H
	DB	065H
	DB	020H
	DB	065H
	DB	069H
	DB	06EH
	DB	073H
	DB	065H
	DB	074H
	DB	07AH
	DB	065H
	DB	06EH
	DB	021H
	MOV	DPTR,#?S1871
	MOV	R5,#01H
	MOV	R4,#01H
	MOV	R7,#010H
	MOV	R6,#00H
	LCALL	?WRITS
 ;        for i:=0 to 150 do
	MOV	I,#00H
?L113:
 ;        begin
	MOV	A,I
	SETB	C
	SUBB	A,#096H
	JC	$+5
	LJMP	?L114
 ;          if P1.skt=(not noCard) then
	MOV	C,P1.04H
	MOV	A,#00H
	RLC	A
	MOV	R6,A
	MOV	C,NOCARD
	CPL	C
	CLR	A
	RLC	A
	XRL	A,R6
	JZ	$+5
	LJMP	?L115
 ;            begin
 ;              i:=150;
	MOV	I,#096H
 ;              CardInit:=true;
	SETB	CARDINIT?RET
 ;              write(display,char(12));
	MOV	A,#0CH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#01H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
 ;            end;
?L115:
 ;          wait(1);
	MOV	ZEHNTELSEC,#LOW(01H)
	MOV	ZEHNTELSEC+01H,#00H
	LCALL	WAIT
 ;        end;
	INC	I
	SJMP	?L113
?L114:
 ;      end;
?L112:
 ;  end;
	RET
 ;
 ;  function CardExit: boolean;
 RSEG	?CARDTERM?B
CARDEXIT?RET:	DBIT	01H
 ;{ liefert TRUE wenn Karte entnommen }
 ;  begin
	RSEG	?CARDTERM?C

CARDEXIT:
 ;    P1:=CdOff;
	MOV	P1,#0F8H
 ;    CardExit:=(P1.skt=noCard);
	MOV	C,P1.04H
	MOV	A,#00H
	RLC	A
	MOV	R6,A
	MOV	C,NOCARD
	MOV	A,#00H
	RLC	A
	XRL	A,R6
	ADD	A,#0FFH
	CPL	C
	MOV	CARDEXIT?RET,C
 ;    if P1.4=(not noCard) then
	MOV	C,P1.04H
	MOV	A,#00H
	RLC	A
	MOV	R6,A
	MOV	C,NOCARD
	CPL	C
	CLR	A
	RLC	A
	XRL	A,R6
	JZ	$+5
	LJMP	?L116
 ;      begin
 ;        write(display,char(12),'Karte entnehmen!');
	MOV	A,#0CH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#01H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	SJMP	$+19
?S2017:
	DB	010H
?S2018:
	DB	04BH
	DB	061H
	DB	072H
	DB	074H
	DB	065H
	DB	020H
	DB	065H
	DB	06EH
	DB	074H
	DB	06EH
	DB	065H
	DB	068H
	DB	06DH
	DB	065H
	DB	06EH
	DB	021H
	MOV	DPTR,#?S2018
	MOV	R5,#01H
	MOV	R4,#01H
	MOV	R7,#010H
	MOV	R6,#00H
	LCALL	?WRITS
 ;        for i:=0 to 50 do
	MOV	I,#00H
?L117:
 ;        begin
	MOV	A,I
	SETB	C
	SUBB	A,#032H
	JC	$+5
	LJMP	?L118
 ;          if P1.skt=noCard then
	MOV	C,P1.04H
	MOV	A,#00H
	RLC	A
	MOV	R6,A
	MOV	C,NOCARD
	MOV	A,#00H
	RLC	A
	XRL	A,R6
	JZ	$+5
	LJMP	?L119
 ;            begin
 ;              i:=50;
	MOV	I,#032H
 ;              CardExit:=true;
	SETB	CARDEXIT?RET
 ;            end;
?L119:
 ;          wait(1);
	MOV	ZEHNTELSEC,#LOW(01H)
	MOV	ZEHNTELSEC+01H,#00H
	LCALL	WAIT
 ;        end;
	INC	I
	SJMP	?L117
?L118:
 ;        write(display,char(12));
	MOV	A,#0CH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#01H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
 ;      end;
?L116:
 ;  end;
	RET
 ;
 ;
 ;{************************* High-Level-Routinen ***************************}
 ;
 ;  procedure AdrMon;
 ;{ Adresse und Wert auf Display anzeigen }
 ;  begin
	RSEG	?CARDTERM?C

ADRMON:
 ;    if monDisp then
	JB	MONDISP,$+6
	LJMP	?L120
 ;      write(display,char(12),NumToHex(adrHi),NumToHex(adrLo),':');
	MOV	A,#0CH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#01H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	MOV	THEBYTE,ADRHI
	LCALL	NUMTOHEX
	MOV	R0,#NUMTOHEX?RET
	MOV	R5,#01H
	MOV	R4,#01H
	MOV	A,@R0
	INC	R0
	MOV	R7,A
	MOV	R6,#01H
	LCALL	?WRITS
	MOV	THEBYTE,ADRLO
	LCALL	NUMTOHEX
	MOV	R0,#NUMTOHEX?RET
	MOV	R5,#01H
	MOV	R4,#01H
	MOV	A,@R0
	INC	R0
	MOV	R7,A
	MOV	R6,#01H
	LCALL	?WRITS
	MOV	A,#03AH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#01H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
?L120:
 ;  end;
	RET
 ;
 ;  procedure ValMon;
 ;{ Adresse und Wert auf Display anzeigen }
 ;  begin
	RSEG	?CARDTERM?C

VALMON:
 ;    if monDisp then
	JB	MONDISP,$+6
	LJMP	?L121
 ;      begin
 ;        write(display,char(13),char(9),char(9),char(9),char(9),char(9));
	MOV	A,#0DH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#01H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	MOV	A,#09H
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#01H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	MOV	A,#09H
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#01H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	MOV	A,#09H
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#01H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	MOV	A,#09H
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#01H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	MOV	A,#09H
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#01H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
 ;        write(display,NumToHex(value));
	MOV	THEBYTE,VALUE
	LCALL	NUMTOHEX
	MOV	R0,#NUMTOHEX?RET
	MOV	R5,#01H
	MOV	R4,#01H
	MOV	A,@R0
	INC	R0
	MOV	R7,A
	MOV	R6,#01H
	LCALL	?WRITS
 ;        if (value>31) and (value<127) then
	MOV	A,VALUE
	SETB	C
	SUBB	A,#01FH
	CPL	C
	CLR	A
	RLC	A
	MOV	R6,A
	MOV	A,VALUE
	CLR	C
	SUBB	A,#07FH
	MOV	A,R6
	ANL	C,ACC
	JC	$+5
	LJMP	?L122
 ;          write(display,'="',char(value),'"')
	SJMP	$+5
?S2320:
	DB	02H
?S2321:
	DB	03DH
	DB	022H
	MOV	DPTR,#?S2321
	MOV	R5,#01H
	MOV	R4,#01H
	MOV	R7,#02H
	MOV	R6,#00H
	LCALL	?WRITS
	MOV	A,VALUE
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#01H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	MOV	A,#022H
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#01H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
 ;        else
	LJMP	?L123
?L122:
 ;          write(display,'    ');
	SJMP	$+7
?S2370:
	DB	04H
?S2371:
	DB	020H
	DB	020H
	DB	020H
	DB	020H
	MOV	DPTR,#?S2371
	MOV	R5,#01H
	MOV	R4,#01H
	MOV	R7,#04H
	MOV	R6,#00H
	LCALL	?WRITS
?L123:
 ;      end;
?L121:
 ;  end;
	RET
 ;
 ;  procedure CardATRtoBuf;
 ;{ rohen ATR einlesen }
 ;  begin
	RSEG	?CARDTERM?C

CARDATRTOBUF:
 ;    CardPOR;
	LCALL	CARDPOR
 ;    for j:=0 to 3 do
	MOV	J,#00H
?L124:
 ;      begin
	MOV	A,J
	SETB	C
	SUBB	A,#03H
	JC	$+5
	LJMP	?L125
 ;        i:=TCdShiftByte;
	LCALL	TCDSHIFTBYTE
	MOV	I,TCDSHIFTBYTE?RET
 ;        dataBuf[j]:=i;
	MOV	A,J
	ADD	A,#DATABUF
	MOV	R0,A
	MOV	@R0,I
 ;      end;
	INC	J
	SJMP	?L124
?L125:
 ;    P1:=CdOn;
	MOV	P1,#0F1H
 ;  end;
	RET
 ;
 ;  procedure SetISOparam;
 ;{ ISO-Parameter nach ATR im Buffer setzen }
 ;  begin
	RSEG	?CARDTERM?C

SETISOPARAM:
 ;    ISOprtk:=dataBuf[0] shr 4;
	MOV	A,#04H
	MOV	R6,A
	MOV	A,DATABUF
	CLR	C
	RRC	A
	DJNZ	R6,$-2
	MOV	ISOPRTK,A
 ;    ISOstruc:=dataBuf[0] and 3;
	MOV	A,DATABUF
	ANL	A,#03H
	MOV	ISOSTRUC,A
 ;    ISOsize:=(dataBuf[1] shr 3) and 7;
	MOV	A,#03H
	MOV	R6,A
	MOV	A,DATABUF+01H
	CLR	C
	RRC	A
	DJNZ	R6,$-2
	ANL	A,#07H
	MOV	ISOSIZE,A
 ;    d:=dataBuf[1] and 3;
	MOV	A,DATABUF+01H
	ANL	A,#03H
	MOV	D,A
 ;    ISOlng:=1;
	MOV	ISOLNG,#01H
 ;    ISOlng:=ISOlng shl d;
	MOV	A,D
	MOV	R4,A
	MOV	A,ISOLNG
	LCALL	?BSHL
	MOV	ISOLNG,A
 ;  end;
	RET
 ;
 ;  procedure GetProtParams;
 ;{ liest ATR, sofern vorhanden, und stellt Ruhezustand ein }
 ;  begin
	RSEG	?CARDTERM?C

GETPROTPARAMS:
 ;    CardATRtoBuf;
	LCALL	CARDATRTOBUF
 ;    SetISOparam;
	LCALL	SETISOPARAM
 ;    case ISOprtk of
 ;      I2CprtkC:
	MOV	A,ISOPRTK
	XRL	A,#08H
	JZ	$+5
	LJMP	?L129
 ;        P1:=CdI2Cidle;
?L128:
	MOV	P1,#0F3H
?L126:
	LJMP	?L130
 ;      ZWDprtkC:
?L129:
	MOV	A,ISOPRTK
	XRL	A,#0AH
	JZ	$+5
	LJMP	?L133
 ;        begin
?L132:
 ;          P1:=CdOn;
	MOV	P1,#0F1H
 ;          rwait;
	LCALL	RWAIT
 ;          P1.rst:=high;
	SETB	P1.02H
 ;          rwait;
	LCALL	RWAIT
 ;          P1.rst:=low;
	CLR	P1.02H
 ;        end;
?L130:
	LJMP	?L134
 ;      DRDprtkC,Tel0PrtkC,Tel1PrtkC,Tel2PrtkC:
?L133:
	MOV	A,ISOPRTK
	XRL	A,#09H
	JZ	$+5
	LJMP	?L137
?L136:
	LJMP	?L138
?L137:
	MOV	A,ISOPRTK
	JZ	$+5
	LJMP	?L140
?L138:
	LJMP	?L141
?L140:
	MOV	A,ISOPRTK
	XRL	A,#02H
	JZ	$+5
	LJMP	?L143
?L141:
	LJMP	?L144
?L143:
	MOV	A,ISOPRTK
	XRL	A,#04H
	JZ	$+5
	LJMP	?L146
 ;        CardPOR;
?L144:
	LCALL	CARDPOR
?L134:
	LJMP	?L147
 ;      else
?L146:
 ;{ ISO-Parameter dann eventuell in den ersten 4 Bytes des I2C-EEPROM }
 ;        begin
 ;          P1:=CdI2Cidle;
	MOV	P1,#0F3H
 ;          adrLo:=0;
	MOV	ADRLO,#00H
 ;          adrHi:=0;
	MOV	ADRHI,#00H
 ;          value:=0;
	MOV	VALUE,#00H
 ;          I2CCmd(I2CreadC);
	MOV	MEMCMD,#0A1H
	LCALL	I2CCMD
 ;          SetISOparam;
	LCALL	SETISOPARAM
 ;          if ISOprtk<>I2CprtkC then
	MOV	A,ISOPRTK
	XRL	A,#08H
	JNZ	$+5
	LJMP	?L148
 ;            begin
 ;              ISOprtk:=NoATRC;
	MOV	ISOPRTK,#0FH
 ;              ISOstruc:=2;
	MOV	ISOSTRUC,#02H
 ;              ISOsize:=2;
	MOV	ISOSIZE,#02H
 ;              ISOlng:=3;
	MOV	ISOLNG,#03H
 ;            end;
?L148:
 ;        end;
 ;    end;
?L147:
 ;    case ISOprtk of
 ;    Tel0PrtkC,Tel1PrtkC,Tel2PrtkC:
	MOV	A,ISOPRTK
	JZ	$+5
	LJMP	?L152
?L151:
	LJMP	?L153
?L152:
	MOV	A,ISOPRTK
	XRL	A,#02H
	JZ	$+5
	LJMP	?L155
?L153:
	LJMP	?L156
?L155:
	MOV	A,ISOPRTK
	XRL	A,#04H
	JZ	$+5
	LJMP	?L158
 ;      begin
?L156:
 ;        ISOsize:=1;
	MOV	ISOSIZE,#01H
 ;        ISOlng:=1;
	MOV	ISOLNG,#01H
 ;      end;
?L149:
	LJMP	?L159
 ;    end;
?L158:
?L159:
 ;    adrLo:=0;
	MOV	ADRLO,#00H
 ;    adrHi:=0;
	MOV	ADRHI,#00H
 ;  end;
	RET
 ;
 ;  procedure WriteCard;
 ;{ Beschreibt Kartenadresse in adrHi, adrLo mit value }
 ;  begin
	RSEG	?CARDTERM?C

WRITECARD:
 ;    AdrMon;
	LCALL	ADRMON
 ;    ValMon;
	LCALL	VALMON
 ;    case ISOprtk of
 ;      NoATRC, I2CprtkC:
	MOV	A,ISOPRTK
	XRL	A,#0FH
	JZ	$+5
	LJMP	?L163
?L162:
	LJMP	?L164
?L163:
	MOV	A,ISOPRTK
	XRL	A,#08H
	JZ	$+5
	LJMP	?L166
 ;        I2CCmd(I2CwriteC);
?L164:
	MOV	MEMCMD,#0A0H
	LCALL	I2CCMD
?L160:
	LJMP	?L167
 ;      Tel0PrtkC,Tel1prtkC,Tel2prtkC:
?L166:
	MOV	A,ISOPRTK
	JZ	$+5
	LJMP	?L170
?L169:
	LJMP	?L171
?L170:
	MOV	A,ISOPRTK
	XRL	A,#02H
	JZ	$+5
	LJMP	?L173
?L171:
	LJMP	?L174
?L173:
	MOV	A,ISOPRTK
	XRL	A,#04H
	JZ	$+5
	LJMP	?L176
 ;        TelCmd;
?L174:
	LCALL	TELCMD
?L167:
	LJMP	?L177
 ;      ZWDprtkC:
?L176:
	MOV	A,ISOPRTK
	XRL	A,#0AH
	JZ	$+5
	LJMP	?L180
 ;        ZWDCmd(ZWDwriteC);
?L179:
	MOV	MEMCMD,#038H
	LCALL	ZWDCMD
?L177:
	LJMP	?L181
 ;      DRDprtkC:
?L180:
	MOV	A,ISOPRTK
	XRL	A,#09H
	JZ	$+5
	LJMP	?L184
 ;        DRDCmd(DRDwriteC);
?L183:
	MOV	MEMCMD,#033H
	LCALL	DRDCMD
?L181:
	LJMP	?L185
 ;    end;
?L184:
?L185:
 ;    aInt:=adrHi*256+adrLo+1;
	MOV	R4,#LOW(0100H)
	MOV	R5,#HIGH(0100H)
	MOV	R2,ADRHI
	MOV	R3,#00H
	LCALL	?IMUL
	MOV	A,R2
	ADD	A,ADRLO
	MOV	R2,A
	MOV	A,R3
	ADDC	A,#00H
	MOV	R3,A
	MOV	A,R2
	ADD	A,#LOW(01H)
	MOV	R2,A
	MOV	A,R3
	ADDC	A,#HIGH(01H)
	MOV	R3,A
	MOV	AINT,R2
	MOV	AINT+01H,R3
 ;    adrHi:=aInt shr 8;
	MOV	R4,#LOW(08H)
	MOV	R5,#HIGH(08H)
	MOV	R2,AINT
	MOV	R3,AINT+01H
	LCALL	?ISHR
	MOV	A,R2
	MOV	ADRHI,A
 ;    adrLo:=aInt and $FF;
	MOV	A,AINT
	ANL	A,#LOW(0FFH)
	MOV	R2,A
	MOV	A,AINT+01H
	ANL	A,#HIGH(0FFH)
	MOV	R3,A
	MOV	A,R2
	MOV	ADRLO,A
 ;  end;
	RET
 ;
 ;  procedure DispatchCard;
 ;{ Lesezugriff auf zugehrige Routine verteilen }
 ;  begin
	RSEG	?CARDTERM?C

DISPATCHCARD:
 ;    case ISOprtk of
 ;      NoATRC, I2CprtkC:
	MOV	A,ISOPRTK
	XRL	A,#0FH
	JZ	$+5
	LJMP	?L189
?L188:
	LJMP	?L190
?L189:
	MOV	A,ISOPRTK
	XRL	A,#08H
	JZ	$+5
	LJMP	?L192
 ;        I2CCmd(I2CreadC);
?L190:
	MOV	MEMCMD,#0A1H
	LCALL	I2CCMD
?L186:
	LJMP	?L193
 ;      Tel0PrtkC,Tel1prtkC,Tel2prtkC:
?L192:
	MOV	A,ISOPRTK
	JZ	$+5
	LJMP	?L196
?L195:
	LJMP	?L197
?L196:
	MOV	A,ISOPRTK
	XRL	A,#02H
	JZ	$+5
	LJMP	?L199
?L197:
	LJMP	?L200
?L199:
	MOV	A,ISOPRTK
	XRL	A,#04H
	JZ	$+5
	LJMP	?L202
 ;        TelCmd;
?L200:
	LCALL	TELCMD
?L193:
	LJMP	?L203
 ;      ZWDprtkC:
?L202:
	MOV	A,ISOPRTK
	XRL	A,#0AH
	JZ	$+5
	LJMP	?L206
 ;        ZWDCmd(ZWDreadC);
?L205:
	MOV	MEMCMD,#030H
	LCALL	ZWDCMD
?L203:
	LJMP	?L207
 ;      DRDprtkC:
?L206:
	MOV	A,ISOPRTK
	XRL	A,#09H
	JZ	$+5
	LJMP	?L210
 ;        DRDCmd(DRDreadC);
?L209:
	MOV	MEMCMD,#0EH
	LCALL	DRDCMD
?L207:
	LJMP	?L211
 ;    end;
?L210:
?L211:
 ;  end;
	RET
 ;
 ;  procedure ReadCard;
 ;{ Anzahl value Werte lesen und hexadezimal seriell ausgeben }
 ;  begin
	RSEG	?CARDTERM?C

READCARD:
 ;    AdrMon;
	LCALL	ADRMON
 ;    if value<>0 then
	MOV	A,VALUE
	JNZ	$+5
	LJMP	?L212
 ;      begin
 ;        value:=value-1;
	MOV	A,VALUE
	CLR	C
	SUBB	A,#01H
	MOV	VALUE,A
 ;        f:=value div 4;
	MOV	B,#04H
	MOV	A,VALUE
	DIV	AB
	MOV	F,A
 ;        g:=value mod 4;
	MOV	B,#04H
	MOV	A,VALUE
	DIV	AB
	MOV	A,B
	MOV	G,A
 ;        for e:=0 to f do
	MOV	E,#00H
?L213:
 ;          begin
	MOV	A,E
	SETB	C
	SUBB	A,F
	JC	$+5
	LJMP	?L214
 ;            value:=0;
	MOV	VALUE,#00H
 ;            DispatchCard;
	LCALL	DISPATCHCARD
 ;            if e = f then
	MOV	A,E
	XRL	A,F
	JZ	$+5
	LJMP	?L215
 ;              c:=g
 ;            else
	MOV	C,G
	LJMP	?L216
?L215:
 ;              c:=3;
	MOV	C,#03H
?L216:
 ;            for d := 0 to c do
	MOV	D,#00H
?L217:
 ;              begin
	MOV	A,D
	SETB	C
	SUBB	A,C
	JC	$+5
	LJMP	?L218
 ;                AdrMon;
	LCALL	ADRMON
 ;                aInt:=adrHi*256+adrLo+1;
	MOV	R4,#LOW(0100H)
	MOV	R5,#HIGH(0100H)
	MOV	R2,ADRHI
	MOV	R3,#00H
	LCALL	?IMUL
	MOV	A,R2
	ADD	A,ADRLO
	MOV	R2,A
	MOV	A,R3
	ADDC	A,#00H
	MOV	R3,A
	MOV	A,R2
	ADD	A,#LOW(01H)
	MOV	R2,A
	MOV	A,R3
	ADDC	A,#HIGH(01H)
	MOV	R3,A
	MOV	AINT,R2
	MOV	AINT+01H,R3
 ;                adrHi:=aInt shr 8;
	MOV	R4,#LOW(08H)
	MOV	R5,#HIGH(08H)
	MOV	R2,AINT
	MOV	R3,AINT+01H
	LCALL	?ISHR
	MOV	A,R2
	MOV	ADRHI,A
 ;                adrLo:=aInt and $FF;
	MOV	A,AINT
	ANL	A,#LOW(0FFH)
	MOV	R2,A
	MOV	A,AINT+01H
	ANL	A,#HIGH(0FFH)
	MOV	R3,A
	MOV	A,R2
	MOV	ADRLO,A
 ;                value:=dataBuf[d];
	MOV	A,D
	ADD	A,#DATABUF
	MOV	R0,A
	MOV	VALUE,@R0
 ;                ValMon;
	LCALL	VALMON
 ;                write(serial,NumToHex(value));
	MOV	THEBYTE,VALUE
	LCALL	NUMTOHEX
	MOV	R0,#NUMTOHEX?RET
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	A,@R0
	INC	R0
	MOV	R7,A
	MOV	R6,#01H
	LCALL	?WRITS
 ;                if (d<c) or (e<f) then
	MOV	A,D
	CLR	C
	SUBB	A,C
	CLR	A
	RLC	A
	MOV	R6,A
	MOV	A,E
	CLR	C
	SUBB	A,F
	MOV	A,R6
	ORL	C,ACC
	JC	$+5
	LJMP	?L219
 ;                  write(serial,',');
	MOV	A,#02CH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
?L219:
 ;              end;
	INC	D
	MOV	A,D
	JZ	$+5
	LJMP	?L217
	NOP
?L218:
 ;          end;
	INC	E
	MOV	A,E
	JZ	$+5
	LJMP	?L213
	NOP
?L214:
 ;      end
 ;    else
	LJMP	?L220
?L212:
 ;      write(serial,'OK');
	SJMP	$+5
?S3169:
	DB	02H
?S3170:
	DB	04FH
	DB	04BH
	MOV	DPTR,#?S3170
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	R7,#02H
	MOV	R6,#00H
	LCALL	?WRITS
?L220:
 ;  end;
	RET
 ;
 ;  procedure MemCdDisplay;
 ;{ fr Stand-Alone-Betrieb: Kartendaten auslesen und anzeigen }
 ;  begin
	RSEG	?CARDTERM?C

MEMCDDISPLAY:
 ;    aInt:=0;
	MOV	AINT,#LOW(00H)
	MOV	AINT+01H,#00H
 ;    repeat
?L221:
 ;      write(display,char(13),NumToHex(Hi(aInt)),NumToHex(Lo(aInt)),': ');
	MOV	A,#0DH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#01H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	MOV	THEBYTE,AINT+01H
	LCALL	NUMTOHEX
	MOV	R0,#NUMTOHEX?RET
	MOV	R5,#01H
	MOV	R4,#01H
	MOV	A,@R0
	INC	R0
	MOV	R7,A
	MOV	R6,#01H
	LCALL	?WRITS
	MOV	A,AINT
	MOV	THEBYTE,A
	LCALL	NUMTOHEX
	MOV	R0,#NUMTOHEX?RET
	MOV	R5,#01H
	MOV	R4,#01H
	MOV	A,@R0
	INC	R0
	MOV	R7,A
	MOV	R6,#01H
	LCALL	?WRITS
	SJMP	$+5
?S3250:
	DB	02H
?S3251:
	DB	03AH
	DB	020H
	MOV	DPTR,#?S3251
	MOV	R5,#01H
	MOV	R4,#01H
	MOV	R7,#02H
	MOV	R6,#00H
	LCALL	?WRITS
 ;      for f:=0 to 2 do
	MOV	F,#00H
?L222:
 ;        begin
	MOV	A,F
	SETB	C
	SUBB	A,#02H
	JC	$+5
	LJMP	?L223
 ;          value:=0;
	MOV	VALUE,#00H
 ;          adrHi:=aInt shr 8;
	MOV	R4,#LOW(08H)
	MOV	R5,#HIGH(08H)
	MOV	R2,AINT
	MOV	R3,AINT+01H
	LCALL	?ISHR
	MOV	A,R2
	MOV	ADRHI,A
 ;          adrLo:=aInt and $FF;
	MOV	A,AINT
	ANL	A,#LOW(0FFH)
	MOV	R2,A
	MOV	A,AINT+01H
	ANL	A,#HIGH(0FFH)
	MOV	R3,A
	MOV	A,R2
	MOV	ADRLO,A
 ;          DispatchCard;
	LCALL	DISPATCHCARD
 ;          for e:=0 to 3 do
	MOV	E,#00H
?L224:
 ;            begin
	MOV	A,E
	SETB	C
	SUBB	A,#03H
	JC	$+5
	LJMP	?L225
 ;              value:=dataBuf[e];
	MOV	A,E
	ADD	A,#DATABUF
	MOV	R0,A
	MOV	VALUE,@R0
 ;              if (value>31) and (value<127) then
	MOV	A,VALUE
	SETB	C
	SUBB	A,#01FH
	CPL	C
	CLR	A
	RLC	A
	MOV	R6,A
	MOV	A,VALUE
	CLR	C
	SUBB	A,#07FH
	MOV	A,R6
	ANL	C,ACC
	JC	$+5
	LJMP	?L226
 ;                write(display,char(value))
	MOV	A,VALUE
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#01H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
 ;              else
	LJMP	?L227
?L226:
 ;                write(display,'.');
	MOV	A,#02EH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#01H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
?L227:
 ;            end;
	INC	E
	SJMP	?L224
?L225:
 ;          aInt:=adrHi*256+adrLo+4;
	MOV	R4,#LOW(0100H)
	MOV	R5,#HIGH(0100H)
	MOV	R2,ADRHI
	MOV	R3,#00H
	LCALL	?IMUL
	MOV	A,R2
	ADD	A,ADRLO
	MOV	R2,A
	MOV	A,R3
	ADDC	A,#00H
	MOV	R3,A
	MOV	A,R2
	ADD	A,#LOW(04H)
	MOV	R2,A
	MOV	A,R3
	ADDC	A,#HIGH(04H)
	MOV	R3,A
	MOV	AINT,R2
	MOV	AINT+01H,R3
 ;        end;
	INC	F
	LJMP	?L222
?L223:
 ;      aInt:=aInt-11;
	MOV	A,AINT
	CLR	C
	SUBB	A,#LOW(0BH)
	MOV	R2,A
	MOV	A,AINT+01H
	SUBB	A,#HIGH(0BH)
	MOV	R3,A
	MOV	AINT,R2
	MOV	AINT+01H,R3
 ;      wait(2);
	MOV	ZEHNTELSEC,#LOW(02H)
	MOV	ZEHNTELSEC+01H,#00H
	LCALL	WAIT
 ;      repeat
?L228:
 ;      until P1.switch=low;
	MOV	C,P1.07H
	MOV	A,#00H
	RLC	A
	MOV	R6,A
	MOV	A,#00H
	XRL	A,R6
	JNZ	?L228
 ;    until P1.skt=noCard;
	MOV	C,P1.04H
	MOV	A,#00H
	RLC	A
	MOV	R6,A
	MOV	C,NOCARD
	MOV	A,#00H
	RLC	A
	XRL	A,R6
	JZ	$+5
	LJMP	?L221
 ;  end;
	RET
 ;
 ;  procedure GetTelCdData;
 ;{ Telefonkarten-Nibbles in cliBuf eintragen und Restwert ermitteln }
 ;  begin
	RSEG	?CARDTERM?C

GETTELCDDATA:
 ;    CardReset;
	LCALL	CARDRESET
 ;{ ATR und Fllbyte bergehen }
 ;    for f:=1 to 3 do
	MOV	F,#01H
?L229:
 ;      d:=TCdshiftByte;
	MOV	A,F
	SETB	C
	SUBB	A,#03H
	JC	$+5
	LJMP	?L230
	LCALL	TCDSHIFTBYTE
	MOV	D,TCDSHIFTBYTE?RET
	INC	F
	SJMP	?L229
?L230:
 ;{ Manufacturer Data }
 ;    for f:=0 to 9 do
	MOV	F,#00H
?L231:
 ;      cliBuf[f]:=TCdshiftNibble;
	MOV	A,F
	SETB	C
	SUBB	A,#09H
	JC	$+5
	LJMP	?L232
	MOV	A,F
	ADD	A,#CLIBUF
	MOV	R0,A
	PUSH	00H
	LCALL	TCDSHIFTNIBBLE
	POP	00H
	MOV	@R0,TCDSHIFTNIBBLE?RET
	INC	F
	SJMP	?L231
?L232:
 ;{ Rest-Gebhrenstand }
 ;    d:=TCdAddByte shl 6;
	LCALL	TCDADDBYTE
	MOV	A,#06H
	MOV	R6,A
	MOV	A,TCDADDBYTE?RET
	CLR	C
	RLC	A
	DJNZ	R6,$-2
	MOV	D,A
 ;    d:=d or TCdAddByte shl 3;
	LCALL	TCDADDBYTE
	MOV	A,#03H
	MOV	R6,A
	MOV	A,TCDADDBYTE?RET
	CLR	C
	RLC	A
	DJNZ	R6,$-2
	ORL	A,D
	MOV	D,A
 ;    d:=d or TCdAddByte;
	LCALL	TCDADDBYTE
	MOV	A,D
	ORL	A,TCDADDBYTE?RET
	MOV	D,A
 ;    aInt:=d;
	MOV	AINT,D
	MOV	AINT+01H,#00H
 ;    aInt:=aInt shl 6;
	MOV	R4,#LOW(06H)
	MOV	R5,#HIGH(06H)
	MOV	R2,AINT
	MOV	R3,AINT+01H
	LCALL	?ISHL
	MOV	AINT,R2
	MOV	AINT+01H,R3
 ;    d:=TCdAddByte shl 3;
	LCALL	TCDADDBYTE
	MOV	A,#03H
	MOV	R6,A
	MOV	A,TCDADDBYTE?RET
	CLR	C
	RLC	A
	DJNZ	R6,$-2
	MOV	D,A
 ;    d:=d or TCdAddByte;
	LCALL	TCDADDBYTE
	MOV	A,D
	ORL	A,TCDADDBYTE?RET
	MOV	D,A
 ;    aInt:=aInt or d;
	MOV	A,AINT
	ORL	A,D
	MOV	R2,A
	MOV	A,AINT+01H
	ORL	A,#00H
	MOV	R3,A
	MOV	AINT,R2
	MOV	AINT+01H,R3
 ;    P1:=CdOff;
	MOV	P1,#0F8H
 ;{ Restwert in aInt }
 ;  end;
	RET
 ;
 ;  procedure TelCdAnalyze;
 ;{ fr Stand-Alone-Betrieb: Telefonkartendaten analysieren und anzeigen }
 ;  begin
	RSEG	?CARDTERM?C

TELCDANALYZE:
 ;    repeat
?L233:
 ;      GetTelCdData;
	LCALL	GETTELCDDATA
 ;      if cliBuf[1]=5 then
	MOV	A,CLIBUF+01H
	XRL	A,#05H
	JZ	$+5
	LJMP	?L234
 ;        write(display,char(12),TelStr)
	MOV	A,#0CH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#01H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	MOV	DPTR,#TELSTR
	MOV	R5,#01H
	MOV	R4,#01H
	CLR	A
	MOVC	A,@A+DPTR
	INC	DPTR
	MOV	R7,A
	MOV	R6,#00H
	LCALL	?WRITS
 ;      else
	LJMP	?L235
?L234:
 ;        write(display,char(12),unbStr,'[',d,']');
	MOV	A,#0CH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#01H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	MOV	DPTR,#UNBSTR
	MOV	R5,#01H
	MOV	R4,#01H
	CLR	A
	MOVC	A,@A+DPTR
	INC	DPTR
	MOV	R7,A
	MOV	R6,#00H
	LCALL	?WRITS
	MOV	A,#05BH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#01H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	MOV	R6,#01H
	MOV	R7,#01H
	MOV	R2,D
	MOV	R3,#00H
	LCALL	?WRITI
	MOV	A,#05DH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#01H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
?L235:
 ;      wait(15);
	MOV	ZEHNTELSEC,#LOW(0FH)
	MOV	ZEHNTELSEC+01H,#00H
	LCALL	WAIT
 ;{ Anhalten, wenn Schalter bettigt }
 ;      repeat
?L236:
 ;      until P1.switch=low;
	MOV	C,P1.07H
	MOV	A,#00H
	RLC	A
	MOV	R6,A
	MOV	A,#00H
	XRL	A,R6
	JNZ	?L236
 ;      write(display,char(12),'von ');
	MOV	A,#0CH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#01H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	SJMP	$+7
?S3787:
	DB	04H
?S3788:
	DB	076H
	DB	06FH
	DB	06EH
	DB	020H
	MOV	DPTR,#?S3788
	MOV	R5,#01H
	MOV	R4,#01H
	MOV	R7,#04H
	MOV	R6,#00H
	LCALL	?WRITS
 ;      case cliBuf[0] of
 ;        0:
	MOV	A,CLIBUF
	JZ	$+5
	LJMP	?L240
 ;          write(display,'Orga');
?L239:
	SJMP	$+7
?S3815:
	DB	04H
?S3816:
	DB	04FH
	DB	072H
	DB	067H
	DB	061H
	MOV	DPTR,#?S3816
	MOV	R5,#01H
	MOV	R4,#01H
	MOV	R7,#04H
	MOV	R6,#00H
	LCALL	?WRITS
?L237:
	LJMP	?L241
 ;        1:
?L240:
	MOV	A,CLIBUF
	XRL	A,#01H
	JZ	$+5
	LJMP	?L244
 ;          write(display,'G&D');
?L243:
	SJMP	$+6
?S3848:
	DB	03H
?S3849:
	DB	047H
	DB	026H
	DB	044H
	MOV	DPTR,#?S3849
	MOV	R5,#01H
	MOV	R4,#01H
	MOV	R7,#03H
	MOV	R6,#00H
	LCALL	?WRITS
?L241:
	LJMP	?L245
 ;        2:
?L244:
	MOV	A,CLIBUF
	XRL	A,#02H
	JZ	$+5
	LJMP	?L248
 ;          write(display,'ODS');
?L247:
	SJMP	$+6
?S3880:
	DB	03H
?S3881:
	DB	04FH
	DB	044H
	DB	053H
	MOV	DPTR,#?S3881
	MOV	R5,#01H
	MOV	R4,#01H
	MOV	R7,#03H
	MOV	R6,#00H
	LCALL	?WRITS
?L245:
	LJMP	?L249
 ;        3:
?L248:
	MOV	A,CLIBUF
	XRL	A,#03H
	JZ	$+5
	LJMP	?L252
 ;          write(display,'Gemplus');
?L251:
	SJMP	$+10
?S3912:
	DB	07H
?S3913:
	DB	047H
	DB	065H
	DB	06DH
	DB	070H
	DB	06CH
	DB	075H
	DB	073H
	MOV	DPTR,#?S3913
	MOV	R5,#01H
	MOV	R4,#01H
	MOV	R7,#07H
	MOV	R6,#00H
	LCALL	?WRITS
?L249:
	LJMP	?L253
 ;        4:
?L252:
	MOV	A,CLIBUF
	XRL	A,#04H
	JZ	$+5
	LJMP	?L256
 ;          write(display,'Solaic');
?L255:
	SJMP	$+9
?S3948:
	DB	06H
?S3949:
	DB	053H
	DB	06FH
	DB	06CH
	DB	061H
	DB	069H
	DB	063H
	MOV	DPTR,#?S3949
	MOV	R5,#01H
	MOV	R4,#01H
	MOV	R7,#06H
	MOV	R6,#00H
	LCALL	?WRITS
?L253:
	LJMP	?L257
 ;        5:
?L256:
	MOV	A,CLIBUF
	XRL	A,#05H
	JZ	$+5
	LJMP	?L260
 ;          write(display,'Uniqa');
?L259:
	SJMP	$+8
?S3983:
	DB	05H
?S3984:
	DB	055H
	DB	06EH
	DB	069H
	DB	071H
	DB	061H
	MOV	DPTR,#?S3984
	MOV	R5,#01H
	MOV	R4,#01H
	MOV	R7,#05H
	MOV	R6,#00H
	LCALL	?WRITS
?L257:
	LJMP	?L261
 ;        6:
?L260:
	MOV	A,CLIBUF
	XRL	A,#06H
	JZ	$+5
	LJMP	?L264
 ;          write(display,'Schlumberger');
?L263:
	SJMP	$+15
?S4017:
	DB	0CH
?S4018:
	DB	053H
	DB	063H
	DB	068H
	DB	06CH
	DB	075H
	DB	06DH
	DB	062H
	DB	065H
	DB	072H
	DB	067H
	DB	065H
	DB	072H
	MOV	DPTR,#?S4018
	MOV	R5,#01H
	MOV	R4,#01H
	MOV	R7,#0CH
	MOV	R6,#00H
	LCALL	?WRITS
?L261:
	LJMP	?L265
 ;        else
?L264:
 ;          write(display,unbStr,'[',d,']');
	MOV	DPTR,#UNBSTR
	MOV	R5,#01H
	MOV	R4,#01H
	CLR	A
	MOVC	A,@A+DPTR
	INC	DPTR
	MOV	R7,A
	MOV	R6,#00H
	LCALL	?WRITS
	MOV	A,#05BH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#01H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	MOV	R6,#01H
	MOV	R7,#01H
	MOV	R2,D
	MOV	R3,#00H
	LCALL	?WRITI
	MOV	A,#05DH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#01H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
 ;      end;
?L265:
 ;      wait(15);
	MOV	ZEHNTELSEC,#LOW(0FH)
	MOV	ZEHNTELSEC+01H,#00H
	LCALL	WAIT
 ;      repeat
?L266:
 ;      until P1.switch=low;
	MOV	C,P1.07H
	MOV	A,#00H
	RLC	A
	MOV	R6,A
	MOV	A,#00H
	XRL	A,R6
	JNZ	?L266
 ;      write(display,char(12),'Datum ',cliBuf[4],'/9',cliBuf[3]);
	MOV	A,#0CH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#01H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	SJMP	$+9
?S4138:
	DB	06H
?S4139:
	DB	044H
	DB	061H
	DB	074H
	DB	075H
	DB	06DH
	DB	020H
	MOV	DPTR,#?S4139
	MOV	R5,#01H
	MOV	R4,#01H
	MOV	R7,#06H
	MOV	R6,#00H
	LCALL	?WRITS
	MOV	R6,#01H
	MOV	R7,#01H
	MOV	R2,CLIBUF+04H
	MOV	R3,#00H
	LCALL	?WRITI
	SJMP	$+5
?S4172:
	DB	02H
?S4173:
	DB	02FH
	DB	039H
	MOV	DPTR,#?S4173
	MOV	R5,#01H
	MOV	R4,#01H
	MOV	R7,#02H
	MOV	R6,#00H
	LCALL	?WRITS
	MOV	R6,#01H
	MOV	R7,#01H
	MOV	R2,CLIBUF+03H
	MOV	R3,#00H
	LCALL	?WRITI
 ;      wait(15);
	MOV	ZEHNTELSEC,#LOW(0FH)
	MOV	ZEHNTELSEC+01H,#00H
	LCALL	WAIT
 ;      repeat
?L267:
 ;      until P1.switch=low;
	MOV	C,P1.07H
	MOV	A,#00H
	RLC	A
	MOV	R6,A
	MOV	A,#00H
	XRL	A,R6
	JNZ	?L267
 ;      write(display,char(12),'SerNr ');
	MOV	A,#0CH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#01H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	SJMP	$+9
?S4236:
	DB	06H
?S4237:
	DB	053H
	DB	065H
	DB	072H
	DB	04EH
	DB	072H
	DB	020H
	MOV	DPTR,#?S4237
	MOV	R5,#01H
	MOV	R4,#01H
	MOV	R7,#06H
	MOV	R6,#00H
	LCALL	?WRITS
 ;      write(display,cliBuf[0]);
	MOV	R6,#01H
	MOV	R7,#01H
	MOV	R2,CLIBUF
	MOV	R3,#00H
	LCALL	?WRITI
 ;      write(display,cliBuf[3]);
	MOV	R6,#01H
	MOV	R7,#01H
	MOV	R2,CLIBUF+03H
	MOV	R3,#00H
	LCALL	?WRITI
 ;      if cliBuf[4]<10 then
	MOV	A,CLIBUF+04H
	CLR	C
	SUBB	A,#0AH
	JC	$+5
	LJMP	?L268
 ;        write(display,'0');
	MOV	A,#030H
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#01H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
?L268:
 ;      write(display,cliBuf[4]);
	MOV	R6,#01H
	MOV	R7,#01H
	MOV	R2,CLIBUF+04H
	MOV	R3,#00H
	LCALL	?WRITI
 ;      for e:=9 downto 5 do
	MOV	E,#09H
?L269:
 ;        write(display,cliBuf[e]);
	MOV	A,E
	CLR	C
	SUBB	A,#05H
	JNC	$+5
	LJMP	?L270
	MOV	A,E
	ADD	A,#CLIBUF
	MOV	R0,A
	MOV	R6,#01H
	MOV	R7,#01H
	MOV	A,@R0
	MOV	R2,A
	MOV	R3,#00H
	LCALL	?WRITI
	DEC	E
	SJMP	?L269
?L270:
 ;      wait(15);
	MOV	ZEHNTELSEC,#LOW(0FH)
	MOV	ZEHNTELSEC+01H,#00H
	LCALL	WAIT
 ;      repeat
?L271:
 ;      until P1.switch=low;
	MOV	C,P1.07H
	MOV	A,#00H
	RLC	A
	MOV	R6,A
	MOV	A,#00H
	XRL	A,R6
	JNZ	?L271
 ;      write(display,char(12),'Nennwert ');
	MOV	A,#0CH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#01H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	SJMP	$+12
?S4383:
	DB	09H
?S4384:
	DB	04EH
	DB	065H
	DB	06EH
	DB	06EH
	DB	077H
	DB	065H
	DB	072H
	DB	074H
	DB	020H
	MOV	DPTR,#?S4384
	MOV	R5,#01H
	MOV	R4,#01H
	MOV	R7,#09H
	MOV	R6,#00H
	LCALL	?WRITS
 ;      case cliBuf[2] of
 ;        3:
	MOV	A,CLIBUF+02H
	XRL	A,#03H
	JZ	$+5
	LJMP	?L275
 ;          write(display,'1,50 DM');
?L274:
	SJMP	$+10
?S4418:
	DB	07H
?S4419:
	DB	031H
	DB	02CH
	DB	035H
	DB	030H
	DB	020H
	DB	044H
	DB	04DH
	MOV	DPTR,#?S4419
	MOV	R5,#01H
	MOV	R4,#01H
	MOV	R7,#07H
	MOV	R6,#00H
	LCALL	?WRITS
?L272:
	LJMP	?L276
 ;        4:
?L275:
	MOV	A,CLIBUF+02H
	XRL	A,#04H
	JZ	$+5
	LJMP	?L279
 ;          write(display,'6 DM');
?L278:
	SJMP	$+7
?S4454:
	DB	04H
?S4455:
	DB	036H
	DB	020H
	DB	044H
	DB	04DH
	MOV	DPTR,#?S4455
	MOV	R5,#01H
	MOV	R4,#01H
	MOV	R7,#04H
	MOV	R6,#00H
	LCALL	?WRITS
?L276:
	LJMP	?L280
 ;        5:
?L279:
	MOV	A,CLIBUF+02H
	XRL	A,#05H
	JZ	$+5
	LJMP	?L283
 ;          write(display,'12 DM');
?L282:
	SJMP	$+8
?S4487:
	DB	05H
?S4488:
	DB	031H
	DB	032H
	DB	020H
	DB	044H
	DB	04DH
	MOV	DPTR,#?S4488
	MOV	R5,#01H
	MOV	R4,#01H
	MOV	R7,#05H
	MOV	R6,#00H
	LCALL	?WRITS
?L280:
	LJMP	?L284
 ;        6:
?L283:
	MOV	A,CLIBUF+02H
	XRL	A,#06H
	JZ	$+5
	LJMP	?L287
 ;          write(display,'50 DM');
?L286:
	SJMP	$+8
?S4521:
	DB	05H
?S4522:
	DB	035H
	DB	030H
	DB	020H
	DB	044H
	DB	04DH
	MOV	DPTR,#?S4522
	MOV	R5,#01H
	MOV	R4,#01H
	MOV	R7,#05H
	MOV	R6,#00H
	LCALL	?WRITS
?L284:
	LJMP	?L288
 ;        else
?L287:
 ;          write(display,'[',cliBuf[1],']');
	MOV	A,#05BH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#01H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	MOV	R6,#01H
	MOV	R7,#01H
	MOV	R2,CLIBUF+01H
	MOV	R3,#00H
	LCALL	?WRITI
	MOV	A,#05DH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#01H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
 ;      end;
?L288:
 ;      wait(15);
	MOV	ZEHNTELSEC,#LOW(0FH)
	MOV	ZEHNTELSEC+01H,#00H
	LCALL	WAIT
 ;      repeat
?L289:
 ;      until P1.switch=low;
	MOV	C,P1.07H
	MOV	A,#00H
	RLC	A
	MOV	R6,A
	MOV	A,#00H
	XRL	A,R6
	JNZ	?L289
 ;      write(display,char(12),'Rest ');
	MOV	A,#0CH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#01H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	SJMP	$+8
?S4619:
	DB	05H
?S4620:
	DB	052H
	DB	065H
	DB	073H
	DB	074H
	DB	020H
	MOV	DPTR,#?S4620
	MOV	R5,#01H
	MOV	R4,#01H
	MOV	R7,#05H
	MOV	R6,#00H
	LCALL	?WRITS
 ;      write(display,aInt div 100,',');
	MOV	R4,#LOW(064H)
	MOV	R5,#HIGH(064H)
	MOV	R2,AINT
	MOV	R3,AINT+01H
	LCALL	?IDIV
	MOV	R6,#01H
	MOV	R7,#01H
	LCALL	?WRITI
	MOV	A,#02CH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#01H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
 ;      if aInt mod 100 < 10 then
	MOV	R4,#LOW(064H)
	MOV	R5,#HIGH(064H)
	MOV	R2,AINT
	MOV	R3,AINT+01H
	LCALL	?IMOD
	MOV	A,R2
	CLR	C
	SUBB	A,#LOW(0AH)
	MOV	A,R3
	XRL	A,#080H
	SUBB	A,#HIGH(0800AH)
	JC	$+5
	LJMP	?L290
 ;        write(display,'0');
	MOV	A,#030H
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#01H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
?L290:
 ;      write(display,aInt mod 100,' DM');
	MOV	R4,#LOW(064H)
	MOV	R5,#HIGH(064H)
	MOV	R2,AINT
	MOV	R3,AINT+01H
	LCALL	?IMOD
	MOV	R6,#01H
	MOV	R7,#01H
	LCALL	?WRITI
	SJMP	$+6
?S4730:
	DB	03H
?S4731:
	DB	020H
	DB	044H
	DB	04DH
	MOV	DPTR,#?S4731
	MOV	R5,#01H
	MOV	R4,#01H
	MOV	R7,#03H
	MOV	R6,#00H
	LCALL	?WRITS
 ;      wait(15);
	MOV	ZEHNTELSEC,#LOW(0FH)
	MOV	ZEHNTELSEC+01H,#00H
	LCALL	WAIT
 ;      repeat
?L291:
 ;      until P1.switch=low;
	MOV	C,P1.07H
	MOV	A,#00H
	RLC	A
	MOV	R6,A
	MOV	A,#00H
	XRL	A,R6
	JNZ	?L291
 ;    until P1.skt=noCard;
	MOV	C,P1.04H
	MOV	A,#00H
	RLC	A
	MOV	R6,A
	MOV	C,NOCARD
	MOV	A,#00H
	RLC	A
	XRL	A,R6
	JZ	$+5
	LJMP	?L233
 ;  end;
	RET
 ;
 ;  procedure TelCdSerAnalyze;
 ;{ Telefonkartendaten analysieren und Daten seriell ausgeben }
 ;  begin
	RSEG	?CARDTERM?C

TELCDSERANALYZE:
 ;    if CardInit then;
	LCALL	CARDINIT
	JB	CARDINIT?RET,$+6
	LJMP	?L292
?L292:
 ;    CardATRtoBuf;
	LCALL	CARDATRTOBUF
 ;    write(serial,ATRStr);
	MOV	DPTR,#ATRSTR
	MOV	R5,#00H
	MOV	R4,#01H
	CLR	A
	MOVC	A,@A+DPTR
	INC	DPTR
	MOV	R7,A
	MOV	R6,#00H
	LCALL	?WRITS
 ;    for j:=0 to 1 do
	MOV	J,#00H
?L293:
 ;      write(Serial,NumToHex(dataBuf[j]));
	MOV	A,J
	SETB	C
	SUBB	A,#01H
	JC	$+5
	LJMP	?L294
	MOV	A,J
	ADD	A,#DATABUF
	MOV	R0,A
	MOV	THEBYTE,@R0
	LCALL	NUMTOHEX
	MOV	R0,#NUMTOHEX?RET
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	A,@R0
	INC	R0
	MOV	R7,A
	MOV	R6,#01H
	LCALL	?WRITS
	INC	J
	SJMP	?L293
?L294:
 ;    GetProtParams;
	LCALL	GETPROTPARAMS
 ;    GetTelCdData;
	LCALL	GETTELCDDATA
 ;    if cliBuf[1]=5 then
	MOV	A,CLIBUF+01H
	XRL	A,#05H
	JZ	$+5
	LJMP	?L295
 ;      write(serial,char(13),TelStr)
	MOV	A,#0DH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	MOV	DPTR,#TELSTR
	MOV	R5,#00H
	MOV	R4,#01H
	CLR	A
	MOVC	A,@A+DPTR
	INC	DPTR
	MOV	R7,A
	MOV	R6,#00H
	LCALL	?WRITS
 ;    else
	LJMP	?L296
?L295:
 ;      write(serial,char(13),'Keine ',TelStr,'[',d,']');
	MOV	A,#0DH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	SJMP	$+9
?S4919:
	DB	06H
?S4920:
	DB	04BH
	DB	065H
	DB	069H
	DB	06EH
	DB	065H
	DB	020H
	MOV	DPTR,#?S4920
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	R7,#06H
	MOV	R6,#00H
	LCALL	?WRITS
	MOV	DPTR,#TELSTR
	MOV	R5,#00H
	MOV	R4,#01H
	CLR	A
	MOVC	A,@A+DPTR
	INC	DPTR
	MOV	R7,A
	MOV	R6,#00H
	LCALL	?WRITS
	MOV	A,#05BH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	MOV	R6,#00H
	MOV	R7,#01H
	MOV	R2,D
	MOV	R3,#00H
	LCALL	?WRITI
	MOV	A,#05DH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
?L296:
 ;    write(serial,char(13),'Hersteller: ');
	MOV	A,#0DH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	SJMP	$+15
?S5011:
	DB	0CH
?S5012:
	DB	048H
	DB	065H
	DB	072H
	DB	073H
	DB	074H
	DB	065H
	DB	06CH
	DB	06CH
	DB	065H
	DB	072H
	DB	03AH
	DB	020H
	MOV	DPTR,#?S5012
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	R7,#0CH
	MOV	R6,#00H
	LCALL	?WRITS
 ;    case cliBuf[0] of
 ;      0:
	MOV	A,CLIBUF
	JZ	$+5
	LJMP	?L300
 ;        write(serial,'Orga Kartensysteme');
?L299:
	SJMP	$+21
?S5047:
	DB	012H
?S5048:
	DB	04FH
	DB	072H
	DB	067H
	DB	061H
	DB	020H
	DB	04BH
	DB	061H
	DB	072H
	DB	074H
	DB	065H
	DB	06EH
	DB	073H
	DB	079H
	DB	073H
	DB	074H
	DB	065H
	DB	06DH
	DB	065H
	MOV	DPTR,#?S5048
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	R7,#012H
	MOV	R6,#00H
	LCALL	?WRITS
?L297:
	LJMP	?L301
 ;      1:
?L300:
	MOV	A,CLIBUF
	XRL	A,#01H
	JZ	$+5
	LJMP	?L304
 ;        write(serial,'Giesecke & Devrient');
?L303:
	SJMP	$+22
?S5094:
	DB	013H
?S5095:
	DB	047H
	DB	069H
	DB	065H
	DB	073H
	DB	065H
	DB	063H
	DB	06BH
	DB	065H
	DB	020H
	DB	026H
	DB	020H
	DB	044H
	DB	065H
	DB	076H
	DB	072H
	DB	069H
	DB	065H
	DB	06EH
	DB	074H
	MOV	DPTR,#?S5095
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	R7,#013H
	MOV	R6,#00H
	LCALL	?WRITS
?L301:
	LJMP	?L305
 ;      2:
?L304:
	MOV	A,CLIBUF
	XRL	A,#02H
	JZ	$+5
	LJMP	?L308
 ;        write(serial,'Oldenbourg Daten Systeme');
?L307:
	SJMP	$+27
?S5142:
	DB	018H
?S5143:
	DB	04FH
	DB	06CH
	DB	064H
	DB	065H
	DB	06EH
	DB	062H
	DB	06FH
	DB	075H
	DB	072H
	DB	067H
	DB	020H
	DB	044H
	DB	061H
	DB	074H
	DB	065H
	DB	06EH
	DB	020H
	DB	053H
	DB	079H
	DB	073H
	DB	074H
	DB	065H
	DB	06DH
	DB	065H
	MOV	DPTR,#?S5143
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	R7,#018H
	MOV	R6,#00H
	LCALL	?WRITS
?L305:
	LJMP	?L309
 ;      3:
?L308:
	MOV	A,CLIBUF
	XRL	A,#03H
	JZ	$+5
	LJMP	?L312
 ;        write(serial,'Gemplus');
?L311:
	SJMP	$+10
?S5195:
	DB	07H
?S5196:
	DB	047H
	DB	065H
	DB	06DH
	DB	070H
	DB	06CH
	DB	075H
	DB	073H
	MOV	DPTR,#?S5196
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	R7,#07H
	MOV	R6,#00H
	LCALL	?WRITS
?L309:
	LJMP	?L313
 ;      4:
?L312:
	MOV	A,CLIBUF
	XRL	A,#04H
	JZ	$+5
	LJMP	?L316
 ;        write(serial,'Solaic');
?L315:
	SJMP	$+9
?S5231:
	DB	06H
?S5232:
	DB	053H
	DB	06FH
	DB	06CH
	DB	061H
	DB	069H
	DB	063H
	MOV	DPTR,#?S5232
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	R7,#06H
	MOV	R6,#00H
	LCALL	?WRITS
?L313:
	LJMP	?L317
 ;      5:
?L316:
	MOV	A,CLIBUF
	XRL	A,#05H
	JZ	$+5
	LJMP	?L320
 ;        write(serial,'Uniqa');
?L319:
	SJMP	$+8
?S5266:
	DB	05H
?S5267:
	DB	055H
	DB	06EH
	DB	069H
	DB	071H
	DB	061H
	MOV	DPTR,#?S5267
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	R7,#05H
	MOV	R6,#00H
	LCALL	?WRITS
?L317:
	LJMP	?L321
 ;      6:
?L320:
	MOV	A,CLIBUF
	XRL	A,#06H
	JZ	$+5
	LJMP	?L324
 ;        write(serial,'Schlumberger');
?L323:
	SJMP	$+15
?S5300:
	DB	0CH
?S5301:
	DB	053H
	DB	063H
	DB	068H
	DB	06CH
	DB	075H
	DB	06DH
	DB	062H
	DB	065H
	DB	072H
	DB	067H
	DB	065H
	DB	072H
	MOV	DPTR,#?S5301
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	R7,#0CH
	MOV	R6,#00H
	LCALL	?WRITS
?L321:
	LJMP	?L325
 ;      else
?L324:
 ;        write(serial,unbStr,'[',d,']');
	MOV	DPTR,#UNBSTR
	MOV	R5,#00H
	MOV	R4,#01H
	CLR	A
	MOVC	A,@A+DPTR
	INC	DPTR
	MOV	R7,A
	MOV	R6,#00H
	LCALL	?WRITS
	MOV	A,#05BH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	MOV	R6,#00H
	MOV	R7,#01H
	MOV	R2,D
	MOV	R3,#00H
	LCALL	?WRITI
	MOV	A,#05DH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
 ;    end;
?L325:
 ;    write(serial,char(13),'Herstellungsdatum: ',cliBuf[4],'/9',cliBuf[3]);
	MOV	A,#0DH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	SJMP	$+22
?S5401:
	DB	013H
?S5402:
	DB	048H
	DB	065H
	DB	072H
	DB	073H
	DB	074H
	DB	065H
	DB	06CH
	DB	06CH
	DB	075H
	DB	06EH
	DB	067H
	DB	073H
	DB	064H
	DB	061H
	DB	074H
	DB	075H
	DB	06DH
	DB	03AH
	DB	020H
	MOV	DPTR,#?S5402
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	R7,#013H
	MOV	R6,#00H
	LCALL	?WRITS
	MOV	R6,#00H
	MOV	R7,#01H
	MOV	R2,CLIBUF+04H
	MOV	R3,#00H
	LCALL	?WRITI
	SJMP	$+5
?S5448:
	DB	02H
?S5449:
	DB	02FH
	DB	039H
	MOV	DPTR,#?S5449
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	R7,#02H
	MOV	R6,#00H
	LCALL	?WRITS
	MOV	R6,#00H
	MOV	R7,#01H
	MOV	R2,CLIBUF+03H
	MOV	R3,#00H
	LCALL	?WRITI
 ;    write(serial,char(13),'Seriennummer: ');
	MOV	A,#0DH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	SJMP	$+17
?S5492:
	DB	0EH
?S5493:
	DB	053H
	DB	065H
	DB	072H
	DB	069H
	DB	065H
	DB	06EH
	DB	06EH
	DB	075H
	DB	06DH
	DB	06DH
	DB	065H
	DB	072H
	DB	03AH
	DB	020H
	MOV	DPTR,#?S5493
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	R7,#0EH
	MOV	R6,#00H
	LCALL	?WRITS
 ;    write(serial,cliBuf[0]);
	MOV	R6,#00H
	MOV	R7,#01H
	MOV	R2,CLIBUF
	MOV	R3,#00H
	LCALL	?WRITI
 ;    write(serial,cliBuf[3]);
	MOV	R6,#00H
	MOV	R7,#01H
	MOV	R2,CLIBUF+03H
	MOV	R3,#00H
	LCALL	?WRITI
 ;    if cliBuf[4]<10 then
	MOV	A,CLIBUF+04H
	CLR	C
	SUBB	A,#0AH
	JC	$+5
	LJMP	?L326
 ;      write(serial,'0');
	MOV	A,#030H
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
?L326:
 ;    write(serial,cliBuf[4]);
	MOV	R6,#00H
	MOV	R7,#01H
	MOV	R2,CLIBUF+04H
	MOV	R3,#00H
	LCALL	?WRITI
 ;    for e:=9 downto 5 do
	MOV	E,#09H
?L327:
 ;      write(serial,cliBuf[e]);
	MOV	A,E
	CLR	C
	SUBB	A,#05H
	JNC	$+5
	LJMP	?L328
	MOV	A,E
	ADD	A,#CLIBUF
	MOV	R0,A
	MOV	R6,#00H
	MOV	R7,#01H
	MOV	A,@R0
	MOV	R2,A
	MOV	R3,#00H
	LCALL	?WRITI
	DEC	E
	SJMP	?L327
?L328:
 ;    write(serial,char(13),'Nennwert: ');
	MOV	A,#0DH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	SJMP	$+13
?S5627:
	DB	0AH
?S5628:
	DB	04EH
	DB	065H
	DB	06EH
	DB	06EH
	DB	077H
	DB	065H
	DB	072H
	DB	074H
	DB	03AH
	DB	020H
	MOV	DPTR,#?S5628
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	R7,#0AH
	MOV	R6,#00H
	LCALL	?WRITS
 ;    case cliBuf[2] of
 ;      3:
	MOV	A,CLIBUF+02H
	XRL	A,#03H
	JZ	$+5
	LJMP	?L332
 ;        write(serial,'1,50 DM');
?L331:
	SJMP	$+10
?S5663:
	DB	07H
?S5664:
	DB	031H
	DB	02CH
	DB	035H
	DB	030H
	DB	020H
	DB	044H
	DB	04DH
	MOV	DPTR,#?S5664
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	R7,#07H
	MOV	R6,#00H
	LCALL	?WRITS
?L329:
	LJMP	?L333
 ;      4:
?L332:
	MOV	A,CLIBUF+02H
	XRL	A,#04H
	JZ	$+5
	LJMP	?L336
 ;        write(serial,'6 DM');
?L335:
	SJMP	$+7
?S5699:
	DB	04H
?S5700:
	DB	036H
	DB	020H
	DB	044H
	DB	04DH
	MOV	DPTR,#?S5700
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	R7,#04H
	MOV	R6,#00H
	LCALL	?WRITS
?L333:
	LJMP	?L337
 ;      5:
?L336:
	MOV	A,CLIBUF+02H
	XRL	A,#05H
	JZ	$+5
	LJMP	?L340
 ;        write(serial,'12 DM');
?L339:
	SJMP	$+8
?S5732:
	DB	05H
?S5733:
	DB	031H
	DB	032H
	DB	020H
	DB	044H
	DB	04DH
	MOV	DPTR,#?S5733
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	R7,#05H
	MOV	R6,#00H
	LCALL	?WRITS
?L337:
	LJMP	?L341
 ;      6:
?L340:
	MOV	A,CLIBUF+02H
	XRL	A,#06H
	JZ	$+5
	LJMP	?L344
 ;        write(serial,'50 DM');
?L343:
	SJMP	$+8
?S5766:
	DB	05H
?S5767:
	DB	035H
	DB	030H
	DB	020H
	DB	044H
	DB	04DH
	MOV	DPTR,#?S5767
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	R7,#05H
	MOV	R6,#00H
	LCALL	?WRITS
?L341:
	LJMP	?L345
 ;      else
?L344:
 ;        write(serial,'[',cliBuf[1],']');
	MOV	A,#05BH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	MOV	R6,#00H
	MOV	R7,#01H
	MOV	R2,CLIBUF+01H
	MOV	R3,#00H
	LCALL	?WRITI
	MOV	A,#05DH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
 ;    end;
?L345:
 ;    write(serial,char(13),'Restguthaben: ');
	MOV	A,#0DH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	SJMP	$+17
?S5844:
	DB	0EH
?S5845:
	DB	052H
	DB	065H
	DB	073H
	DB	074H
	DB	067H
	DB	075H
	DB	074H
	DB	068H
	DB	061H
	DB	062H
	DB	065H
	DB	06EH
	DB	03AH
	DB	020H
	MOV	DPTR,#?S5845
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	R7,#0EH
	MOV	R6,#00H
	LCALL	?WRITS
 ;    write(serial,aInt div 100,',');
	MOV	R4,#LOW(064H)
	MOV	R5,#HIGH(064H)
	MOV	R2,AINT
	MOV	R3,AINT+01H
	LCALL	?IDIV
	MOV	R6,#00H
	MOV	R7,#01H
	LCALL	?WRITI
	MOV	A,#02CH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
 ;    if aInt mod 100 < 10 then
	MOV	R4,#LOW(064H)
	MOV	R5,#HIGH(064H)
	MOV	R2,AINT
	MOV	R3,AINT+01H
	LCALL	?IMOD
	MOV	A,R2
	CLR	C
	SUBB	A,#LOW(0AH)
	MOV	A,R3
	XRL	A,#080H
	SUBB	A,#HIGH(0800AH)
	JC	$+5
	LJMP	?L346
 ;      write(serial,'0');
	MOV	A,#030H
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
?L346:
 ;    write(serial,aInt mod 100,' DM', char(13));
	MOV	R4,#LOW(064H)
	MOV	R5,#HIGH(064H)
	MOV	R2,AINT
	MOV	R3,AINT+01H
	LCALL	?IMOD
	MOV	R6,#00H
	MOV	R7,#01H
	LCALL	?WRITI
	SJMP	$+6
?S5964:
	DB	03H
?S5965:
	DB	020H
	DB	044H
	DB	04DH
	MOV	DPTR,#?S5965
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	R7,#03H
	MOV	R6,#00H
	LCALL	?WRITS
	MOV	A,#0DH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
 ;  end;
	RET
 ;
 ;  procedure KVKSerAnalyze;
 ;{ Daten der KVK nach Tags scannen und seriell ausgeben }
 ;  begin
	RSEG	?CARDTERM?C

KVKSERANALYZE:
 ;    if CardInit then;
	LCALL	CARDINIT
	JB	CARDINIT?RET,$+6
	LJMP	?L347
?L347:
 ;    GetProtParams;
	LCALL	GETPROTPARAMS
 ;    adrHi:=0;
	MOV	ADRHI,#00H
 ;    adrLo:=$1E;
	MOV	ADRLO,#01EH
 ;    DispatchCard;
	LCALL	DISPATCHCARD
 ;    if dataBuf[0]=$60 then
	MOV	A,DATABUF
	XRL	A,#060H
	JZ	$+5
	LJMP	?L348
 ;       write(serial,'Versichertendaten-Template');
	SJMP	$+29
?S6029:
	DB	01AH
?S6030:
	DB	056H
	DB	065H
	DB	072H
	DB	073H
	DB	069H
	DB	063H
	DB	068H
	DB	065H
	DB	072H
	DB	074H
	DB	065H
	DB	06EH
	DB	064H
	DB	061H
	DB	074H
	DB	065H
	DB	06EH
	DB	02DH
	DB	054H
	DB	065H
	DB	06DH
	DB	070H
	DB	06CH
	DB	061H
	DB	074H
	DB	065H
	MOV	DPTR,#?S6030
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	R7,#01AH
	MOV	R6,#00H
	LCALL	?WRITS
?L348:
 ;    if dataBuf[1]>$80 then
	MOV	A,DATABUF+01H
	SETB	C
	SUBB	A,#080H
	JNC	$+5
	LJMP	?L349
 ;      c:=dataBuf[1]-128+32
	MOV	A,DATABUF+01H
	CLR	C
	SUBB	A,#080H
 ;        else
	ADD	A,#020H
	MOV	C,A
	LJMP	?L350
?L349:
 ;      c:=32;
	MOV	C,#020H
?L350:
 ;    for adrLo:= c to $FF do
	MOV	ADRLO,C
?L351:
 ;      begin
	MOV	A,ADRLO
	SETB	C
	SUBB	A,#0FFH
	JC	$+5
	LJMP	?L352
 ;        value:=1;
	MOV	VALUE,#01H
 ;        DispatchCard;
	LCALL	DISPATCHCARD
 ;        z:=char(dataBuf[0]);
	MOV	Z,DATABUF
 ;        case byte(z) of
 ;        $5B:
	MOV	A,Z
	XRL	A,#05BH
	JZ	$+5
	LJMP	?L356
 ;          write(serial,'');
?L355:
	MOV	A,#08EH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
?L353:
	LJMP	?L357
 ;        $5C:
?L356:
	MOV	A,Z
	XRL	A,#05CH
	JZ	$+5
	LJMP	?L360
 ;          write(serial,'');
?L359:
	MOV	A,#099H
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
?L357:
	LJMP	?L361
 ;        $5D:
?L360:
	MOV	A,Z
	XRL	A,#05DH
	JZ	$+5
	LJMP	?L364
 ;          write(serial,'');
?L363:
	MOV	A,#09AH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
?L361:
	LJMP	?L365
 ;        $7B:
?L364:
	MOV	A,Z
	XRL	A,#07BH
	JZ	$+5
	LJMP	?L368
 ;          write(serial,'');
?L367:
	MOV	A,#084H
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
?L365:
	LJMP	?L369
 ;        $7C:
?L368:
	MOV	A,Z
	XRL	A,#07CH
	JZ	$+5
	LJMP	?L372
 ;          write(serial,'');
?L371:
	MOV	A,#094H
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
?L369:
	LJMP	?L373
 ;        $7D:
?L372:
	MOV	A,Z
	XRL	A,#07DH
	JZ	$+5
	LJMP	?L376
 ;          write(serial,'');
?L375:
	MOV	A,#081H
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
?L373:
	LJMP	?L377
 ;        $7E:
?L376:
	MOV	A,Z
	XRL	A,#07EH
	JZ	$+5
	LJMP	?L380
 ;          write(serial,'');
?L379:
	MOV	A,#0E1H
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
?L377:
	LJMP	?L381
 ;        else
?L380:
 ;          if (byte(z)<$80) and (byte(z)>31) then
	MOV	A,Z
	CLR	C
	SUBB	A,#080H
	CLR	A
	RLC	A
	MOV	R6,A
	MOV	A,Z
	SETB	C
	SUBB	A,#01FH
	CPL	C
	MOV	A,R6
	ANL	C,ACC
	JC	$+5
	LJMP	?L382
 ;            write(serial,z);
	MOV	A,Z
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
?L382:
 ;        end;
?L381:
 ;        case byte(z) of
 ;        $80:
	MOV	A,Z
	XRL	A,#080H
	JZ	$+5
	LJMP	?L386
 ;          write(serial,char(13),'Krankenkassen-Name: ');
?L385:
	MOV	A,#0DH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	SJMP	$+23
?S6360:
	DB	014H
?S6361:
	DB	04BH
	DB	072H
	DB	061H
	DB	06EH
	DB	06BH
	DB	065H
	DB	06EH
	DB	06BH
	DB	061H
	DB	073H
	DB	073H
	DB	065H
	DB	06EH
	DB	02DH
	DB	04EH
	DB	061H
	DB	06DH
	DB	065H
	DB	03AH
	DB	020H
	MOV	DPTR,#?S6361
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	R7,#014H
	MOV	R6,#00H
	LCALL	?WRITS
?L383:
	LJMP	?L387
 ;        $81:
?L386:
	MOV	A,Z
	XRL	A,#081H
	JZ	$+5
	LJMP	?L390
 ;          write(serial,char(13),'Krankenkassen-Nummer: ');
?L389:
	MOV	A,#0DH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	SJMP	$+25
?S6423:
	DB	016H
?S6424:
	DB	04BH
	DB	072H
	DB	061H
	DB	06EH
	DB	06BH
	DB	065H
	DB	06EH
	DB	06BH
	DB	061H
	DB	073H
	DB	073H
	DB	065H
	DB	06EH
	DB	02DH
	DB	04EH
	DB	075H
	DB	06DH
	DB	06DH
	DB	065H
	DB	072H
	DB	03AH
	DB	020H
	MOV	DPTR,#?S6424
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	R7,#016H
	MOV	R6,#00H
	LCALL	?WRITS
?L387:
	LJMP	?L391
 ;        $8F:
?L390:
	MOV	A,Z
	XRL	A,#08FH
	JZ	$+5
	LJMP	?L394
 ;          write(serial,char(13),'VKNR: ');
?L393:
	MOV	A,#0DH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	SJMP	$+9
?S6488:
	DB	06H
?S6489:
	DB	056H
	DB	04BH
	DB	04EH
	DB	052H
	DB	03AH
	DB	020H
	MOV	DPTR,#?S6489
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	R7,#06H
	MOV	R6,#00H
	LCALL	?WRITS
?L391:
	LJMP	?L395
 ;        $82:
?L394:
	MOV	A,Z
	XRL	A,#082H
	JZ	$+5
	LJMP	?L398
 ;          write(serial,char(13),'Versicherten-Nummer: ');
?L397:
	MOV	A,#0DH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	SJMP	$+24
?S6537:
	DB	015H
?S6538:
	DB	056H
	DB	065H
	DB	072H
	DB	073H
	DB	069H
	DB	063H
	DB	068H
	DB	065H
	DB	072H
	DB	074H
	DB	065H
	DB	06EH
	DB	02DH
	DB	04EH
	DB	075H
	DB	06DH
	DB	06DH
	DB	065H
	DB	072H
	DB	03AH
	DB	020H
	MOV	DPTR,#?S6538
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	R7,#015H
	MOV	R6,#00H
	LCALL	?WRITS
?L395:
	LJMP	?L399
 ;        $83:
?L398:
	MOV	A,Z
	XRL	A,#083H
	JZ	$+5
	LJMP	?L402
 ;          write(serial,char(13),'Versicherten-Status: ');
?L401:
	MOV	A,#0DH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	SJMP	$+24
?S6601:
	DB	015H
?S6602:
	DB	056H
	DB	065H
	DB	072H
	DB	073H
	DB	069H
	DB	063H
	DB	068H
	DB	065H
	DB	072H
	DB	074H
	DB	065H
	DB	06EH
	DB	02DH
	DB	053H
	DB	074H
	DB	061H
	DB	074H
	DB	075H
	DB	073H
	DB	03AH
	DB	020H
	MOV	DPTR,#?S6602
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	R7,#015H
	MOV	R6,#00H
	LCALL	?WRITS
?L399:
	LJMP	?L403
 ;        $90:
?L402:
	MOV	A,Z
	XRL	A,#090H
	JZ	$+5
	LJMP	?L406
 ;          write(serial,char(13),'Status-Ergnzung: ');
?L405:
	MOV	A,#0DH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	SJMP	$+21
?S6665:
	DB	012H
?S6666:
	DB	053H
	DB	074H
	DB	061H
	DB	074H
	DB	075H
	DB	073H
	DB	02DH
	DB	045H
	DB	072H
	DB	067H
	DB	084H
	DB	06EH
	DB	07AH
	DB	075H
	DB	06EH
	DB	067H
	DB	03AH
	DB	020H
	MOV	DPTR,#?S6666
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	R7,#012H
	MOV	R6,#00H
	LCALL	?WRITS
?L403:
	LJMP	?L407
 ;        $84:
?L406:
	MOV	A,Z
	XRL	A,#084H
	JZ	$+5
	LJMP	?L410
 ;          write(serial,char(13),'Titel: ');
?L409:
	MOV	A,#0DH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	SJMP	$+10
?S6726:
	DB	07H
?S6727:
	DB	054H
	DB	069H
	DB	074H
	DB	065H
	DB	06CH
	DB	03AH
	DB	020H
	MOV	DPTR,#?S6727
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	R7,#07H
	MOV	R6,#00H
	LCALL	?WRITS
?L407:
	LJMP	?L411
 ;        $85:
?L410:
	MOV	A,Z
	XRL	A,#085H
	JZ	$+5
	LJMP	?L414
 ;          write(serial,char(13),'Vorname: ');
?L413:
	MOV	A,#0DH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	SJMP	$+12
?S6776:
	DB	09H
?S6777:
	DB	056H
	DB	06FH
	DB	072H
	DB	06EH
	DB	061H
	DB	06DH
	DB	065H
	DB	03AH
	DB	020H
	MOV	DPTR,#?S6777
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	R7,#09H
	MOV	R6,#00H
	LCALL	?WRITS
?L411:
	LJMP	?L415
 ;        $86:
?L414:
	MOV	A,Z
	XRL	A,#086H
	JZ	$+5
	LJMP	?L418
 ;          write(serial,char(13),'Namenszusatz: ');
?L417:
	MOV	A,#0DH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	SJMP	$+17
?S6828:
	DB	0EH
?S6829:
	DB	04EH
	DB	061H
	DB	06DH
	DB	065H
	DB	06EH
	DB	073H
	DB	07AH
	DB	075H
	DB	073H
	DB	061H
	DB	074H
	DB	07AH
	DB	03AH
	DB	020H
	MOV	DPTR,#?S6829
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	R7,#0EH
	MOV	R6,#00H
	LCALL	?WRITS
?L415:
	LJMP	?L419
 ;        $87:
?L418:
	MOV	A,Z
	XRL	A,#087H
	JZ	$+5
	LJMP	?L422
 ;          write(serial,char(13),'Familienname: ');
?L421:
	MOV	A,#0DH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	SJMP	$+17
?S6885:
	DB	0EH
?S6886:
	DB	046H
	DB	061H
	DB	06DH
	DB	069H
	DB	06CH
	DB	069H
	DB	065H
	DB	06EH
	DB	06EH
	DB	061H
	DB	06DH
	DB	065H
	DB	03AH
	DB	020H
	MOV	DPTR,#?S6886
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	R7,#0EH
	MOV	R6,#00H
	LCALL	?WRITS
?L419:
	LJMP	?L423
 ;        $88:
?L422:
	MOV	A,Z
	XRL	A,#088H
	JZ	$+5
	LJMP	?L426
 ;          write(serial,char(13),'Geburtsdatum: ');
?L425:
	MOV	A,#0DH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	SJMP	$+17
?S6942:
	DB	0EH
?S6943:
	DB	047H
	DB	065H
	DB	062H
	DB	075H
	DB	072H
	DB	074H
	DB	073H
	DB	064H
	DB	061H
	DB	074H
	DB	075H
	DB	06DH
	DB	03AH
	DB	020H
	MOV	DPTR,#?S6943
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	R7,#0EH
	MOV	R6,#00H
	LCALL	?WRITS
?L423:
	LJMP	?L427
 ;        $89:
?L426:
	MOV	A,Z
	XRL	A,#089H
	JZ	$+5
	LJMP	?L430
 ;          write(serial,char(13),'Strae: ');
?L429:
	MOV	A,#0DH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	SJMP	$+11
?S6999:
	DB	08H
?S7000:
	DB	053H
	DB	074H
	DB	072H
	DB	061H
	DB	0E1H
	DB	065H
	DB	03AH
	DB	020H
	MOV	DPTR,#?S7000
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	R7,#08H
	MOV	R6,#00H
	LCALL	?WRITS
?L427:
	LJMP	?L431
 ;        $8A:
?L430:
	MOV	A,Z
	XRL	A,#08AH
	JZ	$+5
	LJMP	?L434
 ;          write(serial,char(13),'Lnder-Code: ');
?L433:
	MOV	A,#0DH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	SJMP	$+16
?S7050:
	DB	0DH
?S7051:
	DB	04CH
	DB	084H
	DB	06EH
	DB	064H
	DB	065H
	DB	072H
	DB	02DH
	DB	043H
	DB	06FH
	DB	064H
	DB	065H
	DB	03AH
	DB	020H
	MOV	DPTR,#?S7051
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	R7,#0DH
	MOV	R6,#00H
	LCALL	?WRITS
?L431:
	LJMP	?L435
 ;        $8B:
?L434:
	MOV	A,Z
	XRL	A,#08BH
	JZ	$+5
	LJMP	?L438
 ;          write(serial,char(13),'Postleitzahl: ');
?L437:
	MOV	A,#0DH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	SJMP	$+17
?S7106:
	DB	0EH
?S7107:
	DB	050H
	DB	06FH
	DB	073H
	DB	074H
	DB	06CH
	DB	065H
	DB	069H
	DB	074H
	DB	07AH
	DB	061H
	DB	068H
	DB	06CH
	DB	03AH
	DB	020H
	MOV	DPTR,#?S7107
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	R7,#0EH
	MOV	R6,#00H
	LCALL	?WRITS
?L435:
	LJMP	?L439
 ;        $8C:
?L438:
	MOV	A,Z
	XRL	A,#08CH
	JZ	$+5
	LJMP	?L442
 ;          write(serial,char(13),'Ort: ');
?L441:
	MOV	A,#0DH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	SJMP	$+8
?S7163:
	DB	05H
?S7164:
	DB	04FH
	DB	072H
	DB	074H
	DB	03AH
	DB	020H
	MOV	DPTR,#?S7164
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	R7,#05H
	MOV	R6,#00H
	LCALL	?WRITS
?L439:
	LJMP	?L443
 ;        $8D:
?L442:
	MOV	A,Z
	XRL	A,#08DH
	JZ	$+5
	LJMP	?L446
 ;          write(serial,char(13),'Gltigkeit: ');
?L445:
	MOV	A,#0DH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	SJMP	$+15
?S7211:
	DB	0CH
?S7212:
	DB	047H
	DB	081H
	DB	06CH
	DB	074H
	DB	069H
	DB	067H
	DB	06BH
	DB	065H
	DB	069H
	DB	074H
	DB	03AH
	DB	020H
	MOV	DPTR,#?S7212
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	R7,#0CH
	MOV	R6,#00H
	LCALL	?WRITS
?L443:
	LJMP	?L447
 ;        $8E:
?L446:
	MOV	A,Z
	XRL	A,#08EH
	JZ	$+5
	LJMP	?L450
 ;          begin
?L449:
 ;            write(serial,char(13),'Prfsumme');
	MOV	A,#0DH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	SJMP	$+12
?S7266:
	DB	09H
?S7267:
	DB	050H
	DB	072H
	DB	081H
	DB	066H
	DB	073H
	DB	075H
	DB	06DH
	DB	06DH
	DB	065H
	MOV	DPTR,#?S7267
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	R7,#09H
	MOV	R6,#00H
	LCALL	?WRITS
 ;            adrLo:=$FF;
	MOV	ADRLO,#0FFH
 ;          end;
?L447:
	LJMP	?L451
 ;        end;
?L450:
?L451:
 ;      end;
	INC	ADRLO
	MOV	A,ADRLO
	JZ	$+5
	LJMP	?L351
	NOP
?L352:
 ;    write(serial,char(13));
	MOV	A,#0DH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
 ;  end;
	RET
 ;
 ;  procedure HexMon;
 ;  begin
	RSEG	?CARDTERM?C

HEXMON:
 ;    f:=AdrHi;
	MOV	F,ADRHI
 ;    if CardInit then;
	LCALL	CARDINIT
	JB	CARDINIT?RET,$+6
	LJMP	?L452
?L452:
 ;    CardATRtoBuf;
	LCALL	CARDATRTOBUF
 ;    write(serial,ATRStr);
	MOV	DPTR,#ATRSTR
	MOV	R5,#00H
	MOV	R4,#01H
	CLR	A
	MOVC	A,@A+DPTR
	INC	DPTR
	MOV	R7,A
	MOV	R6,#00H
	LCALL	?WRITS
 ;    for j:=0 to 3 do
	MOV	J,#00H
?L453:
 ;      write(serial,NumToHex(dataBuf[j]));
	MOV	A,J
	SETB	C
	SUBB	A,#03H
	JC	$+5
	LJMP	?L454
	MOV	A,J
	ADD	A,#DATABUF
	MOV	R0,A
	MOV	THEBYTE,@R0
	LCALL	NUMTOHEX
	MOV	R0,#NUMTOHEX?RET
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	A,@R0
	INC	R0
	MOV	R7,A
	MOV	R6,#01H
	LCALL	?WRITS
	INC	J
	SJMP	?L453
?L454:
 ;    GetProtParams;
	LCALL	GETPROTPARAMS
 ;    AdrHi:=f;
	MOV	ADRHI,F
 ;    case ISOprtk of
 ;    Tel0PrtkC,Tel1PrtkC,Tel2PrtkC:   { Telefonkarte? }
	MOV	A,ISOPRTK
	JZ	$+5
	LJMP	?L458
?L457:
	LJMP	?L459
?L458:
	MOV	A,ISOPRTK
	XRL	A,#02H
	JZ	$+5
	LJMP	?L461
?L459:
	LJMP	?L462
?L461:
	MOV	A,ISOPRTK
	XRL	A,#04H
	JZ	$+5
	LJMP	?L464
 ;      begin
?L462:
 ;        write(serial,char(13),TelStr,'bitseriell',char(13));
	MOV	A,#0DH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	MOV	DPTR,#TELSTR
	MOV	R5,#00H
	MOV	R4,#01H
	CLR	A
	MOVC	A,@A+DPTR
	INC	DPTR
	MOV	R7,A
	MOV	R6,#00H
	LCALL	?WRITS
	SJMP	$+13
?S7462:
	DB	0AH
?S7463:
	DB	062H
	DB	069H
	DB	074H
	DB	073H
	DB	065H
	DB	072H
	DB	069H
	DB	065H
	DB	06CH
	DB	06CH
	MOV	DPTR,#?S7463
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	R7,#0AH
	MOV	R6,#00H
	LCALL	?WRITS
	MOV	A,#0DH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
 ;        CardReset;      { ATR mitlesen }
	LCALL	CARDRESET
 ;        write(serial,'Bit:     7654 3210',char(13));
	SJMP	$+21
?S7506:
	DB	012H
?S7507:
	DB	042H
	DB	069H
	DB	074H
	DB	03AH
	DB	020H
	DB	020H
	DB	020H
	DB	020H
	DB	020H
	DB	037H
	DB	036H
	DB	035H
	DB	034H
	DB	020H
	DB	033H
	DB	032H
	DB	031H
	DB	030H
	MOV	DPTR,#?S7507
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	R7,#012H
	MOV	R6,#00H
	LCALL	?WRITS
	MOV	A,#0DH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
 ;        for j:=0 to 17 do
	MOV	J,#00H
?L465:
 ;          write(serial,'-');
	MOV	A,J
	SETB	C
	SUBB	A,#011H
	JC	$+5
	LJMP	?L466
	MOV	A,#02DH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	INC	J
	SJMP	?L465
?L466:
 ;        for f:= 0 to 15 do
	MOV	F,#00H
?L467:
 ;          begin
	MOV	A,F
	SETB	C
	SUBB	A,#0FH
	JC	$+5
	LJMP	?L468
 ;            write(serial,char(13));
	MOV	A,#0DH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
 ;            e:=TCdShiftByte;
	LCALL	TCDSHIFTBYTE
	MOV	E,TCDSHIFTBYTE?RET
 ;            write(serial,NumToHex(f*8),': ');
	MOV	B,#08H
	MOV	A,F
	MUL	AB
	MOV	THEBYTE,A
	LCALL	NUMTOHEX
	MOV	R0,#NUMTOHEX?RET
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	A,@R0
	INC	R0
	MOV	R7,A
	MOV	R6,#01H
	LCALL	?WRITS
	SJMP	$+5
?S7644:
	DB	02H
?S7645:
	DB	03AH
	DB	020H
	MOV	DPTR,#?S7645
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	R7,#02H
	MOV	R6,#00H
	LCALL	?WRITS
 ;            write(serial,NumToHex(e),' = ',NumToBin(e shr 4),'');
	MOV	THEBYTE,E
	LCALL	NUMTOHEX
	MOV	R0,#NUMTOHEX?RET
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	A,@R0
	INC	R0
	MOV	R7,A
	MOV	R6,#01H
	LCALL	?WRITS
	SJMP	$+6
?S7683:
	DB	03H
?S7684:
	DB	020H
	DB	03DH
	DB	020H
	MOV	DPTR,#?S7684
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	R7,#03H
	MOV	R6,#00H
	LCALL	?WRITS
	MOV	A,#04H
	MOV	R6,A
	MOV	A,E
	CLR	C
	RRC	A
	DJNZ	R6,$-2
	MOV	THEBYTE,A
	LCALL	NUMTOBIN
	MOV	R0,#NUMTOBIN?RET
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	A,@R0
	INC	R0
	MOV	R7,A
	MOV	R6,#01H
	LCALL	?WRITS
	SJMP	$+3
?S7731:
	DB	00H
?S7732:
	MOV	DPTR,#?S7732
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	R7,#00H
	MOV	R6,#00H
	LCALL	?WRITS
 ;            write(serial,NumToBin(e and $F));
	MOV	A,E
	ANL	A,#0FH
	MOV	THEBYTE,A
	LCALL	NUMTOBIN
	MOV	R0,#NUMTOBIN?RET
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	A,@R0
	INC	R0
	MOV	R7,A
	MOV	R6,#01H
	LCALL	?WRITS
 ;          end;
	INC	F
	LJMP	?L467
?L468:
 ;      end
 ;    else
?L455:
	LJMP	?L469
?L464:
 ;      begin
 ;        case ISOprtk of
 ;          I2CprtkC:
	MOV	A,ISOPRTK
	XRL	A,#08H
	JZ	$+5
	LJMP	?L473
 ;            write(serial,char(13),I2CStr);
?L472:
	MOV	A,#0DH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	MOV	DPTR,#I2CSTR
	MOV	R5,#00H
	MOV	R4,#01H
	CLR	A
	MOVC	A,@A+DPTR
	INC	DPTR
	MOV	R7,A
	MOV	R6,#00H
	LCALL	?WRITS
?L470:
	LJMP	?L474
 ;          ZWDprtkC:
?L473:
	MOV	A,ISOPRTK
	XRL	A,#0AH
	JZ	$+5
	LJMP	?L477
 ;            write(serial,char(13),ZWDStr);
?L476:
	MOV	A,#0DH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	MOV	DPTR,#ZWDSTR
	MOV	R5,#00H
	MOV	R4,#01H
	CLR	A
	MOVC	A,@A+DPTR
	INC	DPTR
	MOV	R7,A
	MOV	R6,#00H
	LCALL	?WRITS
?L474:
	LJMP	?L478
 ;          DRDprtkC:
?L477:
	MOV	A,ISOPRTK
	XRL	A,#09H
	JZ	$+5
	LJMP	?L481
 ;            write(serial,char(13),DRDStr);
?L480:
	MOV	A,#0DH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	MOV	DPTR,#DRDSTR
	MOV	R5,#00H
	MOV	R4,#01H
	CLR	A
	MOVC	A,@A+DPTR
	INC	DPTR
	MOV	R7,A
	MOV	R6,#00H
	LCALL	?WRITS
?L478:
	LJMP	?L482
 ;          else
?L481:
 ;            write(serial,char(13),unbStr,I2Cstr,'benutzt');
	MOV	A,#0DH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	MOV	DPTR,#UNBSTR
	MOV	R5,#00H
	MOV	R4,#01H
	CLR	A
	MOVC	A,@A+DPTR
	INC	DPTR
	MOV	R7,A
	MOV	R6,#00H
	LCALL	?WRITS
	MOV	DPTR,#I2CSTR
	MOV	R5,#00H
	MOV	R4,#01H
	CLR	A
	MOVC	A,@A+DPTR
	INC	DPTR
	MOV	R7,A
	MOV	R6,#00H
	LCALL	?WRITS
	SJMP	$+10
?S7951:
	DB	07H
?S7952:
	DB	062H
	DB	065H
	DB	06EH
	DB	075H
	DB	074H
	DB	07AH
	DB	074H
	MOV	DPTR,#?S7952
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	R7,#07H
	MOV	R6,#00H
	LCALL	?WRITS
 ;        end;
?L482:
 ;        write(serial,char(13),'Basisadresse: ',NumToHex(adrHi),'00',char(13));
	MOV	A,#0DH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	SJMP	$+17
?S7989:
	DB	0EH
?S7990:
	DB	042H
	DB	061H
	DB	073H
	DB	069H
	DB	073H
	DB	061H
	DB	064H
	DB	072H
	DB	065H
	DB	073H
	DB	073H
	DB	065H
	DB	03AH
	DB	020H
	MOV	DPTR,#?S7990
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	R7,#0EH
	MOV	R6,#00H
	LCALL	?WRITS
	MOV	THEBYTE,ADRHI
	LCALL	NUMTOHEX
	MOV	R0,#NUMTOHEX?RET
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	A,@R0
	INC	R0
	MOV	R7,A
	MOV	R6,#01H
	LCALL	?WRITS
	SJMP	$+5
?S8040:
	DB	02H
?S8041:
	DB	030H
	DB	030H
	MOV	DPTR,#?S8041
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	R7,#02H
	MOV	R6,#00H
	LCALL	?WRITS
	MOV	A,#0DH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
 ;        write(serial,'Byte:0 ');
	SJMP	$+10
?S8073:
	DB	07H
?S8074:
	DB	042H
	DB	079H
	DB	074H
	DB	065H
	DB	03AH
	DB	030H
	DB	020H
	MOV	DPTR,#?S8074
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	R7,#07H
	MOV	R6,#00H
	LCALL	?WRITS
 ;        for j:=1 to 15 do
	MOV	J,#01H
?L483:
 ;          write(serial,NumToHex(j),' ');
	MOV	A,J
	SETB	C
	SUBB	A,#0FH
	JC	$+5
	LJMP	?L484
	MOV	THEBYTE,J
	LCALL	NUMTOHEX
	MOV	R0,#NUMTOHEX?RET
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	A,@R0
	INC	R0
	MOV	R7,A
	MOV	R6,#01H
	LCALL	?WRITS
	MOV	A,#020H
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	INC	J
	SJMP	?L483
?L484:
 ;        write(serial,'   ASCII',char(13));
	SJMP	$+11
?S8148:
	DB	08H
?S8149:
	DB	020H
	DB	020H
	DB	020H
	DB	041H
	DB	053H
	DB	043H
	DB	049H
	DB	049H
	MOV	DPTR,#?S8149
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	R7,#08H
	MOV	R6,#00H
	LCALL	?WRITS
	MOV	A,#0DH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
 ;        for j:=0 to 70 do
	MOV	J,#00H
?L485:
 ;          write(serial,'-');
	MOV	A,J
	SETB	C
	SUBB	A,#046H
	JC	$+5
	LJMP	?L486
	MOV	A,#02DH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	INC	J
	SJMP	?L485
?L486:
 ;        for f:= 0 to 15 do
	MOV	F,#00H
?L487:
 ;          begin
	MOV	A,F
	SETB	C
	SUBB	A,#0FH
	JC	$+5
	LJMP	?L488
 ;            write(serial,char(13),NumToHex(f*16),': ');
	MOV	A,#0DH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	MOV	B,#010H
	MOV	A,F
	MUL	AB
	MOV	THEBYTE,A
	LCALL	NUMTOHEX
	MOV	R0,#NUMTOHEX?RET
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	A,@R0
	INC	R0
	MOV	R7,A
	MOV	R6,#01H
	LCALL	?WRITS
	SJMP	$+5
?S8270:
	DB	02H
?S8271:
	DB	03AH
	DB	020H
	MOV	DPTR,#?S8271
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	R7,#02H
	MOV	R6,#00H
	LCALL	?WRITS
 ;            for e:=0 to 15 do
	MOV	E,#00H
?L489:
 ;              begin
	MOV	A,E
	SETB	C
	SUBB	A,#0FH
	JC	$+5
	LJMP	?L490
 ;                adrLo:= f*16+e;
	MOV	B,#010H
	MOV	A,F
	MUL	AB
	ADD	A,E
	MOV	ADRLO,A
 ;                value:=0;
	MOV	VALUE,#00H
 ;                DispatchCard;
	LCALL	DISPATCHCARD
 ;                d:=dataBuf[0];
	MOV	D,DATABUF
 ;                write(serial, NumToHex(d),' ');
	MOV	THEBYTE,D
	LCALL	NUMTOHEX
	MOV	R0,#NUMTOHEX?RET
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	A,@R0
	INC	R0
	MOV	R7,A
	MOV	R6,#01H
	LCALL	?WRITS
	MOV	A,#020H
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
 ;              end;
	INC	E
	SJMP	?L489
?L490:
 ;            write(serial,'   ');
	SJMP	$+6
?S8359:
	DB	03H
?S8360:
	DB	020H
	DB	020H
	DB	020H
	MOV	DPTR,#?S8360
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	R7,#03H
	MOV	R6,#00H
	LCALL	?WRITS
 ;            for e:=0 to 15 do
	MOV	E,#00H
?L491:
 ;              begin
	MOV	A,E
	SETB	C
	SUBB	A,#0FH
	JC	$+5
	LJMP	?L492
 ;                adrLo:= f*16+e;
	MOV	B,#010H
	MOV	A,F
	MUL	AB
	ADD	A,E
	MOV	ADRLO,A
 ;                value:=0;
	MOV	VALUE,#00H
 ;                DispatchCard;
	LCALL	DISPATCHCARD
 ;                d:=dataBuf[0];
	MOV	D,DATABUF
 ;                if (d>31) and (d<128) then
	MOV	A,D
	SETB	C
	SUBB	A,#01FH
	CPL	C
	CLR	A
	RLC	A
	MOV	R6,A
	MOV	A,D
	CLR	C
	SUBB	A,#080H
	MOV	A,R6
	ANL	C,ACC
	JC	$+5
	LJMP	?L493
 ;                  write(serial,char(d))
	MOV	A,D
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
 ;                else
	LJMP	?L494
?L493:
 ;                  write(serial,'.');
	MOV	A,#02EH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
?L494:
 ;              end;
	INC	E
	SJMP	?L491
?L492:
 ;            end;
	INC	F
	LJMP	?L487
?L488:
 ;        end;
 ;    end;
?L469:
 ;    write(serial,char(13));
	MOV	A,#0DH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
 ;  end;
	RET
 ;
 ;  procedure BufEval;
 ;{ Simpel-Parser: Hexzahlen im Buffer umwandeln in Adressen }
 ;{ zulssige Eingaben: }
 ;{ ABCD,EF  adrHi=AB, adrLo=CD, value=EF }
 ;{ CD,EF    adrHi=0,  adrLo=CD, value=EF }
 ;{ ABCD     adrHi=AB, adrLo=CD, value=0  }
 ;{ EF       value=EF                     }
 ;
 ;    function BufHex: byte;
 RSEG	?CARDTERM?D
BUFHEX?RET:	DS	01H
 ;    begin
	RSEG	?CARDTERM?C

BUFHEX:
 ;      y:=cliBuf[ptr];
	MOV	A,PTR
	ADD	A,#CLIBUF
	MOV	R0,A
	MOV	Y,@R0
 ;      if y>$60 then        { a..f }
	MOV	A,Y
	SETB	C
	SUBB	A,#060H
	JNC	$+5
	LJMP	?L495
 ;        y:=y-39;
	MOV	A,Y
	CLR	C
	SUBB	A,#027H
	MOV	Y,A
?L495:
 ;      if y>$40 then        { A..F }
	MOV	A,Y
	SETB	C
	SUBB	A,#040H
	JNC	$+5
	LJMP	?L496
 ;        y:=y-7;
	MOV	A,Y
	CLR	C
	SUBB	A,#07H
	MOV	Y,A
?L496:
 ;      y:=y-$30;            { 0..9 }
	MOV	A,Y
	CLR	C
	SUBB	A,#030H
	MOV	Y,A
 ;      If y>15 then
	MOV	A,Y
	SETB	C
	SUBB	A,#0FH
	JNC	$+5
	LJMP	?L497
 ;        ErrCond:=true
 ;      else
	SETB	ERRCOND
	LJMP	?L498
?L497:
 ;        BufHex:=y;
	MOV	BUFHEX?RET,Y
?L498:
 ;    end;
	RET
 ;
 ;  begin
	RSEG	?CARDTERM?C

BUFEVAL:
 ;    ptr:=2;
	MOV	PTR,#02H
 ;    if cliBuf[4]<>13 then
	MOV	A,CLIBUF+04H
	XRL	A,#0DH
	JNZ	$+5
	LJMP	?L499
 ;      begin
 ;        if cliBuf[4]<>byte(',') then
	MOV	A,CLIBUF+04H
	XRL	A,#02CH
	JNZ	$+5
	LJMP	?L500
 ;          begin
 ;            adrHi:=16*BufHex;
	LCALL	BUFHEX
	MOV	B,BUFHEX?RET
	MOV	A,#010H
	MUL	AB
	MOV	ADRHI,A
 ;            inc(ptr);
	INC	PTR
 ;            adrHi:=adrHi+BufHex;
	LCALL	BUFHEX
	MOV	A,ADRHI
	ADD	A,BUFHEX?RET
	MOV	ADRHI,A
 ;            inc(ptr);
	INC	PTR
 ;          end
 ;        else
	LJMP	?L501
?L500:
 ;          adrHi:=0;
	MOV	ADRHI,#00H
?L501:
 ;        adrLo:=16*BufHex;
	LCALL	BUFHEX
	MOV	B,BUFHEX?RET
	MOV	A,#010H
	MUL	AB
	MOV	ADRLO,A
 ;        inc(ptr);
	INC	PTR
 ;        adrLo:=adrLo+BufHex;
	LCALL	BUFHEX
	MOV	A,ADRLO
	ADD	A,BUFHEX?RET
	MOV	ADRLO,A
 ;        inc(ptr);
	INC	PTR
 ;      end;
?L499:
 ;    if cliBuf[ptr]=13 then
	MOV	A,PTR
	ADD	A,#CLIBUF
	MOV	R0,A
	MOV	A,@R0
	XRL	A,#0DH
	JZ	$+5
	LJMP	?L502
 ;      value:=0
 ;    else
	MOV	VALUE,#00H
	LJMP	?L503
?L502:
 ;      begin
 ;        if cliBuf[ptr]=byte(',') then
	MOV	A,PTR
	ADD	A,#CLIBUF
	MOV	R0,A
	MOV	A,@R0
	XRL	A,#02CH
	JZ	$+5
	LJMP	?L504
 ;          inc(ptr);
	INC	PTR
?L504:
 ;        value:=16*BufHex;
	LCALL	BUFHEX
	MOV	B,BUFHEX?RET
	MOV	A,#010H
	MUL	AB
	MOV	VALUE,A
 ;        inc(ptr);
	INC	PTR
 ;        value:=value+BufHex;
	LCALL	BUFHEX
	MOV	A,VALUE
	ADD	A,BUFHEX?RET
	MOV	VALUE,A
 ;        inc(ptr);
	INC	PTR
 ;      end;
?L503:
 ;    if cliBuf[ptr]<>13 then
	MOV	A,PTR
	ADD	A,#CLIBUF
	MOV	R0,A
	MOV	A,@R0
	XRL	A,#0DH
	JNZ	$+5
	LJMP	?L505
 ;      ErrCond:=true;
	SETB	ERRCOND
?L505:
 ;    case ptr of
 ;      4,6,7,9:;
	MOV	A,PTR
	XRL	A,#04H
	JZ	$+5
	LJMP	?L509
?L508:
	LJMP	?L510
?L509:
	MOV	A,PTR
	XRL	A,#06H
	JZ	$+5
	LJMP	?L512
?L510:
	LJMP	?L513
?L512:
	MOV	A,PTR
	XRL	A,#07H
	JZ	$+5
	LJMP	?L515
?L513:
	LJMP	?L516
?L515:
	MOV	A,PTR
	XRL	A,#09H
	JZ	$+5
	LJMP	?L518
?L516:
?L506:
	LJMP	?L519
 ;    else
?L518:
 ;      ErrCond:=true;
	SETB	ERRCOND
 ;    end;
?L519:
 ;    if ErrCond then
	JB	ERRCOND,$+6
	LJMP	?L520
 ;      begin
 ;        adrLo:=0;
	MOV	ADRLO,#00H
 ;        adrHi:=0;
	MOV	ADRHI,#00H
 ;        value:=0;
	MOV	VALUE,#00H
 ;      end;
?L520:
 ;  end;
	RET
 ;
 ;
 ;{*************************** Hauptschleife *******************************}
 ;
 ;begin

	RSEG	?CARDTERM?C

BEGIN:
 ;  reset(serial);
	MOV	R3,#00H
	LCALL	?RESET
 ;  reset(display);
	MOV	R3,#01H
	LCALL	?RESET
 ;  IE:=0;
	MOV	IE,#00H
 ;  write(display,char(12),versStr,chr(13));
	MOV	A,#0CH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#01H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	MOV	DPTR,#VERSSTR
	MOV	R5,#01H
	MOV	R4,#01H
	CLR	A
	MOVC	A,@A+DPTR
	INC	DPTR
	MOV	R7,A
	MOV	R6,#00H
	LCALL	?WRITS
	MOV	A,#0DH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#01H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
 ;  TH1:=250;              { 9600 bit/s }
	MOV	TH1,#0FAH
 ;
 ;  write(serial,char(12),versStr,char(13));
	MOV	A,#0CH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	MOV	DPTR,#VERSSTR
	MOV	R5,#00H
	MOV	R4,#01H
	CLR	A
	MOVC	A,@A+DPTR
	INC	DPTR
	MOV	R7,A
	MOV	R6,#00H
	LCALL	?WRITS
	MOV	A,#0DH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
 ;  monDisp:=false;
	CLR	MONDISP
 ;  noCard:=P1.skt;        { Schaltkontakt Ruhestellung }
	MOV	C,P1.04H
	MOV	NOCARD,C
 ;  P1:=CdOff;
	MOV	P1,#0F8H
 ;  if P1.switch then
	JB	P1.07H,$+6
	LJMP	?L521
 ;    repeat
?L522:
 ;      for y:=0 to 9 do
	MOV	Y,#00H
?L523:
 ;        cliBuf[y]:=0;
	MOV	A,Y
	SETB	C
	SUBB	A,#09H
	JC	$+5
	LJMP	?L524
	MOV	A,Y
	ADD	A,#CLIBUF
	MOV	R0,A
	MOV	@R0,#00H
	INC	Y
	SJMP	?L523
?L524:
 ;      write(serial,'>');
	MOV	A,#03EH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
 ;      for ptr:= 0 to 19 do
	MOV	PTR,#00H
?L525:
 ;        begin
	MOV	A,PTR
	SETB	C
	SUBB	A,#013H
	JC	$+5
	LJMP	?L526
 ;          read(serial,z);
	MOV	R3,#00H
	LCALL	?READ1C
	MOV	Z,R2
 ;          cliBuf[ptr]:=byte(z);
	MOV	A,PTR
	ADD	A,#CLIBUF
	MOV	R0,A
	MOV	@R0,Z
 ;          case char(cliBuf[0]) of
 ;          'D','d':
	MOV	A,CLIBUF
	XRL	A,#044H
	JZ	$+5
	LJMP	?L530
?L529:
	LJMP	?L531
?L530:
	MOV	A,CLIBUF
	XRL	A,#064H
	JZ	$+5
	LJMP	?L533
 ;{ direkt ins Display schreiben }
 ;          if ptr>1 then
?L531:
	MOV	A,PTR
	SETB	C
	SUBB	A,#01H
	JNC	$+5
	LJMP	?L534
 ;            begin
 ;              write(display,z);
	MOV	A,Z
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#01H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
 ;              ptr:=2;
	MOV	PTR,#02H
 ;            end;
?L534:
?L527:
	LJMP	?L535
 ;          'S','s':
?L533:
	MOV	A,CLIBUF
	XRL	A,#053H
	JZ	$+5
	LJMP	?L538
?L537:
	LJMP	?L539
?L538:
	MOV	A,CLIBUF
	XRL	A,#073H
	JZ	$+5
	LJMP	?L541
 ;{ direkt ins EEPROM schreiben }
 ;            if (ptr>1) and (z<>char(13)) then
?L539:
	MOV	A,PTR
	SETB	C
	SUBB	A,#01H
	CPL	C
	CLR	A
	RLC	A
	MOV	R6,A
	MOV	A,Z
	XRL	A,#0DH
	ADD	A,#0FFH
	MOV	A,R6
	ANL	C,ACC
	JC	$+5
	LJMP	?L542
 ;              begin
 ;                value:=byte(z);
	MOV	VALUE,Z
 ;                writeCard;           { erhht adrLo, adrHi }
	LCALL	WRITECARD
 ;                ptr:=2;
	MOV	PTR,#02H
 ;              end;
?L542:
?L535:
	LJMP	?L543
 ;          else                       { Backspace? }
?L541:
 ;            if (z=char(8)) and (ptr>0) then
	MOV	A,Z
	XRL	A,#08H
	ADD	A,#0FFH
	CPL	C
	CLR	A
	RLC	A
	MOV	R6,A
	MOV	A,PTR
	SETB	C
	SUBB	A,#00H
	CPL	C
	MOV	A,R6
	ANL	C,ACC
	JC	$+5
	LJMP	?L544
 ;              ptr:=ptr-2;
	MOV	A,PTR
	CLR	C
	SUBB	A,#02H
	MOV	PTR,A
?L544:
 ;          end;                       { Abschlieen mit Return }
?L543:
 ;          if z=char(13) then
	MOV	A,Z
	XRL	A,#0DH
	JZ	$+5
	LJMP	?L545
 ;            ptr:=99;
	MOV	PTR,#063H
?L545:
 ;        end;
	INC	PTR
	LJMP	?L525
?L526:
 ;      case char(cliBuf[0]) of
 ;        'W','w':
	MOV	A,CLIBUF
	XRL	A,#057H
	JZ	$+5
	LJMP	?L549
?L548:
	LJMP	?L550
?L549:
	MOV	A,CLIBUF
	XRL	A,#077H
	JZ	$+5
	LJMP	?L552
 ;{ Wert in Karte schreiben }
 ;          begin
?L550:
 ;            ErrCond:=false;
	CLR	ERRCOND
 ;            BufEval;
	LCALL	BUFEVAL
 ;            if ErrCond then
	JB	ERRCOND,$+6
	LJMP	?L553
 ;              write(serial,ValErrStr,char(13))
	MOV	DPTR,#VALERRSTR
	MOV	R5,#00H
	MOV	R4,#01H
	CLR	A
	MOVC	A,@A+DPTR
	INC	DPTR
	MOV	R7,A
	MOV	R6,#00H
	LCALL	?WRITS
	MOV	A,#0DH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
 ;            else
	LJMP	?L554
?L553:
 ;              begin
 ;                writeCard;
	LCALL	WRITECARD
 ;                sendStat(true);
	SETB	STATE
	LCALL	SENDSTAT
 ;              end;
?L554:
 ;          end;
?L546:
	LJMP	?L555
 ;        'R','r':
?L552:
	MOV	A,CLIBUF
	XRL	A,#052H
	JZ	$+5
	LJMP	?L558
?L557:
	LJMP	?L559
?L558:
	MOV	A,CLIBUF
	XRL	A,#072H
	JZ	$+5
	LJMP	?L561
 ;{ Wert(e) aus Karte lesen }
 ;          begin
?L559:
 ;            ErrCond:=false;
	CLR	ERRCOND
 ;            BufEval;
	LCALL	BUFEVAL
 ;            if ErrCond then
	JB	ERRCOND,$+6
	LJMP	?L562
 ;              write(serial,ValErrStr)
	MOV	DPTR,#VALERRSTR
	MOV	R5,#00H
	MOV	R4,#01H
	CLR	A
	MOVC	A,@A+DPTR
	INC	DPTR
	MOV	R7,A
	MOV	R6,#00H
	LCALL	?WRITS
 ;            else
	LJMP	?L563
?L562:
 ;              begin
 ;                readCard;
	LCALL	READCARD
 ;              end;
?L563:
 ;            write(serial,char(13));
	MOV	A,#0DH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
 ;          end;
?L555:
	LJMP	?L564
 ;        'P','p':
?L561:
	MOV	A,CLIBUF
	XRL	A,#050H
	JZ	$+5
	LJMP	?L567
?L566:
	LJMP	?L568
?L567:
	MOV	A,CLIBUF
	XRL	A,#070H
	JZ	$+5
	LJMP	?L570
 ;{ Parameter (ATR) setzen }
 ;          begin
?L568:
 ;            ErrCond:=not(cliBuf[6]=13);
	MOV	A,CLIBUF+06H
	XRL	A,#0DH
	ADD	A,#0FFH
	MOV	ERRCOND,C
 ;            BufEval;
	LCALL	BUFEVAL
 ;            if ErrCond then
	JB	ERRCOND,$+6
	LJMP	?L571
 ;              write(serial,ValErrStr,char(13))
	MOV	DPTR,#VALERRSTR
	MOV	R5,#00H
	MOV	R4,#01H
	CLR	A
	MOVC	A,@A+DPTR
	INC	DPTR
	MOV	R7,A
	MOV	R6,#00H
	LCALL	?WRITS
	MOV	A,#0DH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
 ;            else
	LJMP	?L572
?L571:
 ;              begin
 ;                dataBuf[1]:=value;
	MOV	DATABUF+01H,VALUE
 ;                dataBuf[0]:=adrLo;
	MOV	DATABUF,ADRLO
 ;                setISOparam;
	LCALL	SETISOPARAM
 ;              end;
?L572:
 ;            if monDisp then
	JB	MONDISP,$+6
	LJMP	?L573
 ;              begin
 ;                write(display,char(12),ATRStr,NumToHex(adrHi),NumToHex(adrLo));
	MOV	A,#0CH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#01H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	MOV	DPTR,#ATRSTR
	MOV	R5,#01H
	MOV	R4,#01H
	CLR	A
	MOVC	A,@A+DPTR
	INC	DPTR
	MOV	R7,A
	MOV	R6,#00H
	LCALL	?WRITS
	MOV	THEBYTE,ADRHI
	LCALL	NUMTOHEX
	MOV	R0,#NUMTOHEX?RET
	MOV	R5,#01H
	MOV	R4,#01H
	MOV	A,@R0
	INC	R0
	MOV	R7,A
	MOV	R6,#01H
	LCALL	?WRITS
	MOV	THEBYTE,ADRLO
	LCALL	NUMTOHEX
	MOV	R0,#NUMTOHEX?RET
	MOV	R5,#01H
	MOV	R4,#01H
	MOV	A,@R0
	INC	R0
	MOV	R7,A
	MOV	R6,#01H
	LCALL	?WRITS
 ;              end;
?L573:
 ;          end;
?L564:
	LJMP	?L574
 ;        'A','a':
?L570:
	MOV	A,CLIBUF
	XRL	A,#041H
	JZ	$+5
	LJMP	?L577
?L576:
	LJMP	?L578
?L577:
	MOV	A,CLIBUF
	XRL	A,#061H
	JZ	$+5
	LJMP	?L580
 ;{ ATR ausgeben }
 ;          begin
?L578:
 ;            GetProtParams;
	LCALL	GETPROTPARAMS
 ;            if monDisp then
	JB	MONDISP,$+6
	LJMP	?L581
 ;              write(display,char(12),ATRStr);
	MOV	A,#0CH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#01H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	MOV	DPTR,#ATRSTR
	MOV	R5,#01H
	MOV	R4,#01H
	CLR	A
	MOVC	A,@A+DPTR
	INC	DPTR
	MOV	R7,A
	MOV	R6,#00H
	LCALL	?WRITS
?L581:
 ;            for j:=0 to 3 do
	MOV	J,#00H
?L582:
 ;              begin
	MOV	A,J
	SETB	C
	SUBB	A,#03H
	JC	$+5
	LJMP	?L583
 ;                if monDisp then
	JB	MONDISP,$+6
	LJMP	?L584
 ;                  write(display,NumToHex(dataBuf[j]));
	MOV	A,J
	ADD	A,#DATABUF
	MOV	R0,A
	MOV	THEBYTE,@R0
	LCALL	NUMTOHEX
	MOV	R0,#NUMTOHEX?RET
	MOV	R5,#01H
	MOV	R4,#01H
	MOV	A,@R0
	INC	R0
	MOV	R7,A
	MOV	R6,#01H
	LCALL	?WRITS
?L584:
 ;                write(serial,NumToHex(dataBuf[j]));
	MOV	A,J
	ADD	A,#DATABUF
	MOV	R0,A
	MOV	THEBYTE,@R0
	LCALL	NUMTOHEX
	MOV	R0,#NUMTOHEX?RET
	MOV	R5,#00H
	MOV	R4,#01H
	MOV	A,@R0
	INC	R0
	MOV	R7,A
	MOV	R6,#01H
	LCALL	?WRITS
 ;                if j<3 then
	MOV	A,J
	CLR	C
	SUBB	A,#03H
	JC	$+5
	LJMP	?L585
 ;                  write(serial,',');
	MOV	A,#02CH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
?L585:
 ;              end;
	INC	J
	SJMP	?L582
?L583:
 ;            write(serial,char(13));
	MOV	A,#0DH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
 ;          end;
?L574:
	LJMP	?L586
 ;        'M','m':
?L580:
	MOV	A,CLIBUF
	XRL	A,#04DH
	JZ	$+5
	LJMP	?L589
?L588:
	LJMP	?L590
?L589:
	MOV	A,CLIBUF
	XRL	A,#06DH
	JZ	$+5
	LJMP	?L592
 ;{ Hexdump }
 ;          begin
?L590:
 ;            ErrCond:=false;
	CLR	ERRCOND
 ;            if cliBuf[1] <> 13 then
	MOV	A,CLIBUF+01H
	XRL	A,#0DH
	JNZ	$+5
	LJMP	?L593
 ;              begin
 ;                BufEval;
	LCALL	BUFEVAL
 ;                if ErrCond then
	JB	ERRCOND,$+6
	LJMP	?L594
 ;                  write(serial,ValErrStr,char(13))
	MOV	DPTR,#VALERRSTR
	MOV	R5,#00H
	MOV	R4,#01H
	CLR	A
	MOVC	A,@A+DPTR
	INC	DPTR
	MOV	R7,A
	MOV	R6,#00H
	LCALL	?WRITS
	MOV	A,#0DH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
 ;                else
	LJMP	?L595
?L594:
 ;                  adrHi:=value;
	MOV	ADRHI,VALUE
?L595:
 ;              end
 ;            else
	LJMP	?L596
?L593:
 ;              adrHi:=0;
	MOV	ADRHI,#00H
?L596:
 ;            if not ErrCond then
	JNB	ERRCOND,$+6
	LJMP	?L597
 ;              HexMon;
	LCALL	HEXMON
?L597:
 ;          end;
?L586:
	LJMP	?L598
 ;        'T','t':
?L592:
	MOV	A,CLIBUF
	XRL	A,#054H
	JZ	$+5
	LJMP	?L601
?L600:
	LJMP	?L602
?L601:
	MOV	A,CLIBUF
	XRL	A,#074H
	JZ	$+5
	LJMP	?L604
 ;{ Telefonkarte auslesen und Daten in Klartext ausgeben }
 ;          begin
?L602:
 ;            TelCdSerAnalyze;
	LCALL	TELCDSERANALYZE
 ;          end;
?L598:
	LJMP	?L605
 ;        'K','k':
?L604:
	MOV	A,CLIBUF
	XRL	A,#04BH
	JZ	$+5
	LJMP	?L608
?L607:
	LJMP	?L609
?L608:
	MOV	A,CLIBUF
	XRL	A,#06BH
	JZ	$+5
	LJMP	?L611
 ;{ KV-Karte auslesen und Daten in Klartext ausgeben }
 ;          begin
?L609:
 ;            KVKSerAnalyze;
	LCALL	KVKSERANALYZE
 ;          end;
?L605:
	LJMP	?L612
 ;        'I','i':
?L611:
	MOV	A,CLIBUF
	XRL	A,#049H
	JZ	$+5
	LJMP	?L615
?L614:
	LJMP	?L616
?L615:
	MOV	A,CLIBUF
	XRL	A,#069H
	JZ	$+5
	LJMP	?L618
 ;{ "Karte einsetzen" }
 ;          begin
?L616:
 ;            SendStat(CardInit);
	LCALL	CARDINIT
	MOV	C,CARDINIT?RET
	MOV	STATE,C
	LCALL	SENDSTAT
 ;          end;
?L612:
	LJMP	?L619
 ;        'O','o':
?L618:
	MOV	A,CLIBUF
	XRL	A,#04FH
	JZ	$+5
	LJMP	?L622
?L621:
	LJMP	?L623
?L622:
	MOV	A,CLIBUF
	XRL	A,#06FH
	JZ	$+5
	LJMP	?L625
 ;{ "Karte entnehmen" }
 ;          begin
?L623:
 ;            SendStat(CardExit);
	LCALL	CARDEXIT
	MOV	C,CARDEXIT?RET
	MOV	STATE,C
	LCALL	SENDSTAT
 ;          end;
?L619:
	LJMP	?L626
 ;        'D','d','S','s':
?L625:
	MOV	A,CLIBUF
	XRL	A,#044H
	JZ	$+5
	LJMP	?L629
?L628:
	LJMP	?L630
?L629:
	MOV	A,CLIBUF
	XRL	A,#064H
	JZ	$+5
	LJMP	?L632
?L630:
	LJMP	?L633
?L632:
	MOV	A,CLIBUF
	XRL	A,#053H
	JZ	$+5
	LJMP	?L635
?L633:
	LJMP	?L636
?L635:
	MOV	A,CLIBUF
	XRL	A,#073H
	JZ	$+5
	LJMP	?L638
 ;{ schon oben behandelt }
 ;          begin
?L636:
 ;            SendStat(true);
	SETB	STATE
	LCALL	SENDSTAT
 ;          end;
?L626:
	LJMP	?L639
 ;        'B','b':
?L638:
	MOV	A,CLIBUF
	XRL	A,#042H
	JZ	$+5
	LJMP	?L642
?L641:
	LJMP	?L643
?L642:
	MOV	A,CLIBUF
	XRL	A,#062H
	JZ	$+5
	LJMP	?L645
 ;{ Monitor on/off }
 ;          begin
?L643:
 ;            ErrCond:=false;
	CLR	ERRCOND
 ;            BufEval;
	LCALL	BUFEVAL
 ;            if ErrCond then
	JB	ERRCOND,$+6
	LJMP	?L646
 ;              write(serial,ValErrStr,char(13))
	MOV	DPTR,#VALERRSTR
	MOV	R5,#00H
	MOV	R4,#01H
	CLR	A
	MOVC	A,@A+DPTR
	INC	DPTR
	MOV	R7,A
	MOV	R6,#00H
	LCALL	?WRITS
	MOV	A,#0DH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
 ;            else
	LJMP	?L647
?L646:
 ;              if value=1 then
	MOV	A,VALUE
	XRL	A,#01H
	JZ	$+5
	LJMP	?L648
 ;                begin
 ;                  monDisp:=true;
	SETB	MONDISP
 ;                  write(display,char(12),'Monitor on');
	MOV	A,#0CH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#01H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	SJMP	$+13
?S9946:
	DB	0AH
?S9947:
	DB	04DH
	DB	06FH
	DB	06EH
	DB	069H
	DB	074H
	DB	06FH
	DB	072H
	DB	020H
	DB	06FH
	DB	06EH
	MOV	DPTR,#?S9947
	MOV	R5,#01H
	MOV	R4,#01H
	MOV	R7,#0AH
	MOV	R6,#00H
	LCALL	?WRITS
 ;                end
 ;              else
	LJMP	?L649
?L648:
 ;                begin
 ;                  monDisp:=false;
	CLR	MONDISP
 ;                  write(display,char(12));
	MOV	A,#0CH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#01H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
 ;                end;
?L649:
?L647:
 ;          end;
?L639:
	LJMP	?L650
 ;        char(13):
?L645:
	MOV	A,CLIBUF
	XRL	A,#0DH
	JZ	$+5
	LJMP	?L653
 ;          begin
?L652:
 ;          end;
?L650:
	LJMP	?L654
 ;        else
?L653:
 ;          begin
 ;            write(serial,CmdErrStr,char(13));
	MOV	DPTR,#CMDERRSTR
	MOV	R5,#00H
	MOV	R4,#01H
	CLR	A
	MOVC	A,@A+DPTR
	INC	DPTR
	MOV	R7,A
	MOV	R6,#00H
	LCALL	?WRITS
	MOV	A,#0DH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#00H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
 ;          end;
 ;      end;
?L654:
 ;    until false
 ;  else
	LJMP	?L522
	LJMP	?L655
?L521:
 ;{ Stand-Alone-Betrieb }
 ;    repeat
?L656:
 ;      wait(10);
	MOV	ZEHNTELSEC,#LOW(0AH)
	MOV	ZEHNTELSEC+01H,#00H
	LCALL	WAIT
 ;      if CardInit then
	LCALL	CARDINIT
	JB	CARDINIT?RET,$+6
	LJMP	?L657
 ;        begin
 ;          CardATRtoBuf;
	LCALL	CARDATRTOBUF
 ;          write(display,char(12),ATRStr);
	MOV	A,#0CH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#01H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	MOV	DPTR,#ATRSTR
	MOV	R5,#01H
	MOV	R4,#01H
	CLR	A
	MOVC	A,@A+DPTR
	INC	DPTR
	MOV	R7,A
	MOV	R6,#00H
	LCALL	?WRITS
 ;          for j:=0 to 3 do
	MOV	J,#00H
?L658:
 ;            write(display,NumToHex(dataBuf[j]));
	MOV	A,J
	SETB	C
	SUBB	A,#03H
	JC	$+5
	LJMP	?L659
	MOV	A,J
	ADD	A,#DATABUF
	MOV	R0,A
	MOV	THEBYTE,@R0
	LCALL	NUMTOHEX
	MOV	R0,#NUMTOHEX?RET
	MOV	R5,#01H
	MOV	R4,#01H
	MOV	A,@R0
	INC	R0
	MOV	R7,A
	MOV	R6,#01H
	LCALL	?WRITS
	INC	J
	SJMP	?L658
?L659:
 ;          GetProtParams;
	LCALL	GETPROTPARAMS
 ;          wait(15);
	MOV	ZEHNTELSEC,#LOW(0FH)
	MOV	ZEHNTELSEC+01H,#00H
	LCALL	WAIT
 ;          repeat
?L660:
 ;            case ISOprtk of
 ;              Tel0PrtkC,Tel1prtkC,Tel2prtkC:
	MOV	A,ISOPRTK
	JZ	$+5
	LJMP	?L664
?L663:
	LJMP	?L665
?L664:
	MOV	A,ISOPRTK
	XRL	A,#02H
	JZ	$+5
	LJMP	?L667
?L665:
	LJMP	?L668
?L667:
	MOV	A,ISOPRTK
	XRL	A,#04H
	JZ	$+5
	LJMP	?L670
 ;                begin
?L668:
 ;                  TelCdAnalyze;
	LCALL	TELCDANALYZE
 ;                end;
?L661:
	LJMP	?L671
 ;              NoATRC, I2CprtkC:
?L670:
	MOV	A,ISOPRTK
	XRL	A,#0FH
	JZ	$+5
	LJMP	?L674
?L673:
	LJMP	?L675
?L674:
	MOV	A,ISOPRTK
	XRL	A,#08H
	JZ	$+5
	LJMP	?L677
 ;                begin
?L675:
 ;                  write(display,char(12),I2CStr);
	MOV	A,#0CH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#01H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	MOV	DPTR,#I2CSTR
	MOV	R5,#01H
	MOV	R4,#01H
	CLR	A
	MOVC	A,@A+DPTR
	INC	DPTR
	MOV	R7,A
	MOV	R6,#00H
	LCALL	?WRITS
 ;                  wait(15);
	MOV	ZEHNTELSEC,#LOW(0FH)
	MOV	ZEHNTELSEC+01H,#00H
	LCALL	WAIT
 ;                  MemCdDisplay;
	LCALL	MEMCDDISPLAY
 ;                end;
?L671:
	LJMP	?L678
 ;              ZWDprtkC:
?L677:
	MOV	A,ISOPRTK
	XRL	A,#0AH
	JZ	$+5
	LJMP	?L681
 ;                begin
?L680:
 ;                  write(display,char(12),ZWDStr);
	MOV	A,#0CH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#01H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	MOV	DPTR,#ZWDSTR
	MOV	R5,#01H
	MOV	R4,#01H
	CLR	A
	MOVC	A,@A+DPTR
	INC	DPTR
	MOV	R7,A
	MOV	R6,#00H
	LCALL	?WRITS
 ;                  wait(15);
	MOV	ZEHNTELSEC,#LOW(0FH)
	MOV	ZEHNTELSEC+01H,#00H
	LCALL	WAIT
 ;                  MemCdDisplay;
	LCALL	MEMCDDISPLAY
 ;                end;
?L678:
	LJMP	?L682
 ;              DRDprtkC:
?L681:
	MOV	A,ISOPRTK
	XRL	A,#09H
	JZ	$+5
	LJMP	?L685
 ;                begin
?L684:
 ;                  write(display,char(12),DRDStr);
	MOV	A,#0CH
	MOV	R2,A
	MOV	R4,#01H
	MOV	R5,#01H
	MOV	R6,#04H
	MOV	R7,#01H
	LCALL	?WRITS
	MOV	DPTR,#DRDSTR
	MOV	R5,#01H
	MOV	R4,#01H
	CLR	A
	MOVC	A,@A+DPTR
	INC	DPTR
	MOV	R7,A
	MOV	R6,#00H
	LCALL	?WRITS
 ;                  wait(15);
	MOV	ZEHNTELSEC,#LOW(0FH)
	MOV	ZEHNTELSEC+01H,#00H
	LCALL	WAIT
 ;                  MemCdDisplay;
	LCALL	MEMCDDISPLAY
 ;                end;
?L682:
	LJMP	?L686
 ;            end;
?L685:
?L686:
 ;            P1:=CdOff;
	MOV	P1,#0F8H
 ;          until CardExit;
	LCALL	CARDEXIT
	JB	CARDEXIT?RET,$+6
	LJMP	?L660
 ;        end;
?L657:
 ;    until false;
	LJMP	?L656
?L655:
 ;end.
?L687:
	SJMP	?L687

CSEG

	ORG	00H
	SJMP	$+026H
	ORG	026H
	LCALL	?INITSTACK
	LJMP	BEGIN
 EXTRN	CODE ( ?IMUL )
 EXTRN	CODE ( ?IDIV )
 EXTRN	CODE ( ?IMOD )
 EXTRN	CODE ( ?MASSI4 )
 EXTRN	CODE ( ?WRITS )
 EXTRN	CODE ( ?WRITI )
 EXTRN	CODE ( ?READ1C )
 EXTRN	CODE ( ?INITSTACK )
 EXTRN	CODE ( ?ISHL )
 EXTRN	CODE ( ?ISHR )
 EXTRN	CODE ( ?RESET )
 EXTRN	CODE ( ?BSHR )
 EXTRN	CODE ( ?BSHL )

	BSEG
	DBIT	8


END
