$DEBUG
;source text for IODRIVERS with different character writing (WRITC)
; and character reading (READC) routines
;870712 KSC Software Systems
;880430 corrected for use in version 2.0
;890418 corrected for conditional assembly of soft uart characteristics.
;890703 corrected for use in version 3.0
;891114 last correction for version 3.05b
;940802 gekrzt fr cm-Prototyper, nur noch SBUF und DISPLAY


LIBRARY	READC

; READC reads one character from a selected device or string
; at call:  I/O channel number in ?DEVICE; the character is returned in R2,
; the channels are:

; O:   The serial port SBUF, the character is ecchoed.

; 5,6: Those routines are used by the procedure VAL and must not
;		   be changed.



PUBLIC ?READC

EXTRN	CODE	( ?WRITC )
EXTRN	DATA	( ?AR0, ?AR4, ?DEVICE)
?READC?C	SEGMENT	CODE
RSEG	?READC?C

	
?READC:	MOV     A,?DEVICE
        JZ      READ0
        DEC     A
        DEC     A
        DEC     A
      	DEC	    A
        DEC     A
	      JZ	READ5
	      DEC	A
	      JZ	READ6
        RET

READ6:  DEC	?AR4		  ; These routines are for the VAL procedure
	      MOV	A,?AR4		; and must not be changed
	      JZ	RETCR
	      MOVX	A,@DPTR
	      INC	DPTR
	      MOV	R2,A
	      RET

RETCR:	MOV	R2,#13
	      RET

READ5:	DEC	?AR4		  ; These routines are for the VAL procedure
	      MOV	A,?AR4		; and must not be changed
	      JZ	RETCR

	      MOV	R0,?AR0
	      MOV	A,@R0
	      INC	?AR0
	      MOV	R2,A
	      RET

READ0:	JNB	RI,READ0	; Serial uart
	      CLR	RI
	      MOV	A,SBUF
	      MOV	R2,A
	      SUBB	A,#0DH
	      JZ	$+5
	      CALL	?WRITC
	      RET

LIBEND


; WRITC writes one character to a selected device or string
; at call: the character must be in R2, I/O channel number in ?DEVICE
; the channels are:

; O:   The serial port SBUF
; 1:   A parallel memory mapped display like a SANYO LCM 5xx
;		   connected at external RAM address DISPLAY
; 5,6: Those routines are used by the procedure STR and must not
;	     be changed.

LIBRARY	WRITC

PUBLIC	?WRITC, ?DEVICE, ?AR0, ?AR4
?WRITC?C	SEGMENT	CODE
?WRITC?D	SEGMENT	DATA

RSEG	?WRITC?D

?DEVICE:
	DS	1
?AR0:	DS	1
?AR4:	DS	1

RSEG	?WRITC?C


?WRITC:	MOV     A,?DEVICE
        JZ      serwrt
        DEC     A
        JZ      dispwrt
        DEC     A
        DEC     A
      	DEC	    A
        DEC     A
	      JZ	    WRIT5
	      DEC	    A
	      JZ	    WRIT6
        ret

WRIT6:	MOV	A,R2	; For string operation, external RAM
	      MOVX	@DPTR,A
	      INC	DPTR
	      INC	?AR4
	      RET
	
WRIT5:	MOV	A,R2	; For string operation, internal RAM
	      MOV	R0,?AR0
	      MOV	@R0,A
	      INC	?AR0
	      INC	?AR4
	      RET

serwrt: clr TI    ; Original war fehlerhaft!
	      MOV	A,R2
	      MOV	SBUF,A
serwlp: JNB	TI,serwlp
	      CLR	TI
	      RET

; Display des MacInterface, (C) C.Meyer 8/94

DISPLAY		XDATA	8200H	; P2.1 (A9) auf RS   bei Card Analyzer: 8000H
DISPSTAT	XDATA	8100H	; P2.0 (A8) auf R/W  bei Card Analyzer: 4000H
DISPCOMD  XDATA 8000H ; Befehlsregister    bei Card Analyzer: 0000H

DBUSY:  PUSH	  DPH               ; Display busy?
	      PUSH	  DPL
	      MOV	    DPTR,#DISPSTAT
DBUSLP:	MOVX	  A,@DPTR
	      JB	    ACC.7,DBUSLP        ; still busy?
	      POP     DPL
	      POP     DPH
	      RET


dispwrt:
        push    dph
        push    dpl
        acall   dbusy
        CJNE    R2,#12,DISP2    ; FF?
        mov     a, #(1)         ; Clear, Cursor Home
        sjmp    DISPCMD

DISP2:	CJNE    R2,#13,DISP3    ; CR?
DISP2A: mov     a, #(80H+0)     ; Adresse Zeilenanfang
        sjmp    DISPCMD

DISP3:	CJNE    R2,#10,DISP4    ; LF?
DISP3A: mov     a, #(80H+0)     ; Adresse Zeilenanfang
        sjmp    DISPCMD

DISP4:  CJNE    R2,#8,DISP5     ; BS?
        mov     dptr, #DISPSTAT
        movx    a, @dptr        ; Aktuelle Char-Adresse
        jz      dispexit        ; schon am Anfang?
        cjne    a, #40H, disp4a ; auf der Kippe?
        mov     a, #(08H+80H)   ; Adr + Set DD-Adr Command
        mov     dptr, #DISPCOMD
        movx    @dptr, a
        acall   dbusy
disp4a:
        mov     a, #10H         ; Cursor move left
        sjmp    DISPCMD

DISP5:  CJNE    R2,#9,DISP6     ; HT?
        mov     a, #14H         ; Cursor move right
        mov     dptr, #DISPCOMD ; Command in Acc an Display
        movx    @dptr, a
        acall   dbusy
        mov     dptr, #DISPSTAT
        movx    a, @dptr        ; Aktuelle Char-Adresse
        cjne    a, #08H, disp5a ; auf der Kippe?
        mov     a, #(40H+80H)   ; Adr + Set DD-Adr Command
        mov     dptr, #DISPCOMD
        movx    @dptr, a
disp5a:
        sjmp    DISPEXIT

DISP6:  CJNE    R2,#2,DISP7     ; STX?
        mov     a, #(8+4+2+1)   ; Cursor on
        sjmp    DISPCMD

DISP7:  CJNE    R2,#3,DISP8     ; ETX?
        mov     a, #(8+4)       ; Cursor off
        sjmp    DISPCMD

DISP8:  sjmp    DISPANZ

DISPCMD:
        mov     dptr, #DISPCOMD ; Command in Acc an Display
        movx    @dptr, a
        sjmp    dispexit
DISPANZ:
        MOV	    DPTR,#DISPLAY   ; Char in R2 anzeigen:
        MOV	    A,R2
	      MOVX	  @DPTR,A         ; char in accumulator to display
; feststellen, ob Zeilenberlauf (auch bei einzeiligem Display!)
        acall   dbusy
        mov     dptr, #DISPSTAT
        movx    a, @dptr           ; Aktuelle Char-Adresse
        cjne    a, #08H, DISPEXIT  ; #10H bei zweizeiligem Display
        mov     a, #(40H+80H)      ; Adr + Set DD-Adr Command
        mov     dptr, #DISPCOMD
        movx    @dptr, a
DISPEXIT:
        pop     dpl
        pop     dph
	      ret


LIBEND

LIBRARY RESET

PUBLIC ?RESET


?RESET?C	SEGMENT	CODE

RSEG	?RESET?C

?RESET: MOV	A,R3
	      JZ	RESET0
        DEC     A
        JZ  reset1
        RET
	
RESET0:
; this code resets SBUF to polling, 9600 Baud @11.0592 MHz CPU clock
; and resets eof-bit (1)
	      MOV	A,TMOD
	      ANL	A,#0FH
	      ADD	A,#20H
	      MOV	TMOD,A
	      CLR	SM0
	      SETB	SM1
	      MOV	TH1,#250
	      SETB	TR1
	      MOV	A,PCON
	      ORL	A,#80H
	      MOV	PCON,A
	      SETB	REN
	      SETB	TI
	      CLR	1
	      RET

DISPLAY		XDATA	8200H	; P2.1 (A9) auf RS   bei Card Analyzer: 8000H
DISPSTAT	XDATA	8100H	; P2.0 (A8) auf R/W  bei Card Analyzer: 4000H
DISPCOMD  XDATA 8000H ; Befehlsregister    bei Card Analyzer: 0000H

DBUSY:  PUSH	  DPH               ; Display busy?
	      PUSH	  DPL
	      MOV	    DPTR,#DISPSTAT
DBUSLP:	MOVX	  A,@DPTR
	      JB	    ACC.7,DBUSLP        ; still busy?
	      POP     DPL
	      POP     DPH
	      RET


reset1:
; Display auf Default-Werte setzen und lschen
        push    dph
        push    dpl
        mov     dptr, #DISPCOMD
        mov     a, #(32+16+8)   ; Set 8 Bit, 2-line
        movx    @dptr, a
        acall   dBusy
        mov     a, #(8+4)       ; Display on, Cursor off
        movx    @dptr, a
        acall   dBusy
        mov     a, #(4+2)       ; Entry mode: no shift
        movx    @dptr, a
        acall   dBusy
        mov     a, #(1)         ; Clear, Cursor Home
        movx    @dptr, a
        pop     dpl
        pop     dph
	      ret


LIBEND

LIBRARY EOF

EOF?C	SEGMENT CODE

RSEG	EOF?C

PUBLIC ?EOF

?EOF:	MOV	A,R3
	JZ	EOF0
	RET
	
EOF0:	MOV	C,1
	RET

LIBEND
	
; !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;
;  These two last library modules MUST be the last input for the LINK51.
;
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

LIBRARY ISTACK

PUBLIC	?INITISTACK

EXTRN DATA ( ?STACKPTR )

?ISTACK?I	SEGMENT	IDATA
?ISTACK?C	SEGMENT CODE

RSEG	?ISTACK?I

?ISTACKSTART:
	DS	1	; stack in upper part of internal memory
	
RSEG	?ISTACK?C

?INITISTACK:
	MOV	?STACKPTR,#?ISTACKSTART
	POP	0
	POP	1
	MOV	SP,?STACKPTR
	PUSH	1
	PUSH	0
	RET
	

LIBEND

LIBRARY	STACK
PUBLIC	?STACKPTR
PUBLIC	?INITSTACK
?STACK?D	SEGMENT	DATA
?STACK?C	SEGMENT	CODE

RSEG	?STACK?D

?STACKPTR:
	DS	1	; initial value for transfer
?STACKSTART:
	DS	1	; stack: rest of data memory

RSEG	?STACK?C

?INITSTACK:
	MOV	?STACKPTR,#?STACKSTART
	POP	0
	POP	1
	MOV	SP,?STACKPTR
	PUSH	1
	PUSH	0
	RET
	
	
LIBEND

END


