Program cpudetect;
uses DOS;

var EAX,EBX,EDX,ECX:longint;
    delta:byte;
    alt06:pointer;
    exitsave:pointer;

const  unknown:boolean=false;

procedure Int06(Flags, CS, IP, AX, BX, CX, DX,
                       SI, DI, DS, ES, BP: word);
interrupt;
begin
 inc (ip,delta);
 ax:=$82;
 unknown:=true;
end;

Function TESTCPUid:boolean;
var  CRSTR:array[1..12] of char absolute EBX;
     Copyr:string;
     Stepping, Model, Family:Byte;
     Features:Longint;

Procedure CPUID;
begin
delta:=2;
inline ($66/$A1/EAX/
        $0F/$A2/        { CPUID }
        $66/$A3/EAX/    { MOV    [EAX],EAX }
        $66/$89/$1E/EBX/{ MOV    [EBX],EBX }
        $66/$89/$0E/ECX/{ MOV    [ECX],ECX }
        $66/$89/$16/EDX){ MOV    [EDX],EDX }
end;

begin
  EAX:=0; CPUID;
  TESTCPUID:=not unknown;
  if unknown then exit;
  copyr:=CRSTR;
  EAX:=1; CPUID;
  Stepping:=EAX and $F;
  Model:=(EAX shr 4) and $F;
  Family:=(EAX shr 8) and $F;
  Features:=EDX;
  Writeln ('CPUID meldet :',copyr);
  Writeln ('***********************************');
  Write   ('=> Prozessortyp : ');

  case Family of
    3:Writeln ('i386, Model=',Model,' Stepping= ',stepping);
    4:begin
      If copy(copyr,1,3)='UMC' then Write ('UMC ')
                               else Write ('Intel ');
      Write ('486');
      case Model of
       1: Write ('DX');
       2: Write ('SX');
       3: Write ('DX2');
       5: Write ('SX2');
       8: Write ('IDX4');
       else Write('Model:',Model);
      end;
      Writeln (' SL-Enhanced, Stepping= ',stepping);
      end;
    5:begin
      Write ('Pentium, Model=',Model);
      case model of
        1: Write (' 60/66');
        2: Write (' 90/100');
        end;
      Writeln (' Stepping= ',stepping);
      end;

    else Writeln ('Familie=',Family,'  Model=',Model,
                 ' Stepping= ',stepping);
  end;
end;

Function CyrixorTI:boolean;
var fvor,fnach:word;
const fmask=$08D5;

begin
asm
 Mov ax,0
 cmp ax,ax
 pushf
 pop ax
 mov fvor,ax
 mov ax,$0FFFF
 mov dx,0
 mov bx,4
 div bx
 pushf
 pop ax
 mov fnach,ax
 end;
CyrixorTI := (fvor and fmask)
           = (fnach and fmask)
end;



var xfeld:array[0..1] of longint;

Function TestIBM:boolean;

procedure getMSR (index:longint);

begin
 delta:=2;
 unknown:=false;
 asm
   db $66; mov cx,word ptr [index]
   db $0F,$32
   db $66; mov word ptr xfeld,ax
   db $66; mov word ptr [xfeld+4],dx
 end;
end;

begin
 testibm:=false;exit;
 getMsr($1000);
 Testibm:=unknown;
end;

Procedure WriteCyrix;
var Dir0,Dir1:byte;
     cyrix:string;

begin
 Port[$22]:=$FE; Dir0:=port[$23];
 port[$22]:=$FF; Dir1:=port[$23];
 case DIR0 of
  $0 : Cyrix:='486??';
  $7 : Cyrix:='Cx486x2';
  $12: Cyrix:='Cx486S'; { neuere Versionen }
  $13: Cyrix:='CX486S2';
  $1A: Cyrix:='CX486DX';
  $1B: Cyrix:='CX486DX2';
  $FF: Cyrix:='486SLC/DLC/S';
  end;
Writeln ('Cyrix/TI-Prozessor:',cyrix);
end;

Function MSW:word; inline ($0F/$01/$E0);

Function virtuell:boolean;
begin
virtuell:=odd(msw);
end;


Procedure myexit; Far;
begin
  exitproc:=exitsave;
  setintvec($06,alt06);
end;

begin
 exitsave:=exitproc;
 exitproc:=@myexit;
 getintvec ($06,alt06);
 setintvec ($06,@int06);
 If TestCPUid then halt;
 Writeln;
 Writeln ('Keine Intel SL enhanced CPU, kein UMC ');
 if (CyrixorTI) then WriteCyrix
 else
  begin
  If (not virtuell and TestIBM) then write (' IBM Blue-Lightning-Prozessor')
    else
    begin
    Writeln ('Kein IBM/Cyrix/TI-Prozessor');
    Writeln ('=> Intel- (alte Serie), AMD-Prozessor');
    end;
  end;
end.


