Program NWBeisp;

{ Rahmenprogramm zur Demonstration der NetWare-Aufrufe
  und der Einbindung in eigene Applikationen
  (C) Copyright 1994 Alexander Schulze }

Uses
 Crt, Dos,

 NWHilf, NWBasic, NWToolB, NWDOS;

Function MenueAuswahl
 (Titel: TStr80;
  c01: Char; s01: TStr80;
  c02: Char; s02: TStr80;
  c03: Char; s03: TStr80;
  c04: Char; s04: TStr80;
  c05: Char; s05: TStr80;
  c06: Char; s06: TStr80;
  c07: Char; s07: TStr80;
  c08: Char; s08: TStr80;
  c09: Char; s09: TStr80;
  c10: Char; s10: TStr80): Char;

Procedure Add(c: Char; s: TStr80);
Begin
 If c <> ' ' then Writeln('<',c,'> ',s)
End;

Var
 c0,c1: Char;
Begin
 ClrScr;
 Writeln(Titel);
 Writeln;
 Add(c01,s01);
 Add(c02,s02);
 Add(c03,s03);
 Add(c04,s04);
 Add(c05,s05);
 Add(c06,s06);
 Add(c07,s07);
 Add(c08,s08);
 Add(c09,s09);
 Add(c10,s10);
 Writeln;
 Writeln('ESC Zurck');
 Writeln;
 Write  ('Auswahl: ');

 Repeat
  c0:= UpCase(ReadKey);
  If c0 = #0 then c1:= ReadKey else c1:= #0;
  If c0 = ' ' then c0:= #0
 Until (c0 = #27) or
       (c0 = c01) or (c0 = c02) or
       (c0 = c03) or (c0 = c04) or
       (c0 = c05) or (c0 = c06) or
       (c0 = c07) or (c0 = c08) or
       (c0 = c09) or (c0 = c10);

 Menueauswahl:= c0;

 ClrScr;
 If c0 = c01 then Writeln(s01);
 If c0 = c02 then Writeln(s02);
 If c0 = c03 then Writeln(s03);
 If c0 = c04 then Writeln(s04);
 If c0 = c05 then Writeln(s05);
 If c0 = c06 then Writeln(s06);
 If c0 = c07 then Writeln(s07);
 If c0 = c08 then Writeln(s08);
 If c0 = c09 then Writeln(s09);
 If c0 = c10 then Writeln(s10);

 Writeln
End;

Procedure WarteAufTaste;
Begin
 Writeln;
 Writeln(''+NetWareErrMsg(NetWareResult));
 Write('Weiter mit beliebiger Taste... ');
 ReadKey;
 Writeln
End;

Procedure TestConnections;
Var
 c0,c1: Char;
 ConNo: Byte;
 BinderyObject: TBinderyObject;
 NetworkNo: TNetworkNumber;
 NodeAddress: TNodeAddress;
 FSNameTable: TFSNameTable;
 SocketNo: TSocketNumber;
 i,j: Word;
 s1,s2,s3: String;
Begin
 Repeat
  c0:=
   MenueAuswahl
    ('Verbindungs-Funktionen:',
     '1','Log-In',
     '2','Log-Out',
     'A','Attach zu File-Server',
     'D','Detach von File-Server',
     'U','User-Verbindungs-Nummer ermitteln',
     'L','Liste aller Verbindungen zum Server '+ActualServerName,
     'I','Internet-Adresse ermitteln',
     'E','Ethernet-Adresse (NodeAddress) dieser Station',
     ' ','',
     ' ','');

  If c0 <> #27
   then
    Begin
     Case c0 of

       '1': { Login }
         Begin
          Write('Servername: '); Readln(s1);
          Write('Username  : '); Readln(s2);
          Write('Password  : '); Readln(s3);
          If UserLogIn
              (UpCaseStr(s1),UpCaseStr(s2),UpCaseStr(s3)) = cc_Success
           then Writeln('Login: Verbindung hergestellt')
           else Writeln('Login: Zugriff verweigert')
         End;

       '2': { Logout }
         Begin
          LogOut;
          Writeln('Logout: Verbindung zum Netzwerk (zu allen Servern) wurde getrennt')
         End;

       'A': { Attach }
         Begin
          i:= GetFileServerNameTable(FSNameTable);
          Write('Attach zu welchem Server: ');
          Readln(s1);
          AttachToFileServer(s1);
          If NetWareResult = cc_Success then Writeln('Attach erfolgreich')
         End;

       'D': { Detach }
         Begin
          i:= GetFileServerNameTable(FSNameTable);
          If i > 0
           then
            Begin
             Writeln('Verbindung besteht zu folgenden Servern:'^J);
             For j:= 1 to i do
              Writeln('ID: ',j,' Name: '+FSNameTable[j]);
             Writeln;
             Write('Con-ID:');
             Readln(ConNo);
             DetachFromFileServer(ConNo);
             If NetWareResult = cc_Success
              then Writeln('Detach von Server '+FSNameTable[i]+' erfolgreich beendet')
              else Writeln(NetWareErrMsg(NetWareResult))
            End
           else
            Writeln('Es besteht keine Verbindung zu einem Server')
         End;

       'U':
         Begin
          Write('Benutzername: ');
          Readln(s1);
          Writeln;
          ConNo:= GetConnectNoFromName(UpCaseStr(s1),BinderyObject);
          If ConNo <> 0
           then
            Begin
             Writeln('Verbindungs-Nr: ',ConNo);
             Writeln;
             PrintBinderyObject(BinderyObject,true)
            End
           else
            Writeln('Benutzer nicht gefunden oder nicht eingelogged')
         End;

       'L':
         Begin
          For ConNo:= 1 to 100 do
           If (GetConnectionInfo(ConNo,BinderyObject)= 0) and
              (BinderyObject.bo_ID <> 0)
            then
             Begin
              Write('Nr: ',ConNo:3,' ');
              PrintBinderyObject(BinderyObject,false)
             End
         End;

       'I':
         Begin
          Write('Benutzername: ');
          Readln(s1);
          Writeln;
          ConNo:= GetConnectNoFromName(UpCaseStr(s1),BinderyObject);
          If ConNo > 0
           then
            Begin
             GetInternetAddress(ConNo,NetworkNo,NodeAddress,SocketNo);
             Write('Network-No  : ');
             For i:= 1 to 4 do
              Begin
               Write(HexStr(NetworkNo[i],2));
               If i < 4 then Write(':')
              End;
             Writeln;
             Write('Node-Address: ');
             For i:= 1 to 6 do
              Begin
               Write(HexStr(NodeAddress[i],2));
               If i < 6 then Write(':')
              End;
             Writeln;
             Writeln('Socket-No   : ',HexStr(SocketNo,4))
            End
           else
            Writeln('Benutzer nicht gefunden oder nicht eingelogged')
         End;

       'E':
         Begin
          s1:= GetStationAddress(NodeAddress);
          Write('Node-Address: ');
          For i:= 1 to 6 do
           Begin
            Write(NodeAddress[i]);
            If i < 6 then Write(':')
           End;
          Writeln
         End;

      End;

     WarteAufTaste
    End

 Until c0 = #27
End;

Procedure TestFileServer;
Var
 c0,c1: Char;
 s: String;
 i,j,y,m,d,dow,hour,min,sec: Word;
 Freespace: LongInt;
 BinderyObject: TBinderyObject;
 Restrictions: Boolean;
 VolumeInfo: TVolumeInfo;
 FSDescr: TFSDescrStrings;
 FSInfo: TFileServerInfo;
Begin
 Repeat
  c0:=
   MenueAuswahl
    ('NetWare-Toolbox: Fileserver-Funktionen',
     'C','Console-Privileges',
     'L','Liste aller Fileserver',
     'Z','Zeit und Datum des Fileservers '+ActualServerName,
     'B','Beschreibung des Fileservers '+ActualServerName,
     'I','Info ber aktuellen Fileserver '+ActualServerName,
     'F','Freie Plattenkapazitt auf Server '+ActualServerName,
     'V','Volumes am Server '+ActualServerName+' (nur Namen ermitteln)',
     'T','Information ber Volume (Teil-Information ohne Console-Rechte)',
     'K','Information ber Volume (Komplett-Information, nur mit Console-Rechten)',
     ' ','');

  If c0 <> #27
   then
    Begin
     Case c0 of

       'C':
        If CheckConsolePrivileges
         then Writeln('Sie haben Fileserver-Console-Rechte')
         else Writeln('Sie haben keine Fileserver-Console-Rechte');

       'L':
        ListObjects(ot_FileServer,'*');

       'Z':
        Begin
         GetFileServerDateAndTime(y,m,d,dow,hour,min,sec);
         Writeln('Fileserver-Datum: ',d,'.',m,'.',y,'  Zeit: ',hour,':',min,':',sec);
        End;

       'B':
        Begin
         GetFileServerDescriptionStrings(FSDescr);
         If NetWareResult = cc_Success
          then
           With FSDescr do
            Begin
             Writeln('CompanyName  : ',CompanyName);
             Writeln('Revision     : ',Revision);
             Writeln('RevisionDate : ',RevisionDate);
             Writeln('(C) Copyright: ',CopyrightNote);
            End
          else Writeln(NetWareErrMsg(NetWareResult))
        End;

       'I':
        Begin
         GetFileServerInformation(FSInfo);
         If NetWareResult = cc_Success
          then
           With FSInfo do
            Begin
             Writeln('Server-Name       : ',ServerName);
             Writeln('NetWare-Revision  : ',NetWareVers,'.',NetWareSubVers);
             Writeln('Max. Verbindungen : ',MaxConnections);
             Writeln('Benutzte Verb.    : ',UsedConnections);
             Writeln('Max.angeschl.Vol. : ',MaxConnectedVolumes);
             Writeln('OS-Revision       : ',OSRevisionNo);
             Writeln('SFT-Level         : ',SFTLevel);
             Writeln('TTS-Level         : ',TTSLevel);
             Writeln('Bish.max.ben.Verb.: ',PeakConnectionsUsed);
             Writeln('Accounting-Vers.  : ',AccountingVers);
             Writeln('VAP-version       : ',VAPVers);
             Writeln('Queuing-Version   : ',QueuingVers);
             Writeln('Printserver-Vers. : ',PrintServerVers);
             Writeln('Virt.Cons.Vers.   : ',VirtualConsoleVers);
             Writeln('Secur.Restr.Level : ',SecurRestrictLevel);
             Writeln('InternetBridgeVers: ',InternetBridgeVers);
            End
          else Writeln(NetWareErrMsg(NetWareResult))
        End;

       'F':
        Begin
         i:= GetConnectionInfo(GetConnectionNo,BinderyObject);
         If i = cc_Success
          then
           With BinderyObject do
            Begin
             i:= GetBinderyObjectDiskSpaceLeft
                  (bo_ID,FreeSpace,Restrictions);
             If i = cc_Success
              then
               Begin
                Write('Freie Kapazitt fr ',bo_Name,': ',FreeSpace,' KBytes, ');
                If Restrictions
                 then Write('mit ')
                 else Write('ohne ');
                Writeln('Mengen-Beschrnkung')
               End
              else DisplayErrorifExist(i);
            End
          else DisplayErrorIfExist(i)
        End;

       'V':
        Begin
         For i:= 0 to Pred(MaxNetWareVolumes) do
          Begin
           s:= GetVolumeName(i);
           If s <> ''
            then Writeln('Nr: ',i:2,'  Name: ',s)
          End;
        End;

       'T':
        Begin
         For i:= 0 to Pred(MaxNetWareVolumes) do
          Begin
           j:= GetVolumeInfoWithNumber(i,VolumeInfo);
           If j = cc_Success
            then
             With VolumeInfo do
              Begin
               s:= VolumeName + ', ';
               If VolumeIsRemovable
                then s:= s + 'beweglich, '
                else s:= s + 'eingebaut, ';
               s:= s + NrToStr(TotalBlocks,0)+'bl '+NrToStr(AvailableBlocks,0)+'fr, ';
               s:= s + NrToStr(TotalDirSlots,0)+'DirEintr '+NrToStr(AvailableDirSlots,0)+'fr, ';
               Writeln('Nr: ',i:2,' Daten: ',s);
              End
          End
        End;

       'K':
        Begin
         For i:= 0 to Pred(MaxNetWareVolumes) do
          Begin
           j:= GetVolumeInformation(i,VolumeInfo);
           If j = cc_Success
            then
             With VolumeInfo do
              Begin
               s:= VolumeName + ', ';
               If VolumeIsRemovable
                then s:= s + 'beweglich, '
                else s:= s + 'eingebaut, ';
               s:= s + NrToStr(TotalBlocks,0)+'bl '+NrToStr(AvailableBlocks,0)+'fr, ';
               s:= s + NrToStr(TotalDirSlots,0)+'DirEintr '+NrToStr(AvailableDirSlots,0)+'fr, ';
               Writeln('Nr: ',i:2,' Daten: ',s);
              End;
          End;
        End;
      End;

     WarteAufTaste
    End;

 Until c0 = #27
End;

Procedure TestMessages;

 Procedure SetModes;
 Var
  c0: Char;
 Begin
  c0:=
   MenueAuswahl
    ('NetWare-Toolbox: Messagefunktionen',
     'A','Broadcast-Modus anzeigen',
     '1','Automatische Zustellung von Server- und Benutzernachrichten',
     '2','Automatische Zustellung nur von Servernachrichten',
     '3','Manuelles Abholen von Server- und Benutzernachrichten',
     '4','Manuelles Abholen nur von Servernachrichten',
     ' ','',
     ' ','',
     ' ','',
     ' ','',
     ' ','');

  If c0 <> #27
   then
    Case c0 of
      'A':
        Case GetBroadCastMode of
         bm_AutoServAndUser :
          Writeln('Automatisches Zustellen von Server- und Benutzernachrichten');
         bm_AutoServNoUser  :
          Writeln('Automatisches Zustellen nur von Servernachrichten');
         bm_PollServNoUser  :
          Writeln('Manuelles Abholen nur von Servernachrichten');
         bm_PollServAndUser :
          Writeln('Manuelles Abholen von Server- und Benutzernachrichten');
         else
          Writeln('Zurckgelieferter Broadcast-Mode ist unbekannt!');
        End;

      '1': SetBroadcastMode(bm_AutoServAndUser);
      '2': SetBroadcastMode(bm_AutoServNoUser );
      '3': SetBroadcastMode(bm_PollServAndUser);
      '4': SetBroadcastMode(bm_PollServNoUser );

     End { Case }
 End; { SetModes }

Var
 BinderyObject: TBinderyObject;
 OkList: TOkList;
 i,j: Word;
 n,m: Byte;
 ConNo: Byte;
 c0,c1: Char;
 s1,s2,s3: String;

Begin
 Repeat
  c0:=
   MenueAuswahl
    ('NetWare-Toolbox: Messagefunktionen',
     'A','Broadcast-Message an alle Benutzer',
     'B','Broadcast-Message an bestimmten Benutzer',
     'E','Broadcast-Message an eigene Station, Back-Loop-Test',
     'M','Broadcast-Modus einstellen',
     'H','Holen einer Broadcast-Message',
     ' ','',
     ' ','',
     ' ','',
     ' ','',
     ' ','');

  If c0 <> #27
   then
    Begin
     Case c0 of

       'A':
        Begin
         Write('Nachricht an alle Stationen: ');
         Readln(s1);
         SendBroadCastMessage([1..MaxReceiver],s1)
        End;

       'B':
        Begin
         Write('Empfnger-Name: ');
         Readln(s1);
         ConNo:= GetConnectNoFromName(s1,BinderyObject);
         If ConNo = 0
          then Writeln('User nicht gefunden oder nicht eingelogged')
          else
           Begin
            Write('Nachricht     : ');
            Readln(s2);
            DisplayErrorIfExist
             (SendBroadCastMessage([ConNo],s2))
           End
        End;

       'E':
        Begin
         Write('Nachricht an eigene Station: ');
         Readln(s1);
         DisplayErrorIfExist
          (SendBroadCastMessage([GetConnectionNo],s1));
        End;

       'M':
        SetModes;

       'H':
        Begin
         NetWareResult:= GetBroadcastMessage(s1);
         If NetWareResult = cc_Success
          then
           Begin
            Writeln('Message: ',s1);
            If s1 = ''
             then Writeln('Keine Nachricht gespeichert!')
           End
          else Writeln(NetWareErrMsg(NetWareResult))
        End;

      End;

     If c0 <> #0 then WarteAufTaste
    End

 Until c0 = #27
End;

Procedure TestPrintFunctions;
Var
 i,j: Word;
 Port,ConNo: Byte;
 c0,c1: Char;
 s1,s2,s3: String;
Begin
 Repeat
  c0:=
   MenueAuswahl
    ('NetWare-Toolbox: Printfunktionen',
     'N','Neuen aktuellen Drucker setzen',
     'S','Status des aktuellen Captures',
     'B','Beginnen der Umlenkung fr den aktuellen Port',
     'E','Ende der Umlenkung fr den aktuellen Port',
     'C','Abbruch der Umlenkung fr den aktuellen Port',
     'Q','Queue- und Servernamen aller LPT-Ports anzeigen',
     'U','Umlenkung eines Ports auf neue Queue',
     'P','Liste aller Printserver anzeigen',
     'L','Liste aller Printqueues anzeigen',
     'D','Direktes Drucken in Print-Queue');

  If c0 <> #27
   then
    Begin
     Case c0 of

       'N':
        Begin
         Writeln('Aktueller lokaler Drucker ist: LPT',
                  Succ(GetDefaultLocalPrinter));
         Write('Welchen Port als aktuellen setzen? LPT');
         Readln(Port);
         If (Port >= 1) and (Port <= 3)
          then SetDefaultLocalPrinter(Pred(Port))
        End;

       'S':
        Begin
         Writeln('Aktueller lokaler Drucker ist: LPT',
                  Succ(GetDefaultLocalPrinter));
         i:= GetLPTCaptureStatus(ConNo);
         Write('Status des aktuellen Captures: ');
         If i = cs_Active
          then Writeln('aktiv')
          else Writeln('inaktiv');
         Writeln('Verbindungs-Nummer           : ',ConNo)
        End;

       'B': StartLPTCapture;

       'E': EndLPTCapture;

       'C': CancelLPTCapture;

       'Q':
        For i:= 1 to 3 do
         Begin
          Write('LPT',i,': ');
          j:= GetLPTQueue(Pred(i),s1); { j erhlt die Server-Verb.Nr. }
          If j = 0                     { ein Capture gefunden ? }
           then Writeln('Kein Capture aktiv!')
           else Writeln('Queue: ',s1,'  Server: '+GetFileServerName(j))
         End;

       'U':
        Begin
         Write('Welchen Port wollen Sie umlenken? LPT');
         Readln(Port);
         Write('Welche Queue soll verwendet werden? ');
         Readln(s1);
         If (Port >= 1) and (Port <= 3)
          then
           Begin
            Dec(Port);
            i:= GetDefaultLocalPrinter;
            SetDefaultLocalPrinter(Port);
            StartLPTCapture;
            SetLPTQueue(Port,s1);
            SetDefaultLocalPrinter(i)
           End;
        End;

       'P': ListObjects(ot_PrintServer,'*');

       'L': ListObjects(ot_PrintQueue,'*');

       'D':
        Begin
         Write('Name der Queue: '); Readln(s1);
         Write('Welche Datei? : '); Readln(s2);
         If PrintToQueue(s1,s2) = cc_Success
          then Writeln('Datei erfolgreich in Queue gedruckt!')
          else Writeln('Druck nicht erfolgreich!')
        End
      End;

     WarteAufTaste
    End

 Until c0 = #27
End;

Procedure TestQueues;

 Procedure QueueJobs(QueueID: LongInt);
 Var
  ConnectInfo  : TConnectInfo;
  QueueJobList : TQueueJobList;
  QueueJobEntry: TQueueJobEntry;
  QueueStatus  : TQueueStatus;
  BinderyObject: TBinderyObject;
  OldServer    : Byte;
  s1,s2 : String;
  x,y: Byte;
  i: Word;
 Begin
  x:= WhereX;
  y:= WhereY;
  If ReadQueueCurrentStatus(QueueID,QueueStatus) = cc_Success
   then
    Begin
     If GetBinderyObject(QueueStatus.ServerList[1].ID,BinderyObject) = cc_Success
      then Write('Print-Server ',BinderyObject.bo_Name);

     OldServer:= GetConnectionID(ConnectInfo);   { Alte Verbindung sichern }

     Writeln;

     {
     For i:= 1 to 8 do
      Write(HexStr(QueueStatus.ServerList[i].ID,8)); Writeln;
     For i:= 1 to 8 do
      Write(QueueStatus.ServerList[i].ConnectNo:8); Writeln;
     }

     GetQueueJobList(QueueID,QueueJobList);

     If NetWareResult = cc_Success
      then
       Begin
        Writeln(QueueJobList[0]:3,' Jobs');
        For i:= 1 to 15 do
         If i <= QueueJobList[0]
          then
           Begin
            ReadQueueJobEntry(QueueID,QueueJobList[i],QueueJobEntry);

            If NetWareResult = cc_Success
             then
              With QueueJobEntry do
               Begin
                Move(JobFileName,s1[1],14);
                s1[0]:= #14;
                Move(TextJobDescr,s2[1],50);
                s2[0]:= #50;
                If QueueJobList[i] <> 0
                 then Writeln(i:2,' #',QueueJobList[i]:6,' ', s1,' ',s2)
                 else Writeln(' ':79)
               End
             else Writeln(' ':79)
           End
          else Writeln(' ':79)
       End
      else Writeln(NetWareErrMsg(NetWareResult));

     SetPreferredConnectionID(OldServer)
    End
   else Writeln('Queue nicht gefunden');

  GotoXY(x,y)
 End; { QueueJobs }

Var
 PQId: LongInt;
 PQName: String;
 c0,c1: Char;

Begin
 Repeat
  c0:=
   MenueAuswahl
    ('NetWare-Toolbox: Queuefunktionen',
     'I','ID einer Queue ermitteln',
     'J','Jobliste einer Queue ermitteln',
     ' ','',
     ' ','',
     ' ','',
     ' ','',
     ' ','',
     ' ','',
     ' ','',
     ' ','');

  If c0 <> #27
   then
    Begin
     Case c0 of

       'I':
        Begin
         Write('Name der Print-Queue: ');
         Readln(PQName);
         PQName:= UpCaseStr(PQName);
         Writeln;
         If GetQueueID(ot_PrintQueue,PQName,PQId)
          then Writeln('Die ID der Print-Queue ',PQName,' ist ',HexStr(PQId,8))
          else Writeln('Queue ',PQName,' nicht gefunden')
        End;

       'J':
        Begin
         Write('Name der Queue: ');
         Readln(PQName);
         PQName:= UpCaseStr(PQName);
         Writeln;
         Writeln('Drcken Sie Esc, um die Anzeige zu beenden');
         Writeln;
         c0:= #0;
         If GetQueueID(ot_PrintQueue,PQName,PQId)
          then
           Repeat
            QueueJobs(PQID);

            If Keypressed
             then c0:= ReadKey
             else Delay(500);
           Until c0 = #27
          else
           Writeln('Queue ',PQName,' nicht gefunden')
        End;

      End; { Case }
     WarteAufTaste
    End
 Until c0 = #27
End;

Procedure TestWorkstationFunctions;

 Procedure ShowDrvTable;
 Var
  DrvConIDTable  : TDrvConnectIDTable;
  DrvHandleTable : TDrvHandleTable;
  DrvFlagTable   : TDrvFlagTable;
  ServerNameTable: TFSNameTable;
  i: Byte;
 Begin
  GetDrvConnectIDTable(DrvConIDTable);
  GetDrvHandleTable(DrvHandleTable);
  GetDrvFlagTable(DrvFlagTable);
  GetFileServerNameTable(ServerNameTable);

  Writeln('LW: ','Handle':7,'ID':5,' Description');
  For i:= 1 to 26 do
   Begin
    If i = 13 then Delay(1000);
    Writeln
     (' ',Char(i+64)+': ',
      DrvHandleTable[i]:7,
      DrvConIDTable[i]:5,' ',
      ServerNameTable[DrvConIDTable[i]],'/',DrvFlagStr(DrvFlagTable[i]));
   End
 End;

Var
 i,j: Word;
 Port,ConNo: Byte;
 c0,c1: Char;
 s1,s2,s3: String;
 FSNameTable: TFSNameTable;
 ConnectInfo: TConnectInfo;
Begin
 Repeat
  c0:=
   MenueAuswahl
    ('NetWare-Toolbox: Workstation Environment-Funktionen',
     'T', 'Tabelle der Daten der einzelnen Laufwerke',
     'N', 'Namen der verfgbaren Server, vorbesetze Verbindung',
     'A', 'Aktuellen Server wechseln',
     'V','VLM-Version prfen',
     ' ','',
     ' ','',
     ' ','',
     ' ','',
     ' ','',
     ' ','');

  If c0 <> #27
   then
    Begin
     Case c0 of

       'T':
        ShowDrvTable;

       'N':
        Begin
         j:= GetFileServerNameTable(FSNameTable);
         Writeln('Gefundene Server:');
         For i:= 1 to j do Writeln(i:2,' ',FSNameTable[i]);
         i:= GetConnectionID(ConnectInfo);
         Writeln;
         Writeln('Aktueller Server ist (',i,') : ',FSNameTable[i]);
         i:= GetDefaultConnectionID;
         Writeln('Default Server ist   (',i,') : ',FSNameTable[i]);
         i:= GetPrimaryConnectionID;
         Writeln('Primary Server ist   (',i,') : ',FSNameTable[i]);
         i:= GetPreferredConnectionID;
         Writeln('Preferred Server ist (',i,') : ',FSNameTable[i]);
        End;

       'A':
        Begin
         j:= GetFileServerNameTable(FSNameTable);
         Writeln('Gefundene Server:');
         For i:= 1 to j do Writeln(i:2,' ',FSNameTable[i]);
         i:= GetPreferredConnectionID;
         Writeln;
         Writeln('Aktueller Server ist (',i,') : ',FSNameTable[i]);
         If j = 1
          then Writeln('Es steht kein weiterer Server zur Verfgung')
          else
           Begin
            Writeln;
            Write('Auf welchen Server wechseln (1-',j,') : ');
            Readln(i);
            If (i < 1) or (i > j)
             then Writeln('Dieser Server steht nicht zur Verfgung')
             else
            If i = GetPreferredConnectionID
             then Writeln('Dieser Server war bereits der aktuelle')
             else
              Begin
               SetPreferredConnectionID(i);
               Writeln(FSNameTable[i],' ist neuer aktueller Server')
              End
           End
        End;

       'V':
        Begin
         If VLMInstalled(VLMFarCallPtr)
          then
           Begin
            Writeln('Novell''s VLM-Manager ist geladen, ',
                    'VLM-Version: '+GetVLMVersion);
            Writeln;
            Writeln('Programm arbeitet ber VLM-Schnittstelle')
           End
          else
           Begin
            Writeln('Novell''s VLM-Manager ist NICHT geladen');
            Writeln('Programm arbeitet mit NETX-Schnittstelle ber Interrupt 021h')
           End
        End;

      End;

     WarteAufTaste
    End

 Until c0 = #27;
End;

Procedure TestToolBox;
Var
 i,j: Word;
 n,m: Byte;
 c,c0,c1: Char;
 s1,s2,s3: String;
 ServerIdent: TServerIdent;
 WhoAmIArray: TWhoAmI;
 BinderyObject: TBinderyObject;
 GroupList: TGroupList;
 DrvMap: TDrvMap;
Begin
 Repeat
  c0:=
   MenueAuswahl
    ('Funktionen der NetWare Toolbox'^M^J+
     '(C) Copyright 1994 Alexander Schulze',
     'O','Objekt ber alle Server finden',
     'D','Drucken eines Files in eine beliebige Queue',
     'W','WhoAmI-Funktion',
     'G','GroupsImIn-Funktion',
     'M','Map-Funktion',
     'E','Einstellen eines neuen Mappings',
     ' ','',
     ' ','',
     ' ','',
     ' ','');

  If c0 <> #27
   then
    Begin
     Case c0 of

       'O':
        Begin
         Write('Objekt-Name (Wildcards * und ? erlaubt): ');
         Readln(s1);
         Writeln;
         If SearchObjAllServers
          (ot_Wild,UpCaseStr(s1),
           ServerIdent,BinderyObject)
          then
           Begin
            Writeln('Folgendes Objekt wurde gefunden:');
            Writeln;
            PrintBinderyObject(BinderyObject,true);
            Writeln;
            With ServerIdent do
             Writeln('Server: '+ServerName+', Server-ID: ',ConnectionID)
           End
           else Writeln('Kein bereinstimmendes Objekt gefunden')
        End;

       'D':
        Begin
         Write('Name der Queue: '); Readln(s1);
         Write('Welche Datei? : '); Readln(s2);
         If PrintToQueue(s1,s2) = cc_Success
          then Writeln('Datei erfolgreich in Queue gedruckt!')
          else Writeln('Druck nicht erfolgreich!')
        End;

       'W':
        Begin
         n:= WhoAmI(WhoAmIArray);
         For i:= 1 to n do
          With WhoAmIArray[i] do
           Writeln('Sie sind Benutzer ',UserName,' ',
                   'am Server ',ServerName,', ',
                   'Verbindungs-Nr. ',ConnectionNo)
        End;

       'G':
        Begin
         Write('Servername : '); Readln(s1);
         Write('Benutzer   : '); Readln(s2);
         n:= GroupsImIn(s1,s2,GroupList);
         Writeln;
         If n > 0                      { Gruppen gefunden? }
          then
           Begin
            Writeln('Sie sind Mitglied folgender Gruppen:');
            Writeln;
            For i:= 1 to n do
             With GroupList[i] do Writeln('Gruppe ',GroupName)
           End
          else
           Writeln('Keine Gruppenzuordnung gefunden')
        End;

       'M':
        Begin
         GetDrvMap(DrvMap);
         For i:= 1 to 26 do
          With DrvMap[i] do
           Case DrvFlag of
             df_notAllocated : ;
             df_localDrv   :
              Writeln
               (Char(i+64),': ',
                DrvFlagStr(DrvFlag))
             else
              Writeln
               (Char(i+64),': ',Path,' ',
                DrvFlagStr(DrvFlag))
            End
        End;

       'E':
        Begin
         Write('Laufwerk   : '); c:= UpCase(ReadKey); Writeln(c,':');
         If (c >= 'A') and (c <= 'Z')
          then
           Begin
            Write('Server-Pfad: '); Readln(s1);

            If SetDrvMapping(Byte(c)-64,s1) = cc_Success
             then Writeln('Laufwerk ',c,': konnte erfolgreich auf ',s1,' gemapped werden')
             else Writeln('Mapping nicht erfolgreich.')
           End
        End

      End;

     WarteAufTaste
    End

 Until c0 = #27;
End;

Procedure Test;
Var
 c0: Char;
Begin
 Repeat
  c0:=
   MenueAuswahl
    ('Testprogramm fr NetWare-Toolbox'^M^J'(C) Copyright 1994 Alexander Schulze',
     'C','Connections, Verbindungs-Funktionen',
     'F','Fileserver-Funktionen',
     'Q','Queue-Funktionen',
     'M','Messages, Mail-Funktionen',
     'P','Printer, Druck-Funktionen',
     'W','Workstation-Funktionen',
     'T','Toolbox (Borland-/Turbo-Pascal)',
     ' ','',
     ' ','',
     ' ','');

  If c0 <> #27
   then
    Case c0 of

      'M': TestMessages;

      'C': TestConnections;

      'P': TestPrintFunctions;

      'Q': TestQueues;

      'W': TestWorkstationFunctions;

      'F': TestFileserver;

      'T': TestToolbox;

     End
 Until c0 = #27
End;

Begin
 Test
End.