Unit NWHilf;

{ Hilfsroutinen zur Arbeit mit den NetWare-Funktionen
  (C) Copyright 1994 Alexander Schulze }

Interface

Function  PStr(Var p): String;
Function  LongSwap(Var l: LongInt): LongInt;
Function  NrToStr(Zahl: LongInt; Len: Byte): String;
Function  LStr(s: String; Len: Byte): String;
Function  HexStr(Value: LongInt; Len: Byte): String;
Function  UpCaseStr(s: String): String;

Implementation

{ Umwandlung eines Null-terminierten ASCIIZ-Strings in Pascal-String }
Function PStr(Var p): String;
Var
 s: String;
 i: Byte;
Begin
 Move(p,s[1],255);
 i:= 1;
 While (i <= 255) and (s[i] <> #0) do Inc(i);
 s[0]:= Char(Pred(i));
 PStr:= s
End;

{ Kehrt die Byte-Reihenfolge einer 32bit-LongIntZahl im Intel-LSB-MSB-
  Format ins NetWare-MSB-LSB-Format um }
Function LongSwap(Var l: LongInt): LongInt;
Begin
 l:= (l and $000000FF) shl 24 or
     (l and $0000FF00) shl  8 or
     (l and $00FF0000) shr  8 or
     (l and $FF000000) shr 24;
 LongSwap:= l
End;

{ Wandelt eine Zahl mit Len Stellen in einen String um. Diese Funktion
  wird hauptschlich fr eine einfache formatierte Zeichenausgabe bentigt }
Function NrToStr(Zahl: LongInt; Len: Byte): String;
Var
 s: String;
Begin
 Str(Zahl:Len,s);
 NrToStr:= s
End;

{ formatiert einen String linksbndig auf eine eingebbare Lnge }
Function LStr(s: String; Len: Byte): String;
Var
 t: String;
Begin
 FillChar(t[1],Pred(SizeOf(t)),' ');
 t[0]:= Char(Len);
 If Length(s) < Len then Len:= Length(s);
 Move(s[1],t[1],Len);
 LStr:= t
End;

{ gibt den Hex-Wert einer Zahl als String mit einstellbarer Lnge zurck }
Function HexStr(Value: LongInt; Len: Byte): String;
Var
 i,j: Byte;
 s: String[8];
Begin
 s:= '';
 For i:= 1 to Len do
  Begin
   j:= Value and $0F;
   If j < 10
    then s:= Char(j+48) + s
    else s:= Char(j+55) + s;
   Value := Value shr 4
  End;
 HexStr:= s
End;

{ Wandelt alle Zeichen eines Strings in Grobuchstaben um }
Function UpCaseStr(s: String): String;
Var
 i : Byte;
Begin
 For i:= 1 to Length(s) do s[i]:= UpCase(s[i]);
 UpCaseStr:= s
End;

End.