Unit NWToolB;

{ NetWare-Toolbox
  (C) Copyright 1994 Alexander Schulze }

Interface

Uses
 Dos,
 NWHilf, NWBasic, NWDos;

Const
 MaxGroups = 32;

Type
 TDrvMap =
  Array[1..26] of
   Record
    Path     : String;
    ServerID : Byte;
    DrvFlag  : Byte
   End;

 TGroupList =
  Array[1..MaxGroups] of
   Record
    GroupName: TObjNameStr;
    GroupID  : LongInt;
   End;

 TServerIdent =
  Record
   ConnectionID: Byte;
   ServerName  : TFSNameStr;
  End;

 TWhoAmI =
  Array[1..8] of
   Record
    ServerName  : TFSNameStr;
    UserName    : TObjNameStr;
    ConnectionNo: Byte;
   End;

Procedure PrintBinderyObject
           (Var BinderyObject: TBinderyObject;
            InclProperties: Boolean);

Procedure ListObjects
           (ObjType: Word;
            Mask: TStr80);

Function  UserLogIn
           (ServerName,UserName,Password: TStr80): Byte;

Procedure QSplit
           (QueuePath: TQueuePath;
            Var ServerName: TFSNameStr;
            Var QueueName: TQueueStr);

Function  SearchObjServer
           (ConnectID: Byte;
            Typ: Word;
            Name: TObjNameStr;
            Var BinderyObject: TBinderyObject): Boolean;

Function  SearchObjAllServers
           (Typ: Word;
            Name: TObjNameStr;
            Var ServerIdent: TServerIdent;
            Var BinderyObject: TBinderyObject): Boolean;

Function  ServerExist
           (ServerName: TFSNameStr;
            Var ConnectID: Byte): Boolean;

Function  SetLPTQueue
           (LPTDevice: Byte;
            QueuePath: TQueuePath): Byte;

Function  GetLPTQueue
           (LPTDevice: Byte;
            Var QueuePath: TQueuePath): Byte;

Function  PrintToQueue
           (QueuePath: TQueuePath;
            FileName: PathStr): Byte;

Function  WhoAmI
           (Var WhoAmIArray: TWhoAmI): Byte;

Function  GroupsImIn
           (ServerName,UserName: TObjNameStr;
            Var GroupList: TGroupList): Byte;

Procedure NetFSplit
           (Path: String;
            Var Server: TFSNameStr;
            Var Volume: TVolumeStr;
            Var Dir   : DirStr;
            Var Name  : NameStr;
            Var Ext   : ExtStr);

Function  GetDrvMap
           (Var DrvMap: TDrvMap): Boolean;

Function  SetDrvMapping
           (DrvNo: Byte;
            Var Path: PathStr): Byte;

Function  DeleteDrvMapping
           (DrvNo: Byte): Byte;

Implementation

{ Ausgabe eines Bindery-Objektes auf dem Bildschirm }
Procedure
 PrintBinderyObject
  (Var BinderyObject: TBinderyObject;
   InclProperties: Boolean);

 Function XedStr(s: String): String;
 Var
  i: Byte;
 Begin
  For i:= 1 to Length(s) do
   If s[i] < #32 then s[i]:= '';
   XedStr:= s
 End;

Var
 Ok1,Ok2: Boolean;
 Content: String;
 i: Byte;
 Property: TProperty;
Begin
 With BinderyObject do
  Begin
   Writeln(LStr(bo_Name,21),
           LStr(ObjTypeStr(bo_Typ),12),
           ' ID ',HexStr(LongSwap(bo_ID),8),
           ' Flag ',HexStr(bo_Flag,2),
           ' Sec ',HexStr(bo_Security,2),
           ' Prop ',HexStr(bo_HasProp,2));

   If InclProperties and (bo_HasProp <> 0)
    then
     Begin
      Writeln(' Properties:');
      Ok1:= ScanPropertyFirst(BinderyObject,Property,'*');
      While Ok1 do
       Begin
        Writeln('  ',Property.Name);
        { falls noch Information zu den Values angezeigt werden sollen:
        Ok2:= ReadPropertyValueFirst(BinderyObject,Property,Content);
        While Ok2 do
         Begin
          Writeln('   '+XedStr(Content));
          For i:= 1 to 127 do Write(HexStr(Byte(Content[i]),2));
          Writeln;
          Ok2:= ReadPropertyValueNext(BinderyObject,Property,Content);
         End;
        }
        Ok1:= ScanPropertyNext(BinderyObject,Property,'*');
       End
     End
  End
End;

{ Listet alle Objekte eines Typs auf, die der Maske entsprechen }
Procedure ListObjects(ObjType: Word; Mask: TStr80);
Var
 BinderyObject: TBinderyObject;
 Ok: Boolean;
Begin
 Ok:= ScanBinderyObjectFirst(BinderyObject,ObjType,Mask);
 While Ok do
  Begin
   PrintBinderyObject(BinderyObject,false);
   Ok:= ScanBinderyObjectNext(BinderyObject,ObjType,Mask)
  End
End;

{ Rahmenfunktion zum Einloggen eines Benutzers an beliebigen FileServer }
Function UserLogIn(ServerName,UserName,Password: TStr80): Byte;
Var
 BinderyObject: TBinderyObject;
Begin
 FillChar(BinderyObject, SizeOf(BinderyObject), 0);

 With BinderyObject do
  Begin
   bo_Typ     := ot_User;
   bo_Name    := UpCaseStr(UserName);
   bo_Password:= UpCaseStr(Password);

   UserLogIn  := LoginToFileServer(BinderyObject)
  End
End;

{ Aufsplitten eines Queue-Pfades in Server- und Queue-Name }
Procedure
 QSplit
  (QueuePath: TQueuePath;
   Var ServerName: TFSNameStr;
   Var QueueName: TQueueStr);
Var
 i: Byte;
Begin
 QueuePath:= UpCaseStr(QueuePath);
 i:= Pos('/',QueuePath);               { Server mit im Queue-Pfad ? }
 If i > 0
  then
   Begin
    ServerName:=                       { dann Server-Namen separieren }
     Copy(QueuePath,1,Pred(i));
    QueueName:=
     Copy(QueuePath,Succ(i),
          Length(QueuePath)-i)
   End
  else
   Begin
    ServerName:= '';                   { sonst Server-Namen leer lassen }
    QueueName:= QueuePath              { QueueName ist dann kompl,. Pfad }
   End
End;

Function
 SearchObjServer
  (ConnectID: Byte; Typ: Word; Name: TObjNameStr;
   Var BinderyObject: TBinderyObject): Boolean;
Var
 bk_Server: Byte;
 ConInfo  : TConnectInfo;
 Change   : Boolean;
Begin
 bk_Server:= GetPreferredConnectionID; { aktuellen Server ermitteln }
 Change:= bk_Server <> ConnectID;      { mu Server gewechselt werden ? }
 If Change
  then
   SetPreferredConnectionID(ConnectID);{ auf neuen Server wechseln }
 SearchObjServer:=
  ScanBinderyObjectFirst               { Object hier suchen }
   (BinderyObject,Typ,Name);           { und Ergebnis zurckliefern }
 If Change
  then
   SetPreferredConnectionID(bk_Server);{ wieder auf alten Server zurck }
End;

{ Diese Funktion durchsucht alle verfgbaren Server nach dem durch Typ und
  Name bezeichneten Objekts. Es wird zunchst der aktuelle Server, dann die
  weiteren Server durchsucht. Sollte ein Objekt gleichen Typs und Namens auf
  mehreren Servern vorhanden sein, wird nur das erste in der Reihenfolge
  gefunden }
Function
 SearchObjAllServers
  (Typ: Word; Name: TObjNameStr;
   Var ServerIdent: TServerIdent;
   Var BinderyObject: TBinderyObject): Boolean;
Var
 Ok       : Boolean;
 AnzServer: Byte;
 AktServer: Byte;
 FoundOn  : Byte;
 FSNameTab: TFSNameTable;
Begin
 AnzServer:=                           { Anzahl der verfgbaren Server }
  GetFileServerNameTable(FSNameTab);   { und deren Namen holen }
 AktServer:= GetPreferredConnectionID; { zunchst aktuellen durchsuchen }
 Ok:= SearchObjServer(AktServer,Typ,Name,BinderyObject);
 If Ok
  then FoundOn:= AktServer
  else
   Begin
    FoundOn:= 1;
    Repeat
     If FoundOn <> AktServer
      then Ok:= SearchObjServer(FoundOn,Typ,Name,BinderyObject);
     If not Ok then Inc(FoundOn)
    Until Ok or (FoundOn > AnzServer)
   End;

 SearchObjAllServers:= Ok;

 If Ok
  then
   With ServerIdent do
    Begin
     ConnectionID:= FoundOn;
     ServerName  := FSNameTab[FoundOn]
    End
End;

Function ServerExist(ServerName: TFSNameStr; Var ConnectID: Byte): Boolean;
Var
 FSNameTable: TFSNameTable;
 Ok : Boolean;
 i,j: Byte;
Begin
 j:= GetFileServerNameTable(FSNameTable);
 i:= 1;
 Repeat
  Ok:= FSNameTable[i] = ServerName;
  If Ok then ConnectID:= i;
  Inc(i)
 Until Ok or (i > j);
 ServerExist:= Ok
End;

Procedure InitCaptureFlags(Var CaptureFlags: TCaptureFlags);
Begin
 FillChar(CaptureFlags,SizeOf(CaptureFlags),0);
 With CaptureFlags do
  Begin
   Status         := 0;                { Print Jobs enabled }
   Flags          := cpf_Standard;     { Standard-Flags }
   TabSize        := 8;                { Standard-Tab Size 8 Zeichen }
   ServerPrinter  := 0;                { Default Printer }
   NumberOfCopies := 1;                { nur 1 Original Ausdruck }
   FormType       := 0;                { Default }
   reserved_01    := 0;                { wird nicht bentigt }
   BannerText     := 'NoBannerSpec.';  { wird nicht bentigt }
   reserved_02    := 0;                { wird nicht bentigt }

(*
   LocalLPTDevice :=
   FlushTimeOut   :=
   FlushOnDevClose:=
   MaxLines       :=
   MaxColumns     :=
   FormName       :=
   LPTCaptureFlag :=
   FileCaptureFlag:=
   TimingOutFlag  :=
   PPrinterSetup  :=
   PPrinterReset  :=
   ConnectID      :=
   CaptureInProgr :=
   PrintQueueFlag :=
   PrintJobValid  :=
   PrintQueueID   :=
   PrintJobNo     :=
*)
  End
End;

{ Setzt das Capture eines LPT-Ports auf die angegebene Queue }
Function
 SetLPTQueue
  (LPTDevice: Byte;
   QueuePath: TQueuePath): Byte;
Var
 BinderyObject: TBinderyObject;
 ServerIdent  : TServerIdent;
 ServerName   : TFSNameStr;
 QueueName    : TQueueStr;
 ServerID     : Byte;
 bk_Server    : Byte;
 bk_Printer   : Byte;
 cc           : Word;
Begin
 bk_Printer:= GetDefaultLocalPrinter;  { bisherigen akt. Printer sichern }
 SetDefaultLocalPrinter(LPTDevice);    { auf neuen Port wechseln }
 FlushLPTCapture;                      { eventuelle Spooldaten ausdrucken }
 EndLPTCapture;                        { und aktuelles Capture dort beenden }

 bk_Server:= GetPreferredConnectionID; { aktuellen Server sichern }
 cc:= cc_Success;                      { Erfolg wird erstmal vorausgesetzt }

 With ServerIdent do
  Begin
   QSplit(QueuePath,ServerName,QueueName);
   If ServerName = ''                  { kein Server-Name angegeben ? }
    then
     If SearchObjAllServers            { dann alle Server durchsuchen }
         (ot_PrintQueue,QueueName,
          ServerIdent,BinderyObject)
      then
       SetPreferredConnectionID        { falls Objekt gefunden, dann }
        (ServerIdent.ConnectionID)     { auf diesen Server wechseln }
      else
       cc:= $FF                        { Requested Object Failure }
    else                               { konkreter Server angegeben }
     If ServerExist                    { existiert dieser ? }
         (ServerName,ServerID) and     { Verbindungs-Nummer holen }
        SearchObjServer                { Objekt in der Bindery suchen }
         (ServerID,ot_PrintQueue,
          QueueName,BinderyObject)     { und Server wechseln }
      then                             { falls dort gefunden }
       SetPreferredConnectionID(ServerID)
      else
       cc:= $FF                        { sonst Fehler zurckliefern }
  End;

 If cc = cc_Success                    { Falls Objekt gefunden und Server }
  then                                 { ggfs. gewechselt }
   Begin
    cc:= SetCapturePrintQueue          { neu Setzen der Queue anhand der ID }
          (LPTDevice,BinderyObject.bo_ID);
    If cc = cc_Success                 { Falls alles O.K. dann }
     then StartLPTCapture              { Umlenkung gleich aktivieren }
     else EndLPTCapture                { sonst sicherheitshalber abschalten }
   End;

 SetPreferredConnectionID(bk_Server);  { aktuellen Server wieder herstellen }
 SetDefaultLocalPrinter(bk_Printer);   { alten aktuellen lokalen Port }
 SetLPTQueue:= cc                      { Ergebnis bertragen }
End;

{ Holt den Namen der Queue des angegebenen LPT-Ports
  ConnectID, falls alles O.K., 0, falls kein Capture aktiv oder Fehler }
Function GetLPTQueue(LPTDevice: Byte; Var QueuePath: TQueuePath): Byte;
Var
 BinderyObject: TBinderyObject;
 CaptureFlags : TCaptureFlags;
 ConnectInfo  : TConnectInfo;
 bk_Server    : Byte;
 bk_Printer   : Byte;
 Ok           : Boolean;
Begin
 GetLPTQueue:= 0;                      { Initialisieren des Ergebnisses }
 QueuePath  := '';                     { Erstmal keine Queue gefunden }
 bk_Printer := GetDefaultLocalPrinter; { vorherigen akt. Printer sichern }
 bk_Server  := GetConnectionID(ConnectInfo);
                                       { aktuelle Server-Verbindung sichern }
 Ok:= SetDefaultLocalPrinter(LPTDevice) = cc_Success;
 If Ok                                 { aktuellen Printer neu setzen }
  then
   Begin
    Ok:= GetDefaultCaptureFlags(CaptureFlags) = cc_Success;
    If Ok
     then
      With CaptureFlags do
       Begin
        SetPreferredConnectionID(ConnectID);
        If GetBinderyObject(PrintQueueID,BinderyObject) = cc_Success
         then
          Begin
           QueuePath:=
            GetFileServerName(ConnectID) + '/' +
            BinderyObject.bo_name;
           GetLPTQueue:= ConnectID
          End
       End
   End;

 SetDefaultLocalPrinter(bk_Printer);
 SetPreferredConnectionID(bk_Server)
End;

{ Drucken einer beliebigen Datei in eine beliebige Queue
  In Multi-Server-Umgebungen wird automatisch zunchst der aktuelle
  dann alle weiteren Server nach der Queue abgesucht,
  Es wird immer ber LPT1 gedruckt. Ein evtl. bereits bestehendes
  Capture wird am Ende wieder rekonstruiert }
Function PrintToQueue(QueuePath: TQueuePath; FileName: PathStr): Byte;
Const
 XfrSize   = 1024;
Var
 Regs      : Registers;
 ConID     : Byte;
 Count     : Word;
 i         : Word;
 pf        : File;                     { Print-File }
 XfrPuffer : Array[1..XfrSize] of Char;{ Puffer fr Blocklesen der Druckdatei }
 ServerName: TFSNameStr;               { Zum Splitten des Queue-Namens }

 bk_Printer   : Byte;                  { vorheriger aktueller Drucker }
 bk_Server    : Byte;                  { vorheriger aktueller Server }
 bk_Capture   : Byte;                  { vorheriger Capture-Status }
 bk_Queue     : TQueueStr;             { vorherige Queue }
 bk_CaptFlags : TCaptureFlags;         { vorherige Capture-Flags }

 CaptureFlags : TCaptureFlags;         { hier verwendete neue Capture-Flags }
 ServerIdent  : TServerIdent;          { Server, am die Queue gef. wurde }
 BinderyObject: TBinderyObject;        { um die Bindery zu druchsuchen }

Begin
 PrintToQueue:= $FF;                   { Funktionsergebnis: allg. Fehler }

 QSplit(QueuePath,ServerName,QueuePath);

 If (ServerName <> '') and             { Servername angegeben ? }
    not ServerExist(ServerName,ConID)  { und existtier auch? }
  then                                 { falls nicht, mit Fehler beenden }
   Begin
    PrintToQueue:= $FC;                { Fehler: unknown FileServer }
    Exit                               { und Routine verlassen }
   End;

 If not SearchObjAllServers            { Binderies aller Server nach Queue }
         (ot_PrintQueue,QueuePath,     { absuchen und Routine verlassen, }
          ServerIdent,BinderyObject)   { falls nicht gefunden }
  then Exit;

 Assign(pf,FileName);
 If NetReset                           { Druckdatei ffnen, alles O.K. ? }
     (pf,1,am_ReadOnly,sm_DenyWrite) <> cc_Success
  then Exit;                           { Fehler bei Datei, dann raus }

 bk_Server:= GetPreferredConnectionID; { aktuellen Server sichern }
 bk_Printer:= GetDefaultLocalPrinter;  { aktuellen Drucker sichern }

 SetDefaultLocalPrinter(pn_LPT1);      { hier wird ber LPT1 gedruckt }

 bk_Capture:=
  GetLPTQueue(pn_LPT1,bk_Queue);

 If bk_Capture > 0                     { falls schon ein Capture bestand }
  then
   Begin
    FlushLPTCapture;                   { Alle Daten im Spooler drucken und  }
    GetDefaultCaptureFlags(bk_CaptFlags);
    EndLPTCapture                      { dieses Capture beenden }
   End;

 SetPreferredConnectionID(ConID);      { wir mssen auf den richtigen Server }
 StartLPTCapture;                      { um den Capture dort zu aktivieren }
 SetCapturePrintQueue                  { und die richtige Queue zu setzen }
  (pn_LPT1,BinderyObject.bo_ID);

 InitCaptureFlags(CaptureFlags);       { Initialisieren und Setzen der }
 SetDefaultCaptureFlags(CaptureFlags); { gewnschten neuen Capture-Flags }

 Repeat                                { Schleife fr Lesen aller Zeichen }
  NetWareResult:=
   NetRead(pf,XfrPuffer,XfrSize,Count);{ Zeichen aus Datei in Puffer lesen }
  If NetWareResult = cc_Success
   then
    For i:= 1 to Count do              { Schleife fr alle gelesenen Zeichen }
     With Regs do
      Begin
       ah:= $00;                       { 00h = Funktions-Nr. Zeichen drucken }
       al:= Byte(XfrPuffer[i]);        { Dieses Zeichen mu gedruckt werden }
       dx:= pn_LPT1;                   { Hier nur ber LPT1 drucken }
       Intr($17,Regs)                  { Zeichen drucken }
      End
 Until (Count < XfrSize) or
       (NetWareResult <> cc_Success);

 FlushLPTCapture;                      { Spooler leeren und Datei drucken }

 If bk_Capture > 0                     { Bestand vorher ein Capture ? }
  then                                 { dann altes Capture wiederherstellen }
   SetDefaultCaptureFlags(bk_CaptFlags)
  else                                 { sonst Capture deaktivieren }
   EndLPTCapture;

 SetPreferredConnectionID(bk_Server);  { alten akt. Server wiederherst. }
 SetDefaultLocalPrinter(bk_Printer);   { alten akt. Drucker wiederherst. }
 NetClose(pf);                         { Druck-Datei schlieen }
 PrintToQueue:= cc_Success             { Funktionsergebnis: alles O.K. }
End;

{ WhoAmI liefert Server- und Benutzernamen der aufrufenden Station an
  allen Servern, zu denen Verbidnung besteht.
  Ergebnis ist die Anzahl der Eintrge }
Function WhoAmI(Var WhoAmIArray: TWhoAmI): Byte;
Var
 Ok           : Boolean;
 ConCount     : Byte;
 bk_Server    : Byte;
 ConNo        : Byte;
 i,AnzServer  : Byte;
 BinderyObject: TBinderyObject;
 FSNameTable  : TFSNameTable;
Begin
 bk_Server:= GetPreferredConnectionID;
 ConCount:= 0;
 AnzServer:= GetFileServerNameTable(FSNameTable);
 For i:= 1 to AnzServer do
  Begin
   SetPreferredConnectionID(i);
   ConNo:= GetConnectionNo;
   GetConnectionInfo(ConNo,BinderyObject);
   Inc(ConCount);
   With WhoAmIArray[ConCount] do
    Begin
     ServerName  := FSNameTable[i];
     UserName    := BinderyObject.bo_Name;
     ConnectionNo:= ConNo
    End
  End;
 SetPreferredConnectionID(bk_Server);
 WhoAmI:= ConCount
End;

{ Ermittlung der Gruppen denen ein Benutzer an einem bestimmten
  Server zugeordnet ist. Wird der Server nicht angegeben, so wird der
  aktuelle durchsucht }
Function
 GroupsImIn
  (ServerName,UserName: TObjNameStr;
   Var GroupList: TGroupList): Byte;
Var
 GroupObject,
 BinderyObject: TBinderyObject;
 Property     : TProperty;
 GroupCount,i : Byte;
 Ok           : Boolean;
 ConnectID    : Byte;
 bk_Server    : Byte;
 ID           : LongInt;
 Value        : String;
Begin
 GroupCount:= 0;
 GroupsImIn:= 0;

 ServerName:= UpCaseStr(ServerName);
 UserName  := UpCaseStr(UserName);

 If UserName = '' then Exit;

 bk_Server:= GetPreferredConnectionID;
 If ServerName <> ''
  then
   If ServerExist(ServerName,ConnectID)
    then SetPreferredConnectionID(ConnectID)
    else Exit;

 If ScanBinderyObjectFirst             { User gefunden ? }
     (BinderyObject,ot_User,UserName) and
    ScanPropertyFirst                  { und Eigenschaften gefunden }
     (BinderyObject,Property,'GROUPS_I''M_IN') and
    Property.HasValue
  then
   Begin
    Ok:= ReadPropertyValueFirst(BinderyObject,Property,Value);
    While Ok and (GroupCount < MaxGroups) do
     Begin
      For i:= 1 to 16 do
       Begin
        Move(Value[Succ((i-1) shl 2)],ID,4);
        If ID <> 0
         then
          Begin
           Inc(GroupCount);
           With GroupList[GroupCount] do
            Begin
             GetBinderyObject(ID,GroupObject);
             GroupName:= GroupObject.bo_Name;
             GroupID:= ID
            End;
          End
       End;
      Ok:= ReadPropertyValueNext(BinderyObject,Property,Value)
     End
   End;

 SetPreferredConnectionID(bk_Server);
 GroupsImIn:= GroupCount;
End;

Procedure NetFSplit
 (Path: String;
  Var Server: TFSNameStr;
  Var Volume: TVolumeStr;
  Var Dir   : DirStr;
  Var Name  : NameStr;
  Var Ext   : ExtStr);
Var
 i: Byte;
 DosPath: PathStr;
Begin
 i:= Pos(':',Path);                    { ist Server/Volume angegeben? }
 If i > 1                              { falls ja ... }
  then
   Begin
    DosPath:=                          { DOS-Teil separieren }
     Copy(Path,Succ(i),Length(Path)-i);{ wird unten weiter aufgesplittet }
    Path:= Copy(Path,1,Pred(i));       { Server/Volume analysieren }
    i:= Pos('/',Path);
    If i > 0                           { Servernamen gefunden ? }
     then
      Begin
       Server:= Copy(Path,1,Pred(i));  { Variablen-Parameter zuordnen }
       Volume:= Copy(Path,Succ(i),Length(Path)-i)
      End
     else                              { ... sonst }
      Begin
       Server:= '';                    { Kein Servername angegeben }
       Volume:= Path                   { nur Volume }
      End
   End
  else                                 { kein Laufwerk oder Volume }
   Begin
    i:= Pos('/',Path);
    If i > 0                           { Servernamen gefunden ? }
     then
      Begin
       Server:= Copy(Path,1,Pred(i));  { Variablen-Parameter zuordnen }
       Volume:= Copy(Path,Succ(i),Length(Path)-i);
       DosPath:= ''
      End
     else                              { ... sonst }
      Begin
       Server:= '';                    { dann keine Server- und }
       Volume:= '';                    { keine Volume-Daten, also... }
       DosPath:= Path                  { gem DOS-Konvention splitten }
      End
   End;
 FSplit(DosPath,Dir,Name,Ext)          { DOS-Teil splitten }
End;

Function GetDrvMap(Var DrvMap: TDrvMap): Boolean;
Var
 FSNameTable: TFSNameTable;
 DrvConTable: TDrvConnectIDTable;
 i: Byte;
 DirHandle: Byte;
 bk_Server: Byte;
 Server: TFSNameStr;
 Volume: TVolumeStr;
 Dir   : DirStr;
 Name  : NameStr;
 Ext   : ExtStr;
Begin
 FillChar(DrvMap,SizeOf(DrvMap),0);
 GetFileServerNameTable(FSNameTable);
 GetDrvConnectIDTable(DrvConTable);
 bk_Server:= GetPreferredConnectionID;

 For i:= 1 to 26 do
  With DrvMap[i] do
   Begin
    ServerID:= DrvConTable[i];
    SetPreferredConnectionID(ServerID);

    DirHandle:= GetDirectoryHandle(i,DrvFlag);
    If (DrvFlag <> df_notAllocated) and
       (DrvFlag <> df_LocalDrv)
     then
      Path:=
       FSNameTable[ServerID] + '/' +
       GetDirectoryPath(DirHandle)
   End;

 If bk_Server > 0                      { falls Server-Verbindung gendert }
  then
   SetPreferredConnectionID(bk_Server) { dann hier wiederherstellen }
End;

Function SetDrvMapping(DrvNo: Byte; Var Path: PathStr): Byte;
Var
 DrvFlags,
 DirHandle: Byte;
 bk_Server: Byte;
 ConID : Byte;
 Server: TFSNameStr;
 Volume: TVolumeStr;
 Dir   : DirStr;
 Name  : NameStr;
 Ext   : ExtStr;
Begin
 SetDrvMapping:= $FF; { allg. Fehlercode }

 DirHandle:=
  GetDirectoryHandle(DrvNo,DrvFlags);

 Path:= UpCaseStr(Path);
 NetFSplit(Path,Server,Volume,Dir,Name,Ext);

 If Server = ''                        { Ist ein Server angegeben? }
  then bk_Server:= 0                   { falls nicht, keine nderung }
  else                                 { sonst ... }
   Begin
    If not ServerExist(Server,ConID)   { gibt's diesen Server? }
     then Exit;                        { falls nicht, dann raus hier }
    If DirHandle <> 0                  { war das Laufwerk zuvor gemapped ? }
     then DeallocateDirectoryHandle(DirHandle); { ...dann freigeben }

    bk_Server:=                        { bestehende Server-Verbindung }
     GetPreferredConnectionID;         { sichern }
    SetPreferredConnectionID(ConID);   { und auf neuen Server-Wechseln }

    DirHandle:=
     GetDirectoryHandle(DrvNo,DrvFlags);
    If DirHandle <> 0
     then DeallocateDirectoryHandle(DirHandle)
   End;

 SetDrvMapping:=
  AllocPermanentDirectoryHandle
   (Char(DrvNo+64),DirHandle,Volume+':'+Dir+Name+Ext);
 Path:= Server+'/'+Volume+':'+Dir+Name+Ext;

 If bk_Server > 0                      { falls Server-Verbindung gendert }
  then SetPreferredConnectionID(bk_Server) { dann hier wiederherstellen }
End;


Function DeleteDrvMapping(DrvNo: Byte): Byte;
Var
 DrvConID,
 DrvFlags,
 bk_Server: Byte;
 DrvConTable: TDrvConnectIDTable;

Begin
 GetDrvConnectIDTable(DrvConTable);
 DrvConID:= DrvConTable[DrvNo];

 If DrvConID = 0                       { ist Laufwerk berhaupt gemapped? }
  then
   Begin
    DeleteDrvMapping:= $B0;          { lokales Laufwerk nicht gemapped }
    Exit
   End;

 bk_Server:= GetPreferredConnectionID;
 SetPreferredConnectionID(DrvConID);

 DeleteDrvMapping:=
  DeallocateDirectoryHandle
   (GetDirectoryHandle(DrvNo,DrvFlags));

 SetPreferredConnectionID(bk_Server)
End;

End.