/* lupe.c : Demo zum Umgang mit Bitmaps */

#define INCL_WIN
#define INCL_GPI
#define INCL_DOSPROCESS
#include <os2.h>

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "t.h"
#include "t_rsc.h"


#define SB_DEFAULT  0
#define SB_SHOT     1
#define SB_ZOOM     2
#define SB_ZOOMTWO  3
#define SB_ZOOMTHREE 4
#define SB_ZOOMFOUR 5

#define ID_MTIMER 1245



MainParamBlock Mpb = {0};
ULONG fState = SB_DEFAULT;



struct {
     RECTL rcl;     /* Lupenfenster in Window-Koords */
     SWP swp;
} Zoom;



/*--------------------------------------------------------------------------*/
/* Ablaufplan: Standardeinstieg bis zur Messageloop                         */
/* fState: Kontrolliert, welcher Modus gerade aktiv, fr Reaktion auf       */
/* Mausereignisse, die kontextsensitiv                                      */
/* WM_CREATE: Laden der Resourcen: Lupenmauszeiger, Standard-Bitmap aus .rc */
/*                                                                          */
/* Die Bitmaps werden nur als Handle gehalten und der MemDC nur bei Bedarf  */
/* erzeugt zusammen mit einem geeigneten PS                                 */
/* Die andere Variante ist zwar krzer, wenn MemDC und MemPS permanent, aber*/
/* diese zu Testzwecken implementiert                                       */
/*                                                                          */
/* IDM_LOAD : ldt Bitmap aus Datei, DC-Mem temporr, ersetzt die in Mpb.hbm*/
/*            gespeicherte Standardbitmap                                   */
/* IDM_SHOT : Erzeugt Bitmap fr Mpb.hbmShot, fllt mit Screenshot, Status  */
/*            Sorgt dafr, das MainPaint die neue anzeigt                   */
/* IDM_SAVE : Speichert die in Mpb.hbmShot liegende Bmp in eine Datei       */
/* Die IDM_LUPE bzw. ZOOM-Fktnen setzen Quell- und ZielPS und die Koords.   */
/*                               fr Transfer (Zoom-Struct), MOUSEMOVE      */
/* erledigt den entsprechenden BitBlt                                       */
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* ExitProc(), Funktion zum Aufrumen, die beim Abbruch ber die DOSEXITLIST*/
/* von OS/2 aufgerufen wird, so da man sich nicht bei jedem Ausgang extra  */
/* um das Aufrumen kmmern mu                                             */
/*--------------------------------------------------------------------------*/
VOID ExitProc(USHORT usTermCode)
{
  if (WinIsWindow(Mpb.hab, Mpb.hwndMainFrame))
    WinDestroyWindow(Mpb.hwndMainFrame);

  WinDestroyMsgQueue(Mpb.hmq);

  WinTerminate(Mpb.hab);

  DosExitList(EXLST_EXIT, (PFNEXITLIST)NULL);

}  /* End of ExitProc() */



/*------ Init() : for main Window creation ---------------------------*/
BOOL Init(VOID)
{
  if (DosExitList(EXLST_ADD, (PFNEXITLIST)ExitProc)) {
    MessageBox(HWND_DESKTOP,
	       IDMSG_CANNOTLOADEXITLIST,
	       MB_OK | MB_ERROR,
	       TRUE);
    DosExit(EXIT_PROCESS, RETURN_ERROR);
  }

  /*-------- load application name ----------------------------------------*/
  if (!WinLoadString(Mpb.hab,
		     (HMODULE)0,
		     IDS_APPNAME,
		     MAXNAMEL,
		     Mpb.szAppName))
    return(FALSE);

  /* Register Main Window Class */
  if (!WinRegisterClass(Mpb.hab,
			(PSZ)Mpb.szAppName,
			(PFNWP)MainWndProc,
			CS_CLIPCHILDREN | CS_SIZEREDRAW,
			0L)) {            /* no extra memory */
    return(FALSE);
  }

  return(TRUE);
}  /* Ende Init() */




/****************************************************************************/
/* main(): Einstiegspunkt,                                                  */
/*         Initialisiert PM, erzeugt Message Queue, ruft gpi.c:Init() auf   */
/*         fr weitere Initialisierung, erzeugt das einzige verwendete      */
/*         Fenster mitsamt dem Client-Area und verteilt die Ereignisse      */
/*         ber die Message-Loop                                            */
/*         Parameter: keine                                                 */
/*         Rckgabe: 0 bei Erfolg, sonst Fehlercode                         */
/****************************************************************************/
int main(VOID)                             /* keine Kommandozeilenparameter */
{
  ULONG flMainWinStyle = 0L;                         /* Flags fr Fenster-Layout */
  QMSG qmsg;                                               /* Message-Queue */


  if ((Mpb.hab = WinInitialize(0)) == NULLHANDLE)   {      /* PM-Initial. */
    DosBeep(BEEP_WARN_FREQ, BEEP_WARN_DUR);
    return(RETURN_ERROR);
  }

				         /* Message Queue  in Standardgre */
  if ((Mpb.hmq = WinCreateMsgQueue(Mpb.hab,0)) == NULLHANDLE) {
    DosBeep(BEEP_WARN_FREQ, BEEP_WARN_DUR);
    WinTerminate(Mpb.hab);
    return(RETURN_ERROR);
  }

  if (!Init()) {                              /* Andere Inits. */
    MessageBox(HWND_DESKTOP,                  /* Window handle of owner */
	       IDMSG_INITFAILED,              /* Index in RC-Messagetable */
	       MB_OK | MB_ERROR,              /* OK-Button, Stop-Sign */
	       TRUE);                         /* Alarmton ja nein ? */
    return(RETURN_ERROR);
  }


  /*------------ Ab jetzt Aufrumen ber ExitProc bei Prog.-Ende ---------*/

  flMainWinStyle = FCF_TITLEBAR | FCF_SYSMENU | FCF_SIZEBORDER |
                     FCF_MENU | FCF_TASKLIST | FCF_SHELLPOSITION ;

  /*------------- Hauptfenster erzeugen ------------------------------------*/
  Mpb.hwndMainFrame = WinCreateStdWindow(HWND_DESKTOP,       /*parent handle*/
					 WS_VISIBLE,         /* frame style */
					 &flMainWinStyle,     /* creat style*/
					 (PSZ)Mpb.szAppName,  /* Class name */
					 (PSZ)Mpb.szAppName,  /* title text */
					 WS_VISIBLE,         /* client style*/
					 (HMODULE) NULL,     /* res. in exe */
					 IDR_RESOURCE,               /* frame ID */
					 (PHWND) &Mpb.hwndMainClient);

  if(NULLHANDLE == Mpb.hwndMainFrame)   {
    MessageBox(HWND_DESKTOP,
	       IDMSG_MAINWINDOWCREATEFAILED,
	       MB_OK | MB_ERROR,
	       TRUE);
    return(RETURN_ERROR);
  }

  /*-------------------------- Message Loop ------------------------------*/
  /* kein Filter : Alle Messages, kein Bereich definiert                  */
  while(WinGetMsg(Mpb.hmq, (PQMSG) &qmsg, (HWND)NULL,(ULONG)NULL,(ULONG)NULL))
    WinDispatchMsg(Mpb.hmq, (PQMSG) &qmsg);

  return(RETURN_SUCCESS);
}  /*---------------------------- Ende main() --------------------------*/


/* ---------------------- Messagebox() --------------------------------*/
/* gibt Fehlermeldung mit in Resourcen definiertem Text aus            */
/*---------------------------------------------------------------------*/

ULONG MessageBox(HWND hwndOwner, ULONG idMsg, ULONG fsStyle, BOOL fBeep)
{
  CHAR szText[MESSAGELEN];            /* MESSAGELEN definiert in PMWIN.h */

  if (!WinLoadMessage(Mpb.hab,            /* anchor block handle */
		      (HMODULE)NULL,     /* module handle, 0 = in .exe */
		      idMsg,             /* Resource-ID of message */
		      MESSAGELEN,        /* length of recieving buffer */
		      (PSZ)szText))      /* buffer that recieve message */
    {
      WinAlarm(HWND_DESKTOP, WA_ERROR);
      return MBID_ERROR;                 /* returnvalue von WinMessageBox */
    }

  if (fBeep)
    WinAlarm(HWND_DESKTOP, WA_ERROR);    /* einer von drei Alarmtnen */

  return(WinMessageBox(HWND_DESKTOP,     /* Parent */
		       hwndOwner,        /* Owner  */
		       szText,           /* Text in box */
		       (PSZ)NULL,        /* 'Error' as title */
		       0       ,   /*Box ID,passed to HK_HELP hook if WM_HELP*/
		       fsStyle));        /* Knpfe und Symboles der Msgbox */
}  /* End Messagebox */

void PrimMessageBox(char *text)
{
  WinMessageBox(HWND_DESKTOP,
		HWND_DESKTOP,
		text,
		(PSZ)NULL,
		0,
		MB_OK | MB_ERROR);
}
		


void ShowErrorMsg(char *text)
{
  PrimMessageBox(text);
  return;
}

HDC CreateMemDC(void)
{
  HDC hdcMem = NULLHANDLE;

  DEVOPENSTRUC dop = {NULL, "Display", NULL, NULL, NULL, NULL, NULL, NULL, NULL};

  hdcMem = DevOpenDC(Mpb.hab,
                         OD_MEMORY, "*", 4,
                         (PDEVOPENDATA)&dop,
                         NULLHANDLE);             /* Screen-kompatibel ist Standard */
 
  return hdcMem;
} /* endfunction */




/*-------------------------------------------------------------------------*/
/* Ldt eine Bitmapdatei, neues oder altes OS/2-Format bzw. Windows-Format */
/* auf Handle hbm in Mpb, ersetzt die vorher dort gespeicherte             */
/*-------------------------------------------------------------------------*/
BOOL LoadGFile(PSZ name)
{
   HFILE hf = NULLHANDLE;
   ULONG ulDummy, cScans, cScansRet, cbRead;
   APIRET rc;
   FILESTATUS fsts;
   PBYTE pFileBegin = NULL;
   PBITMAPFILEHEADER2 pbfh2;
   PBITMAPINFOHEADER2 pbmp2;
   BOOL bRes;
   HPS hps = NULLHANDLE;
   HDC hdc = NULLHANDLE;
   SIZEL sizl = {0,0};

   DosOpen(name, &hf, &ulDummy, 0, FILE_NORMAL, FILE_OPEN,
           OPEN_ACCESS_READONLY | OPEN_SHARE_DENYWRITE, NULL);

   do {
     rc = DosQueryFileInfo(hf, 1, &fsts, sizeof(fsts));     /* Gre  */
     if (rc)  break;
     rc = DosAllocMem((PPVOID) &pFileBegin,
                      (ULONG) fsts.cbFile,
                      (ULONG) PAG_READ | PAG_WRITE | PAG_COMMIT);
     if (rc) break;

     if (DosRead(hf, (PVOID)pFileBegin, fsts.cbFile, &cbRead))
        break;

     /* Testen auf Format des Files */

     pbfh2 = (PBITMAPFILEHEADER2) pFileBegin;
     pbmp2 = NULL;                                /* dient zur Kontrolle */

     switch(pbfh2->usType) {
        case BFT_BITMAPARRAY:     /* Array, Zeiger auf ersten Fileheader */
          pbfh2 = &(((PBITMAPARRAYFILEHEADER2) pFileBegin)->bfh2);
          pbmp2 = &pbfh2->bmp2;  /* Zeiger auf Infoheader */
          break;

        case BFT_BMAP:            /* Single BMP-Format */
          pbmp2 = &pbfh2->bmp2;
          break;

        default:
        case BFT_ICON:
        case BFT_POINTER:
        case BFT_COLORICON:
        case BFT_COLORPOINTER:
        break;
     } /* endswitch */

     if (pbmp2 == NULL)
        break;

     if (pbmp2->cbFix == sizeof(BITMAPINFOHEADER))
        cScans = (ULONG) ((PBITMAPINFOHEADER)pbmp2)->cy; /* alt */
     else
        cScans = pbmp2->cy;                              /* neu */

                                       /* jetzt Bitmap erzeugen */
     hdc = CreateMemDC();
     hps = GpiCreatePS(Mpb.hab, hdc, &sizl,
                       PU_PELS | GPIA_ASSOC | GPIT_MICRO);

     bRes = GpiDeleteBitmap(Mpb.hbm);           /* alte lschen */

     Mpb.hbm = GpiCreateBitmap(hps,
                               pbmp2,        /* Bitmap erzeugen */
                               0L,
                               NULL,NULL);

     if (!Mpb.hbm) {
        ShowErrorMsg("LoadBitmap CreateBitmap failed.");
        break;
     }

     GpiSetBitmap(hps, Mpb.hbm);               /* im PS auswhlen */

     cScansRet = GpiSetBitmapBits(hps,         /* Bilddaten rein  */
                                  0L,
                                  cScans,
                                  pFileBegin + pbfh2->offBits,
                                  (PBITMAPINFO2) pbmp2);

     GpiSetBitmap(hps, NULLHANDLE);            /* Bitmap trennen */
     GpiDestroyPS(hps);                        /* PS freigeben */
     DevCloseDC(hdc);
     DosFreeMem(pFileBegin);                   /* Speicher frei */
     DosClose(hf);                             /* File schliessen */
     return TRUE;
   } while (FALSE); /* enddo, mit break zur Fehlerbehandlung */

   if (hdc)
        DevCloseDC(hdc);
   if (hps)                               /* Aufrumen bei Fehler */
        GpiDestroyPS(hps);
   if (pFileBegin != NULL)
        DosFreeMem( pFileBegin);
   DosClose(hf);
   return FALSE;
}



/*--------------------------------------------------------------------------*/
/* Ldt bmp-Datei in hbm als neuen Standard                                 */
/*--------------------------------------------------------------------------*/
void LoadBitmapFromFile(void)
{
  FILEDLG fild;          /* Speicher fr File-Dialog-Struktur */
  HWND hwndDlg = NULLHANDLE;

    memset(&fild, 0, sizeof(FILEDLG));   /* Struktur Initialisieren */
    fild.cbSize = sizeof(FILEDLG);
    fild.fl = FDS_CENTER | FDS_OPEN_DIALOG;
    fild.pszTitle = "BMP load file dialog";
    strcpy(fild.szFullFile,"*.bmp");
    hwndDlg = WinFileDlg(HWND_DESKTOP, Mpb.hwndMainClient,&fild);

    if (hwndDlg && (fild.lReturn == DID_OK)) {
       LoadGFile(fild.szFullFile);            /* zugehriges File erzeugen */
       fState = SB_DEFAULT;
       WinInvalidateRect(Mpb.hwndMainClient,NULL,FALSE);
    }
} /* endfunction */



/*---------------------------------------------------------------------------*/
/* Speichert aktuellen Screenshot in BMP-Datei, neues OS/2-Format            */
/*---------------------------------------------------------------------------*/
void SaveShotToFile(void)
{
  HPS hps = NULLHANDLE;
  SIZEL sizl = {0,0};
  BITMAPFILEHEADER2 bmpfh2 = {0L};
  BITMAPINFOHEADER2 bmpih2 = {0L};
  PBITMAPINFOHEADER2 pbmpit;
  void *pbmpbits;
  unsigned long h,h2;
  LONG cScansRet = 0L;
  FILEDLG fild;          /* Speicher fr File-Dialog-Struktur */
  HWND hwndDlg = NULLHANDLE;
  FILE *fOut;
  HDC hdc = NULLHANDLE;

   if (fState != SB_SHOT)
     return;

   bmpih2.cbFix = sizeof(bmpih2);
   GpiQueryBitmapInfoHeader(Mpb.hbmShot, &bmpih2);             /* Info besorgen */

   h = bmpih2.cbFix + bmpih2.cPlanes                 /* Platzbedarf mit Farbtab */
       * (1 << bmpih2.cBitCount) * sizeof(RGB2) + 10;

   pbmpit = malloc(h);                                  /* Speicher reservieren */

   h2 = ((bmpih2.cBitCount * bmpih2.cx + 31)/32)
        * bmpih2.cPlanes * 4 * (bmpih2.cy+2);

   pbmpbits = malloc(h2);                         /* Hier fr eigentliches Bild */

   hdc = CreateMemDC();
   hps = GpiCreatePS(Mpb.hab, hdc, &sizl,
                      PU_PELS | GPIA_ASSOC | GPIT_MICRO);
   GpiSetBitmap(hps, Mpb.hbmShot);

   *(PBITMAPINFOHEADER2) pbmpit = bmpih2;

   cScansRet = GpiQueryBitmapBits(hps, 0L, bmpih2.cy, pbmpbits, (PBITMAPINFO2) pbmpit);

    memset(&fild, 0, sizeof(FILEDLG));   /* Struktur Initialisieren */
    fild.cbSize = sizeof(FILEDLG);
    fild.fl = FDS_CENTER | FDS_OPEN_DIALOG;
    fild.pszTitle = "BMP Save file dialog";
    strcpy(fild.szFullFile,"*.bmp");
    hwndDlg = WinFileDlg(HWND_DESKTOP, Mpb.hwndMainClient,&fild);

    if (hwndDlg && (fild.lReturn == DID_OK) && cScansRet != GPI_ALTERROR) {
       fOut = fopen(fild.szFullFile, "wb");
       bmpfh2.usType = BFT_BMAP;
       bmpfh2.cbSize = sizeof(bmpfh2);
       bmpfh2.offBits = sizeof(bmpfh2) - sizeof(bmpih2)+h;
       fwrite(&bmpfh2, 1,sizeof(bmpfh2) - sizeof(bmpih2), fOut);
       fwrite(pbmpit, 1, h, fOut);
       fwrite(pbmpbits,1,h2,fOut);
       fclose(fOut);
    }

   free(pbmpit);
   free(pbmpbits);
   GpiSetBitmap(hps, NULLHANDLE);
   GpiDestroyPS(hps);
   DevCloseDC(hdc);
}

/*--------------------------------------------------------------------------*/
VOID MainCommand(HWND hwnd, MPARAM mp1, MPARAM mp2)
{
  HPS hps = NULLHANDLE, hpsScreen = NULLHANDLE;
  HDC hdc = NULLHANDLE;
  SIZEL sizl = {0,0};
  LONG alData[2] = {0,0},
       alCaps[CAPS_VERTICAL_RESOLUTION+3] = {0,0};
  ULONG ulWidth = 0, ulHeight = 0;
  BITMAPINFOHEADER2 bmp = {0};
  POINTL aptl[4];
  BOOL bRes = FALSE;

  if (fState == SB_ZOOMFOUR) {              /* Nur Stop4 wenn Zoom4 aktiv !!*/
    if (SHORT1FROMMP(mp1) == IDM_ZOOM4STOP) {
      WinReleasePS(Mpb.hpsMem);
      WinReleasePS(Mpb.hpsWindow);
      fState = SB_DEFAULT;
      WinInvalidateRect(hwnd, NULL, FALSE);
    }
    else return;
  } /* endif */
  else {

  switch(SHORT1FROMMP(mp1))  {                        /* Welches Kommando ? */
  case IDM_LOAD:                     /* Bitmap aus Datei als neues Standard */
     LoadBitmapFromFile();
     break;

  case IDM_SHOT:
    hdc = CreateMemDC();
    hps = GpiCreatePS(Mpb.hab, hdc, &sizl,
                      PU_PELS | GPIA_ASSOC | GPIT_MICRO);
    GpiQueryDeviceBitmapFormats(hps, 2, alData);         /* Bitmap-Formate ? */
    DevQueryCaps(hdc,                             /* Screenkompatibel */
                 CAPS_FAMILY, CAPS_VERTICAL_RESOLUTION+2,
                 alCaps);
    bmp.cbFix = (ULONG) sizeof(BITMAPINFOHEADER2);
    bmp.cx = ulWidth = alCaps[CAPS_WIDTH];
    bmp.cy = ulHeight = alCaps[CAPS_HEIGHT];
    bmp.cPlanes = alData[0];
    bmp.cBitCount = alData[1];
    bmp.ulCompression = BCA_UNCOMP;
    bmp.cbImage = 0;
    bmp.cxResolution = alCaps[CAPS_HORIZONTAL_RESOLUTION];
    bmp.cyResolution = alCaps[CAPS_VERTICAL_RESOLUTION];
    bmp.cclrUsed = 0;      /* Default, alle benutzt */
    bmp.cclrImportant = 0;
    bmp.usUnits = BRU_METRIC;
    bmp.usReserved = 0;
    bmp.usRecording = BRA_BOTTOMUP;
    bmp.usRendering = BRH_NOTHALFTONED;
    bmp.cSize1 = 0;
    bmp.cSize2 = 0;
    bmp.ulColorEncoding = BCE_RGB;
    bmp.ulIdentifier = 0;

    bRes = GpiDeleteBitmap(Mpb.hbmShot); /* Beim ersten mal natrlich falsch */
    Mpb.hbmShot = GpiCreateBitmap( hps,  /* ohne Init */
                                  &bmp,
                                  0L, NULL, NULL);
    GpiSetBitmap(hps, Mpb.hbmShot);

    aptl[0].x = aptl[0].y = 0;
    aptl[1].x = ulWidth;
    aptl[1].y = ulHeight;
    aptl[2].x = aptl[2].y = 0;

    hpsScreen = WinGetScreenPS(HWND_DESKTOP);
    GpiBitBlt(hps, hpsScreen,
               3L, aptl, ROP_SRCCOPY, BBO_IGNORE);
               WinReleasePS(hps);
    WinReleasePS(hpsScreen);
    GpiSetBitmap(hps, NULLHANDLE);  /* Zurcksetzen */
    GpiDestroyPS(hps);
    DevCloseDC(hdc);
    fState = SB_SHOT;
    WinInvalidateRect(hwnd, NULL, FALSE);
  break;

  case IDM_SAVE:
     SaveShotToFile();
     break;


  case IDM_LUPE:  /* Mem -> Window */
    WinSendMsg(hwnd, WM_COMMAND, MPFROMSHORT(IDM_SHOT), (MPARAM) 0L); /* Shot !*/
    hdc = CreateMemDC();
    Mpb.hpsMem = GpiCreatePS(Mpb.hab, hdc, &sizl,               /* Quell PS Mem*/
                      PU_PELS | GPIA_ASSOC | GPIT_MICRO);
    Mpb.hpsWindow = WinGetPS(Mpb.hwndMainClient);                  /* Ziel PS  */
    GpiSetBitmap(Mpb.hpsMem, Mpb.hbmShot);
    fState = SB_ZOOM;
    WinSetCapture(HWND_DESKTOP,Mpb.hwndMainClient);  /* Maus blockiert fr andre */
    WinQueryWindowPos(Mpb.hwndMainFrame, &Zoom.swp);/* Pos Frame-Window im Screen*/
    break;

  case IDM_ZOOM2: /* Screen -> Window */
    Mpb.hpsMem = WinGetScreenPS(HWND_DESKTOP);
    Mpb.hpsWindow = WinGetPS(Mpb.hwndMainClient);
    fState = SB_ZOOMTWO;
    WinSetCapture(HWND_DESKTOP,Mpb.hwndMainClient);
    WinQueryWindowPos(Mpb.hwndMainFrame, &Zoom.swp);    /* Pos Frame-Window */
    break;

  case IDM_ZOOM3:  /* Screen -> Screen */
    Mpb.hpsWindow = Mpb.hpsMem = WinGetScreenPS(HWND_DESKTOP);
    fState = SB_ZOOMTHREE;
    WinSetCapture(HWND_DESKTOP,Mpb.hwndMainClient);
    WinQueryWindowPos(Mpb.hwndMainClient, &Zoom.swp);
    Zoom.rcl.xLeft += Zoom.swp.x;
    Zoom.rcl.xRight += Zoom.swp.x;
    Zoom.rcl.yBottom += Zoom.swp.y;
    Zoom.rcl.yTop += Zoom.swp.y;
    WinQueryWindowPos(Mpb.hwndMainFrame, &Zoom.swp);
    Zoom.rcl.xLeft += Zoom.swp.x;
    Zoom.rcl.xRight += Zoom.swp.x;
    Zoom.rcl.yBottom += Zoom.swp.y;
    Zoom.rcl.yTop += Zoom.swp.y;        /* Ziel in Screen-Koordinaten umrechnen */
    break;

  case IDM_ZOOM4:             /* andere blockieren aktiv die Eingabe (Capture)! */
    Mpb.hpsMem = WinGetScreenPS(HWND_DESKTOP);
    Mpb.hpsWindow = WinGetPS(Mpb.hwndMainClient);
    WinQueryWindowRect(Mpb.hwndMainClient, &Zoom.rcl);
    fState = SB_ZOOMFOUR;
    WinStartTimer(Mpb.hab, hwnd, ID_MTIMER, 100);
    break;

  } /* endelse */

  } /* endswitch */

} /* endfunction} */



/*-------------------------------------------------------------------------*/
/*Funktion MainWndProc(), Window-Procedure fr die Registrierte ClientClass*/
/*--------------------------------------------------------------------------*/
MRESULT EXPENTRY MainWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
  HPS hps = NULLHANDLE;
  HDC hdcMem = NULLHANDLE;
  SIZEL sizlPage = {0,0};
  BOOL bRet;
  RECTL rcl = {0};
  POINTL ptlMPos= {0,0}, aptl[4];
  BOOL bRes;
  HBITMAP rbm;


  switch (msg) {

  case WM_CREATE:
    Mpb.hptr = WinLoadPointer(HWND_DESKTOP,
                              0L, IDP_LUPE);          /* Lupen - Mauszeiger */

    hdcMem  = CreateMemDC();
    hps     = GpiCreatePS(Mpb.hab, hdcMem,
                          &sizlPage, 
                          PU_PELS | GPIA_ASSOC | GPIT_MICRO);
    Mpb.hbm  = GpiLoadBitmap(hps, NULLHANDLE, 
                             IDB_HELLO, 0L, 0L);         /* Standard-Bitmap */
    GpiSetBitmap(hps, NULLHANDLE);       /* Deselktieren sicherrheitshalber */
    bRet = GpiDestroyPS(hps);       
    bRet = (BOOL) DevCloseDC(hdcMem);
    break;


  case WM_PAINT:
    hps = WinBeginPaint(hwnd, NULLHANDLE, &rcl);
    WinQueryWindowRect(hwnd, &rcl);             /* braucht gesamtes Fenster */

    switch (fState) {
    case SB_DEFAULT:
        WinDrawBitmap(hps, Mpb.hbm, NULL, (PPOINTL) &rcl,
                      CLR_NEUTRAL, CLR_BACKGROUND, DBM_STRETCH);
      break;

    case SB_SHOT:
    case SB_ZOOM:
        WinDrawBitmap(hps, Mpb.hbmShot,
                      NULL,                               /* gesamte Bitmap */
                      (PPOINTL) &rcl,
                      CLR_NEUTRAL, CLR_BACKGROUND, DBM_STRETCH);
      break;

    } /* endswitch fState */

    WinEndPaint(hps);
    break;

  case WM_COMMAND:
    MainCommand(hwnd, mp1, mp2);
    break;

  case WM_SIZE:
          WinQueryWindowRect(Mpb.hwndMainClient, &Zoom.rcl); /* Lupenfenster */
    break;



  case WM_MOUSEMOVE:
    if (fState >= SB_ZOOM) {
       WinSetPointer(HWND_DESKTOP, Mpb.hptr);                 /* Lupenzeiger */
       if (fState < SB_ZOOMFOUR) {
         ptlMPos.x = MOUSEMSG(&msg)->x;              /* Client-Window Coords */
         ptlMPos.y = MOUSEMSG(&msg)->y;
         aptl[0].x = Zoom.rcl.xLeft;                  /* Target Lupenfenster */
         aptl[0].y = Zoom.rcl.yBottom;
         aptl[1].x = Zoom.rcl.xLeft + 60 * 5;
         aptl[1].y = Zoom.rcl.yBottom + 60 * 5;            /* Vergr.Faktor 5 */
         aptl[2].x = Zoom.swp.x + ptlMPos.x - 20;         /* Quelle MausPos. */
         aptl[2].y = Zoom.swp.y + ptlMPos.y - 20;      /* in Screenkoord.    */
         aptl[3].x = Zoom.swp.x + ptlMPos.x + 40;      /* umger. aus Window  */
         aptl[3].y = Zoom.swp.y + ptlMPos.y + 40;
         GpiBitBlt(Mpb.hpsWindow, Mpb.hpsMem, 4L, aptl, ROP_SRCCOPY, BBO_IGNORE);
       }
    }
    else
      return( WinDefWindowProc(hwnd,msg,mp1,mp2) );   /* normaler Mauszeiger */
    break;

  case WM_BUTTON2DOWN:             /* Abbrechen, Standardlogo */
    if (fState > SB_SHOT) {
      WinReleasePS(Mpb.hpsWindow);
      if (fState == SB_ZOOM) {     /* Mem->Window */
         rbm = GpiSetBitmap(Mpb.hpsMem, NULLHANDLE);
         bRes = GpiDeleteBitmap(Mpb.hbmShot);
         GpiDestroyPS(Mpb.hpsMem);
      }
      else
         WinReleasePS(Mpb.hpsMem);
      fState = SB_DEFAULT;
      WinSetCapture(HWND_DESKTOP, NULLHANDLE);     /* Maus freigeben */
      WinInvalidateRect(hwnd, NULL, FALSE);
    }
    break;

  case WM_TIMER:
    if (SHORT1FROMMP(mp1) == ID_MTIMER) {
       WinStopTimer(Mpb.hab, hwnd, ID_MTIMER);
       WinQueryPointerPos(HWND_DESKTOP, &ptlMPos);
       aptl[0].x = Zoom.rcl.xLeft;
       aptl[0].y = Zoom.rcl.yBottom;
       aptl[1].x = Zoom.rcl.xRight;
       aptl[1].y = Zoom.rcl.yTop;
       aptl[2].x = ptlMPos.x - 20;
       aptl[2].y = ptlMPos.y - 20;
       aptl[3].x = ptlMPos.x + 40;
       aptl[3].y = ptlMPos.y + 40;
       GpiBitBlt(Mpb.hpsWindow, Mpb.hpsMem, 4L, aptl, ROP_SRCCOPY, BBO_IGNORE);
       WinStartTimer(Mpb.hab, hwnd, ID_MTIMER, 200);
    }
    break;



  default: /* wenn keiner getroffen */
    return( WinDefWindowProc(hwnd,msg,mp1,mp2) );

  } /* switch (msg) zuende */
  return (MRESULT)NULL;     /* this return all WinProcs by default */

} /*------------------ endfunction MainWndProc() ---------------------------*/











