/* pm_fonts.c : Hilfsfunktionen fr die benutzung der PM-Zeichenstze */ 

#define INCL_PM  /* Window Standard Font Functions     */
#include <os2.h>
#include <string.h>
#include <memory.h>
#include <malloc.h>
 

#include "pm_fonts.h"
#include "pm_print.h"


PFONTMETRICS SearchFonts(HPS hps, PSZ pszFacename, LONG *lNumFonts)
{
  PFONTMETRICS afmMetrics = NULL;
  LONG lReqFonts = 0L;
  LONG lRemFonts = GPI_ALTERROR;
  BOOL fRet = FALSE;
 
  *lNumFonts = GpiQueryFonts(hps,
			    QF_PUBLIC,
			    pszFacename,
			    &lReqFonts,
			    0L,
			    NULL);

  if ((*lNumFonts!=GPI_ALTERROR) && (*lNumFonts!=0L))
    afmMetrics  = malloc(*lNumFonts*sizeof(FONTMETRICS));

  if (afmMetrics != NULL)
    lRemFonts = GpiQueryFonts(hps,
			      QF_PUBLIC,
			      pszFacename,
			      lNumFonts,
			      (LONG)sizeof(FONTMETRICS),
			      afmMetrics);

  if (lRemFonts != GPI_ALTERROR)
    return afmMetrics;
  else
    return NULL;
} /* endfunction */




/****************************************************************************/
LONG CreateRasterFont(HPS hps, PSZ pszFacename, PSTR8 pstr8Fontname,
		      SHORT sPtSize)
{

  PFONTMETRICS  afmMetrics = NULL;         /* ptr to FONTMETRICS array */
  LONG          lNumFonts;                 /* number of fonts available */
  LONG          lXDevRes;                  /* actual X Device resolution */
  LONG          lYDevRes;                  /* actual Y Device resolution */
  BOOL          fRet = FALSE;              
  HDC           hdc = NULLHANDLE;  
  LONG          lLcid = GPI_ERROR;         /* set id */
  INT           i;
  USHORT        usCodePage = GPI_ERROR;    
  FATTRS        fatAttrs;


  afmMetrics = SearchFonts(hps, pszFacename, &lNumFonts);

  /*-- aktuelle Deviceauflsung erfragen --------------------------*/

  if (afmMetrics)
    hdc = GpiQueryDevice(hps);                 /* Device zum PS erfragen */

  if ((hdc != NULLHANDLE) && (hdc != HDC_ERROR)) 
    fRet = DevQueryCaps(hdc,
			CAPS_HORIZONTAL_FONT_RES,  /* Font Resolution */
			1L,
			&lXDevRes);

  if (fRet)
    fRet = DevQueryCaps(hdc,
			CAPS_VERTICAL_FONT_RES,    /* dito fr y */
			1L,
			&lYDevRes);

  /*-----------------------------------------------------------------------*/
  /* Suche  Font, der alle Bedingungen erfllt und erzeuge logischen Font  */
  /*-----------------------------------------------------------------------*/

  if (fRet) {
    for (i=0;i< (INT ) lNumFonts;i++) {
      if (!(afmMetrics[i].fsDefn & FM_DEFN_OUTLINE)           /* nur Raster */
	  && !(strcmp(afmMetrics[i].szFacename, pszFacename)) /* Facename   */
	  &&  (afmMetrics[i].sNominalPointSize == sPtSize) /* Gre 1/10 pt */
	  && ((LONG)afmMetrics[i].sXDeviceRes == lXDevRes) /* dev resolution*/
	  && ((LONG)afmMetrics[i].sYDeviceRes == lYDevRes))    
	{
	  lLcid = AllocateSetID(hps);              /* freie set-Id besorgen */

	  if (lLcid != GPI_ERROR)
	    usCodePage = GpiQueryCp(hps);            /* code page besorge   */
	  fatAttrs.usRecordLength = sizeof(FATTRS);
	  fatAttrs.fsSelection    = 0;               /* keine sim. Charakt. */
	  fatAttrs.lMatch = 0L;              /* benutze Hhenangaben direkt */
	  strcpy(fatAttrs.szFacename, afmMetrics[i].szFacename);
	  fatAttrs.idRegistry = afmMetrics[i].idRegistry;
	  fatAttrs.usCodePage = usCodePage;
	  fatAttrs.lMaxBaselineExt = afmMetrics[i].lMaxBaselineExt;
	  fatAttrs.lAveCharWidth   = afmMetrics[i].lAveCharWidth;
	  fatAttrs.fsType = 0;      /* keine sp. Typen, wie z.B. Antialized */ 
	  fatAttrs.fsFontUse = 0;                  /* keine Flags -> Raster */

	  /*---------------- logischen Font erzeugen --------------------*/
	  if (usCodePage != GPI_ERROR)
	    fRet = GpiCreateLogFont(hps,
				    pstr8Fontname, /* logischer Fontname */
				    lLcid,
				    &fatAttrs) != GPI_ERROR;
	  break;
	} /* Ende if font passt */
    } /* Ende for-Schleife */
  } /* Ende if (fRet) */

  free(afmMetrics);         /* Speicher fr die Fontmetrics freigeben */
  
  if (!fRet || usCodePage == GPI_ERROR)
    lLcid = GPI_ERROR;

  return lLcid;                   /* Set ID oder GPI_ERROR zurck */
} /* Ende CreateRasterFont() */





LONG CreateOutlineFont(HPS hps, PSZ pszFacename, PSTR8 pstr8Fontname)
{

  PFONTMETRICS afmMetrics = NULL;
  BOOL fRet = FALSE;
  LONG lLcid = GPI_ERROR, lNumFonts = 0;
  INT i;
  USHORT usCodePage = GPI_ERROR;
  FATTRS fatAttrs;

  afmMetrics = SearchFonts(hps, pszFacename, &lNumFonts);

  if (afmMetrics) {
    for (i=0; i< (INT) lNumFonts; i++)  {
      if ((afmMetrics[i].fsDefn & FM_DEFN_OUTLINE)
	  && !(strcmp(afmMetrics[i].szFacename,pszFacename)))  {

	lLcid = AllocateSetID(hps);
	
	if (lLcid != GPI_ERROR)
	  usCodePage = GpiQueryCp(hps);

	fatAttrs.usRecordLength = sizeof(FATTRS);
	fatAttrs.fsSelection    = 0;
	fatAttrs.lMatch         = afmMetrics[i].lMatch;
	strcpy(fatAttrs.szFacename, afmMetrics[i].szFacename);
	fatAttrs.idRegistry     = afmMetrics[i].idRegistry;
	fatAttrs.usCodePage     = usCodePage;
	fatAttrs.lMaxBaselineExt = 0L;
	fatAttrs.lAveCharWidth  = 0L;
	fatAttrs.fsType         = 0;
	fatAttrs.fsFontUse      = (FATTR_FONTUSE_OUTLINE |
				   FATTR_FONTUSE_TRANSFORMABLE);
	
	if (usCodePage != GPI_ERROR)
	  fRet = GpiCreateLogFont(hps,
				  pstr8Fontname,
				  lLcid,
				  &fatAttrs) != GPI_ERROR;

	break;
      }
    }
  }

  free(afmMetrics);

  if (!fRet || usCodePage==GPI_ERROR)
    lLcid = GPI_ERROR;

  return(lLcid);
}


/***************************************************************************/
/* Besorgt eine noch nicht benutzte ID fr einen Font                      */
/***************************************************************************/
LONG AllocateSetID (HPS hps)
{
#define MAXSETID 254L

  INT i;
  LONG lLcid = GPI_ERROR;
  LONG lCount;
  BOOL fRet = FALSE;
  PLONG alLcids = NULL;
  PLONG alTypes;
  PSTR8 aNames;

  lCount = GpiQueryNumberSetIds(hps);

  if (lCount == 0)
    return 1L;

  if (lCount!=GPI_ALTERROR) {
    alLcids = malloc((SHORT)((sizeof(LONG)*2 + sizeof(STR8))*lCount));
    alTypes = (PLONG)(alLcids + lCount);
    aNames  = (PSTR8)(alTypes + lCount);

    if (alLcids!=NULL)
      fRet = GpiQuerySetIds(hps,
			    lCount,
			    alTypes,
			    aNames,
			    alLcids);

    if (fRet) {       /* Korrekte Nummern 1 - 254 */
      for (lLcid=1; lLcid<255; lLcid++) {  /* 255 Fehlermeldung !!! */
	for (i=0;i < (int)lCount && alLcids[i]!=lLcid; i++);
	if (i==(INT )lCount)  break;
      }
      if (lLcid==255)
	lLcid = GPI_ERROR;
    }
    free(alLcids);
  }
  return lLcid;
}






/***************************************************************************/
/* ShowFontDialog- zeigt den Standarddialog zur Zeichensatzauswahl,        */
/* vorbesetzt mit dem Zeichensatz aus pfmFont, diese Variable enthlt      */
/* spter die Metrics des gewhlten Fonts.                                 */
/* Rckgabe FALSE- Fehler                                                  */
/* pbReturn zeigt, ob OK (TRUE) oder Cancel (FALSE) beim verlassen der Box */
/* simulierte Charakteristika werden nicht untersttzt                     */
/***************************************************************************/
BOOL ShowFontDialog(HAB hab, HWND hwndClient, HPS hpsScreen,  HPS hpsPrinter,
		    PFONTMETRICS pfmFont, USHORT *pusPtSize, BOOL *pbReturn)
{
  FONTDLG fontDlg = {0};  /* Rest wird auch auf 0 gesetzt !! C-Standard */
  CHAR szTitle[30] = "Zeichensatzausdwahl";
  CHAR pszFamilyname[FACESIZE];

  /*------------------- alles klar fr Ausgabe -------------------------*/
  fontDlg.cbSize     = sizeof(FONTDLG);               
  fontDlg.hpsScreen  = hpsScreen;                          /* Screen PS */
  fontDlg.hpsPrinter = hpsPrinter;                        /* Printer PS */
    
  fontDlg.pszTitle      = szTitle;               /* Titel der Dialogbox */
  strncpy(pszFamilyname, pfmFont->szFamilyname,sizeof(pszFamilyname));
  fontDlg.pszFamilyname = pszFamilyname; 
  fontDlg.fxPointSize  = MAKEFIXED(*pusPtSize/10,0); /* Gre in 1/10 pt */
  fontDlg.fl           = FNTS_CENTER | FNTS_INITFROMFATTRS;
  fontDlg.clrFore      = CLR_BLACK;                 /* foreground color  */
  fontDlg.clrBack      = CLR_WHITE;                 /* background color  */
  fontDlg.sNominalPointSize = pfmFont->sNominalPointSize;
  fontDlg.usWeight = pfmFont->usWeightClass; /* boldness of the font */
  fontDlg.usWidth = pfmFont->usWidthClass;  /* The width of the font */
  fontDlg.usFamilyBufLen = sizeof(pszFamilyname); 
                                        /*Length family name buffer */
  strcpy(fontDlg.fAttrs.szFacename,pfmFont->szFacename); 
  
  if(!WinFontDlg(HWND_DESKTOP,hwndClient, &fontDlg)) 
    return FALSE;

  /******** ------ gewhlte Einstellung Speichern ----------- ************/
  strncpy(pfmFont->szFamilyname, fontDlg.pszFamilyname, sizeof(pszFamilyname));
  strcpy(pfmFont->szFacename,fontDlg.fAttrs.szFacename);
  pfmFont->sNominalPointSize = fontDlg.sNominalPointSize;
  pfmFont->usWeightClass = fontDlg.usWeight ; /* boldness of the font */
  pfmFont->usWidthClass = fontDlg.usWidth;  /* The width of the font */
  *pusPtSize = FIXEDINT(fontDlg.fxPointSize)*10;
  
  if (fontDlg.lReturn == DID_OK) 
    *pbReturn = TRUE;
  else 
    *pbReturn = FALSE;

  return TRUE;
}   /* End of ShowFontDialog() */







