{$D+,L+}
(* Hilfs-DLL fr Enumerate-CallBacks *)
(* Ingo T. Storm / c't 12/94 / Borland Pascal fr Windows *)
{ $C PRELOAD FIXED}
(* Callbacks mssen in FIXED-Segmenten liegen *)
Unit UEnumerate;

interface

uses WinTypes, WinProcs, Objects;

function EnumWindows2(const hWindow : hWnd; const wUserMsg : Word):boolean;

implementation

(* allgemeine Callback-Funktion fr EnumerateWindos   *)
(* hWnd: von Windows gelieferte Window-Handles        *)
(* dwhWin_Msg: LoWord - Fenster-Handle der Client-App *)
(*             HiWord - anwendungsdefinierte Message  *)
(* sendet die gemeldeten Fensterhandles an die Applikation *)
(* zurck, die EnumerateWindows aufgerufen hat             *)
function EnumWinCB(const hWindow: hWnd; dwhWinMsg:LongInt):Boolean; export;
var l:longint;
begin
  (* KEIN Postmessage - sonst verstopft die Task-Queue *)
  l:=GetTickCount;
  SendMessage(LongRec(dwhWinMsg).Hi,LongRec(dwhWinMsg).Lo, hWindow, l);
  EnumWinCB:=TRUE;
end;

function EnumWindows2(const hWindow : hWnd; const wUserMsg : Word):boolean;
var
  pEnumCB : TFarproc; (* Funktionspointer fr Callback *)
  bEnumOk : boolean;
begin
  bEnumOk := false;
  if hWindow = 0 then OutputDebugString('EnumWin2: invalid hWnd'#13)
  else if (wUserMsg<WM_USER) or (wUserMsg>$7FFF)
    then OutputDebugString('EnumWin2: invalid UserMsg'#13)
  else begin
    (*$IFOPT K+*)
    OutputDebugString('EnumWin2: YES Smart Callbacks.'#13);
    bEnumOK := EnumWindows(@EnumWinCB,LongInt(hWindow) SHL 16  + wUserMsg);
    if not bEnumOk then
      OutputDebugString('EnumWin2: not all windows enumerated.'#13);
    (*$ELSE*)
    OutputDebugString('EnumWin2: NO Smart Callbacks.'#13);
    pEnumCB := MakeprocInstance(@EnumWinCB,hInstance);
    if pEnumCB = nil then
      OutputDebugString('EnumWin2: MakeProcInstance failed.'#13)
    else begin
      bEnumOK := EnumWindows(pEnumCB,LongInt(hWindow) SHL 16  + wUserMsg);
      if not bEnumOk then
        OutputDebugString('EnumWin2: not all windows enumerated.'#13);
      FreeProcInstance(pEnumCB);
    end;
    (*$ENDIF*)
  end;
  EnumWindows2 := bEnumOk
end;

begin
end.
