{$A+,B-,D-,F-,G+,I+,K-,L-,N-,P-,Q-,R-,S+,T-,V+,W+,X+,Y+}
{$M 8192,8192}
program WindowList;

(* listet Top-Level-Fenster auf *)
(* Mausclick in die Liste holt etwas mehr Inf *)
(* Ingo T. Storm // c't 12/94 // Borland pascal fr Windows *)
(* Eine Bitte: dies ist eine kleine Demo, wie man recht einfach *)
(* EnumWindows2 benutzen kann. Mehr nicht. Fragen an it@ct.ix.de*)
(* bzw. Ingo T. Storm CIS 72662, 3142 *)

uses WinCrt, WinProcs, WinTypes, OMemory, oWindows,
     ODialogs, Strings, ToolHelp,
     UEnumerate, (* um diese Unit geht es hier *)
     HeapDebW; (* siehe "Scherben aufsammeln" im gleichen Heft *)
const
  WM_ENUMERATE = WM_USER + 1; (* Message-Konstante fr Enum-Nachrichten *)
  ID_LISTBOX   = 101;
  ID_Refresh   = 102;
  wTopHeight   = 50;

Type
  PMyWin = ^TMyWin;
  TMyWin = object (TWindow)
             lbWinList : PListBox;
             bRefresh  : PButton;
             constructor Init(AParent: PWindowsObject; ATitle: PChar);
             procedure SetupWindow; virtual;
             procedure WMEnum(var msg: TMessage); (* bearbeitet Aufzhlungsnachrichten *)
                       virtual WM_Enumerate;
             procedure WMRefresh(var msg: TMessage); (* veranlat Aufzhlung *)
                       virtual id_First + id_Refresh;
             procedure HandleListBoxMsg(var Msg: TMessage);
                       virtual id_First + ID_LISTBOX;
             procedure WMSize(var Msg: TMessage);
                       virtual WM_First + WM_Size;
           end;

  TMyApp = object (TApplication)
             procedure InitMainWindow; virtual;
           end;

constructor TMyWin.Init(AParent: PWindowsObject; ATitle: PChar);
begin
  inherited Init(AParent, ATitle);
  lbWinList := New(PListBox, Init(@Self, ID_LISTBOX, 0, 0, 0, 0));
  lbWinList^.attr.style
    :=(lbWinList^.attr.style OR lbs_nointegralheight);
  bRefresh  := New(PButton, Init(@Self, ID_Refresh, '&Refresh',
                            5, 5, 100, wTopHeight - 5 - 5, true));
end;

procedure TMyWin.SetupWindow;
var
  hf : hFont;
  msg : TMessage;
begin
  inherited SetupWindow;
  hF:=GetStockObject(ANSI_FIXED_FONT);
  SendMessage(lbWinList^.hWindow,WM_SETFONT,hF,0);
  WMRefresh(msg);
end;

procedure TMyWin.WMEnum(var msg: TMessage);
var
  Args   : Array[0..3] of Word;
  pszCap, pszOut  : PChar;
  wCapLen  : Word;
begin
  Args[0] := msg.wParam;
  wCapLen := GetWindowTextLength(msg.wParam);
  if wCapLen>0 then begin
    GetMem(pszCap, wCapLen + 1);
    GetWindowtext(msg.wParam,pszCap,80)
  end
  else begin
    pszCap:=StrNew('HAS NO TITLE');
    wCapLen :=StrLen(pszCap);
  end;
    Args[1] := Ofs(pszCap^);
    Args[2] := Seg(pszCap^);
    GetMem(pszOut,wCapLen + 17);
    wvsprintf(pszOut,'hWnd %04X title %s',Args);
    lbWinList^.AddString(pszOut);
    FreeMem(pszOut, wCapLen + 17);
    FreeMem(pszCap, wCapLen + 1);
  DefWndproc(msg);
end;

procedure TMyWin.WMRefresh;
begin
  lbWinList^.ClearList;
  EnumWindows2(hWindow, WM_Enumerate);
end;

procedure TMyWin.HandleListBoxMsg(var Msg: TMessage);
var
  Idx: Integer;
  pszlbText, pszCaption: PChar;
  szHandle : ARRAY[0..5] of char;
  wlbTextLen, wCapLen : Word;
  strHandle: string;
  hWin     : hWnd;
  hInst    : THandle;
  err      : integer;
  szModule : array[0..255] of Char;
  szAll    : ARRAY[0..1024] of Char;
  LongArgs : ARRAY[0..4]   of LongInt;
begin
  if Msg.LParamHi = lbn_SelChange then
  begin
    lbWinList^.Disable;
    Idx := lbWinList^.GetSelIndex;
    wlbTextLen:=lbWinList^.GetStringLen(Idx)+1;
    getMem(pszlbText,wlbTextLen);
    lbWinList^.GetSelString(pszlbText, wlbTextLen);
    StrLCopy(@szHandle,pszlbText+5,4);
    strHandle:='$'+StrPas(szHandle);
    Val(strHandle,hWin,err);
    wCapLen := GetWindowTextLength(hWin)+1;
    getMem(pszCaption, wCaplen);
    GetWindowText(hWin,pszCaption, wCaplen);
    hInst:=GetWindowWord(hWin,GWW_HINSTANCE);
    GetModuleFileName(hInst, szModule, sizeOf(szModule)-1);
    LongArgs[0]:=LongInt(@szHandle);
    LongArgs[1]:=LongInt(pszCaption);
    LongArgs[2]:=LongInt(@szModule);
    wvsprintf(szAll,'Handle: %s'+#13+'Window text: %s'+#13+'Module Filname: %s',LongArgs);
    MessageBox(hWindow,szAll,'Window Info',mb_ok);
    FreeMem(pszlbText,wlbTextLen);
    FreeMem(pszCaption,wCaplen);
    lbWinList^.Enable;
  end
  else DefWndProc(Msg);
end;

procedure TMyWin.WMSize(var Msg: TMessage);
begin
  inherited WMSize(Msg);
  SetWindowPos( lbWinList^.HWindow, 0, -1, wTopHeight, Msg.LParamLo+1,
                                       Msg.LParamHi + 1  - wTopHeight,
                swp_NoZOrder);
end;

procedure TMyApp.InitMainWindow;
begin
  MainWindow:=new(PMyWin,Init(nil,'Mahlzeit'));
end;

var
  App: TMyApp;
begin
  WITH App do begin Init('Moin'); Run; Done; end;
  DoneMemory;
end.
