; Assemblieren mit TASM IDEDRV
; Linken mit TLINK IDEDRV /t

                .model tiny
                .286
                .code
                org 0100h
 	start:          jmp init                             ;TSR initialisieren
 	counter1        dw 0888h                             ;=2184 Dez./18,2=120Sek.
	old_timer       dd 00h                               ;4 Bytes Seg./Offs.Time
	irq:            pushf                                ;alle Registerwerte die
                push ax                              ;bentigt werden,auf den
                push dx                              ;Stack
                mov dx,03f6h                         ;Alternative Status Reg.
                in al,dx                             ;einlesen
                and al,80h                           ;busy bit 7
                jnz m02                              ;arbeitet Festplatte?
                dec word ptr cs:[counter1]           ;Zhler -1
                cmp word ptr cs:[counter1],00h       ;Zhler schon 0?
                jnz m01                              ;dann irq verlassen
                mov dx,01f6h                         ;Drive/Head Register
                in al,dx                             ;einlesen
                or al,10h                            ;Slave Unit ansprechen
                out dx,al                            ;falls vorhanden
                inc dx                               ;+1 Command Register
                mov al,0e0h                          ;>>>> oder bei manchen
                                                     ;Platten 94h statt E0h
                                                     ;Motor on/off Command
                out dx,al                            ;an Port senden
                mov dx,03dah                         ;Vertical Blank
                in al,dx                             ;Routine dient der
                and al,08h                           ;Verzgerung,damit
                jz $-3                               ;Master Unit bereit ist
                in al,dx
                and al,08h
                jnz $-8
                mov dx,01f6h                         ;Drive/Head Register
                in al,dx                             ;einlesen
                and al,0efh                          ;Master Unit ansprechen
                out dx,al                            ;falls vorhanden
                inc dx                               ;+1 Command Register
                mov al,0e0h                          ;>>>> oder bei manchen
                                                     ;Platten 94h statt E0h
                                                     ;Motor on/off Command
                out dx,al                            ;an Port senden
m02:            mov word ptr cs:[counter1],0100h     ;Zhler neu setzen
m01:            pop dx                               ;benutzte Registerwerte
                pop ax                               ;wieder vom Stack
                popf                                 ;holen
                jmp [cs:dword ptr old_timer]         ;Timer Routine anspringen
init:           push es                              ;Extra-Segment retten
                xor ax,ax                            ;Segment auf Null
                mov es,ax                            ;zeigen lassen
                cmp es:word ptr [01e0h],0109h        ;TSR schon in IRQ-TABLE?
                jnz not_installed                    ;Nein,dann init TSR!
                pop es                               ;Extra-Segment holen
                mov dx,offset text2                  ;Text fr
                mov ah,09h                           ;TSR schon installiert!
                int 21h
                mov ax,4c00h                         ;Programm beenden
                int 21h
not_installed:  mov es:word ptr [01e0h],0109h        ;Kennung fr INSTALLIERT
                pop es                               ;Extra-Segment holen
                mov dx,offset text1                  ;Text fr
                mov ah,09h                           ;Programm erfolgreich
                int 21h                              ;installiert
                mov ax,351ch                         ;Interrupt-Vektor
                int 21h                              ;auslesen
                mov word ptr [old_timer+00h],bx      ;und
                mov word ptr [old_timer+02h],es      ;abspeichern
                mov dx,offset irq                    ;Neuen Interrupt-Vektor
                mov ax,251ch                         ;setzen
                int 21h
                mov dx,offset init                   ;Zeiger auf TSR-INIT
                int 27h                              ;und installieren
text1           db "c't-IDEDRV V1.0 successfully installed!",0dh,0ah,24h
text2           db "c't-IDEDRV V1.0 already installed!",0dh,0ah,24h

end start
